#!/bin/sh

current_value=$(ctm config systemsettings:server::get <SERVER_NAME> | grep -A1 ENABLE_AGENT_UTIL | grep value | cut -f4 -d '"')

if [[ "$current_value" != "Y" ]]; then
  echo "Updating ENABLE_AGENT_UTIL to 'Y'..."
  ctm config systemsettings:server::set ENABLE_AGENT_UTIL Y <SERVER_NAME>
  if [[ $? -eq 0 ]]; then
    echo "Successfully updated ENABLE_AGENT_UTIL to 'Y'."
  else
    echo "Failed to update ENABLE_AGENT_UTIL." >&2
    exit 1
  fi
  #waiting for synchronization of systemsettings value
  sleep 30
else
  echo "ENABLE_AGENT_UTIL is already set to '$current_value'. No update needed."
fi

echo "Adding variables..."

<CTMVAR_COMMANDS>

echo "All variables added."

if [[ "$current_value" != "Y" ]]; then
  echo "Updating ENABLE_AGENT_UTIL to 'N'..."
  ctm config systemsettings:server::set ENABLE_AGENT_UTIL N <SERVER_NAME>
  if [[ $? -eq 0 ]]; then
    echo "Successfully updated ENABLE_AGENT_UTIL to 'N'."
  else
    echo "Failed to update ENABLE_AGENT_UTIL." >&2
    exit 1
  fi
fi
