#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir

SUFFIX = "_%%$SMART_ORDERID"
def main(argv):
    input_file =  'in.xml'
    output_file = 'output.xml'
    try:
        opts, args = getopt.getopt(argv,"hi:o:",["ifile=","ofile="])
    except getopt.GetoptError:
        print ('xml-make-unique-flow.py -i <inputfile> -o <outputfile>')
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print ('xml-make-unique-flow.py -i <inputfile> -o <outputfile>')
            sys.exit()
        elif opt in ("-i", "--ifile"):
            input_file = arg
        elif opt in ("-o", "--ofile"):
            output_file = arg
    print ('Input file is: ' + input_file)
    print ('Output file is: ' + output_file)

    tree = ET.parse(input_file); print("Read the input file: " + input_file)
    root = tree.getroot()

    triggered_folders_list = get_all_triggered_folders(root); print("Got all triggered folders. Total: ", str(len(triggered_folders_list)))
    process_all_folders(root, triggered_folders_list); print("processed all triggered folders.")

    print("Writing updates to the XML file...")
    tree.write(output_file);print("Updates saved to the output XML file.")

def get_all_triggered_folders(root):
    triggered_folders_list = []
    for job in root.iter('JOB'):
        try: 
            memname = job.attrib['JOBNAME']
        except KeyError:
            continue
        on_list = job.iter('ON')
        for on_item in on_list:
            do_force_list = on_item.iter('DOFORCEJOB')
            for do_force in do_force_list:
                triggered_folder = do_force.attrib['TABLE_NAME']
                if triggered_folder not in triggered_folders_list:
                    triggered_folders_list.append(triggered_folder)
    return triggered_folders_list

def process_all_folders(root, triggered_folders_list):
    condition_changed = 0
    for folder in root.iter('SMART_FOLDER'):
        folder_name = folder.attrib['FOLDER_NAME']
        if folder_name in triggered_folders_list:
            condition_changed += process_folder(folder)
    print(str(condition_changed), " conditions were changed")

def process_folder(folder):
    condition_changed = 0
    in_cond_list = get_in_cond_list(folder)
    out_cond_list = get_out_cond_list(folder)
    do_cond_list = get_do_cond_list(folder)
    condition_changed += update_folder_incond(folder, out_cond_list, do_cond_list)
    condition_changed += update_folder_outcond(folder, in_cond_list, out_cond_list, do_cond_list)
    condition_changed += update_folder_docond(folder, in_cond_list, out_cond_list, do_cond_list)
    return condition_changed

def get_in_cond_list(folder):
    in_cond_list = []
    for job in folder.iter('JOB'):
        for in_cond in job.iter('INCOND'):
            in_cond_list.append(in_cond.attrib['NAME'])
    return in_cond_list

def get_out_cond_list(folder):
    out_cond_list = []
    for job in folder.iter('JOB'):
        for out_cond in job.iter('OUTCOND'):
            if out_cond.attrib['SIGN'] == "+":
                out_cond_list.append(out_cond.attrib['NAME'])
    return out_cond_list

def get_do_cond_list(folder):
    do_cond_list = []
    for job in folder.iter('JOB'):
        for on in job.iter('ON'):
            for do_cond in on.iter('DOCOND'):
                if do_cond.attrib['SIGN'] == "+":
                    do_cond_list.append(do_cond.attrib['NAME'])
    return do_cond_list

def update_folder_incond(folder, out_cond_list, do_cond_list):
    global SUFFIX
    condition_changed = 0
    for job in folder.iter('JOB'):
        for in_cond in job.iter('INCOND'):
            in_cond_name = in_cond.attrib['NAME']
            if in_cond_name in out_cond_list or in_cond_name in  do_cond_list:
                name_with_sufix = in_cond_name + SUFFIX
                in_cond.attrib['NAME'] = name_with_sufix
                condition_changed += 1
    return condition_changed

def update_folder_outcond(folder, in_cond_list, out_cond_list, do_cond_list):
    global SUFFIX
    condition_changed = 0
    for job in folder.iter('JOB'):
        for out_cond in job.iter('OUTCOND'):
            out_cond_name = out_cond.attrib['NAME']
            name_with_sufix = out_cond_name + SUFFIX 
            if out_cond.attrib['SIGN'] == "+":
                if out_cond_name in in_cond_list:
                    out_cond.attrib['NAME'] = name_with_sufix
                    condition_changed += 1
            if out_cond.attrib['SIGN'] == "-":
                if out_cond_name in out_cond_list or out_cond_name in  do_cond_list:
                    out_cond.attrib['NAME'] = name_with_sufix
                    condition_changed += 1
    return condition_changed

def update_folder_docond(folder, in_cond_list, out_cond_list, do_cond_list):
    global SUFFIX
    condition_changed = 0
    for job in folder.iter('JOB'):
        for on in job.iter('ON'):
            for do_cond in on.iter('DOCOND'):
                do_cond_name = do_cond.attrib['NAME']
                name_with_sufix = do_cond_name + SUFFIX 
                if do_cond.attrib['SIGN'] == "+":
                    if do_cond_name in in_cond_list:
                        do_cond.attrib['NAME'] = name_with_sufix
                        condition_changed += 1
                if do_cond.attrib['SIGN'] == "-":
                    if do_cond_name in out_cond_list or do_cond_name in  do_cond_list:
                        do_cond.attrib['NAME'] = name_with_sufix
                        condition_changed += 1
    return condition_changed

start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")