#!/bin/sh

version_to_number() {
  echo "$@" | awk -F. '{ printf("%d%03d%03d%03d\n", $1,$2,$3,$4); }'
}

check_java() {
  supported_java_version=21
  java_path=$(dirname "$(which java | grep java)" 2>/dev/null)
  if [ -z "${java_path}" ] || [ "${java_path}" = "." ]; then
    echo ""
    echo "Could not find Java Runtime Environment."
    echo "This utility requires Java Runtime Environment version ${supported_java_version} or higher."
    echo "Make sure Java is installed and configured before rerunning the utility."
    echo ""
    exit 1
  fi

  java_version=$(java -version 2>&1 | awk -F '"' '/version/ {print $2}')
  if [ "$(version_to_number "$java_version")" -lt "$(version_to_number "${supported_java_version}")" ]; then
    echo ""
    echo "Found Java Runtime Environment version ${java_version}."
    echo "This utility requires Java Runtime Environment version ${supported_java_version} or higher."
    echo "Make sure Java is installed and configured before rerunning the utility."
    echo ""
    exit 1
  fi
}


conversion_jar_file="bin/SplitLargeFolder-ctmconvert-jar-with-dependencies.jar"
if [ ! -f "${conversion_jar_file}" ]; then
  echo "The file $conversion_jar_file was not found"
  exit 1
else
  if [ -f "./JRE/jre_64/bin/java" ]; then
    ./JRE/jre_64/bin/java -Xmx8G -jar "${conversion_jar_file}" "$@"
  else
	check_java
    java -Xmx8G -jar "${conversion_jar_file}" "$@"
  fi
fi
