@echo off

SET CURRENT_DIR=%CD%
SET ROOT_DIR=%CD%

SETLOCAL

set "splitLargeFolder_jarFile=bin\SplitLargeFolder-ctmconvert-jar-with-dependencies.jar"
IF NOT EXIST "%splitLargeFolder_jarFile%" (
    echo.
    echo "%CD%"
    echo The file "%splitLargeFolder_jarFile%" was not found
    echo.
)

IF EXIST "%ROOT_DIR%\..\..\..\JRE" (GOTO CONVERSION_TOOL_JAVA)


IF NOT EXIST "%ROOT_DIR%\JRE" (GOTO PATH_JAVA)
IF "%RUN_MY_JAVA%"=="" GOTO PACKED_WITH_JAVA
IF %RUN_MY_JAVA% NEQ RUN_MY_JAVA goto PACKED_WITH_JAVA
GOTO PATH_JAVA

:CONVERSION_TOOL_JAVA
:: echo 64-bit...
"%ROOT_DIR%\..\..\..\JRE\jre_64\bin\java.exe" -Xmx8G -jar "%splitLargeFolder_jarFile%" %*
GOTO EXIT


:PACKED_WITH_JAVA
:: echo using Java from conversion
:: echo 64-bit...
"%ROOT_DIR%\JRE\jre_64\bin\java.exe" -Xmx8G -jar "%splitLargeFolder_jarFile%" %*
GOTO EXIT

:PATH_JAVA
:: echo using Java from PATH
java -version >NUL 2>&1
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA

::echo RUN_MY_JAVA = %RUN_MY_JAVA%
java.exe -jar "%splitLargeFolder_jarFile%" %*
goto EXIT

:EXIT
ENDLOCAL
SET RC=%errorLevel%
CD %CURRENT_DIR%
echo.
exit /B %RC%

:NO_JAVA
  echo.
  echo This utility requires Java Runtime Environment version 15 or higher.
  echo Make sure Java is installed and configured before rerunning the utility.
  echo.
  pause
  goto EXIT
