#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re
from xml.dom import minidom

USAGE= "script-to-cmdline.py -i <inputfile> -o <outputfile> [-s <file-suffix] [-c <comparefile>]"
def main(argv):
    input_file =  'in.xml'
    output_file = 'out.xml'
    file_suffix = ''
    compare_file = 'compare.xml'
    try:
        opts, args = getopt.getopt(argv,"hc:i:s:o:",["infile=","ofile="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt == "-c":
            compare_file = arg
        elif opt in ("-i", "--infile"):
            input_file = arg
        elif opt == "-s":
            file_suffix = arg
        elif opt in ("-o", "--ofile"):
            output_file= arg
    print ('Input file is: ' + input_file)
    print ('Output file is: ' + output_file)
    if len(compare_file) > 0:
        print ('Compare file is: ' + compare_file)
    if len(file_suffix) > 0:
        print ('Suffix for selection is: ' + file_suffix)

    tree = ET.parse(input_file); print("Read the input file: " + input_file)
    root = tree.getroot()

    if len(compare_file) > 0:
        tree.write(compare_file);print("Original saved for comparison.")


    process_all_jobs(root, file_suffix)

    print("Writing updates to the XML file...")

    tree.write(output_file);print("Updates saved to the output XML file.")

    content_in_str = minidom.parseString(ET.tostring(root)).toprettyxml(indent="   ")
    with open('formated_' + output_file, 'w') as f:
        for line in content_in_str.splitlines():
            f.write("{}\n".format(line))



def process_all_jobs(root, file_suffix):
    for job in root.iter('JOB'):
        if (job.attrib['TASKTYPE'] == 'Job') or (job.attrib['TASKTYPE'] == 'Dummy' and get_var_content(job,'%%$BMCWAIORIGTYPE') == 'Job'):
            process_script_job(job, file_suffix)
            # print('job {} processed'.format(get_jobname(job)))
    return

def process_script_job(job, file_suffix):
    # print('job {}'.format(job.attrib['JOBNAME']))
    # print('job {} has script {}{}'.format(job.attrib['JOBNAME'], job.attrib['MEMLIB'], job.attrib['MEMNAME']))
    try:
        if job.attrib['USE_INSTREAM_JCL'] == "Y":
            # print('job {} is instream-jcl and ignored'.format(job.attrib['JOBNAME']))
            return
    except KeyError:
        pass
    try:
        parm_content = get_all_parms_content(job)
        script_name = job.attrib['MEMNAME']
        if len (file_suffix) > 0 and not script_name.endswith('.' + file_suffix):
            return
        command_line = job.attrib['MEMLIB'] + job.attrib['MEMNAME'] +  parm_content
        if len(command_line) > 512:
            print ('job {} command line will be too long. Kept as Script type'.format(get_jobname(job)))
            return
        if (job.attrib['TASKTYPE'] == 'Job'):
            job.attrib['TASKTYPE'] = 'Command'
        if (job.attrib['TASKTYPE'] == 'Dummy'):
            set_var_content(job,'%%$BMCWAIORIGTYPE','Command')
        job.attrib['CMDLINE'] = command_line
        del job.attrib['MEMLIB']
        del job.attrib['MEMNAME']
        del_all_parms(job)
    except KeyError as e:
        print('job {} is in error. Missing attribute {}'.format(job.attrib['JOBNAME'], str(e)))
    return

def get_jobname(job):
    job_name = ''
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        job_name = job.attrib['MEMNAME']
    return job_name

def get_all_parms_content(job):
    all_parms_content = ''
    for p_num in range (1, 99):
        parm = '%%PARM' + str(p_num)
        # print(parm)
        parm_value = get_var_content(job,parm)
        if len(parm_value) > 0:
            all_parms_content = all_parms_content +  ' ' + parm_value
        else:
            break
    return all_parms_content

def get_var_content(job, name):
    var_value = ''
    try:
        for var in job.iter('VARIABLE'):
            if var.attrib['NAME'] == name:
                var_value = var.attrib['VALUE']
                break
    except KeyError:
        var_value = ' '
        print('Job {} has variable {} with no value'.format(get_jobname(job), name))
    return var_value

def set_var_content(job, name, value):
    for var in job.iter('VARIABLE'):
        if var.attrib['NAME'] == name:
            var.attrib['VALUE'] = value
            break
    return

# def get_parm_content(job,parm):
#     parm_value = ''
#     for var in job.iter('VARIABLE'):
#         if var.attrib['NAME'] == parm:
#             parm_value = var.attrib['VALUE']
#     return parm_value

def del_all_parms(job):
    for p_num in range (1, 99):
        parm = '%%PARM' + str(p_num)
        # print(parm)
        parm_value = get_var_content(job,parm)
        if len(parm_value) > 0:
            del_parm(job,parm)
        else:
            break
    return

def del_parm(job,parm):
    for var in job.iter('VARIABLE'):
        if var.attrib['NAME'] == parm:
            job.remove(var)
    return


start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")