#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import time, math		
import sys, getopt

attributes_to_resolve: list = [
    "CMDLINE", 
    "MEMLIB" 
    ]
variables_to_keep: list = [
    # "%%FILENAME"
    ]

USAGE= "resolve-temp-variables-usage.py -i <inputfile> -o <outputfile> [-c <comparefile>]"
def main(argv):
    input_file =  'in.xml'
    output_file = 'out.xml'
    compare_file = ''
    try:
        opts, args = getopt.getopt(argv,"hc:i:o:",["infile=","ofile="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt == "-c":
            compare_file = arg
        elif opt in ("-i", "--infile"):
            input_file = arg
        elif opt in ("-o", "--ofile"):
            output_file= arg
    print ('Input file is: ' + input_file)
    print ('Output file is: ' + output_file)
    if len(compare_file) > 0:
        print ('Compare file is: ' + compare_file)

    tree = ET.parse(input_file); print("Read the input file: " + input_file)
    root = tree.getroot()

    if len(compare_file) > 0:
        tree.write(compare_file);print("Original saved for comparison.")


    process_all_jobs(root)

    print("Writing updates to the XML file...")

    tree.write(output_file);print("Updates saved to the output XML file.")

def process_all_jobs(root):
    for job in root.iter('JOB'):
        process_job_temp_var(job)

def process_job_temp_var(job):
    var_dict: dict = get_var_dict(job)
    var_to_remove: list = resolve_temp_var_in_var(job, var_dict)
    var_dict: dict = get_var_dict(job)
    var_to_remove = var_to_remove + resolve_temp_var_in_cmd(job, var_dict)
    remove_temp_var(job, var_to_remove)
    return

def get_var_dict(job):
    var_dict: dict = {}
    for var in job.iter('VARIABLE'):
        try:
            var_value = var.attrib['VALUE']
        except KeyError:
            var_value = ''
        # print ("In job {}, Variable name {}".format(job.attrib['JOBNAME'], var.attrib['NAME']))
        var_dict[var.attrib['NAME']] = var_value
    return var_dict

def resolve_temp_var_in_var(job, var_dict):
    remove_list: list = []
    for var in job.iter('VARIABLE'):
        modified = True
        while modified:
            try:
                value = var.attrib['VALUE']
                modified = resolve_var_value(var_dict, remove_list, var, value)
            except KeyError:
                modified = False
    return remove_list

def resolve_var_value(var_dict, remove_list, var, value):
    modified = False
    for temp_var in var_dict.keys():
        if temp_var in value:
                # print ("found {} in var {} in job {}".format( temp_var, value, job.attrib['JOBNAME']))
            value = value.replace(temp_var + '.', var_dict.get(temp_var))
            value = value.replace(temp_var, var_dict.get(temp_var))
                # print ("new value is {}".format(value))
            remove_list.append(temp_var)
            modified = True
            var.attrib['VALUE'] = value
    return modified

def resolve_temp_var_in_cmd(job, var_dict):
    remove_list: list = []
    for attribute in attributes_to_resolve:
        try:
            cmdline = job.attrib[attribute]
            for temp_var in var_dict.keys():
                if temp_var in cmdline:
                    # print ("found {} in cmdline {} in job {}".format( temp_var, cmdline, job.attrib['JOBNAME']))
                    cmdline = cmdline.replace(temp_var + '.', var_dict.get(temp_var))
                    cmdline = cmdline.replace(temp_var, var_dict.get(temp_var))
                    remove_list.append(temp_var)
                    job.attrib[attribute] = cmdline
        except KeyError:
            pass
    return remove_list

def remove_temp_var(job, remove_list):
    for temp_cond in remove_list:
        if temp_cond not in variables_to_keep:
            for var in job.iter('VARIABLE'):
                if var.attrib['NAME'] == temp_cond:
                    job.remove(var)
    return

start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")