#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re
import csv


USAGE= "qres-xref.py -i <inputfile_or_directory> -o <outputdir> -h"
def main(argv):
    input_path =  ''
    output = 'output'
    try:
        opts, args = getopt.getopt(argv,"hi:o:",["input=","outdir="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt in ("-i", "--input"):
            input_path = arg
        elif opt in ("-o", "--outdir"):
            output = arg
    
    if not os.path.isdir(output):
        os.makedirs(output)

    # Check if input is a file or directory
    if os.path.isfile(input_path):
        print('Input file: ' + input_path)
        print('Output results directory: ' + output)
        tree = ET.parse(input_path)
        print("Read the input file: " + input_path)
        root = tree.getroot()
        process_all_folders(root, output)
    elif os.path.isdir(input_path):
        print('Input directory: ' + input_path)
        print('Output results directory: ' + output)
        process_directory(input_path, output)
    else:
        print("Error: Input path '{}' is neither a file nor a directory".format(input_path))
        sys.exit(1)

def process_directory(input_dir, output):
    """Process all XML files in a directory and combine results into a single report"""
    xml_files = []
    
    # Find all XML files in the directory
    for file in os.listdir(input_dir):
        if file.lower().endswith('.xml'):
            xml_files.append(os.path.join(input_dir, file))
    
    if not xml_files:
        print("No XML files found in directory: " + input_dir)
        return
    
    print("Found {} XML files to process:".format(len(xml_files)))
    for xml_file in xml_files:
        print("  - " + os.path.basename(xml_file))
    
    # Combined dictionary to hold all QRES from all files
    combined_qres_dict = {}
    
    # Process each XML file and merge results
    for xml_file in xml_files:
        try:
            print("Processing: " + xml_file)
            tree = ET.parse(xml_file)
            root = tree.getroot()
            file_qres_dict = build_qres_xref(root)
            
            # Merge this file's results into the combined dictionary
            for qres_name, qres_list in file_qres_dict.items():
                if qres_name in combined_qres_dict:
                    combined_qres_dict[qres_name].extend(qres_list)
                else:
                    combined_qres_dict[qres_name] = qres_list.copy()
                    
        except ET.ParseError as e:
            print("Error parsing XML file {}: {}".format(xml_file, str(e)))
            continue
        except Exception as e:
            print("Error processing file {}: {}".format(xml_file, str(e)))
            continue
    
    # Generate combined reports using the same logic as single file processing
    print("Generating combined reports from {} XML files".format(len(xml_files)))
    print("Got all Resources. Total: {}".format(str(len(combined_qres_dict))))
    generate_reports(combined_qres_dict, output)

def process_all_folders(root, output):
    qres_dict = build_qres_xref(root)
    print("Got all Resources. Total: {}".format(str(len(qres_dict))))
    generate_reports(qres_dict, output)

def generate_reports(qres_dict, output):
    """Generate CSV reports from the QRES dictionary"""
    qres_quant_1 = 0
    qres_quant_99 = 0
    jobs_count_1 = 0
    jobs_count_2 = 0
    jobs_count_many = 0
    jobs_count_1_qres_list = []
    jobs_count_2_qres_list = []
    jobs_count_many_qres_list = []
    output_report_1 = output + '\\qres_with_single_use.csv'
    output_report_2 = output + '\\qres_with_dual_use.csv'
    output_report_many = output + '\\qres_with_many_use.csv'
    with open(output_report_1, 'w', encoding='UTF8', newline='') as csv_report_1, \
         open(output_report_2, 'w', encoding='UTF8', newline='') as csv_report_2, \
         open(output_report_many, 'w', encoding='UTF8', newline='') as csv_report_many:
        csv_writer_1 = csv.writer(csv_report_1)
        csv_writer_1.writerow(['folder', 'job', 'qres', 'quantity'])
        csv_writer_2 = csv.writer(csv_report_2)
        csv_writer_2.writerow(['qres', 'folder1', 'job1', 'quant1', 'folder2', 'job2', 'quant2'])
        csv_writer_many = csv.writer(csv_report_many)
        csv_writer_many.writerow(['qres', 'folder', 'job', 'quantity','num of jobs'])

        for qres in qres_dict.keys():
            qres_list = qres_dict[qres]
            if len(qres_list) == 1:
                jobs_count_1 = jobs_count_1 + 1
                jobs_count_1_qres_list.append(qres)
                # if qres_list[0].quant != '0099':
                #     print('single use with quantity not 99: folder {}, job {}, qres {}, quantity {}'.format(qres_list[0].folder, qres_list[0].job, qres, qres_list[0].quant))
                csv_writer_1.writerow([qres_list[0].folder, qres_list[0].job, qres, qres_list[0].quant])
            if len(qres_list) == 2:
                jobs_count_2 = jobs_count_2 + 1
                jobs_count_2_qres_list.append(qres)
                csv_writer_2.writerow([qres, qres_list[0].folder, qres_list[0].job,qres_list[0].quant, qres_list[1].folder, qres_list[1].job, qres_list[1].quant])
                # if qres_list[0].quant != '0099' or qres_list[1].quant != '0099':
                #     print('dual use with quantity not 99: folder {}, job {}, qres {}, quantity {}'.format(qres_list[0].folder, qres_list[0].job, qres, qres_list[0].quant))
            if len(qres_list) > 2:
                jobs_count_many = jobs_count_many + 1
                jobs_count_many_qres_list.append(qres)
                for qres_list_item in qres_list:
                    csv_writer_many.writerow([qres, qres_list_item.folder,  qres_list_item.job,  qres_list_item.quant, len(qres_list) ])
                    
 
    # for res in qres_list:
    #     if (res in control_ds_list):
    #         print('{} Resourcs {} is crossing Control-M'.format(res_type, res))
    #         cross_count = cross_count + 1
    # print('Number of crossing {} resources: {}'.format(res_type, cross_count))
    print('QRES with single job {}, QRES with 2 jobs {}, QRES with many jobs {}'.format(jobs_count_1,jobs_count_2, jobs_count_many))

    return

def build_qres_xref(root):
    # class qres_item: 
    #     def __init__(self, name, quant): 
    #         self.name = name 
    #         self.quant = quant

    qres_dict = {}
    for folder in root.iter("SMART_FOLDER"):
        folder_name = folder.attrib['FOLDER_NAME']
        for job in folder.iter("JOB"):
            jobname = get_jobname(job)
            for res in job.iter("QUANTITATIVE"):
                res_name = res.attrib['NAME']
                res_quant = res.attrib['QUANT']
                qres: qres_item  = qres_item(folder_name, jobname, res_quant)
                if res_name in qres_dict.keys():
                    res_list: list = qres_dict[res_name]
                    res_list.append(qres)
                else:
                    res_list: list = []
                    res_list.append(qres)
                qres_dict[res_name] = res_list
    return qres_dict

class qres_item: 
    def __init__(self, folder, job, quant): 
        self.folder = folder
        self.job = job 
        self.quant = quant

def get_jobname(job):
    job_name = ''
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        job_name = job.attrib['MEMNAME']
    return job_name


start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")