#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re


USAGE= "detect-cross-res.py -m <inputfile> -d <inputfile>"
def main(argv):
    input_mf_file =  'MF.XML'
    input_ds_file =  'DS.XML'
    try:
        opts, args = getopt.getopt(argv,"hm:d:",["mffile=","dsfile="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt in ("-m", "--mffile"):
            input_mf_file = arg
        elif opt in ("-d", "--dsfile"):
            input_ds_file = arg
    print ('Input file from MF is: ' + input_mf_file)
    print ('Input file from DS is: ' + input_ds_file)
    tree_mf = ET.parse(input_mf_file); print("Read the MF input file: " + input_mf_file)
    root_mf = tree_mf.getroot()
    tree_ds = ET.parse(input_ds_file); print("Read the DS input file: " + input_ds_file)
    root_ds = tree_ds.getroot()

    process_all_folders(root_mf, root_ds, 'CONTROL')
    process_all_folders(root_mf, root_ds, 'QUANTITATIVE')

def process_all_folders(root_mf, root_ds, res_type):
    control_mf_list = build_control_list(root_mf, res_type); print("Got all MF {} Resources. Total: {}".format(res_type, str(len(control_mf_list))))
    control_ds_list = build_control_list(root_ds, res_type); print("Got all DS {} Resources. Total: {}".format(res_type, str(len(control_ds_list))))
    cross_count = 0
    for res in control_mf_list:
        if (res in control_ds_list):
            print('{} Resourcs {} is crossing Control-M'.format(res_type, res))
            cross_count = cross_count + 1
    print('Number of crossing {} resources: {}'.format(res_type, cross_count))
    return

def build_control_list(root, res_type):
    control_list = []
    for res in root.iter(res_type):
        res_name = res.attrib['NAME']
        if res_name not in control_list:
            control_list.append(res_name)
    return control_list



start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")