import json
from folder import folder
from folder_group import folder_group
from config_parms import config_parms
import os


class write_jsons:
    #
    # This class writes the output jsons based on the original json file breaking.
    # Folders are identified by their sequence number within the original json (and not by their name to accommodate duplicates).
    #
    def __init__(self, cp, grp_list):

        self._jsons_dict_ = dict()
        self._parm_ = cp
        self._seq_in_json_ = 0

        filename = self._parm_.get_input_file_name()

        if filename[len(filename) - 5:].lower() != '.json':  # Do nothing if the input is a test (.txt) file
            return

        print(' ' * 80, end='\r')  # clear for spinner message...
        print('Preparing json files...', end='\r')  # Spinner message...

        with open(filename, mode="r", encoding="utf-8") as infile:
            json_obj = json.load(infile)

            for f in json_obj:
                fd = json_obj[f]

                if f == "Folders":  # folders array needs to be tested... didn't see this format yet...
                    for fld in fd:
                        self._manage_json_folder_(fld['Name'], fld, grp_list)
                else:
                    self._manage_json_folder_(f, fd, grp_list)

    def _manage_json_folder_(self, fname, fdata, grp_list):
        #
        # For each folder, get the json file name assigned to it (based on the file seq) and add it to the dict managing this file.
        #
        if isinstance(fdata, dict):
            json_name = self._get_json_name_(self._seq_in_json_, grp_list)
            self._add_folder_to_json_(fname, fdata, json_name)
            self._seq_in_json_ = self._seq_in_json_ + 1

    def _get_json_name_(self, seq, grp_list):
        #
        # Returns the json file name to which the folder is to be written to
        #
        for g in grp_list:
            if seq in g.folder_seqs():
                return (g.json_name())

    def _add_folder_to_json_(self, fname, fdata, json_name):
        #
        # Adds the folder to the json dict
        #
        json = self._jsons_dict_.get(json_name)
        if json == None:
            # create a new json object in dict (first assigned folder to this json name)
            self._jsons_dict_[json_name] = dict()
            json = self._jsons_dict_[json_name]

        # Remove the folder name if exists as the name is added externaly (old CTM json format without a folder array)
        if 'Name' in fdata:
            fdata.pop('Name')

        json[fname] = fdata

    def write_jsons_to_files(self):
        #
        # Writes all the jsons to their files
        #
        os.makedirs(os.path.dirname(self._parm_.get_output_folder() + '/jsons/'), exist_ok=True)
        for j in self._jsons_dict_:
            fname = self._parm_.get_output_folder() + '/jsons/' + j
            print(' ' * 80, end='\r')  # clear for spinner message...
            print('Writing ' + fname + '...', end='\r')  # Spinner message...
            with open(fname, mode="w", encoding="utf-8") as write_file:
                json.dump(self._jsons_dict_[j], write_file, indent=2)
