import datetime
import sys

from folder_fetcher_factory import folder_fetcher_factory
from folders_merger import folders_merger
from config_parms import config_parms
from merge_jsons import merge_jsons
from write_jsons import write_jsons
from write_results import write_results

#
# The main routine 
# ---------------- 
# Breakes a set of folders (main workflow) to several distinct sets of folders (distinct workflows) that have no resource in common. 
# This allows breaking a CTM/Server content into several CTM/Servers with no interactions between each server content.
#
#    Written by Tal Kastel
#
class wf_breaker:

    def __init__(self):
        return
        
    def _print_title_with_time_(self, title):
        now = datetime.datetime.now()
        print (now.strftime("%Y-%m-%d %H:%M:%S") + ' : ' + title)

    def _print_groups_list_content_(self, grp_list):
        #
        # Print the content of all the groups in the given groups list
        #
        print ('Number of groups generated: ' + str(len(grp_list)))
        print ('==================================')
        for group in grp_list: 
            group.group_info() 
            print('----------------------------------------')   

    def _get_parms_file_name_from_args_(self):
        #
        # Returns the configuration parameters file name from the arguments (the only argument for this utility) or the default name if no argument provided
        #
        if len(sys.argv) == 2:
            return(sys.argv[1])
        else:
            return('parameters/invocation_parms.txt')
        
    def run(self):

        self._print_title_with_time_('Start...')                               # Print start message  

        parms = config_parms(self._get_parms_file_name_from_args_())           # Get parameters file name from the invocaiton argument (the input file is one of the parms)

        if parms.write_output_to_terminal():                                   # Print the parameters file to terminal (based on config parameter)
            parms.print_config_parms()
            
        inFile = folder_fetcher_factory().get_fetcher(parms.get_input_file_name())          # Get a folder fetcher (reads a folder by folder from the input file)
        
        m = folders_merger(inFile)                                             # Define the folders merger object  

        grp_list = m.merge_folders_to_groups()                                 # Merge the folders into groups

        if parms.write_output_to_terminal():
            print_groups_list_content(grp_list)                                # Print the merge results to terminal (based on config parameter)
        
        ji = None
        if parms.generate_sub_jsons():
            m = merge_jsons(grp_list)                                          # Merge the groups to as less as possible json files 
            write_jsons(parms, grp_list).write_jsons_to_files()                # Write the sub-jsons of the "broken original json" (based on config parameter)
            ji = m.get_jsons_info()
        
        write_results(parms).write_to_file(grp_list, ji)                       # Write output to excel 
        
        self._print_title_with_time_('End...')                                 # Print end message 

if __name__ == "__main__":
       wf_breaker().run()
