from folder_group import folder_group
from config_parms import config_parms

class merge_jsons ():
  #
  # This class merges the folder groups into bigger json files so the output will spand over less files. 
  # The merge is performed based on cinfiguration parameter max_jobs_in_json. 
  # When max_jobs_in_json=0, no merge is performed and each folder_group is written in its own jsod file. 
  # When max_jobs_in_json = xxx then an attempt is made to write as many groups as possible to a file that will hold no more than xxx jobs. 
  # Note that groups that already start with more jobs than xxx will be written to their own jsons and won't be split (they have internal dependencies...).
  #
  
  def __init__(self, grp_list):
   
   self._jsons_dict_  = dict()
   self._max_jobs_in_json_ = config_parms().max_jobs_in_json()
   self._curr_json_num_ = 1
   
   if self._max_jobs_in_json_ == 0:                                # if max jobs per json is set to 0 - keep each group in its own json (named as the group)
     return
      
   for g in grp_list:
     
    group_added = False

    for j in self._jsons_dict_:
      if int(self._jsons_dict_[j]) + int(g.jobs_count()) <= int(self._max_jobs_in_json_):
         #
         # json that has enough "space" can take this group so it is added there
         #
         self._jsons_dict_[j] = self._jsons_dict_[j] + g.jobs_count()
         g.set_json_name(j) 
         group_added = True
         break

    if group_added == False:                         
         #
         # if no space in any json - create a new one (or the first one...)
         #
         jname =  'J' + str(self._curr_json_num_).zfill(10)
         self._jsons_dict_[jname] = g.jobs_count()
         g.set_json_name(jname)
         self._curr_json_num_ = self._curr_json_num_ + 1

  def get_jsons_info(self):
    return self._jsons_dict_
