from folder_fetcher import folder_fetcher
from folder_fetcher_from_test_file import folder_fetcher_from_test_file
from folder_fetcher_from_json import folder_fetcher_from_json


class folder_fetcher_factory():

    def get_fetcher(self, file_name) -> folder_fetcher:
        #
        # folder_fetcher factory: return a fetcher instance based on the file type passed to it (.txt or .json).
        #
        if file_name[len(file_name) - 5:].lower() == '.json':
            return folder_fetcher_from_json(file_name)  # Input from a CTM json file (the "real thing")
        else:
            return folder_fetcher_from_test_file(file_name)  # Input from a .txt test file (debug purposes)
