from consts import consts
from config_parms import config_parms


#
# Folder Class
# ------------
#
# This class represents a folder in CTM. 
# The folder has 3 attributes: 
#   + Its name
#   + Jobs counter (how many jobs are included in it)
#   + Collection of "resources" it uses (the folder and the jobs in it)
#
# In this class a "resource" is represented by a simple string and different resource types can be supported using 
# a predefined convention (e.g. res:name for simple resource, qres:name for quantitative resource, event:name for condition).
#
class folder:

    def __init__(self, name, seq=0):
        self._folder_name_ = name
        self._seq_in_json_ = seq
        self._jobs_counter_ = 0
        self._folder_resources_ = dict()

    def add1_to_jobs_counter(self):
        self._jobs_counter_ = self._jobs_counter_ + 1

    def add_resource(self, res):
        # Only if the resource is not in the exclude list and thie type of resource is configured to be managed:
        #  If the folder does not use the resource then add it.
        #  If the folder already uses the resource, update the resource use count.
        if self._res_type_is_managed_(res) and res not in config_parms().get_exclude_list():
            if res in self._folder_resources_:
                self._folder_resources_[res] = self._folder_resources_[res] + 1
            else:
                self._folder_resources_[res] = 1

    def folder_name(self):
        return self._folder_name_

    def folder_seq(self):
        return self._seq_in_json_

    def jobs_counter(self):
        return self._jobs_counter_

    def resources(self):
        return self._folder_resources_

    def folder_info(self):
        print('Folder name: ', self._folder_name_, ', Folder Sequence in json: ', self._seq_in_json_)
        print('Jobs counter: ', self._jobs_counter_)
        print('Resources: ', self._folder_resources_)

    def _res_type_is_managed_(self, res):
        res_type = res[0: res.find(':') + 1]
        match res_type:
            case consts.EVENT_PREFIX:
                return config_parms().manage_events()
            case consts.RES_PREFIX:
                return config_parms().manage_res()
            case consts.QRES_PREFIX:
                return config_parms().manage_qres()
            case consts.VAR_PREFIX:
                return config_parms().manage_vars()
