#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt

counter_var_changed = 0
counter_vars_unmodified = 0

def main(argv):
    global counter_var_changed, counter_vars_unmodified
    input_file =  'c:\\Users\ilacohen\\OneDrive - BMC Software, Inc\\ilanc\\mf\\hcsc\\xml-folder-var-to-job\\in.xml'
    output_file = 'c:\\Users\\ilacohen\\OneDrive - BMC Software, Inc\\ilanc\\mf\\hcsc\\xml-folder-var-to-job\\output.xml'
    script_dir = 'c:\\Users\\ilacohen\\OneDrive - BMC Software, Inc\\ilanc\\mf\\hcsc\\xml-folder-var-to-job\\vbscripts'
    try:
        opts, args = getopt.getopt(argv,"hi:o:s:",["ifile=","ofile=","scriptdir="])
    except getopt.GetoptError:
        print ('xml-folder-var-to-job.py -i <inputfile> -o <outputfile>')
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print ('xml-folder-var-to-job.py -i <inputfile> -o <outputfile> -s <script-directory>')
            sys.exit()
        elif opt in ("-i", "--ifile"):
            input_file = arg
        elif opt in ("-o", "--ofile"):
            output_file = arg
        elif opt in ("-s", "--scriptdir"):
            script_dir = arg
    print ('Input file is: ' + input_file)
    print ('Output file is: ' + output_file)
    print ('Script dir is: ' + script_dir)
    counter_var_changed = 0
    counter_vars_unmodified = 0

    tree = ET.parse(input_file); print("Read the input file: " + input_file)
    root = tree.getroot()

    all_folder_var_to_job(root, script_dir); print("Changed all folders, all folders variables are must.")

    print("Writing updates to the XML file...")
    tree.write(output_file);print("Updates saved to the output XML file.")

    print ("Number of changed variables: {}".format(counter_var_changed))
    print ("Number of variables left unchanged: {}".format(counter_vars_unmodified))

# process all folders
def all_folder_var_to_job(root, script_dir):
    for folder in root.iter('SMART_FOLDER'):
        folder_var_to_job(folder, script_dir)
    return

# Process a single folder
def folder_var_to_job(folder, script_dir):
    global counter_var_changed, counter_vars_unmodified
    folder_name = folder.attrib['FOLDER_NAME']
    variable_names_to_delete = []
    for element in folder:
        if (element.tag.find('VARIABLE') >= 0):
            variable_name = element.attrib['NAME']
            owner_job_uid = None
            variable_real_name = None
            # print("Folder:{},Folder Variable:{},under-location:{}".format(folder_name, variable_name, variable_name.find('_') ))
            if (variable_name.find('_') == 14):
                owner_job_uid = variable_name[2:14]
                variable_real_name = variable_name[15:]
            if (variable_name[29:30] == '_'):
                owner_job_uid = variable_name[17:29]
                variable_real_name = variable_name[30:]
            if (owner_job_uid != None):
                variable_real_value = element.attrib['VALUE']
                # print("Folder:{},Folde Variable:{},uid:{}".format(folder_name, variable_name, owner_job_uid ))
                job_list = get_job_list_by_var(folder, variable_name)
                if (len(job_list) == 1):
                    # print("no external usage: Folder:{},Folder Variable:{}".format(folder_name, variable_name))
                    # detect source job
                    job = get_job_by_zena_uid(folder, owner_job_uid)
                    if (job != None):
                        # print("found in job: Folder:{},Folder Variable:{},job:{}".format(folder_name, variable_name,job.attrib['JOBNAME']))
                        # print("going to replace: Folder Variable:{},job-ZenaUID:{},real-name:{}, with value:{}".format(variable_name, owner_job_uid, variable_real_name, variable_real_value))
                        if (not var_set_by_vb_script(job, variable_real_name, script_dir)):
                            # print ("Variable set by the script in folder:{} in job:{} var name:{}".format(folder_name, variable_name,job.attrib['JOBNAME']))
                            # else:
                            #   replace in job 
                            update_job_var(job, variable_name, variable_real_name, variable_real_value)
                            counter_var_changed += 1
                            #   delete in folder
                            variable_names_to_delete.append(variable_name)
                            # print ("Variable moved to job level. Folder:{} in job:{} var name:{}".format(folder_name,job.attrib['JOBNAME'], variable_name))
                        else:
                            counter_vars_unmodified += 1

                else:
                    counter_vars_unmodified += 1
                    # for job in job_list:
                    #     zena_uid = get_job_zena_uid(job)
                    #     job_name = job.attrib['JOBNAME']
                    #     print("Multi job: Folder:{},Folder Variable:{},Job:{},Uid={}".format(folder_name, variable_name, job_name,zena_uid ))
            # else:
                # print("Not found - Folder:{},Folder Variable:{},under-location:{}".format(folder_name, variable_name, variable_name.find('_') ))

    for element in folder:
        if (element.tag.find('VARIABLE') >= 0):
            variable_name = element.attrib['NAME']
            if (variable_name in variable_names_to_delete):
                folder.remove(element)
    return

def get_job_zena_uid(job):
    variable_list = job.iter('VARIABLE')
    zena_uid = ""
    for variable in variable_list:
        var_name = variable.attrib['NAME']
        if (var_name.find("%%ZenaUID") >= 0):
            zena_uid = variable.attrib['VALUE']
    return zena_uid

def get_job_list_by_var(folder, variable_name):
    jobs_with_var_list = []
    for job in folder.iter('JOB'):
        job_name = job.attrib['JOBNAME']
        variable_list = job.iter('VARIABLE')
        for variable in variable_list:
            var_name = variable.attrib['NAME']
            # print("checking Folder:{},Folder Variable:{},job:{},current var:{}".format(folder.attrib['FOLDER_NAME'], variable_name, job_name, var_name ))
            if (var_name.find(variable_name) >= 0):
                jobs_with_var_list.append(job)
            var_value = variable.attrib['VALUE']
            if (var_value.find(variable_name) >= 0):
                if (not job in jobs_with_var_list):
                    jobs_with_var_list.append(job)
        for attr_key, attr_value in job.items():
            # print ("key:{},value{}".format(attr_key, attr_value))
            if (attr_value.find(variable_name) >= 0):
                if (not job in jobs_with_var_list):
                    jobs_with_var_list.append(job)

 
    return jobs_with_var_list

def get_job_by_zena_uid(folder, zena_uid):
    for job in folder.iter('JOB'):
        for variable in job.iter('VARIABLE'):
            var_name = variable.attrib['NAME']
            if (var_name.find("%%ZenaUID") == 0):
                if (variable.attrib["VALUE"].find(zena_uid) == 0):
                    return job
    return None

def update_job_var(job, folder_variable_name, variable_real_name, variable_real_value):
    for variable in job.iter('VARIABLE'):
        var_name = variable.attrib['NAME']
        if (var_name.find('%%' + variable_real_name) == 0):
            # print("real variable value is:{}".format(variable.attrib['VALUE'] ))
            if (variable.attrib['VALUE'].find(folder_variable_name) == 0):
                variable.attrib['VALUE'] = variable_real_value
                # print ("value replaced")
                return
    return

def var_set_by_vb_script(job, variable_real_name, script_dir):
    # print ("Checking variable for job:{} var name:{}".format(variable_real_name,job.attrib['JOBNAME']))
    command_line = None
    if (job.attrib['TASKTYPE'] == 'Command'):
        command_line = job.attrib['CMDLINE']
    if (command_line != None and command_line.find('cscript.exe') > 0):
        cscript_col = command_line.find('cscript.exe')
        cmdline_vbs_script_full_name = command_line[cscript_col+13:len(command_line)-1]
        basename = os.path.basename(cmdline_vbs_script_full_name)
        # print("Looking for VBS in {}, file name:{}".format(cmdline_vbs_script_full_name, basename))
        vbs_script_full_name = script_dir + "\\" + basename
        vbs_file = open(vbs_script_full_name, 'r') 
        vbs_lines = vbs_file.readlines() 
        for vbs_line in vbs_lines: 
            # print("Line: {}".format( vbs_line))
            if (line_uses_variable(vbs_line, variable_real_name)):
                # print("Line {} uses variable {}".format( vbs_line, variable_real_name))
                return True
    return False

def line_uses_variable(line, variable_real_name):
    if (line.find('ctmvar') > 0 and line.find('ZenaUid') > 0):
        if (line.find('_' + variable_real_name + ' ') > 0):
            return True
    return False


start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")