#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re

attributes_to_resolve: list = [
    "CMDLINE", 
    "MEMLIB" 
    ]
variables_to_keep: list = [
    # "%%FILENAME"
    ]

USAGE= "convert-linux-jcl.py -i <inputdir> -o <outputdir> [-e <encoding>]"
def main(argv):
    input_dir =  "c:\\temp\\JCLLIB_LINUX"
    output_dir = 'linux-out'
    encoding = 'ANSI'
    try:
        opts, args = getopt.getopt(argv,"hi:o:e:",["infile=","ofile="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt in ("-i", "--infile"):
            input_dir = arg
        elif opt in ("-o", "--ofile"):
            output_dir= arg
        elif opt in ("-e"):
            encoding= arg
    print ('Input dir is: ' + input_dir)
    print ('Output dir is: ' + output_dir)
    print ('File encoding in use is: ' + encoding)

    directory = os.fsencode(input_dir)
    for file in os.listdir(directory):
        filename = os.fsdecode(file)
        filepath = os.path.join(input_dir, filename)
        print('processing {}'.format(filepath))
        output_lines = process_file(filepath, encoding)
        with open(os.path.join(output_dir, filename), 'w',encoding=encoding) as f:
            for line in output_lines:
                f.write(line + '\n')


def process_file(filepath, encoding):
    output_line = []
    with open(filepath, encoding=encoding) as file:
        lines = file.readlines()
        lines = [line.rstrip() for line in lines]
    for line in lines:
        output_line.append(process_line(line))
    return output_line

def process_line(line):
    if line.startswith('//*%OPC'):
        line = '# ' + line
    if line.find('&OJOBNAME') > 0:
        print('replaced variables: &OJOBNAME')
        line = line.replace('&OJOBNAME', '$JOBNAME')
    regex = r"(.)*=(\s)*(&)[a-zA-Z]"
    matches = re.finditer(regex, line)
    for matchnum, match in enumerate(matches, start=1):
        matched_col = match.start(3)
        print('replaced variables:{}'.format(line[matched_col+1:]))
        line = line[:matched_col] + '$' + line[matched_col+1:]

    if ((line.find('&&') < 0) and (line.find('&') > 0)):
        print('line with OPC variable:{}'.format(line))
    return line

start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")