@echo off

SET CURRENT_DIR=%CD%
SET BATCH_DIR=%~dp0
CD %BATCH_DIR%..\..\..
SET ROOT_DIR=%CD%
CD %CURRENT_DIR%

SETLOCAL

set "BridgeBuilder_jar_file=%ROOT_DIR%\lib\Tools\caespToCtmBridgeBuilder-1.0.jar"
IF NOT EXIST "%BridgeBuilder_jar_file%" (
    echo.
                echo "%CD%"
    echo The file "%BridgeBuilder_jar_file%" was not found
    echo.
)
CD %BATCH_DIR%

:: if date format of the CSV created by the EM Reporting Facility is not American, un-comment the following
:: line, and if required modify the value to match the exact format found in the file
:: SET EMREPORTINGFACILITYDATEFORMAT="dd/MM/yy HH:mm:ssa"

:: echo checking %ROOT_DIR%
IF NOT EXIST "%ROOT_DIR%\JRE" (GOTO PATH_JAVA)

IF "%RUN_MY_JAVA%"=="" GOTO CONVERSION_JAVA
IF %RUN_MY_JAVA% NEQ RUN_MY_JAVA goto CONVERSION_JAVA
GOTO PATH_JAVA

:CONVERSION_JAVA
:: echo using Java from conversion
:: echo 64-bit...
"%ROOT_DIR%\JRE\jre_64\bin\java.exe" -cp "%ROOT_DIR%\lib\Infrastructure\*;%BridgeBuilder_jar_file%" com.bmc.caespToCtmBridgeBuilder.App %*
GOTO EXIT

:PATH_JAVA
echo using Java from PATH
java -version >NUL 2>&1
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA

java -version 2>&1 | findstr /r "1[5-9]\.[0-9]*" >NUL
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA
::echo RUN_MY_JAVA = %RUN_MY_JAVA%
java.exe   -jar   -Djco.trace_path=logs %BridgeBuilder_jar_file%
goto EXIT

:EXIT
ENDLOCAL
SET RC=%errorLevel%
CD %CURRENT_DIR%
echo.
exit /B %RC%

:NO_JAVA
  echo.
  echo This utility requires Java Runtime Environment version 1.8 or higher.
  echo Make sure Java is installed and configured before reruning the utility.
  echo.
  pause
  goto EXIT
