8#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re
import concurrent.futures 
import logging
from datetime import datetime
from multiprocessing import Process
import openpyxl

#these variables will be shared between functions so they're GLOBAL! 

USAGE= "leadtime99_cond_cleanup.py -i <inputfile> -o <outputdir> -l <logfile> -d <y/N> -x <Excelfile> -s<suffix>"
dict99={} # dictionary to store all conditions relative to leadtm=99    
folderTot=0
folderCur=0
removed = 0
outcondTot = 0
delete = 'N'
wb = openpyxl.Workbook()
ws = wb.active

def main(argv):
    input_file =  ''
    output_dir = 'out'
    log_dir = ''
    global ok_suffix, condition_format, remove_date, conditions_names, sched_id_sep
    global wb,ws,delete, excel
    ok_suffix = '_OK'
    sched_id_sep = '!'
    condition_format = 'u'
    remove_date = "ODAT"
    excel =''
    # parse arguments
    try:
        opts, args = getopt.getopt(argv,"h:i:o:d:l:x:s:",["infile=","odir=","logfile=", "xl="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt in ("-i", "--infile"):
            input_file = arg
        elif opt in ("-o", "--odir"):
            output_dir = arg
        elif opt in ("-l", "--logfile"):
            log_dir = arg            
        elif opt in ("-x", "--xl"):
            excel = arg            
        elif opt in ("-s"):
            ok_suffix = arg
        elif opt in ("-d"):
            delete = arg            
            if delete.lower() != 'n' and delete.lower() != 'y':
               print("invalid value for -d '"+delete+"' - please enter Y or N") 
               return 99

    if log_dir=='':  
        # if no specific log given, create one in the input folder           
        p = os.path.abspath(input_file)
        log_dir = os.path.dirname(p)
    
    if excel != '':
        # excel file name is not empt - if there's no path in the name, we'll create it in 
        # the output folder
        if excel.count("\\") ==0:
            excel = output_dir + "\\" + excel
        if not excel.lower().endswith('.xlsx'):
            excel = excel+".xlsx" 
        ws.append(["condition", "folder", "job"])
    
    #allocate and instantiate logfile
    generate_log_file(log_dir)
    
    logging.info(' script parameters: ' + str(args))
    logging.info(' script options   : ' + str(opts))
    
    if delete.lower() == 'n':
        logging.info(' delete option is NO - no output file will be generated')
    else:
        logging.info(' delete option is YES - will write a new file without the conditions related to LEADTIME=99')
    
    logging.info(' Input file from MF is: ' + input_file)
    print ('Input file from MF is: ' + input_file)

    #parse the XML tree
    tree_mf = ET.parse(input_file); 
    print("Read the MF input file: " + input_file)
    logging.info(' Read the MF input file: ' + input_file)
    
    root_mf = tree_mf.getroot()
    process_all_folders(root_mf)
    
    print ("Scanned", str(outcondTot), "out conditions - removed ",str(removed), "conditions")
    logging.info(" Scanned " + str(outcondTot)+ " out conditions - removed "+str(removed)+ " conditions")

    if excel != '':
        wb.save(excel)    
        
    if delete.lower() == 'y':
        print("Writing updates to the XML file...")     
        logging.info("Writing updates to the XML file...")
        tree_mf.write(output_dir + "\\" + os.path.basename(input_file));
        print(" updates saved to the output XML file.")
        logging.info(" updates saved to the output XML file.")
    

def process_all_folders(root):
    # Step 1: build a dictionary of all conditions that we need to track in step 2.
    global folderCur
    global folderTot
    folderTot = len(root)
    print("Building conditions dictionary")
    logging.info(" Building conditions dictionary")
    
    # no need for sequential processing, so process the XML tree using multiple threads
    
    with concurrent.futures.ThreadPoolExecutor() as executor: 
        for folder in root.iter('SMART_FOLDER'):
            folderCur = folderCur + 1
            executor.submit(iterate_jobs(folder))
        #iterate_jobs(folder)

    with concurrent.futures.ThreadPoolExecutor() as executor: 
        for folder in root.iter('FOLDER'):
            folderCur = folderCur + 1
            executor.submit(iterate_jobs(folder))           
        #iterate_jobs(folder)    
        
    folderCur = 0
    print("Dictionary building completed                              ")
    print("Conditions dictionary contains", str(len(dict99)) ,"entries")        
    print("Removing unnecessary conditions")  
    logging.info(" Dictionary building completed")
    logging.info(" Conditions dictionary contains " + str(len(dict99)) +" entries")
    logging.info(" Removing unnecessary conditions")                       
    
    # Step 2: scan all OUTCONDS with a "+" SIGN and check if they are in the dictionary
    
    with concurrent.futures.ThreadPoolExecutor() as executor: 
        for folder in root.iter('SMART_FOLDER'):
            folderCur = folderCur + 1        
            executor.submit(remove_ldt99_conds(folder))
            #remove_ldt99_conds(folder)
    with concurrent.futures.ThreadPoolExecutor() as executor: 
        for folder in root.iter('FOLDER'):        
            folderCur = folderCur+1
            executor.submit(remove_ldt99_conds(folder))
            #remove_ldt99_conds(folder)
               
    return

def iterate_jobs(folder):
    # step 1: iterate all jobs in a folder
    global folderCur
    global folderTot    

    jobl = len(folder)
    jobn = 0
    foldperc = folderCur/folderTot 
    with concurrent.futures.ThreadPoolExecutor() as executor: 
        for job in folder.iter('JOB'):
            jobn=jobn+1
            jobperc = jobn/jobl
            msg = 'folder '+str(folderCur)+'/'+str(folderTot)+ ' ({:.2%}) -  job ' + str(jobn) + '/' + str(jobl) + ' ({:.2%})' + '                    '
            print(msg.format(foldperc,jobperc), end='\r')
            executor.submit(job_handler(job,folder))
    return

def job_handler(job,folder):
    # this proc is needed to avoid a lambda in the submit 
    # see if there's at least one SETVAR %%LEADTM=99*
    handle_this_job = find_leadtime99(job)
    # if it's there, let's add them all to the dictionary
    if handle_this_job == True:
        add_job_conditions(job,folder)

def find_leadtime99(job):
    # leadtime=99 -> out condition receiver must be in this table
    for variable in job.iter('VARIABLE'):
        if variable.attrib['NAME'] == '%%LEADTM' and variable.attrib['VALUE'].startswith("99"):
            return True
    return False

def add_job_conditions(job,folder):
    # building condition dictiorary    
    global dict99
    folder_name = folder.attrib["FOLDER_NAME"]
    for variable in job.iter('VARIABLE'):
        if variable.attrib['NAME'] == '%%LEADTM' and variable.attrib['VALUE'].startswith("99"):
            jobname_a = variable.attrib['VALUE'].split("_")[2]
            jobname_b = job.attrib['MEMNAME']
            condname = jobname_a + '_' + jobname_b + ok_suffix
            #temp_job = folder.findall(".//JOB[@MEMNAME='"+jobname_a+"']") 
            #if len(temp_job) > 0:
            if not condname in dict99:
                dict99[condname] = folder_name
    return
                   
def remove_ldt99_conds(folder):
    # step 2: iterate all job in all folders     
    global folderCur
    global folderTot
    jobl = len(folder)
    jobn = 0
    foldperc = folderCur/folderTot
    with concurrent.futures.ThreadPoolExecutor() as executor:         
        for job in folder.iter('JOB'):
            jobn = jobn + 1
            jobperc = jobn/jobl
            msg = 'folder '+str(folderCur)+'/'+str(folderTot)+ ' ({:.2%}) -  job ' + str(jobn) + '/' + str(jobl) + ' ({:.2%})' + '                    '
            print(msg.format(foldperc,jobperc), end='\r')
            executor.submit(fix_job(job,folder))
    return

def fix_job(job,folder):
    # step 2: iterate thru all OUTCONDS
    # please note: copy operation is needed to iterate while deleting list members    
    jobcopy = copy.copy(job)
    for outcond in jobcopy.iter('OUTCOND'):
        chk_cond(outcond,job,folder)
    return            

def chk_cond(outcond, job,folder):
    global dict99
    global removed
    global outcondTot
    global delete
    global wb,ws
    folder_name = folder.attrib["FOLDER_NAME"]
    job_name = job.attrib["MEMNAME"]        
    # STEP 2: we only deal with ADD OUTCONDs
    if outcond.attrib['SIGN'] == '+':
        outcondTot = outcondTot+1
        cond_name = outcond.attrib['NAME']
        # is it in the dictionary?
        if cond_name in dict99:
            #get receiver job's name - sender_receiver_OK -  0_1_2 for split
            jobname = cond_name.split("_")[1]
            # let's see if we have a job with that name in the folder where the job resides
            temp_job = folder.find(".//JOB[@MEMNAME='"+jobname+"']") 
            # temp job is the first such jobs, if present
            if temp_job is None:
                # log deletion
                logging.info(" Removing " + cond_name + " in folder " + folder_name + " job " + job_name) 
                # write it to excel sheet if needed
                if excel != '':
                    ws.append([cond_name,folder_name,job_name])   
                # actually remove it from the XML tree if delete parameter = Y
                if delete.lower() == 'y':
                    job.remove(outcond)
                    removed = removed + 1
            
            
def generate_log_file(logfile):
    # instantiate the logger class
    
    # if we've been given just a valid directory, append file name
    if os.path.isdir(logfile):
        path = os.path.join(logfile, "leadtime99_cond_cleanup.log")
    else:
        path = logfile        

    #fh = logging.FileHandler(path, mode='w')        
    
    
    logging.basicConfig(filename=path, 
                        level=logging.INFO,
                        filemode='w', #overwrites previous run
                        format='%(asctime)s %(levelname)s %(message)s', # log format date/time INFO message
                        datefmt='%Y-%m-%d %H:%M:%S') 
           
start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")