#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import sys, getopt
import csv
from datetime import date
from datetime import datetime

USAGE= "leadtime-report-creation.py -m <inputfile> -d <inputfile> -o <output-report>"
def main(argv):
    input_mf_file =  ''
    input_ds_file =  ''
    output_report = 'lead_time_report.csv'
    try:
        opts, args = getopt.getopt(argv,"hm:d:o:",["mffile=","dsfile=","orep="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt in ("-m", "--mffile"):
            input_mf_file = arg
        elif opt in ("-d", "--dsfile"):
            input_ds_file = arg
        elif opt in ("-o", "--orep"):
            output_report= arg
    print ('Input file from MF is: ' + input_mf_file)
    print ('Input file from DS is: ' + input_ds_file)
    print ('Output report is: ' + output_report)

    tree = ET.parse(input_mf_file); print("Read the MF input file: " + input_mf_file)
    root = tree.getroot()
    tree_ds = ET.parse(input_ds_file); print("Read the DS input file: " + input_ds_file)
    root_ds = tree_ds.getroot()
    merge_trees(root, root_ds)

    header = ['job-name', 'lead-job', 'lead-time', 'schid', 'predecessor-job', 'predecessor-lead-job', 'same-flow', 'from-time', 'prev-required', 'type', 'last-run', 'pred-last-run', 'actual-lead-time']
    with open(output_report, 'w', encoding='UTF8', newline='') as csv_report:
        csv_writer = csv.writer(csv_report)
        csv_writer.writerow(header)
        process_all_jobs(root, csv_writer)

def merge_trees(root, root_ds):
    for folder in root_ds.iter('SMART_FOLDER'):
        root.append(folder)
    for folder in root_ds.iter('FOLDER'):
        root.append(folder)
    return

def process_all_jobs(root, csv_writer):
    for job in root.iter('JOB'):
        for var in job.iter('VARIABLE'):
            if (var.attrib['NAME'] == "%%LEADTM"):
                jobname = get_jobname(job)
                value = var.attrib['VALUE']
                leadtm = value[0:2]
                schid = value[3:6]
                group = get_group(job)
                jobtype = get_job_type(job)
                fromtime = "0000"
                try:
                    fromtime = job.attrib['TIMEFROM']
                except KeyError:
                    fromtime = get_folder_from_time(root, group)
                fromtime = "{}:{}".format(fromtime[0:2],fromtime[2])

                prev_required = 'N/A'
                if (leadtm > '00' and leadtm < '99'):
                    time_diff = int(fromtime[0:2]) - int(leadtm)
                    if (time_diff > 0):
                        prev_required = 'No'
                    else:
                        prev_required = 'Yes'
                predecessor_name = value[7:]
                predecessor_job = get_job_by_name(root, predecessor_name)
                last_run = 'N/A'
                pred_last_run = 'N/A'
                actual_lead_time = 'N/A'
                if (predecessor_job == None):
                    # print("job {} does not exists, even though other jobs has it as predecessor".format(predecessor_name))
                    predecessor_folder = 'N/A'
                    same = 'N/A'
                else:
                    predecessor_folder = get_group(predecessor_job)
                    last_run_datetime = get_last_run(job)
                    pred_last_run_datetime = get_last_run(predecessor_job)
                    if (last_run_datetime != None and pred_last_run_datetime != None ):
                        last_run = format(last_run_datetime.strftime('%m/%d/%y+%H:%M'))
                        pred_last_run = format(pred_last_run_datetime.strftime('%m/%d/%y+%H:%M'))
                        if (pred_last_run_datetime < last_run_datetime):
                            actual_lead_time_datetime = last_run_datetime - pred_last_run_datetime
                            actual_lead_time = actual_lead_time_datetime.days * 24 + actual_lead_time_datetime.seconds//3600
                            if ((actual_lead_time_datetime.seconds//60)%60 > 30):
                                actual_lead_time = actual_lead_time + 1
                    same = "No"
                    if predecessor_folder == group:
                        same = "Yes"
                csv_writer.writerow([jobname, group, leadtm, schid, predecessor_name, predecessor_folder, same, fromtime, prev_required ,jobtype, \
                        last_run, pred_last_run, actual_lead_time])
                # print("In job {}/{} found LEADTM with value {}, leadtm {}. schid {}, predecessor {}/{}".format(jobname, group, var.attrib['VALUE'], leadtm, schid, predecessor_name, predecessor_folder))

def get_jobname(job):
    job_name = ''
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        job_name = job.attrib['MEMNAME']
    return job_name

def get_group(job):
    group = ''
    try:
        group = job.attrib['GROUP']
    except KeyError:
        group = job.attrib['SUB_APPLICATION']
    return group

def get_job_by_name(root, jobname):
    for job in root.iter('JOB'):
        if (get_jobname(job) == jobname):
            return job
    # print("job not found {}".format(jobname))
    return None

def get_job_type(job):
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        return "MF"
    return "DS"

def get_folder_from_time(root, foldername):
    timefrom = "0000"
    for folder in root.iter('SMART_FOLDER'):
        if folder.attrib['MEMNAME'] == foldername:
            try:
                timefrom = folder.attrib['TIMEFROM']
            except KeyError:
                timefrom = "0000"
    return timefrom
def get_last_run(job):
    run_date = None
    for var in job.iter('VARIABLE'):
        if (var.attrib['NAME'] == "%%$LASTRUNDT"):
            last_run = var.attrib['VALUE']
            if (last_run == '00000/0000'):
                return None
            run_date = datetime.strptime(last_run, "%y%j/%H%M")
    return run_date




start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")