#!/usr/bin/python
#coding=utf8

import xml.etree.cElementTree as ET			
import os, time, math		
import copy, re	   
import sys, getopt
from os.path import isfile, join
from os import listdir
import re


USAGE= "collide-multi-sched.py -i <inputfile> -o <outputfile> [-s <schedule-library>] [-f <suffix>] [-c <comparedir>]"
def main(argv):
    input_file =  ''
    output_file =  ''
    compare_dir = ''
    global schedule_library
    schedule_library = ''
    global ok_suffix
    ok_suffix = '_OK'

    try:
        opts, args = getopt.getopt(argv,"hi:o:s:f:c:",["ifile=","ofile="])
    except getopt.GetoptError:
        print (USAGE)
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print (USAGE)
            sys.exit()
        elif opt == "-c":
            compare_dir = arg
        elif opt == "-s":
            schedule_library = arg
        elif opt == "-f":
            ok_suffix = arg
        elif opt in ("-i", "--ifile"):
            input_file = arg
        elif opt in ("-o", "--ofile"):
            output_file = arg
    print ('Input file is: ' + input_file)
    print ('Output file is: ' + output_file)
    if len(compare_dir) > 0:
        print ('Compare dir is: ' + compare_dir)

    tree = ET.parse(input_file); print("Read the MF input file: " + input_file)
    root = tree.getroot()

    if len(compare_dir) > 0:
        tree.write(compare_dir + "\\" + os.path.basename(input_file));print("Original saved for comparison.")
 

    process_all_folders(root)

    print("Writing updates to the XML file...")

    tree.write(output_file);print("Updates saved to the output XML file.")

def process_all_folders(root):
    global schedule_library
    if len(schedule_library) == 0:
        schedule_library = get_smart_folder_dsn(root)
    smart_folder_dict = build_folder_dict(root)
    collide_all_folders(root, smart_folder_dict)
    return

def build_folder_dict(root):
    folder_dict = {}
    for folder in root.iter('SMART_FOLDER'):
        folder_dict[folder.attrib['FOLDER_NAME']] = folder
    return folder_dict

def collide_all_folders(root, smart_folder_dict):
    global schedule_library
    folders_to_delete = []
    for folder in root.iter('FOLDER'):
        if (folder.attrib['PLATFORM'] == 'MVS'):
            if (folder.attrib['FOLDER_DSN'] != schedule_library):
                folder_name = folder.attrib['FOLDER_NAME']
                folder_name_to_delete = folder_name + '+' + folder.attrib['FOLDER_DSN']
                folder_schid = folder.attrib['FOLDER_DSN'][-3:]
            else:
                continue
        if (folder.attrib['PLATFORM'] == 'UNIX'):
            if folder.attrib['FOLDER_NAME'].find(".") > 0:
                folder_name, folder_schid = folder.attrib['FOLDER_NAME'].split(".")
                folder_name_to_delete = folder.attrib['FOLDER_NAME']
            else:
                continue
        if folder_name in smart_folder_dict:
            target_folder = smart_folder_dict.get(folder_name)
            collide_folder(folder, target_folder, folder_schid)
            folders_to_delete.append(folder_name_to_delete)
        else:
            make_folder_smart(folder, folder_name, folder_schid)
            smart_folder_dict[folder_name] = folder
               

    delete_redundent_folders(root, folders_to_delete)
    return

def make_folder_smart(folder, folder_name, folder_schid):
    global schedule_library
    if folder.attrib['PLATFORM'] == 'MVS':
        folder.attrib['FOLDER_DSN'] = schedule_library
    folder.tag = "SMART_FOLDER"   # make it SMART - Add RBCs
    folder.attrib['FOLDER_NAME'] = folder_name # for DS
    job = get_head_of_tree_job(folder, folder_name)
    folder.attrib['MEMNAME'] = folder_name
    folder.attrib['GROUP'] = folder_name
    folder.attrib['MAXWAIT'] = job.attrib['MAXWAIT']
    folder.attrib['OWNER'] = job.attrib['OWNER']
    folder.attrib['REMOVEATONCE'] = 'Y'
    folder.attrib['DAYSKEEPINNOTOK'] = '00'
    folder.attrib['ADJUST_COND'] = '1'
    folder.attrib['TASKTYPE'] = 'SMART Table'
    folder.attrib['APPLICATION'] = job.attrib['APPLICATION']
    folder.attrib['DOCMEM'] = folder_name
    # rbc = copy.deepcopy(skeleton_rbc)
    rbc_name = folder_schid + '_' + folder_name
    add_rbc_from_a_job(folder,job, rbc_name)
    
    clear_local_sched_and_add_rbc(folder, rbc_name)

    rename_inter_condition(folder, folder_schid, folder_name)
    return
def clear_local_sched_and_add_rbc(folder, rbc_name):
    rbc_ref = ET.Element('RULE_BASED_CALENDARS')
    rbc_ref.attrib['NAME'] = rbc_name
    for job in folder.iter('JOB'):
        job.attrib['GROUP'] = folder.attrib['FOLDER_NAME']
        job.append(copy.deepcopy(rbc_ref))
        job.attrib.pop('DAYS', None)
        job.attrib.pop('DAYSCAL', None)
        job.attrib.pop('DAYS_AND_OR', None)
        job.attrib.pop('WEEKDAYS', None)
        job.attrib.pop('WEEKSCAL', None)
        job.attrib.pop('CONFCAL', None)
        job.attrib.pop('SHIFT', None)
        job.attrib.pop('SHIFTNUM', None)
        job.attrib.pop('DATE', None)
        job.attrib.pop('JAN', None)
        job.attrib.pop('FEB', None)
        job.attrib.pop('MAR', None)
        job.attrib.pop('APR', None)
        job.attrib.pop('MAY', None)
        job.attrib.pop('JUN', None)
        job.attrib.pop('JUL', None)
        job.attrib.pop('AUG', None)
        job.attrib.pop('SEP', None)
        job.attrib.pop('OCT', None)
        job.attrib.pop('NOV', None)
        job.attrib.pop('DEC', None)
        job.attrib.pop('SAC', None)
        active_from_value = ""
        try:
            active_from_value = job.attrib['ACTIVE_FROM']
        except KeyError:
            pass
        active_till_value = ""
        try:
            active_till_value = job.attrib['ACTIVE_TILL']
        except KeyError:
            pass
        if active_from_value != "" or active_till_value != "":
            job.attrib['RULE_BASED_CALENDAR_RELATIONSHIP'] = 'A'
            job.attrib['DAYS'] = 'ALL'
            print ('job {} in folder {} has Active From {}'.format(get_jobname(job), folder.attrib['FOLDER_NAME'],active_from_value))

        else:
            job.attrib['RULE_BASED_CALENDAR_RELATIONSHIP'] = 'O'

    return
def add_rbc_from_a_job(folder,job, rbc_name):
    rbc = ET.Element('RULE_BASED_CALENDAR')
    rbc.attrib['NAME'] = rbc_name
    copy_rbc_attribute(rbc, job, 'MAXWAIT')
    copy_rbc_attribute(rbc, job, 'DAYS')
    copy_rbc_attribute(rbc, job, 'DAYSCAL')
    copy_rbc_attribute(rbc, job, 'DAYS_AND_OR')
    copy_rbc_attribute(rbc, job, 'WEEKDAYS')
    copy_rbc_attribute(rbc, job, 'WEEKSCAL')
    copy_rbc_attribute(rbc, job, 'CONFCAL')
    copy_rbc_attribute(rbc, job, 'SHIFT')
    copy_rbc_attribute(rbc, job, 'SHIFTNUM')
    copy_rbc_attribute(rbc, job, 'DATE')
    copy_rbc_attribute(rbc, job, 'JAN')
    copy_rbc_attribute(rbc, job, 'FEB')
    copy_rbc_attribute(rbc, job, 'MAR')
    copy_rbc_attribute(rbc, job, 'APR')
    copy_rbc_attribute(rbc, job, 'MAY')
    copy_rbc_attribute(rbc, job, 'JUN')
    copy_rbc_attribute(rbc, job, 'JUL')
    copy_rbc_attribute(rbc, job, 'AUG')
    copy_rbc_attribute(rbc, job, 'SEP')
    copy_rbc_attribute(rbc, job, 'OCT')
    copy_rbc_attribute(rbc, job, 'NOV')
    copy_rbc_attribute(rbc, job, 'DEC')
    copy_rbc_attribute(rbc, job, 'SAC')
    # copy_rbc_attribute(rbc, job, 'ACTIVE_FROM')
    # copy_rbc_attribute(rbc, job, 'ACTIVE_TILL')
    print ('job {} in folder {} with rbc {}'.format(get_jobname(job), folder.attrib['FOLDER_NAME'], rbc_name))
    folder.append(rbc)

    return

def collide_folder(folder, target_folder, folder_schid):
    rbc_name = folder_schid + '_' + target_folder.attrib['FOLDER_NAME']
    job = get_head_of_tree_job(folder, target_folder.attrib['FOLDER_NAME'])
    add_rbc_from_a_job(target_folder,job, rbc_name)    
    clear_local_sched_and_add_rbc(folder, rbc_name)
    # Extract schedulin criteria and create RBC to be used by each job
    rename_inter_condition(folder, folder_schid, target_folder.attrib['FOLDER_NAME'])
    for job in folder.iter('JOB'):
        target_folder.append(job)
    #
    return


def get_head_of_tree_job(folder, folder_name):
    for job in folder.iter('JOB'):
        # print ('job {} in folder {} checking if head-of-tree'.format(get_jobname(job), folder_name))
        if (get_jobname(job) == folder_name):
            # print ('job {} in folder {} is head-of-tree'.format(get_jobname(job), folder.attrib['FOLDER_NAME']))
            return job
    return job

def copy_rbc_attribute(rbc, job, attribute):
    try:
        rbc.attrib[attribute] = job.attrib[attribute]
    except KeyError:
        pass
    return


def get_jobname(job):
    job_name = ''
    try:
        job_name = job.attrib['JOBNAME']
    except KeyError:
        job_name = job.attrib['MEMNAME']
    return job_name


def get_smart_folder_dsn(root):
    schedule_library = ''
    for folder in root.iter('SMART_FOLDER'):
        try:
            schedule_library = folder.attrib['FOLDER_DSN']
            return schedule_library
        except KeyError:
            pass
 
    return schedule_library

def rename_inter_condition(folder, folder_schid, target_folder_name):
    dict_of_out_cond = get_dict_of_all_out_cond(folder)
    for job in folder.iter('JOB'):
        for in_cond in job.iter('INCOND'):
            in_cond_name = in_cond.attrib['NAME']
            if in_cond_name in dict_of_out_cond.keys():
                # print('incond {} is to be renamed '.format(in_cond_name))
                new_cond_name = get_new_cond_name(job, target_folder_name, in_cond_name, folder_schid)
                in_cond.attrib['NAME'] = new_cond_name
                dict_of_out_cond.get(in_cond_name).attrib['NAME'] = new_cond_name
    return

def get_new_cond_name(job, target_folder_name, in_cond_name, folder_schid):
    regex = '(\S*(-)?)(T(\d)*)[_-](\S*)(_\d\d)?' + ok_suffix # multiple copies counter support must be added
    results = re.findall(regex, in_cond_name)
    if len(results) > 0:
        result = results[0]
        prefix = result[0]
        # init_folder_name = result[2]
        source_job = result[4]
        counter = result[5]
        # print('for cond {}, prefix is {} and init_table is {}, source job is {}'.format(in_cond_name, prefix, init_folder_name, target_job))
        # new_cond_name = prefix + source_job + '_' + get_jobname(job) + '_S' + folder_schid + ok_suffix
        new_cond_name = prefix + target_folder_name + '_' + source_job + '_S' + folder_schid + counter + ok_suffix
    else:
        print('in job {}, in condition name {} can not be parsed'.format(get_jobname(job), in_cond_name))
        new_cond_name = in_cond_name + '_S' + folder_schid
    return new_cond_name 

def get_dict_of_all_out_cond(folder):
    dict_of_out_cond:dict = {}
    if folder is not None:
        for job in folder.iter('JOB'):
            for out_cond in job.iter('OUTCOND'):
                out_cond_name:str = out_cond.attrib['NAME']
                if out_cond.attrib['SIGN'] == 'ADD' or out_cond.attrib['SIGN'] == '+':
                    if out_cond_name.endswith(get_jobname(job) + ok_suffix) or \
                        re.match("\S*" + "T" + "(\d)*" + '_' + get_jobname(job) + "_\d\d" + ok_suffix, out_cond_name):
                        dict_of_out_cond[out_cond_name] = out_cond
    return dict_of_out_cond

def delete_redundent_folders(root, folders_to_delete):
    for item_to_delete in folders_to_delete:
        for folder in root.iter('FOLDER'):
            if (folder.attrib['PLATFORM'] == 'MVS'):
                if item_to_delete == folder.attrib['FOLDER_NAME'] + '+' + folder.attrib['FOLDER_DSN']:
                    root.remove(folder)
            if (folder.attrib['PLATFORM'] == 'UNIX'):
                if item_to_delete == folder.attrib['FOLDER_NAME']:
                    root.remove(folder)
    return



start = time.time()
main(sys.argv[1:])
end = time.time()
print("It took:", math.floor((end-start)/60), "minutes and", math.floor((end-start)%60), "seconds")