#!/bin/perl

$in_file = shift;
$out_file = shift;
$tmp_file_1 = $in_file.".tmp";


%rbc_name_to_content;
%rbc_content_to_name;
%rbc_rename_map;
%rbc_temp_rename_map;
$used_names=",";


# 1st pass, create unique RBC names;
open (IN, "<$in_file") or die "Failed to open $in_file for reading";
open (TMP_OUT, "> $tmp_file_1") or die "Failed to open $tmp_file_1 for writing";
while (my $current_line = <IN>)
{
	if ($current_line =~ /\s+<RULE_BASED_CALENDAR\s+/)
	{
		my $rbc = $current_line;
		while (!$current_line =~ /\/>/)
		{
			$rbc.=$current_line;
			$current_line = <IN>;
		}
		$rbc=~/NAME="(.+?)"/;
		my $rbc_name = $1;
		my $suggested_name=$rbc_name;
		my $suffix=0;
		while ($used_names=~/.*,$suggested_name,.*/)
		{
			$suffix++;
			$suggested_name=$rbc_name."_$suffix";
		}
		$rbc=~s/NAME="(.+?)"/NAME="$suggested_name"/;
		my $mapped_rbc=$rbc;
		$mapped_rbc=~s/NAME="(.+?)"/NAME=""/;
		$mapped_rbc=~s/NAME=""/NAME="!"/ if ($rbc_name=~/^!.*/);
		$used_names.="$suggested_name,";
		if (! defined $rbc_content_to_name{$mapped_rbc})
		{
			$rbc_content_to_name{$mapped_rbc}=$suggested_name;
		}
		$rbc_rename_map{$suggested_name} = $rbc_content_to_name{$mapped_rbc};
		$rbc_temp_rename_map{$rbc_name}=$suggested_name;
		print TMP_OUT $rbc;
	}
	else
	{
		if($current_line =~ /\s+<RULE_BASED_CALENDARS\s+/)
		{	
			$current_line =~ s/NAME="(.+?)"/NAME="$rbc_temp_rename_map{$1}"/;
		}
		print TMP_OUT $current_line;
		next;
	}
}
close (IN);
close (TMP_OUT);

# 2nd pass copy to a single smart_table
open (IN, "<$tmp_file_1") or die "Failed to open $tmp_file_1 for reading";
open (OUT, "> $out_file") or die "Failed to open $out_file for writing";

$target_folder="";
# open 1st SMART Folder
while (my $current_line = <IN>)
{
	print OUT $current_line;
	last if ($current_line=~/\s*<SMART_FOLDER/);
}
while (my $current_line = <IN>)
{
	print OUT $current_line;
	$target_folder=$1 if ($current_line =~/FOLDER_NAME="(.*?)"/);
	last if ($current_line=~/\s*>/);
}

# write RBC definitions;
foreach my $rbc (keys %rbc_content_to_name)
{
	my $tmp_rbc = $rbc;
	$tmp_rbc=~s/NAME="!?"/NAME="$rbc_content_to_name{$rbc}"/;
	print OUT $tmp_rbc;
}

#write the rest of the draft
while (my $current_line = <IN>)
{
	if ($current_line=~/\s*<RULE_BASED_CALENDAR\s+/ || $current_line=~/\s*<RULE_BASED_CALENDAR$/) #skip last RBC def
	{
		if ($current_line=~/\s*\/>/)
		{
			$current_line=<IN>;
		}
		else
		{
			while ($current_line=<IN>)
			{
				last if ($current_line=~/\s*\/>/);
			}
		}
	}
	$current_line =~s/PARENT_FOLDER=".*?"/PARENT_FOLDER="$target_folder"/; #UPDATE PARENT

	if ($current_line=~/\s*<SMART_FOLDER/) # skip smart folder tags
	{
		while($current_line = <IN>)
		{
			last if ($current_line =~/\s*<JOB/);
		}
	}
	if ($current_line=~/\s*<RULE_BASED_CALENDARS/) #update RBC usage
	{
		$current_line =~ s/NAME="(.+?)"/NAME="$rbc_rename_map{$1}"/;
	}
	if ($current_line =~/<\/DEFTABLE>/)
	{
		print OUT "</SMART_FOLDER>\n";
	}
	print OUT $current_line unless ($current_line =~/.*<\/SMART_FOLDER>.*/);
}

close (IN);
close (OUT);
unlink $tmp_file_1 or print "Failed to del $tmp_file_1: $!";
