@ECHO off
setlocal enabledelayedexpansion
REM set default values for the arguments

SET username=
SET password=
SET server=
SET database=
SET tables_list=definitions

SET pattern=-
:loop_argument
IF NOT "%1"=="" (
	IF "%1"=="-U" (
        SET username=%2
        SHIFT
    )
    IF "%1"=="-P" (
        SET password=%2
        SHIFT
    )
	IF "%1"=="-S" (
        SET server=%2
        SHIFT
    )
	IF "%1"=="-D" (
        SET database=%2
        SHIFT
    )
	
    SHIFT
	GOTO :loop_argument
)

set MISSING_ARGUMENT=
IF NOT DEFINED username SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<username^>
IF NOT DEFINED password SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<password^>
IF NOT DEFINED server SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<database server^>
IF NOT DEFINED database SET MISSING_ARGUMENT=1 & ECHO Missing argument ^<database/schema name^>

IF DEFINED MISSING_ARGUMENT GOTO USAGE

REM initialize parameters
SET data_directory_name=Data
SET log_name=log.log
SET header_file_name=HeadersOnly.csv
SET data_file_name=TableDataWithoutHeaders.csv
SET final_data_file_suffix=_DATA_TABLE.csv

REM Check for bcp utility to exist on execution host
bcp -v 2>&1 >> %log_name%
IF errorlevel 1 (
	ECHO.
	ECHO Unable to locate the MSSQL client, specifically the "bcp" utility, please verify this is executed on a machine with a MSSQL client installed!
	exit /b 2
)

MKDIR %data_directory_name% 2>&1 >> %log_name%
IF errorlevel 1 (
	ECHO.
	ECHO Directory "Data" already exist, any file exists in "Data" directory might be overwritten.
	CHOICE /M  "Would you like to continue, "
	IF errorlevel 2 (
		EXIT /b 0
	)
)

ECHO. 
ECHO Exporting definitions ...
SET failed=0

echo id,folderid,modified,details,name,enable_flag> %header_file_name%
BCP "SELECT id, folderid, modified, '""' + REPLACE(CAST(details AS varchar(MAX)), '""', '""""') + '""', name, enable_flag FROM %database%.dbo.definitions " queryout %data_file_name% -c -t, -S%server% -U%username% -P%password% 2>&1 >> %log_name%

COPY /b %header_file_name%+%data_file_name% %data_directory_name%\definitions%final_data_file_suffix% 2>&1 >> %log_name%

IF NOT EXIST %header_file_name% (
	ECHO Failed to export definitions headers.
	SET failed=1
) ELSE (
	DEL %header_file_name% 2>&1 >> %log_name%
)

IF NOT EXIST %data_file_name% (
	ECHO Failed to export definitions data.
	SET failed=1
) ELSE (
	DEL %data_file_name% 2>&1 >> %log_name%
)

IF !failed!==1 IF EXIST %data_directory_name%\definitions%final_data_file_suffix% (
	DEL %data_directory_name%\definitions%final_data_file_suffix% 2>&1 >> %log_name%
)



ECHO. 
ECHO Exporting agents ...
SET failed=0

echo id,modified,folderid,details,ostype,platform,timedelta,name,enable_flag> %header_file_name%
BCP "SELECT id, modified, folderid, '""' + REPLACE(CAST(details AS varchar(MAX)), '""', '""""') + '""', ostype, platform, timedelta, '""' + REPLACE(CAST(name AS varchar(MAX)), '""', '""""') + '""', enable_flag FROM %database%.dbo.agents " queryout %data_file_name% -c -t, -S%server% -U%username% -P%password% 2>&1 >> %log_name%

COPY /b %header_file_name%+%data_file_name% %data_directory_name%\agents%final_data_file_suffix% 2>&1 >> %log_name%

IF NOT EXIST %header_file_name% (
	ECHO Failed to export agents headers.
	SET failed=1
) ELSE (
	DEL %header_file_name% 2>&1 >> %log_name%
)

IF NOT EXIST %data_file_name% (
	ECHO Failed to export agents data.
	SET failed=1
) ELSE (
	DEL %data_file_name% 2>&1 >> %log_name%
)

IF !failed!==1 IF EXIST %data_directory_name%\agents%final_data_file_suffix% (
	DEL %data_directory_name%\agents%final_data_file_suffix% 2>&1 >> %log_name%
)


ECHO. 
ECHO Exporting folders ...
SET failed=0

echo id,modified,details,name> %header_file_name%
BCP "SELECT id, modified, '""' + REPLACE(CAST(details AS varchar(MAX)), '""', '""""') + '""', '""' + name + '""' FROM %database%.dbo.folders " queryout %data_file_name% -c -t, -S%server% -U%username% -P%password% 2>&1 >> %log_name%

COPY /b %header_file_name%+%data_file_name% %data_directory_name%\folders%final_data_file_suffix% 2>&1 >> %log_name%

IF NOT EXIST %header_file_name% (
	ECHO Failed to export folders headers.
	SET failed=1
) ELSE (
	DEL %header_file_name% 2>&1 >> %log_name%
)

IF NOT EXIST %data_file_name% (
	ECHO Failed to export folders data.
	SET failed=1
) ELSE (
	DEL %data_file_name% 2>&1 >> %log_name%
)

IF !failed!==1 IF EXIST %data_directory_name%\folders%final_data_file_suffix% (
	DEL %data_directory_name%\folders%final_data_file_suffix% 2>&1 >> %log_name%
)



EXIT /b %failed%

:USAGE
SET tab=	
ECHO.
ECHO This script requires a MSSQL client installed including the bcp utility.
ECHO usage:%tab%Zena_MsSQL_export -U ^<username^> -P ^<password^> -S ^<database server^> -D ^<database/schema name^>
