use strict;
use warnings;
use XML::Simple;

my $num_args = $#ARGV + 1;
if ($num_args != 2) {
	print "\nUsage: SplitToSpecificObjectFiles.pl <Input file name> <prefix>.\n";
	exit;
}
 
my $in_file_name = $ARGV[0];
my $file_prefix = $ARGV[1];

print $in_file_name."\n";
 
open(my $in,  "<",  $in_file_name)  or die "Can't open input xml: $!";

my $xml_header = <$in> . <$in>;
my $type_cnt = 0;
my %file_handles;

while (<$in>)
{
	if (/^\s*<(.*?)(_.*?)? .*>/)
	{
		my $out_file;
		my $type = $1;
		my $file_name = $file_prefix . $type . ".xml";

		$type_cnt = 0;


		if (not exists $file_handles{$file_name})
		{
			open( $file_handles{$file_name}, ">> $file_name") or die "Can't open output xml: $!";
			print $file_name . "\n";
			$out_file = $file_handles{$file_name};
			print $out_file $xml_header;
		}
		$out_file = $file_handles{$file_name};
		
		print $out_file $_;
		while (<$in>)
		{
			print $out_file $_;
			if (/^\s*<($type)/)
			{
				# if (substr ($_, length($_)-3, 2) ne '/>')
				$type_cnt++ unless (/^\s*<($type).*\/>$/);
			}
			last if (/^\s*<([\/]$type)/ && ($type_cnt-- == 0));
		}
	}
}

while ((my $key, my $value) = each(%file_handles)){
	 print $value "</uc-export>";
}
