#!/usr/bin/perl

use strict;
use warnings;

my $dir = '.';
my %file_handles;

opendir(DIR, $dir) or die $!;

my $result_dir_name = "merge_result_" . $$;
mkdir $result_dir_name or die $!;


while (my $file = readdir(DIR)) 
{
	# We only want files
	next unless (-f "$dir/$file");
	# We donot wont the current file
	#next if ($file =~ $0);
	print "processing $file\n";
	
	open(my $in,  "<",  $file)  or die "Can't open input xml: $!";
	
	my $xml_header = <$in> . <$in>;
	my $type_cnt = 0;
	
	while (<$in>)
	{
		if (/^\s*<(.*?)(_.*?)? .*>/)
		{
			my $out_file;
			my $type = $1;
			my $file_name = $result_dir_name . "\\" . $type . ".xml";
			
			$type_cnt = 0;
		
		
			if (not exists $file_handles{$file_name})
			{
				open( $file_handles{$file_name}, ">> $file_name") or die "Can't open output xml: $!";
				print $file_name . "\n";
				$out_file = $file_handles{$file_name};
				print $out_file $xml_header;
			}
			$out_file = $file_handles{$file_name};
		
			print $out_file $_;
			
			while (<$in>)
			{
				print $out_file $_;
				if (/^\s*<($type)/)
				{
					# if (substr ($_, length($_)-3, 2) ne '/>')
					$type_cnt++ unless (/^\s*<($type).*\/>$/);
				}
				last if (/^\s*<([\/]$type)/ && ($type_cnt-- == 0));
			}

		}
	}
}

while ((my $key, my $value) = each(%file_handles))
{
	 print $value "</uc-export>";
	 close $value;
}

closedir(DIR);
exit 0;