#################################################
#          CREATE SAP ACOUNTS - TNG    	        #
#################################################

($templateFile, $csvFile, $sapOutputFile) = inputCheck();

################ MAIN ##################

%mapping = ('CLIENT', 'SAPR3-CLIENT',
			'LANGUAGE', 'SAPR3-LANG',
			'SYSNR', 'SAPR3-SYSNR',
			'JOBUSER', 'SAPR3-USER');

@keysArrangement;
%accounts;
%accountNames;
%template_bw;
%template_r3;

createTemplate();
pasreCsv();
printToFile();

########################################



sub pasreCsv(){
	open CSVFILE, "<$csvFile" or die "Error open $csvFile ...\n";
	
	# extract keys from hash to str
	my $keys = "";
	foreach $key (keys %mapping){
		$keys = $keys . $key . '|';
	}	
	chop($keys);
	
	# update to new string
	while(my $line = <CSVFILE>){
		chomp($line);
		if($line =~ /sapjob.exe/){
			my %hash_R3 = %template_r3;
			my %hash_BW = %template_bw;
			
			while($line =~ /($keys)=(.*?),/g){
				if($mapping{$1} ne ""){
					$hash_R3{$mapping{$1}} = $2;
					$hash_BW{$mapping{$1}} = $2;
				}	
			}	
			
			my $counter = 2;
			my $counterStr = '';
			my $isExist = 0;
			
			my $accountName = $hash_R3{'SAPR3-USER'} . "_" . $hash_R3{'SAPR3-SYSNR'};
				
			while($accounts{$accountName.$counterStr}){
				my $a = compareHashes($accounts{$accountName.$counterStr}{'R3'}, \%hash_R3);
				my $b = compareHashes($accounts{$accountName.$counterStr}{'BW'}, \%hash_BW);
				
				if($a && $b){
					last;
					$isExist = 1;
				}
				$counterStr = '_' . $counter++;
			}
				
			if(!$isExist){
				$accounts{$accountName.$counterStr}{'R3'} = {%hash_R3};
				$accounts{$accountName.$counterStr}{'BW'} = {%hash_BW};
			}
		}
	}
	
	close CSVFILE;
}

  
# print sap accounts to output file.
sub printToFile(){
	open SAP, ">$sapOutputFile" or die "Error open $sapOutputFile.\n";
	
	$counter = 0;
	foreach $accountKey (keys %accounts){
		
		%hash_R3_BW = %{$accounts{$accountKey}};
		my %hash_R3 = %{$hash_R3_BW{'R3'}};
		my %hash_BW = %{$hash_R3_BW{'BW'}};
		
		print SAP "[$accountKey]\n";  		# -- R3
		foreach $key (@keysArrangement){
			print SAP $key . "                    " . $hash_R3{$key} . "\n";
		}
		print SAP "\n\n";
		print "$accountKey was created.\n";
	
		
		print SAP "[$accountKey"."_BW]\n";  # -- BW
		foreach $key (@keysArrangement){
			print SAP $key . "                    " . $hash_BW{$key} . "\n";
		}
		print SAP "\n\n";
		print "$accountKey". "_BW was created.\n";
		
		$counter = $counter + 2;
	
	}
	
	print "$counter accounts were created.\n";
	
	close SAP;
	
	
}


# CREATE HASH MAPS REPRESENTS THE TEMPLATE FILE

sub createTemplate(){
	open TEMPLATE, "<$templateFile" or die "Error open $templateFile...\n";
	
	my $bw_found = 0;
	my $r3_found = 0;
	my %tmp;
	my $line;
	
	# loop until end of template file
	while($line = <TEMPLATE>){
		 while($line !~ /\[(.*)\]/){$line = <TEMPLATE>;}   # skip lines until start of new account
		 $line = <TEMPLATE>;
		 
		 # read all current account data to %tmp
		 @keysArrangement = ();
		 while($line =~ /.+/){                  
			my @arr = split(/\s+/, $line,2);
			chomp $arr[1];
			$tmp{$arr[0]} = $arr[1];
			push(@keysArrangement, $arr[0]);
			$line = <TEMPLATE>;
		}
		 
		 # if current account is R3
		 if(($tmp{'APP_VERSION'} =~ /R3/) && $r3_found ==0){
			$r3_found = 1;
			%template_r3 = %tmp;
		 }
		 
		 # if current account is BW
		 elsif(($tmp{'APP_VERSION'} =~ /BW/) && $bw_found ==0){
			$bw_found = 1;
			%template_bw = %tmp;
		 }
		 
		 %tmp = ();
		last if($r3_found && $bw_found); # both account types found
	}
	
	close TEMPLATE;
}





sub compareHashes(){
	(my $hashRef1, my $hashRef2) = @_;
	foreach $key (keys %{$hashRef1}){
		if(${$hashRef1}{$key} ne ${$hashRef2}{$key}){
			return 0;
		}
	}
	return 1;
}



# verifying inputs
sub inputCheck(){

	$flags = '(template|csv|out)';
	my %inputFlags = ();
	my $inError = 0;
	while($arg = shift(@ARGV)){
		$arg =~ /-(.*)/;
		
		$key = $1;
		$val = shift(@ARGV);
		
		
		if($key !~ /$flags/i){	# if is key
			$inError = 1;
			print "error - bad flag.\n";
			last;
		}elsif($val eq ""){		# if is valid value
			$inError = 1;
			print "bad argument - ". uc $key ."\n";
			last;
		}else{
			$inputFlags{$key} = $val;
		}
	}

	
	# print useage if needed
	if($inError or scalar(keys (%inputFlags))==0){
		print "useage -\n\t generateSapAccounts.pl ";
		print '-TEMPLATE <file name> ';
		print '-CSV <file name> ';
		print '-OUT <file name>' . "\n";
		die;
	}
	
	return ($inputFlags{'template'}, $inputFlags{'csv'}, $inputFlags{'out'});
	
}