#########################################
#               TNG                     #
# - ADD RESOURCES TO SMART TABLES       # 
# - ADD QUANTIATIVE RESOURCES TO SERVER #
#########################################

$usageMsg = "\nUsage: -DRAFT <Draft file name> -CAUEXPR <Cauexpr file name>\n\t[-RESOURCE {INCOND|CONTROL|NOTHING}]\n\t[-RATIO <Calculation ratio>]\n\t[-OVERRIDE <Override file name>]\n\t[-OUTPUT <XML Output file name>]";

### INITIALIZE PARAMETERS AND VALIDATE ### 
%args = ("resource", "incond", "ratio", 1, "output", "output_draft.xml");
AddParametersToArgs(@ARGV);
ValidateArgs();

### ADD RESOURCES TO SMART TABLES ###
if($args{'resource'} ne 'nothing'){
	%tableResources = CreateTableResourceHash();
	ScanDarftAddResources();
}

### DEFINE QUANTIATIVE RESOURCES TO SERVER ###
%qrHash = CreateQrHashMap(); 
%inputFileHash = CreateInputFileHash(); 
CalculateQuantity();
UpdateqrHashAccordingToInputFile();
AddQrToServer();





#################################################
#                 FUNCTIONS                     #
#################################################



# Add parameters to %args and exit if errors
sub AddParametersToArgs(){
	while($it = shift){
		if($it !~ /^(-draft|-cauexpr|-resource|-ratio|-override|-output)$/i){
			die "Invalid argument $it\n$usageMsg\n";
		}
		if($it =~ /-draft/i){
			my $tmp = shift;
			if($tmp eq ""){die "Missing value for -DRAFT\n$usageMsg\n";}
			$args{'draftFile'} = $tmp;
		}
		if($it =~ /-cauexpr/i){
			my $tmp = shift;
			if($tmp eq ""){die "Missing value for -CAUEXPR\n$usageMsg\n";}
			$args{'cauexprFile'} = $tmp;
		}
		if($it =~ /-resource/i){
			my $tmp = shift;
			if($tmp eq ""){die "Missing value for -RESOURCE\n$usageMsg\n";}
			$args{'resource'} = $tmp;
		}
		if($it =~ /-ratio/i){
			my $tmp = shift;
			if($tmp eq ""){die "Missing value for -RATIO\n$usageMsg\n";}
			$args{'ratio'} = $tmp;
		}
		if($it =~ /-override/i){
			my $tmp = shift;
			if($tmp eq ""){die "Missing value for -OVERRIDE\n$usageMsg\n";}
			$args{'override'} = $tmp;
		}
		if($it =~ /-output/i){
			my $tmp = shift;
			if($tmp eq ""){die "Missing value for -OUTPUT\n$usageMsg\n";}
			$args{'output'} = $tmp;
		}
	}
}	


# Validate arguments and print errors
sub ValidateArgs(){
	my $error = 0;
	if($args{'draftFile'} eq ""){  
		print "Missing argument -DRAFT\n";
		$error = 1;
	}
	if($args{'cauexprFile'} eq ""){  
		print "Missing argument -CAUEXPR\n";
		$error = 1;
	}
	if($args{'resource'} !~ /^incond$/i && $args{'resource'} !~ /^control$/i && $args{'resource'} !~ /^nothing$/i){  
		print "Invalid argument -RESOURCE\n";
		$error = 1;
	}
	if($args{'ratio'} !~ /^\d+\.\d+$/ && $args{'ratio'} !~ /^\d+$/){
		print "Invalid argument -RATIO\n";
		$error = 1;
	}
	if($error == 1){
		die $usageMsg."\n";
	}
}



###  ADD RESOURCES TO SMART TABLES FUNCTIONS  ###

# scan draft file and add inconditon/control and print to $outputFile
sub ScanDarftAddResources(){
	open INDRAFT, "<$args{'draftFile'}" or die "Error open $args{'draftFile'}...\n";
	open OUTDRAFT, ">$args{'output'}" or die "Error open $args{'output'}...\n";
	
	my $inTable = 0;  #flags
	my $inJob = 0;
	
	while(<INDRAFT>){
		my $line = $_;
		if($line =~ /<SMART_TABLE/){$inTable = 1;}
		if($line =~ /<\/SMART_TABLE>/){$inTable = 0;}
		if($line =~ /<JOB/){$inJob = 1;}
		if($line =~ /<\/JOB>/){$inJob = 0;}
		
		if(($line =~ /JOBNAME="(.*)"/ ) && $inTable==1 && $inJob==0){
			my $tableName = $1;
			if($tableResources{$tableName} ne ""){  # table that need resource
				$line = SkipLinesUntilStartOfJob($line);
				$inJob = 1;
				AddResourceToTable($tableName);
				}
			print OUTDRAFT $line;	
		}
		else{
			print OUTDRAFT $line;
		}	
	}

	close INDRAFT;
	close OUTDRAFT;
}


# adds resources to smart table named $tableName
sub AddResourceToTable(){
	my $tableName = shift;
	my @resArr = split(';;', $tableResources{$tableName});

	# add inconditon to table named QR_resourceName
	if($args{'resource'} eq 'incond'){
		foreach(@resArr){
			(my $resName, my $usage)  = split(",", $_);
			print OUTDRAFT "  <INCOND AND_OR=\"AND\" NAME=\"QR_$resName\" ODATE=\"ODAT\"/>\n\n";
		}
	}
	# add control resource to table
	elsif($args{'resource'} eq 'control'){
		my $type;
		foreach(@resArr){
			(my $resName, my $usage)  = split(",", $_);
			if($usage eq 'SHARED'){$type = 'S';}
			else{$type = 'E';}
			print OUTDRAFT "  <CONTROL NAME=\"$resName\" TYPE=\"$type\"/>\n\n";
		}
	}
}



# skip lines until start of job and print those lines
sub SkipLinesUntilStartOfJob(){
	my $line = shift;
	print OUTDRAFT $line;
	$line = <INDRAFT>;
	while($line !~ /<JOB/){
		print OUTDRAFT $line;
		$line = <INDRAFT>;
	}
	return $line;
}


# create hashmap with tableName as key , resources as values (separated by ';;' if more then 1)
sub CreateTableResourceHash(){
	open CAUEXPRT, "<$args{'cauexprFile'}" or die "Error open file $args{'cauexprFile'}...\n";
	my %hash =();
	
	while(<CAUEXPRT>){
		my $line = $_;
		if($line =~ /DEFINE\s+JOBSETRES\s+ID=\((.*),(.*)\).*USAGE=(.*)/){
			(my $tableName , my $resName, my $usage) = ChopQuotes($1,$2,$3);
			
			if($hash{$tableName} ne ""){      # more then one resource for table
				$hash{$tableName} = $hash{$tableName}.';;'.$resName.",".$usage;
			}
			else{
				$hash{$tableName} = $resName.",".$usage;
			}
		}
	}

	close CAUEXPRT;
	return %hash;
}


# chop qutes from arguments
sub ChopQuotes(){
	(my $tableName , my $resName, my $usage) = @_;
	if($tableName =~ /'(.*)'/){$tableName = $1;}
	if($resName =~ /'(.*)'/){$resName = $1;}
	if($usage =~ /'(.*)'/){$usage = $1;}
	return ($tableName , $resName, $usage);
}




#############################################
#  ADD RESOURCES TO SMART TABLES FUNCTIONS  #
#############################################


# create hashmap with resources names and quantity
sub CreateQrHashMap(){
	open IN , "<$args{'draftFile'}" or die "Error open $args{'draftFile'}...\n";
	%hashMap = ();
	ScanXmlForQuantiativeResources();
	close IN;
	return %hashMap;
}


# scan draft file to find quantiative resources and update hashmap
sub ScanXmlForQuantiativeResources(){
	while(<IN>){
		$line = $_;
		if($line =~ /\s*<QUANTITATIVE\s+NAME="(.*)"\s+QUANT="(.*)"\s*\/>/){
			UpdateHashMap($1,$2);
		}
	}
}



# update hashmap only if value is greater then prev value
sub UpdateHashMap(){
	(my $key, my $value) = @_;
	if($hashMap{$key} < $value){
		$hashMap{$key} = $value;
	}
}


# create %inputFileHash according to the user override file
sub CreateInputFileHash(){
	return if($args{'override'} eq "");
	open INPUT , "<$args{'override'}" or die "Error open $args{'override'}...\n";
	
	my %hash = ();
	while(<INPUT>){
		(my $qrName, my $max) = split(/\s+/, $_);
		$hash{$qrName} = $max;
	}	
	close INPUT;
	return %hash;
}


# update %qrHash according to %inputFileHash
sub UpdateqrHashAccordingToInputFile(){
	return if($args{'override'} eq "");    # no overide file from user
	while((my $qrName, my $max) = each(%inputFileHash)){
		if($qrHash{$qrName} ne ""){
			$qrHash{$qrName} = $max;
		}
	}
}


# loop over hashmap and add resources to server
sub AddQrToServer(){
	while((my $qrName, my $max) = each(%qrHash)){
		system("ecaqrtab add $qrName $max >>add_to_server_report.txt");
	}
} 


# loop over hashmap and calculate quantity according to $RATIO
sub CalculateQuantity(){
	while((my $qrName, my $max) = each(%qrHash)){
		$qrHash{$qrName} = int($qrHash{$qrName} * $args{'ratio'});
	}
}


