use warnings;
use strict;

sub countFiles($);
sub getNumberFromFile($);

#############main starts here###############
if($#ARGV != 1){
	print "Usage $0 <source path> <destination data>\n";
	exit 1;	#exit code 1 - syntax error
}

my $fileCount = getNumberFromFile($ARGV[0]);
my ($dirs, $files) = countFiles($ARGV[1]);
my $diff = ($files - $fileCount);

print $diff;
exit $diff;

#############main ends here###############


# get number of filed copied 
sub getNumberFromFile($){
	my $path = shift();
	open(my $file, "<$path")or die "Can't open log file: $!";
	my @lines = <$file>;
	my $size = scalar(@lines);
	while($size){
		if($lines[--$size] =~ /^(\d+)/){
			return $1;
		}
	}
}

#return the number of files and the number of sub directories in $path
sub countFiles($){
	my $path = shift;
	opendir(DIR, "$path") or die "Can't open dir $path: $!\n";
	my @list = readdir(DIR);
	closedir(DIR);

	my $fileCount = 0;
	my $folderCount = 0;
	
	foreach my $file (@list) {
		next if($file eq '.' || $file eq '..');
		my $fullPath = $path . '\\' .  $file;
		
		if(-d $fullPath){
			(my $numOfFolders , my $numOfFiles)  = countFiles($fullPath);
			$folderCount += $numOfFolders;
			$fileCount += $numOfFiles;
			$folderCount++;
		}elsif(-f $fullPath){
			$fileCount++;
		}
	}
	return ($folderCount, $fileCount);
}



