use strict;
use warnings;
use XML::Simple;


sub read_next_cond;
sub read_all_conditions;
sub parse_array;
sub insert_into_cluster;
sub create_clusters;  
sub create_cluster;
sub print_clusters;
sub print_cluster;
sub prepare_cluster;

my $num_args = $#ARGV + 1;
if ($num_args != 1 && $num_args != 2) {
  print "\nUsage: 700_To_640_XMLDraft.pl <Input file name> [<Output file name>]\n";
  exit;
}
 
 my $in_file_name = $ARGV[0];
 my $out_file_name= "640_XMLDraft.xml";
 
 if ($num_args == 2)
 {
	$out_file_name = $ARGV[1];
 }
 
 open(my $in,  "<",  $in_file_name)  or die "Can't open input xml: $!";
 open(my $out, ">", $out_file_name) or die "Can't open output xml: $!";
 
 my %xml_tags_hash = (
        '(.*\s*)(</?\s*SMART_TABLE.*)' => "replace_tag_name ('SMART_TABLE', 'SCHED_GROUP', '%s')",
		'(.*\s*)(</?\s*TABLE.*)' => "replace_tag_name ('TABLE', 'SCHED_TABLE', '%s')",
        '(.*\s*)(<\s*AUTOEDIT2.*)' => "fix_autoedit_tag ('%s')",
		'(.*\s*)(<\s*DOAUTOEDIT2.*)' => "fix_autoedit_tag ('%s')",
		'(.*\s*)(</?\s*ON_TABLE.*)' => "replace_tag_name ('ON_TABLE', 'ON_TABLE', '%s')",
		'(.*\s*)(</?\s*DO_TABLE.*)' => "replace_tag_name ('DO_TABLE', 'DO_GROUP', '%s')",
		'(.*\s*)(\s*PARENT_TABLE=".*)' => "remove_line ('%s')",
		'(.*\s*)(</?\s*RULE_BASED_CALENDARS NAME.*)' => "replace_tag_name ('RULE_BASED_CALENDARS NAME', 'TAG_NAMES TAG_NAME', '%s')",
		'(.*\s*)(\s*RULE_BASED_CALENDAR_RELATIONSHIP=".*)' => "remove_line ('%s')",
		'(.*\s*)(</?\s*RULE_BASED_CALENDAR[\s|$])' => "replace_tag_name ('RULE_BASED_CALENDAR', 'TAG', '%s')",
		'(.*\s*)(^\s*NAME.*)' => "replace_tag_name ('NAME', 'TAG_NAME', '%s')",
		'(.*\s*)(\s*LEVEL=".*)' => "remove_line ('%s')",
    );
 
 while (my $line = <$in>)
 {
	my $out_line = $line;
	
	while ( my ($key, $value) = each(%xml_tags_hash) ) {
		if (eval ('$line =~ /$key/'))
		{
			$out_line = eval ( sprintf( $value, $line ) );
		}
    }
	
	print $out $out_line;
 }
 
 sub replace_tag_name
 {
	my $find = shift;
	my $replace = shift;
	my $str = shift;
	
	$str =~ s/$find/$replace/;
	
	return $str;
 }
 
 sub fix_autoedit_tag
 {
	my $str = shift;
	$str =~ /<(DO)?AUTOEDIT2 NAME=\"(.*?)\" VALUE=\"(.*?)\"\/>/;
	my $do =$1;
	$do = "" if !defined $do;
	
	return sprintf "<%sAUTOEDIT EXP=\"%s=%s\"/>\n",$do,$2,$3;
 }
 
 sub remove_line
 {
	return "";
 }
 