JSONP.response({
  responseText: '﻿{\"pages\":[{\"id\":1,\"title\":\"Welcome\",\"url\":\"52152.htm\",\"text\":\"Introduction to Control-M Conversion  \"},{\"id\":2,\"title\":\"Introduction to Control-M Conversion\",\"url\":\"Intro_to_CtrlM_conv_tool.htm\",\"text\":\"Control-M Conversion guides you through the steps for converting your data from your current scheduling application to Control-M. For a description of the conversion procedure steps, see Conversion procedure steps. You may need to export your data or configure your environment before converting your data to Control-M. For more information, see Conversion project configuration and Project configuration.  Control-M Conversion includes the following capabilities:  Data conversion: Converts data from schedulers and applications, as described in Conversion schedulers and applications.   For more information about the capabilities of each scheduler, see Conversion capability. For recommended practices for TWS and AutoSys, see Recommended practices.  Control-M OS to Application Jobs: Enables a mass update at Control-M flow level, which finds jobs according to specified criteria and replaces them with user defined Control-M job or jobs.  For more information, see Control-M OS to Application Jobs overview.  Control-M Self Conversion: Enables you to develop automatic conversions from any scheduler, business application, or homegrown application to Control-M data (Folders and Jobs). For more information, see Control-M Self Conversion.  Verification Tool: Compares Scheduler forecasts and execution history reports with Control-M, as described in Verification Tool.  Validation: Validates draft data, which was not converted using this tool, as described in Defining a new Validation project.  Conversion enables you to do the following:  Select a new project, existing project or a demo project to see how data is converted into Control-M, as described in Capturing data.   After you have imported data, evaluate the data that has been imported into Control-M, as described in Evaluate data.  Change settings and rules to suit your requirements. You can convert scheduling definitions, calendars, and other related files, as described in Conversion Rules.  After converting the data to Control-M you can analyze results, which show entities that have converted without problems and those that generate warning or error messages. With this information, you can identify necessary changes and return to the Conversion Rules phase to modify configuration elements or filters before rerunning the Evaluation phase. For more information, see Conversion.   You can also compare the generated scheduling criteria definitions in Control-M against the current tool&#8217;s forecast report. For more information, see Validation.  NOTE: Control-M Conversion Tool is compatible with Control-M supported versions. When opening the conversion tool, if the Conversion Tool version is lower than the latest version, a pop-up window appears with instructions how to update the Conversion tool.  Click the following image to view a short overview video about Control-M Conversion.  \"},{\"id\":3,\"title\":\"Conversion schedulers and applications\",\"url\":\"87575.htm\",\"text\":\"The following table describes the Schedulers and Applications that can be converted to Control-M.  If you have a Scheduler, Application, or homegrown application that is not listed below, you can use Control-M Self Conversion to convert your data. For more information, see Control-M Self Conversion.  Type  Scheduler  Schedulers  CA AppWorx  CA Automic (UC4)  CA AutoSys&reg; Workload Automation  CA Dollar Universe&reg;   CA Jobtrac&#8482;  CA Unicenter WLM&reg; (TNG)  CA Workload Automation DE (dSeries)  Cron   IBM&reg; Tivoli&reg; Workload Scheduler (TWS)  Hitachi JP1 Automatic Job Scheduler (AJS)  MS Task Scheduler   Redwood CPS   Tidal Software&reg; Enterprise Scheduler   Zena  Applications  Hadoop - Oozie  IBM&reg; Sterling Connect:Direct&reg;   SAP  \"},{\"id\":4,\"title\":\"Conversion capability\",\"url\":\"46090.htm\",\"text\":\"The following table describes conversion capability for each Scheduler.  Vendor  Data Import Automatic  Data Import  Manual  Data Assessment Report  Conversion Report  Scheduling valuation report  Scheduling valuation report (Tango mode)  SAP  PeopleSoft  Condition Naming Convention  TimeZone Conversion  Exclude RBC Usage  CA AppWorx  CA Automic(UC4)  CA Autosys  CA Dollar Universe  CA JobTrac  CA Workload Automation DE  Cron  JP1 AJS  MS Task Scheduler  Oozie (Hadoop)  Redwood  SAP  TWS  TNG  Zena  \"},{\"id\":5,\"title\":\"Conversion procedure steps\",\"url\":\"Conv_procedure_steps.htm\",\"text\":\"Before you start a conversion project you may need to extract data or configure your conversion. For more information, see Conversion project configuration and Project configuration.  The following topics describe the conversion procedure steps:  Select Project: Enables you to create a new, existing or demo project. For more information, see Capturing data.  Evaluate Data: Enables you to analyze data after you have imported it to the Conversion Tool. If you want to change the imported data, you can reload the data. For more information about Selecting the project and evaluating data, see Capturing data.  Run Conversion: Enables you to rerun the conversion by loading the existing projects file or rerun the conversion using the data that you imported previously. For more information, see Conversion project results. You can also view and change settings and rules, as described in Conversion Rules.  Conversion Results: Enables you to view how much of your data was converted successfully, and how many Control-M jobs and folders were created during the conversion. For more information, see Conversion.   Validate Results:  Enables you to view the Control-M configuration information used for the conversion, and validate the converted data which enables you to confirm that the jobs run on the same date as your original scheduler. For more information, see Validation.  Load to Control-M:  Enables you to load the conversion data automatically or manually into Control-M. For more information, see Loading to Control-M.  Summary: Displays a summary of the stages that were either completed or skipped for each conversion that was performed. For more information, see Summary.  \"},{\"id\":6,\"title\":\"Verification Tool\",\"url\":\"80284.htm\",\"text\":\"Conversion includes a Verification Tool, which enables you to compare Scheduler forecasts and execution history reports with Control-M forecast and execution reports.  Relevant for the following schedulers:   ASG-Zeke  ASG-Zena  CA Dollar Universe  CA-AutoSys  CA-ESP  CA Unicenter WLM (TNG)  CA-7  IBM TWS (DS & MF)  The Verification Tool produces a report for each date, which indicates the following:  Jobs that have run or planned to run by the Scheduler but are missing from Control-M.  Jobs that have run or planned to run by Control-M but are missing from the Scheduler.  The report helps you to verify that the definitions in Control-M are functionally equivalent to those in the legacy tool.  You can access the Verification Tool by clicking @ and selecting Verification Tool.  \"},{\"id\":7,\"title\":\"CA AppWorx\",\"url\":\"99693.htm\",\"text\":\"The following topics describe how to extract CA AppWorx data, define a new project, and additional settings:  Extracting CA AppWorx data  Defining a new CA AppWorx conversion project  Setting additional CA AppWorx rules  \"},{\"id\":8,\"title\":\"Extracting CA AppWorx data\",\"url\":\"46070.htm\",\"text\":\"This procedure describes how to extract CA AppWorx (AppWorx) data before starting a new project. After exporting data, you can define a new project.  To extract AppWorx data:   Define the following files:  .exp file: Enables you to migrate between two AppWorx Application Managers. This file contains all your environment definitions. You need to export the .exp file from your AppWorx environment to the conversion environment using the AppWorx export utility. For more information, see Exporting AppWorx objects into Control-M,  NodeMapping.txt output file: Enables you to map the operating system for each host used in the .exp file. You need to import the NodeMapping.txt output file into the conversion environment. For more information, see Importing the node mapping file.  Open the Conversion Tool and import the data, as described in Defining a new UC4 AppWorx conversion project.  \"},{\"id\":9,\"title\":\"Exporting AppWorx objects\",\"url\":\"39590.htm\",\"text\":\"The following procedure describes how to export AppWorx objects.   For more details about exporting objects, see the AppWorx Administration Guide.  To Export AppWorx objects:  In the Export window of your AppWorx environment, select the objects you want to convert to Control-M.  Move the selected objects to the Objects to be exported area.  Select the Reference tab, which contains a list of all dependencies that are required.  Select the dependencies and move them to the Objects to be exported area.  Click Export.  The file is saved as an .exp file.  Open the .exp file with an editing tool.  If the .exp file contains CHECK L or CHECK M return to the AppWorx environment and manually search for the missing objects and add these and its references to Objects to be exported.  NOTE: At the beginning of the .exp file there is a list of objects starting with &#8220;CHECK&#8221;, which indicates a missing object.  EXAMPLE:  CHECK M xxx: missing Module xxx.  CHECK L xxx: missing Library xxx.  After manually adding the Libraries or Modules to the Objects to be exported area, repeat steps 5 to 7.  The .exp file is now ready to be converted to Control-M.  EXAMPLE 1:  If you see &#8220;CHECK M module_XXX&#8221; in the .exp file, in the AppWorx environment, select Object Type and chose Modules. In the Search bar, type the module name, &#8220;module_XXX&#8221; and then click >> to add it to the Objects to be exported area.  EXAMPLE 2:  If you see &#8220;CHECK L library_XXX&#8221; in the. exp file, in the AppWorx environment, select Object Type and chose Libraries. In the Search bar, type the library name, &#8220;library_XXX&#8221; and then click >> add it to Objects to be exported area.  \"},{\"id\":10,\"title\":\"Importing the node mapping file\",\"url\":\"21492.htm\",\"text\":\"This procedure describes how to import the node mapping output file for UC4 AppWorx. The output file needs to be imported to the conversion environment before defining a new UC4 AppWorx conversion project.  To import the node mapping file:  Copy the following script to your AppWorx environment.  <Conversion Home>\\\\scripts\\\\AppWorx\\\\NodeMapping.SQL  Open a command prompt window and type the following command:  sqlplus -S user/password @NodeMapping.SQL  The script produces a NodeMapping.txt output file.  Copy the NodeMapping.txt output file to the conversion environment.  NOTE: You need to supply the path to the conversion tool when Defining a new UC4 AppWorx conversion project.  \"},{\"id\":11,\"title\":\"Defining a new CA AppWorx conversion project\",\"url\":\"20791.htm\",\"text\":\"This topic describes how to define a new CA AppWorx (AppWorx) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   Before you begin  Ensure the following:  Export AppWorx data, as described in Setting a new UC4 AppWorx project.  Create a new project as described in Running a new conversion project.  To define a new AppWorx conversion project:  From the CA AppWorx - Load Data window, in the Import Scheduling Data area, complete the following fields:  (Mandatory) .exp file: Click @ to locate the exported file.  Nodes mapping: Click @ to locate the Nodes mapping file.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":12,\"title\":\"Setting additional CA AppWorx rules\",\"url\":\"20846.htm\",\"text\":\"This procedure describes how to set additional CA AppWorx rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional CA AppWorx rules:  In the General area, select or modify the options that you want:  First day of the week: Defines the first day of the week of your Control-M work environment.  Node default platform: Defines the name of the default operating system for each node data.  Keep active for: Defines the maximum number of days that a Control-M job can wait for execution after order date (default: 0). Valid values:  0-99 (integer).  Ignore Performed Condition-Actions: Select the check box to ignore performed condition-action pairs (already performed on AppWorx) when converting jobs to Control-M.  In the Conditions area, select one of the following condition names:  CID<Unique number>@JOBA@JOBB: Enables you to define how two jobs are connected by creating a unique condition in the format: CID<Unique number>@JOBA@JOBB.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  JOBA@<Status>: Enables you to set a dependence condition between many jobs according its end status.    For more details see Job Dependencies in Using Control-M.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":13,\"title\":\"CA Automic (UC4) data extraction\",\"url\":\"99694.htm\",\"text\":\"The following topics describe how to extract UC4 data, define a new UC4 project, and additional settings:  CA Automic  Defining a new CA Automic  Setting additional CA Automic  \"},{\"id\":14,\"title\":\"CA Automic (UC4) data extraction\",\"url\":\"89178.htm\",\"text\":\"The Conversion Tool converts CA Automic (UC4) XML files into Control-M data.   Before using the Conversion Tool, you need to extract UC4 data per object type (such as Jobs, Agents, Group, etc) into separate XML files. For example, you need to extract a UC4 job object type into a Job XML file, a UC4 Agent object type to an Agent XML file, etc.   Ensure that you include jobs in your list of objects, as jobs are a mandatory object. Include as many objects as possible, as it improves your conversion results.   You can extract UC4 data to XML by the following methods:  UC4 Explorer: Enables you to can extract UC4 data to XML through the Export function in UC4 Explorer, as described in see Configuring the UC4 environment.  Use the Search tool to select types of objects to export to XML. One or more objects can be chosen at one time to export, but only if they are in the same folder.     Export script: Enables you to use an export script to export files automatically, as described in Extracting UC4 data to XML using an export script.   If you have converted all objects into one XML file, you need to separate them into different XML files, otherwise, the Conversion Tool converts the entire XML according to the first object type it encounters, but ignores or mishandles objects of other types included in the XML. To avoid this, run the SplitToSpecificObjectFiles.pl script, which is in the following directory:  <Conversion home>\\\\scripts\\\\uc4  You can also filter the script so that you can export one object at a time. For example, you can define the script to export only Calendar objects. For an example about using the script and filter, see UC4 data extraction using export script example.  \"},{\"id\":15,\"title\":\"Extracting UC4 data to XML using the UC4 Explorer\",\"url\":\"46242.htm\",\"text\":\"This procedure describes how to use the Export function in UC4 Explorer. Before converting UC4 data you need to export your list of objects to XML files.  Before you begin  Ensure the following:  You have at least the same Service Pack version installed as the source system (XML file).  Do not use this export function for mass transports. For more information, see the UC4 Administration Guide.  The UC4 administrator can limit the maximum number of objects that should be exported at one time. Use the key \\\"MAX_EXPORT_COUNT\\\" in the UC4 Variable UC_SYSTEM_SETTINGS for this purpose.  To extract UC4 data to an XML file:  From the UC4 Explorer, do one of the following:  Export objects with the same type to one file, as described in Extracting all objects with the same type to one file.  Export each object to separate files, as described in Exporting each object to a separate file  NOTE: If you want to export the data only one time, use the Search tool to select all objects of a particular type, select them all and export them.  After exporting data to XML, open the Conversion Tool and import the XML files, as described in Defining a new UC4 conversion project setup.  \"},{\"id\":16,\"title\":\"Extracting objects with the same type to one file\",\"url\":\"94687.htm\",\"text\":\"This procedure describes how to extract objects with the same type to one file using the UC4 File Explorer.  To extract objects with the same type to one file:  In the UC4 File Explorer click Search.  The Search window appears.  In the Name field, type *.  In the Search For field, select Objects, and then from the dropdown list, select the object type you want to export (such as jobs).  Click Start.  A list of search results appears.  Select all by pressing Ctrl + A.   From the File menu, select Export.  The Save dialog box appears.  Click Save.  \"},{\"id\":17,\"title\":\"Exporting objects to separate files\",\"url\":\"94689.htm\",\"text\":\"This procedure describes how to extract each object to a separate file using the UC4 File Explorer.  To extract each object to a separate file:  In the UC4 File Explorer click Search.  The Search window appears.  In the Name field, type *.  In the Search For field, select the Objects and then from the dropdown list, select the object type you want to export (such as jobs).  Click Start.  A list of search results appears.  Right click on one of the objects, and select Export.  The Save dialog box appears.  Save the file as .csv.  Create a new directory and place the .csv file you saved in step 8 in the new directory.  Run the following script:  :SET &HOST#          =   \\\"<name of Host>\\\"  :SET &CSV_FILE#      =  \\\"<name of the file and full directory of the exported objects to csv>\\\"  :SET &EXPORT_PATH#   =  \\\"<name of the target path directory>\\\"     :SET &HND#=PREP_PROCESS_FILE(&HOST#,&CSV_FILE#,,\\\"COL=DELIMITER\\\",\'DELIMITER=\\\";\\\"\')  :PROCESS &HND#  :   SET &Line#=GET_PROCESS_LINE(&HND#,1)  :   PRINT \\\"<&Line#>\\\"  :   SET &OBJECT# = &Line#  :   SET &File# = \\\"&EXPORT_PATH#&line#.xml\\\"  :   SET &Ret# = EXPORT (&Object#, &File#)  :ENDPROCESS  For an example of the script, see Exporting each file to a separate file running the script example.  \"},{\"id\":18,\"title\":\"Exporting each file to a separate file running the script example\",\"url\":\"94690.htm\",\"text\":\"In the following example, we want to run the script on WIN01 host and the .csv file is saves as Search.csv in the C:\\\\temp directory. We want to export it to the C:temp\\\\export directory:  :SET &HOST#          =   \\\"WIN01\\\"   :SET &CSV_FILE#      =  \\\"c:\\\\temp\\\\search.csv\\\"  :SET &EXPORT_PATH#   =  \\\"C:\\\\temp\\\\export\\\\     :SET &HND#=PREP_PROCESS_FILE(&HOST#,&CSV_FILE#,,\\\"COL=DELIMITER\\\",\'DELIMITER=\\\";\\\"\')  :PROCESS &HND#  :   SET &Line#=GET_PROCESS_LINE(&HND#,1)  :   PRINT \\\"<&Line#>\\\"  :   SET &OBJECT# = &Line#  :   SET &File# = \\\"&EXPORT_PATH#&line#.xml\\\"  :   SET &Ret# = EXPORT (&Object#, &File#)  :ENDPROCESS  \"},{\"id\":19,\"title\":\"Extracting UC4 data to XML using an export script\",\"url\":\"89179.htm\",\"text\":\"This procedure describes how to export to XML many objects automatically using an export script. After exporting data, you can define a new conversion project.  Before you begin  Ensure the following:   You have at least the same Service Pack version installed as the source system (XML file).  The export script function must be run from the Client where the object currently exists.  To extract UC4 data to an XML file:  Login to client 0 (Admin-Client).  Open UC_SYSTEM_SETTINGS.  Set the MAX_EXPORT_COUNT parameter to 1000000 (maximum).   NOTE: A restart is not necessary.   Save the object.  Log in to the productive client(s) and type the following script:  :SET &OBJECT# = \\\"<object_name>\\\"  :SET &FILE#  = \\\"<file_name>\\\"  :SET &RET#   = EXPORT(&OBJECT#,&FILE#)  NOTE: Where you have large files, you can filter the type of objects you want to convert.  For an example using the export script and the filter, see UC4 data extraction using export script example.  (Optional) If you have multiple objects in one XML file, split the objects by running the SplitToSpecificObjectFiles.pl script which is located in the following directory:  <Conversion home>\\\\scripts\\\\uc4  After exporting data to XML, open the Conversion Tool and import the XML files, as described in Defining a new UC4 conversion project setup.  \"},{\"id\":20,\"title\":\"UC4 data extraction using export script example\",\"url\":\"89183.htm\",\"text\":\"The following example describes using an export script with the calendar filter, which enables you to export only objects with the name Calendar:  :SET &OBJECT# = \\\"CALE.*\\\"  :SET &FILE#  = \\\"C:\\\\temp\\\\export\\\\automic_CALENDAR_export.xml\\\"  :SET &RET#   = EXPORT(&OBJECT#,&FILE#)   By adapting the first Script-Line (:SET &OBJECT#=&#8221;[OBJECT_NAME_WITH_WILDCARDS&#8221;) you can also modify the exports. For instance, if your Calendars use the default naming convention, which starts always with CALE.[NAME], you can create one xml-file for all calendars as shown above.  \"},{\"id\":21,\"title\":\"Defining a new CA Automic (UC4) conversion project\",\"url\":\"Define_UC4_conv.htm\",\"text\":\"This topic describes how to define a new CA Automic (UC4) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   Before you begin  Ensure the following:  Export UC4 data to XML, as described in CA Automic (UC4) data extraction.  Create a new conversion project, as described in Running a new conversion project.  To define a new UC4 conversion project:  From the UC4- Load Data window, in the Import Scheduling Data area, and in the Data files location field, click @ to locate and select the folder for your UC4 data file.  Click Find Files.  The Conversion Tool reads the XML data file. One of the following icons appears next to the objects included in your data file.  Success @: indicates objects that are found and are valid  Warning @: indicates objects that are found but are not valid  Error @: indicates a mandatory object is not found or is not valid  Not found @: indicates objects that are not found  NOTE: If you have run a UC4 conversion before and copied the UC4_scripts_conversion_to_ctm.xls file (UC4 Script Conversion file) to the same location as your data, the Conversion Tool detects the file. For more information, see UC4 scripts conversion overview.  When the data is found, click OK.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":22,\"title\":\"Setting additional CA Automic (UC4) rules\",\"url\":\"Set_addl_UC4_rules.htm\",\"text\":\"This procedure describes how to set additional CA Automic (UC4) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional UC4 rules:  In the Additional UC4 rules tab, do the following:  In the General area, select or modify the options required, as described in General UC4 parameters.  The following table describe the General parameters in the Additional UC4 rules tab.  Parameter  Description  First day of the week  Defines the first day of the week to your Control-M work environment.  Default UC4 client time zone  Defines the time zone of the UC4 client server.  Convert UC4 executable objects without secheduling  Converts object that are not in any UC4 Schedule definitions, such as Post Script. For more information about converting UC4 jobs with Post Script, see Converting UC4 scripts to Control-M.  Convert \'Start\' and \'End\' tasks to Dummy jobs  Converts Start and End tasks to Control-M Dummy jobs. By default, Start and End tasks are ignored and not added to Control-M.  In the Job/Folder name Manipulation area, select or modify the options as required as described in Job/Folder Name Manipulation parameters.  In the Condition Name Convention area, select or modify the options required, as described in UC4 Condition Name Convention parameters.  The following table describes the Condition Name Convention parameters in the Additional UC4 rules tab.  Parameter  Description  Delimiter  Uses the character to separate the prefix, suffix, or conditions.  Prefix  Defines the prefix to separate the conditions.  Suffix  Defines the suffix to separate the conditions.  Format  Defines the default format used for creating job dependencies.  Condition name format that will be created  Displays the resulting format based on the changes made to the other options in the Condition Name Convention area.  If you have scripts that contain UC4 Scripting language keywords or functions that need to be converted to Control-M functionality, from the UC4 Script Rules tab do the following:  Open the UC4_scripts_conversion_to_ctm.xls file to map each UC4 Pre/Post Script into an equivalent Control-M option. For more information about the file, see UC4 scripts conversion overview.  In the Additional Conversion Options area, select the options as required, as described in Additional Conversion Options parameters.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":23,\"title\":\"UC4 General parameters\",\"url\":\"93153.htm\",\"text\":\"The following table describe the General parameters in the Additional UC4 rules tab.  Parameter  Description  First day of the week  Defines the first day of the week to your Control-M work environment.  Default UC4 client time zone  Defines the time zone of the UC4 client server.  Convert UC4 executable objects without secheduling  Converts object that are not in any UC4 Schedule definitions, such as Post Script. For more information about converting UC4 jobs with Post Script, see Converting UC4 scripts to Control-M.  Convert \'Start\' and \'End\' tasks to Dummy jobs  Converts Start and End tasks to Control-M Dummy jobs. By default, Start and End tasks are ignored and not added to Control-M.  \"},{\"id\":24,\"title\":\"Job/Folder Name Manipulation parameters\",\"url\":\"95061.htm\",\"text\":\"The following table describes the Job/Folder Name Manipulation parameters in the Additional UB4 Rules tab:  Parameter  Description  Change prefix/suffix  Uses a character to indicate the location in the filename where characters were removed.  Truncate characters from the beginning  Shortens a file name by truncating characters from the beginning of the name.  Truncate characters from the end  Shortens a file name by truncating characters from the end of the name.  Uniqueness suffix separator  Uses a character to separate the original file name from the numbers that are added to the end of the file name.  \"},{\"id\":25,\"title\":\"UC4 Condition Name Convention parameters\",\"url\":\"93155.htm\",\"text\":\"The following table describes the Condition Name Convention parameters in the Additional UC4 rules tab.  Parameter  Description  Delimiter  Uses the character to separate the prefix, suffix, or conditions.  Prefix  Defines the prefix to separate the conditions.  Suffix  Defines the suffix to separate the conditions.  Format  Defines the default format used for creating job dependencies.  Condition name format that will be created  Displays the resulting format based on the changes made to the other options in the Condition Name Convention area.  \"},{\"id\":26,\"title\":\"UC4 scripts conversion\",\"url\":\"93110.htm\",\"text\":\"CA Automic (UC4) uses its own scripting language to automate job processes that can be split according to the following UC4 job tabs:  Pre-Process Tab: Contains statements that prepare the job for its execution that can be used in the script section.  Process Tab: Contains the main script logic.  Post-Process Tab: Contains scripts that affect the job status after the job ends.  By default, UC4 Jobs that contain scripts inside Pre, Post and Process tabs are converted to Control-M Embedded scripts jobs.   If those scripts contain UC4 Scripting language keywords or functions, you need to clean them before executing those jobs in Control-M. In the Conversion Tool Report, you can see warnings about such jobs that contain these scripts.   To convert UC4 scripting language into Control-M, the conversion tool creates a UC4_scripts_conversion_to_ctm.xls file (UC4 Script Conversion file), which enables you to map and convert each UC4 Pre/Post Script into an equivalent Control-M option. You can also view UC4 Scripts reoccurring patterns in the UC4_scripts_analysis tab. For more information, see UC4 script analysis.  The UC4 Script Conversion file is located in <conversion_home>\\\\workarea\\\\datasources\\\\<project_name>\\\\data. You can also open it in the UC4 Scripts Rules tab in the Conversion Tool.  In the UC4 Script Conversion file, (UC4_scripts_conversion_to_ctm tab) Pre-Script and Post Scripts that are found in UC4 input objects data are sorted according to the number of UC4 jobs that contain them, so you can handle them by priority.   After you analyze and understand the script logic, and see how it should be converted to Control-M, you can use this file to create conversion rules to convert from UC4 Pre/Post Scripts to Control-M.   In the Select conversion option column, you can choose how to convert the UC4 Scripts into Control-M, as described in Control-M options.   For more information about the UC4 Script Conversion file, see UC4_scripts_conversion_to_ctm tab. For more information about converting UC4 Pre/Post Scripts, see Converting UC4 scripts to Control-M.  After you have defined conversion rules that convert Pre/Post Scripts to Control-M, save the file, move it to the same location as the UC4 Objects input data, and rerun the conversion.   The Conversion Tool uses the UC4 Script Conversion file as additional input data to convert Pre/Post Scripts to Control-M.   NOTE: Do not rename the UC4_scripts_conversion_to_ctm.xls file, as the Conversion Tool searches for the specific name.  You can convert UC4 Scripts that contain one command into Control-M Command Line jobs and/or exclude Pre and Post Scripts in Control-M client, as described in Additional Conversion Options parameters.  \"},{\"id\":27,\"title\":\"Converting UC4 scripts to Control-M\",\"url\":\"93111.htm\",\"text\":\"This procedure enables you to convert UC4 Scripts to Control-M using the UC4 Script Conversion file.   After you run the initial UC4 conversion, the Conversion Tool automatically generates the UC4_scripts_conversion_to_ctm.xls file (UC4 Script Conversion file).   In this file, you need to analyze and understand the script logic, and see how it should be converted to Control-M. For more information about the UC4 Script Conversion file, see UC4_scripts_conversion_to_ctm tab.  Before you begin  Ensure that you load and convert UC4 data to Control-M.  To convert UC4 Scripts to Control-M:  From the UC4 Script Rules tab, in the UC4 Scripts Conversion section, open the UC4_scripts_conversion_to_ctm.xlsx file.  The UC4_scripts_conversion to ctm file opens.  From the UC4_scripts_conversion_to_ctm tab, in the Select conversion option 1 column, from the dropdown list, select the one of the following options:  Post Script Type: Select one of the following:  Convert to Control-M On Do Actions  Do not Convert Script  Pre Script Type: Select one of the following:  Convert to Control-M Variables  Replace with another script  Do not convert script  For more information about the Conversion options, see Control-M options.  NOTE: You can view UC4 script reoccurring patterns in the UC4_scripts_analysis tab. For more information, see UC4 script analysis.  In the Conversion option 1 value column type or supply the value, if required.   NOTE: If you want to convert UC4 Post scripts to On Do Actions, supply the value in XML format, as described in Adding an On Do Action XML value.   If you want to convert UC4 Pre Scripts to Control-M Variables, supply the value in XML format, as described in Adding a Control-M Variable XML value.  (Optional) In the Select conversion option 2, and Conversion option 2 value columns, add any additional options and values by repeating steps 2 and 3.  Save the UC4 Script Conversion file, move it to the same location as the UC4 Objects input data, and rerun the conversion.   NOTE: The Conversion Tool uses the UC4 Script Conversion file as additional input data and converts the Pre/Post Scripts according to this file.   \"},{\"id\":28,\"title\":\"UC4_scripts_conversion_to_ctm tab\",\"url\":\"93384.htm\",\"text\":\"The following table describes the information contained in the UC4_scripts_conversion_to_ctm tab in the UC4_scripts_conversion_to_ctm .xls file:  Name  Description  UC4 Script type  Indicates if the UC4 Script found belongs to the Pre/Post Script attributes.  NOTE: In the Select conversion option column the options vary according to Script Type.  UC4 Script Content  Contains the UC4 Script detected in the Pre/Post-Script attribute.  Number of jobs use the script  Contains the number of UC4 Jobs that use the same script.  Type  Indicates the type of Control-M Job to use when creating Control-M On Do Actions or Parameters data in Control-M client.  Select conversion option 1  Enables you to define how to convert UC4 Pre/Post Scripts into Control-M using one of the following options:  Convert to Control-M On Do Actions (Post Script Type only)  Convert to Control-M Variables (Pre Script Type only)  Replace with another Script (Pre Script Type only)  Do not Convert Script  For more information about the Control-M options, see Control-M options.  The following table describes the Control-M options in the Select Conversion option column in the UC4 Script Conversion file.  Script type  Control-M option  Description  Post Script  Convert to Control-M On Do Actions  Converts UC4 Post Script to Control-M On Do Action.  When selecting this option, you need to supply the Control-M On Do Action XML in the Conversion Option Value column, as described in Adding an On Do Action XML value.  Do not Convert Script  Does not convert UC4 Post Script to a Control-M embedded Script Job and the Conversion Tool does not issue a warning message in the Conversion Report.  Use this option when you decide that UC4 Script is not needed in Control-M.  Pre Script  Convert to Control-M Variables  Converts UC4 Pre Script to a Control-M Variable.  When selecting this option, you need to supply the Control-M Variable XML in the Conversion Option Value column, as described in Adding a Control-M Variable XML value.  Replace with another Script  Replaces a UC4 Pre Script with another script that does not use UC4 Scripting language.  When selecting this option, you need to supply a replacement script in the Conversion Option Value column.   Do not Convert Script  Does not convert UC4 Pre script to a Control-M embedded Script job and does not issue a warning message in the conversion report.   Use this option when you decide that UC4 Script is not needed in Control-M.  Conversion option 1 value  Defines the Conversion option value that is imported into Control-M  Select conversion option 2 (optional)  Defines an additional option in Control-M, as described in Select conversion option 1.   Conversion option 2 value (optional)  Defines an additional Conversion option value, as described in Conversion option value 1.  \"},{\"id\":29,\"title\":\"Control-M options\",\"url\":\"94118.htm\",\"text\":\"The following table describes the Control-M options in the Select Conversion option column in the UC4 Script Conversion file.  Script type  Control-M option  Description  Post Script  Convert to Control-M On Do Actions  Converts UC4 Post Script to Control-M On Do Action.  When selecting this option, you need to supply the Control-M On Do Action XML in the Conversion Option Value column, as described in Adding an On Do Action XML value.  Do not Convert Script  Does not convert UC4 Post Script to a Control-M embedded Script Job and the Conversion Tool does not issue a warning message in the Conversion Report.  Use this option when you decide that UC4 Script is not needed in Control-M.  Pre Script  Convert to Control-M Variables  Converts UC4 Pre Script to a Control-M Variable.  When selecting this option, you need to supply the Control-M Variable XML in the Conversion Option Value column, as described in Adding a Control-M Variable XML value.  Replace with another Script  Replaces a UC4 Pre Script with another script that does not use UC4 Scripting language.  When selecting this option, you need to supply a replacement script in the Conversion Option Value column.   Do not Convert Script  Does not convert UC4 Pre script to a Control-M embedded Script job and does not issue a warning message in the conversion report.   Use this option when you decide that UC4 Script is not needed in Control-M.  \"},{\"id\":30,\"title\":\"UC4 script analysis\",\"url\":\"95541.htm\",\"text\":\"The UC4_scripts_analysis tab in the UC4_scripts_conversion_to_ctm.xls fle enables you to view UC4 script reoccurring patterns, which are sorted according to the number of UC4 jobs that contain them.   All the UC4 scripts that contain the same UC4 keywords sequence are combined into one group. You can view the UC4 keywords sequence inside the group pattern column   When clicking + you can expand the group and then view the content of each UC4 script inside it.  \"},{\"id\":31,\"title\":\"Adding an On Do Action XML value\",\"url\":\"93112.htm\",\"text\":\"This procedure describes how to add an On Do Action XML to the Conversion option value column in the UC4 Script Conversion file. Before adding the value, you need to create an On Do Action in Control-M client and export it to an XML file. For an example, see On Do Action XML value example.  To add an On Do action XML value:  In Control-M client, from the Planning domain, create a job.  Create an On Do Action, by adding the On Do Action parameters, as necessary, as described in On/Do Actions in Control-M Parameters.  Export the selected jobs to an XML file, by doing one of the following:  Select the entities to export.  Select @, and select Export Selected Entities.  To export the workspace, click @.  Click Save.  Open the XML file that you saved in step 4, and copy and paste the On Do Action into the Conversion option value 1 and/or 2 columns in the UC4 Script file.  Continue with Converting UC4 scripts to Control-M.  \"},{\"id\":32,\"title\":\"Adding a Control-M Variable XML value\",\"url\":\"94114.htm\",\"text\":\"This procedure describes how to add a Control-M Variable XML to the Conversion option value column in the UC4 Script Conversion file. Before adding the value, you need to create a Control-M Variable in Control-M client and export it to an XML file.   For an example, see Control-M Variable XML value example.  To add a Control-M variable XML value:  In Control-M client, from the Planning domain, create a job.  Create the Control-M Variable, by adding the variables as necessary, as described in Variables in Control-M Parameters.  Export the selected jobs to an XML file, by doing one of the following:  Select the entities to export.  Select @, and select Export Selected Entities.  To export the workspace, click @.  Click Save.  Open the XML file that you saved in step 4, and copy and paste the Control-M Variable XML into the Conversion option value 1 and/or 2 columns in the UC4 Script Conversion file.  Continue with Converting UC4 scripts to Control-M.  \"},{\"id\":33,\"title\":\"On Do Action XML value example\",\"url\":\"93125.htm\",\"text\":\"The following example describes how to export to XML an On Do Action in the Planning domain, and then add it to the Conversion Option value column in the UC4 Script Conversion file.   In Job Properties, create the following On Do Action:  From the Workspace tab, select Export, and save the exported XML.  Open the following XML:  <?xml version=\\\"1.0\\\" encoding=\\\"utf-8\\\"?>  <!--Exported at 18-09-2017 15:35:47-->  <DEFTABLE xmlns:xsi=\\\"http://www.w3.org/2001/XMLSchema-instance\\\" xsi:noNamespaceSchemaLocation=\\\"Folder.xsd\\\">  <FOLDER DATACENTER=\\\"CTM-Server1\\\" VERSION=\\\"900\\\" PLATFORM=\\\"UNIX\\\" FOLDER_NAME=\\\"Folder#2\\\" FOLDER_ORDER_METHOD=\\\"SYSTEM\\\" TYPE=\\\"1\\\" ENFORCE_VALIDATION=\\\"N\\\">  <JOB MEMNAME=\\\"a\\\" JOBNAME=\\\"OS_Job#1\\\" CREATED_BY=\\\"amir\\\" RUN_AS=\\\"a\\\" CRITICAL=\\\"0\\\" TASKTYPE=\\\"Job\\\" CYCLIC=\\\"0\\\" INTERVAL=\\\"00001M\\\" MEMLIB=\\\"a\\\" CONFIRM=\\\"0\\\" RETRO=\\\"0\\\" MAXWAIT=\\\"0\\\" MAXRERUN=\\\"0\\\" AUTOARCH=\\\"1\\\" MAXDAYS=\\\"0\\\" MAXRUNS=\\\"0\\\" DAYS=\\\"ALL\\\" JAN=\\\"1\\\" FEB=\\\"1\\\" MAR=\\\"1\\\" APR=\\\"1\\\" MAY=\\\"1\\\" JUN=\\\"1\\\" JUL=\\\"1\\\" AUG=\\\"1\\\" SEP=\\\"1\\\" OCT=\\\"1\\\" NOV=\\\"1\\\" DEC=\\\"1\\\" DAYS_AND_OR=\\\"O\\\" SHIFT=\\\"Ignore Job\\\" SHIFTNUM=\\\"+00\\\" SYSDB=\\\"1\\\" IND_CYCLIC=\\\"S\\\" RULE_BASED_CALENDAR_RELATIONSHIP=\\\"O\\\" APPL_TYPE=\\\"OS\\\" MULTY_AGENT=\\\"N\\\" USE_INSTREAM_JCL=\\\"N\\\" CYCLIC_TOLERANCE=\\\"0\\\" CYCLIC_TYPE=\\\"C\\\" PARENT_FOLDER=\\\"Folder#2\\\">  <ON STMT=\\\"*\\\" CODE=\\\"NOTOK\\\">  <DOACTION ACTION=\\\"OK\\\" />  <DOMAIL URGENCY=\\\"R\\\" DEST=\\\"amir_banai@bmc.com\\\" SUBJECT=\\\"Job Failed\\\" ATTACH_SYSOUT=\\\"D\\\" />  </ON>  </JOB>  </FOLDER>  </DEFTABLE>  Copy the following XML to the Conversion Option value column:  <ON STMT=\\\"*\\\" CODE=\\\"NOTOK\\\">  <DOACTION ACTION=\\\"OK\\\" />  <DOMAIL URGENCY=\\\"R\\\" DEST=\\\"amir_banai@bmc.com\\\" SUBJECT=\\\"Job Failed\\\" ATTACH_SYSOUT=\\\"D\\\" />  </ON>  \"},{\"id\":34,\"title\":\"Control-M Variable XML value example\",\"url\":\"94115.htm\",\"text\":\"The following example describes how to export to XML a Control-M Variable in the Planning domain, and then to add it to the Conversion Option value column in the UC4 Script Conversion file.   From Job Properties, in the Variables section, create the following 3 variables:  From the Workspace tab, select Export, and save the exported XML.  Open the following XML:  <?xml version=\\\"1.0\\\" encoding=\\\"utf-8\\\"?>  <!--Exported at 18-09-2017 15:35:47-->  <DEFTABLE xmlns:xsi=\\\"http://www.w3.org/2001/XMLSchema-instance\\\" xsi:noNamespaceSchemaLocation=\\\"Folder.xsd\\\">  <FOLDER DATACENTER=\\\"CTM-Server1\\\" VERSION=\\\"900\\\" PLATFORM=\\\"UNIX\\\" FOLDER_NAME=\\\"Folder#2\\\" FOLDER_ORDER_METHOD=\\\"SYSTEM\\\" TYPE=\\\"1\\\" ENFORCE_VALIDATION=\\\"N\\\">  <JOB MEMNAME=\\\"a\\\" JOBNAME=\\\"OS_Job#1\\\" CREATED_BY=\\\"amir\\\" RUN_AS=\\\"a\\\" CRITICAL=\\\"0\\\" TASKTYPE=\\\"Job\\\" CYCLIC=\\\"0\\\" INTERVAL=\\\"00001M\\\" MEMLIB=\\\"a\\\" CONFIRM=\\\"0\\\" RETRO=\\\"0\\\" MAXWAIT=\\\"0\\\" MAXRERUN=\\\"0\\\" AUTOARCH=\\\"1\\\" MAXDAYS=\\\"0\\\" MAXRUNS=\\\"0\\\" DAYS=\\\"ALL\\\" JAN=\\\"1\\\" FEB=\\\"1\\\" MAR=\\\"1\\\" APR=\\\"1\\\" MAY=\\\"1\\\" JUN=\\\"1\\\" JUL=\\\"1\\\" AUG=\\\"1\\\" SEP=\\\"1\\\" OCT=\\\"1\\\" NOV=\\\"1\\\" DEC=\\\"1\\\" DAYS_AND_OR=\\\"O\\\" SHIFT=\\\"Ignore Job\\\" SHIFTNUM=\\\"+00\\\" SYSDB=\\\"1\\\" IND_CYCLIC=\\\"S\\\" RULE_BASED_CALENDAR_RELATIONSHIP=\\\"O\\\" APPL_TYPE=\\\"OS\\\" MULTY_AGENT=\\\"N\\\" USE_INSTREAM_JCL=\\\"N\\\" CYCLIC_TOLERANCE=\\\"0\\\" CYCLIC_TYPE=\\\"C\\\" PARENT_FOLDER=\\\"Folder#2\\\">  <VARIABLE NAME=\\\"%%A\\\" VALUE=\\\"Local\\\" />  <VARIABLE NAME=\\\"%%\\\\\\\\Banai\\\\Amir\\\" VALUE=\\\"Pool\\\" />  <VARIABLE NAME=\\\"%%\\\\BB\\\" VALUE=\\\"Global\\\" />  </JOB>  </FOLDER>  </DEFTABLE>  Copy the following XML to the Conversion Option value column:  <VARIABLE NAME=\\\"%%A\\\" VALUE=\\\"Local\\\" />  <VARIABLE NAME=\\\"%%\\\\\\\\Banai\\\\Amir\\\" VALUE=\\\"Pool\\\" />  <VARIABLE NAME=\\\"%%\\\\BB\\\" VALUE=\\\"Global\\\" />  \"},{\"id\":35,\"title\":\"Additional Conversion Options parameters\",\"url\":\"95075.htm\",\"text\":\"The following table describes the Additional Conversion Options Parameters in the UC4 Scripts Rules tab:  Parameter  Description  Don\'t add Pre Scripts into Control-M Embedded Script  Does not convert the Pre Script content into the Control-M Embedded Script field.  A warning message about Pre Script content still appears in the Conversion Report.  NOTE: By default, the Conversion Tool converts the content of UC4 Pre Script into the Control-M Embedded script field.  If you do not want to convert UC4 Pre-Script and remove the warning message, set the appropriate rule in the UC4_scripts_conversion_to_ctm.xls file.  Don\'t add Post Scripts into Control-M Embedded Script  Does not convert Post Script content into the Control-M Embedded Script field  A warning message about Post Script content still appears in the Conversion Report.  NOTE: By default, the Conversion Tool converts the content of UC4 Post Script into the Control-M Embedded script field.   If you do not want to convert UC4 Pre-Script and remove the warning message, set the appropriate rule in the UC4_scripts_conversion_to_ctm.xls file.  Convert UC4 Scripts with \'1\' command into Control-M Command line jobs  Converts UC4 Scripts, which contains only one command into the Control-M Command line field, if it does not include UC4 Scripting language keywords.  NOTE: By default, the Conversion Tool converts the content of UC4 Scripts into the Control-M Embedded script field.  \"},{\"id\":36,\"title\":\"CA AutoSys Workload Automation\",\"url\":\"99695.htm\",\"text\":\"The following topics describe how to extract AutoSys data, define a new project, additional settings, and recommended practices:  Extracting CA AutoSys Workload Automation data  Defining a new CA AutoSys Workload Automation conversion project  Setting additional CA AutoSys Workload Automation rules  CA AutoSys recommended practices  \"},{\"id\":37,\"title\":\"Extracting CA AutoSys Workload Automation data\",\"url\":\"46053.htm\",\"text\":\"This procedure describes how to extract CA AutoSys Workload Automation (AutoSys) data before starting a new conversion project. After extracting data, you can then define a new conversion project.  For AutoSys recommended practices, see CA AutoSys recommended practices.  To extract AutoSys data:  Create the following definitions file by running the following commands:   .JIL jobs definitions: autorep &#8211;j ALL &#8211;q  .TZO time zones definitions: autotimezone &#8211;l  .CAL calendars definitions: autocal_asc &#8211;E autosys.STANDARD_CAL &#8211;s ALL  Open the Conversion Tool and import the files, as described in Defining a new CA AutoSys Workload Automation conversion project.  \"},{\"id\":38,\"title\":\"Defining a new CA AutoSys Workload Automation conversion project\",\"url\":\"Define_autosys_conv.htm\",\"text\":\"This procedure describes how to define a new CA AutoSys Workload Automation (AutoSys) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   Before you begin  Ensure the following:  Create and export definitions files, as described in Setting up a CA Autosys Workload Automation project.  This procedure describes how to extract CA AutoSys Workload Automation (AutoSys) data before starting a new conversion project. After extracting data, you can then define a new conversion project.  For AutoSys recommended practices, see CA AutoSys recommended practices.  To extract AutoSys data:  Create the following definitions file by running the following commands:   .JIL jobs definitions: autorep &#8211;j ALL &#8211;q  .TZO time zones definitions: autotimezone &#8211;l  .CAL calendars definitions: autocal_asc &#8211;E autosys.STANDARD_CAL &#8211;s ALL  Open the Conversion Tool and import the files, as described in Defining a new CA AutoSys Workload Automation conversion project.  Create a new project, as described in Running a new conversion project.  To define a new CA AutoSys conversion project:  From the CA AutoSys Workload Automation Load Data window, in the Import Scheduling Data area, complete the Import scheduling data parameters.  The following table describes the Import scheduling data parameters when defining a new Autosys project.  Parameter  Description  Jobs definitions (JIL)  (Mandatory) Enables you to locate and select the job definitions file, .JIL by clicking on @.  Time zone definitions  Enables you to locate and select the time zones definitions file, .TZO by clicking on @.  Calendar definitions  Enables you to locate and select the standard calendar definitions file, .CAL by clicking on @.  Extended calendar definitions  Enables you to locate and select the extended calendar definitions file, .CAL by clicking on @.  NOTE: Only standard calendar conversion is supported by the Control-M Conversion Tool. Cyclic and extended calendars require manual definition in the Control-M environment. For more information, see Job scheduling in Using Control-M.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.  For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.   Continue converting project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   NOTE: In the Validation phase, you can compare your scheduler\'s forecast report to the Control-M forecast report created during validation. To create the report, use any of the report parameter files below.  To report from a specific date to infinity, use: job_depends -t -J ALL -F \\\"mm/dd/yyyy\\\".  To display all jobs scheduled to run between two dates, use: job_depends -t -J ALL -F mm/dd/yyyy hh:mm -T mm/dd/yyyy hh:mm. For example, job_depends -t -J ALL -F 01/03/2009 10:01 -T 02/15/2009 19:01.  To report for a specific date, use: job_depends -t -J ALL -F mm/dd/yyyy hh:mm -T mm/dd/yyyy hh:mm. For example, job_depends -t -J ALL -F 02/01/2009 00:01 -T 02/01/2009 23:59.  For more information on validation, see Validation.  \"},{\"id\":39,\"title\":\"AutoSys scheduling data parameters\",\"url\":\"45831.htm\",\"text\":\"The following table describes the Import scheduling data parameters when defining a new Autosys project.  Parameter  Description  Jobs definitions (JIL)  (Mandatory) Enables you to locate and select the job definitions file, .JIL by clicking on @.  Time zone definitions  Enables you to locate and select the time zones definitions file, .TZO by clicking on @.  Calendar definitions  Enables you to locate and select the standard calendar definitions file, .CAL by clicking on @.  Extended calendar definitions  Enables you to locate and select the extended calendar definitions file, .CAL by clicking on @.  \"},{\"id\":40,\"title\":\"Setting additional CA AutoSys Workload Automation rules\",\"url\":\"Set_addl_autosys_rules.htm\",\"text\":\"This procedure explains how to set additional CA Autosys Workload Automation (Autosys) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules.  For more information about AutoSys recommended practices, see CA AutoSys recommended practices.  Before you begin  Ensure that the Conversion Settings window is open. For more information, see Selecting or creating a conversion rules file.  To set additional AutoSys rules:  From the Additional Autosys Rules tab, in the General area, select the local time zone of the Control-M/Server computer from the Local Timezone drop-down list. In Control-M jobs, the local time zone is replaced with an empty value.  In the Source Command text box, enter the command used to source the script defined in the profile field of your source scheduler.  Select the Convert unscheduled boxes to USERDAILY=\\\"ON_DEMAND\\\" check box.  NOTE: By default Control-M runs the jobs automatically. By checking the box the jobs run on demand.  In the Un-boxed jobs area, specify how to configure standalone jobs by choosing one of the following options:  GROUP all standalone jobs in one folder: Enables standalone jobs to be grouped into one folder.  Create a different folder for each standalone job: Enables you to create a different folder for each standalone job.  To define the condition format in Control-M, in the Convert to format field, from the dropdown list, select one of the following condition format options:  {Job/Folder Name}_Status  {Job/Folder Name}-TO-{TargetJob:Job/Folder Name}   In the File Watcher Type area, select one of the following:  AFT  Ctmfw utility   By default, File Watcher jobs are converted to Control-M for AFT (AFT) jobs. The second option allows the use of the Control-M File Watcher utility instead. For more information, see ctmfw File Watcher utility in Control-M Utilities.  In the SAP area, select the Enable SAP conversion check box to convert SAP jobs using the Control-M for SAP forms.  In the PeopleSoft area, select the Enable PeopleSoft conversion check box to convert PeopleSoft jobs using the Control-M for PeopleSoft forms.  In the Text File Reading and Monitoring Job Type area, select the Convert to community AI FWText Job option.  The Control-M FWText job supports the following fields: text_file_filter, text_file_name, and text_file_filter_exists. The monitor_mode field is set to NOW and the text_file_mode field is set to LINE.  NOTE: If you select this option, you must download the FWText job and import it as described in Importing job from file.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":41,\"title\":\"CA AutoSys recommended practices\",\"url\":\"46143.htm\",\"text\":\"As CA-AutoSys is a command line driven scheduler, you should retain this way of working and set the rules file to convert all jobs to command line jobs.   The following topics describe the recommended practice to convert AutoSys jobs to Control-M, with information and warning messages, and AutoSys utilities.  Converting AutoSys jobs to Control-M - recommended practice  AutoSys information and warning messages - corrective action  AutoSys utilities  \"},{\"id\":42,\"title\":\"Converting AutoSys jobs to Control-M - recommended practice\",\"url\":\"46144.htm\",\"text\":\"This procedure describes the recommended practices for converting AutoSys jobs to Control-M.  To convert AutoSys jobs to Control-M:  Before converting jobs, it is recommended that you do the following:  A full scan of all scripts run by AutoSys, which enables you to look for occurrences of AutoSys command lines, executables and variables within the scripts.  Identify any external interfaces to, for example, monitoring and alerting tools, reporting tools, help desk incident management tools and CMDB&#8217;s.  A precursory scan of the JIL file. The conversion tool does not handle Job_terminator and box_terminator statements. Before commencing the conversion, you should scan the JIL extract file keywords. For more information, see CA AutoSys Keywords.  Create AutoSys virtual machines, which are equivalent to Control-M host groups.  Obtain a list from AutoSys of all virtual machine names and the hosts that constitute the group, which can be obtained by running the following AutoSys command:  autorep &#8211;M ALL &#8211;d   For an example of the output, see Example Output - autorep -M ALL command.  Create AutoSys variables.  These are equivalent to Control-M variables and can be embedded in the job definition or script.  Obtain a list of AutoSys variables and convert these manually to Control-M Variables for a one off installation. To obtain a list of AutoSys variables, run the following AutoSys command:  autorep &#8211;G ALL   For an example of the output, see Example AutoSys variables.  In the Conversion Tool do the following:  From the Conversion Settings window, in the General tab in the Job Type Conversion area, select Convert all jobs to Control-M command line jobs. For more information, see Setting General rules.  If you have Control-M for Advanced File Transfer, select AFT in the File Watcher Type otherwise use the Ctmfw utility which matches AutoSys. For more information, see Setting additional Autosys rules.  After the conversion, from the Conversion Results window, in the Actions tab, click Generate Scripts to add automatically Quantitative resources. For more information, see Generating scripts for Control-M/Server. For an example, see Example Batch file to load Quantitative Resources.  \"},{\"id\":43,\"title\":\"CA AutoSys Keywords\",\"url\":\"46178.htm\",\"text\":\"The following table describes the .JIL extract files which you need to scan for occurrences of the AutoSys keywords.  CA AutoSys Keyword  Description  job terminator: 1  job terminator: Y  job terminator: y  If any of these statements are present and the AutoSys box (Smart folder) was set to a failure status, this job should be killed.  box terminator: 0  box terminator: N  box terminator: n  If a job in the box fails, do not stop the box or mark it as failed.  In Control-M this can be handled by setting an ON NOTOK DO OK in the job or group.  \"},{\"id\":44,\"title\":\"Example Output - autorep -M ALL command\",\"url\":\"46145.htm\",\"text\":\"The following is an example of output when running the AutoSys command autorep &#8211;M ALL &#8211;d  autorep -M ALL     Machine Name                  Max Load   Current Load Factor  O/S         Status  _____________________________ __________ ____________ _______ ___________ ______  abtgpdb                       ---        ---          1.00    Unix        Online  abtgpftp                      ---        ---          1.00    Unix        Online  abtgposs1                     ---        ---          1.00    Unix        Online  abtgpstmt                     ---        ---          1.00    Unix        Online  TGPRODDB.abtgpdb              ---        ---          ----    Unix        Online  TGPRODFTP.abtgposs1           ---        ---          ----    Unix        Online  TGPRODSTMT.abtgpstmt          ---        ---          ----    Unix        Online  abtgqdb                       ---        ---          1.00    Unix        Online  TGQADB.abtgqdb                ---        ---          ----    Unix        Online  TGQAFTP.abtgqdb               ---        ---          ----    Unix        Online  TGQASTMT.abtgqdb              ---        ---          ----    Unix        Online  Example conversion to Control-M Server:  ctmnodegrp -EDIT -NODEGRP TGPRODDB -APPLTYPE OS -ADD abtgpdb               ctmnodegrp -EDIT -NODEGRP TGPRODFTP -APPLTYPE OS -ADD abtgposs1            ctmnodegrp -EDIT -NODEGRP TGPRODSTMT -APPLTYPE OS -ADD abtgpstmt           ctmnodegrp -EDIT -NODEGRP TGQADB -APPLTYPE OS -ADD abtgqdb                 ctmnodegrp -EDIT -NODEGRP TGQAFTP -APPLTYPE OS -ADD abtgqdb                ctmnodegrp -EDIT -NODEGRP TGQASTMT -APPLTYPE OS -ADD abtgqdb  \"},{\"id\":45,\"title\":\"Example AutoSys variables\",\"url\":\"46147.htm\",\"text\":\"The following example describes the output when running the AutoSys command, autorep &#8211;G ALL.   autorep -G %TGPROD%  Global Name                  Value                                  Last Changed          ____________________________ _____________________________________  ____________________  TGPROD_APIINBOX              /tgprod/interfaces/inbox               03/02/2009 16:44:09   TGPROD_APIOUTBOX             /tgprod/interfaces/outbox              03/02/2009 16:44:09   TGPROD_AUTOBACKUP            /tgprod/reports/current                06/12/2009 11:00:50   TGPROD_AUTOBIN               /opt/CA/AutoSys/autosys/bin            03/02/2009 16:44:09   TGPROD_DATEA                 2009-09-18                             09/18/2009 00:01:04   TGPROD_DATEB                 20090918                               09/18/2009 00:01:04   TGPROD_DATEC                 090918    Example conversion to Control-M Server for Windows:  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_APIINBOX\\\"     &#8211;VAREXPR /tgprod/interfaces/inbox  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_APIOUTBOX\\\"    &#8211;VAREXPR /tgprod/interfaces/outbox  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_AUTOBACKUP\\\"   &#8211;VAREXPR /tgprod/reports/current  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_AUTOBIN\\\"      &#8211;VAREXPR /opt/CA/AutoSys/autosys/bin  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_DATEA\\\"        &#8211;VAREXPR 2009-09-18  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_DATEB\\\"        &#8211;VAREXPR 20090918  ctmvar -ACTION SET -VAR \\\"%%%%\\\\TGPROD_DATEC\\\"        &#8211;VAREXPR 090918  \"},{\"id\":46,\"title\":\"Example Batch file to load Quantitative Resources\",\"url\":\"46183.htm\",\"text\":\"The following example describes the Batch file to load Quantitative Resources.  ecaqrtab ADD QRResource1 0  ecaqrtab ADD QRResource2 100  ecaqrtab ADD QRResource3 25  \"},{\"id\":47,\"title\":\"AutoSys information and warning messages - corrective action\",\"url\":\"46150.htm\",\"text\":\"The following table describes the AutoSys information and warning messages and the corrective action.  NOTE: This does not include all of the AutoSys information, warning and error messages.  Product  Message ID  Message Description  Action  AutoSys  INF4002  Value truncated. Manually correct the &#8216;Run As&#8217; user  It is typical for the defined owner in AutoSys to refer to a fully qualified domain host name such as username@company.domain.com which if exceeds 30 characters is truncated.  These errors need to be corrected by ensuring that the job looks at the correct agent with the correct user name and remove the @company.domain.com   AutoSys  INF4003  Cannot redirect only STDERR  None required. In AutoSys it is usual to send STDOUT and STDERR to different locations.  Control-M Conversion adjusts both to send to the same location.  AutoSys  INF4004  Calendar required  A Calendar needs to be created.  AutoSys  INF4007  Updated redirection\\t  None required. Additional redirection of the output can be pointed at a location using AutoSys variables. These are converted to Control-M variables in the job definition.  AutoSys  WRN1005  The command line exceeds 512 characters.   You can shorten the command line or manually change it to Control-M embedded script.   AutoSys  WRN4000  AutoSys utility &#8216;XXX&#8217; used  Identify the utility and review possible solutions.  AutoSys  WRN4002  Unconvertible attribute <attribute name>  No available attribute with Control-M. Review options. Reports a function in AutoSys that is not available with Control-M.  If the attribute is term_run_time, then the Control-M job definition needs to be updated to have a shout to a destination that points to a ctmkilljob script (P) based on EXECTIME options.  AutoSys  WRN4006  Cannot convert attribute <attribute name> for group entities  Typically start times or minutes defined on the box level. Change the job to be cyclic  AutoSys  WRN4007  Failed to convert <sub condition>  Unable to convert failure status on the job dependency.  Review the predecessor to set condition on failure that matches up with a condition name in the successor job.  AutoSys  WRN4009\\t  Time zone &#8216;XXX&#8217; could not be converted to a Control-M/Server time zone.  If only a few, correct manually.  If more, correct the source time-zone file or mass update the JIL file.  AutoSys  WRN4012  Conditions nesting cannot be converted <formula substring>  Usually a mix of AND/OR statements or variables used as dependencies.  Review and adjust manually.  \"},{\"id\":48,\"title\":\"AutoSys utilities\",\"url\":\"46152.htm\",\"text\":\"The following table describes the CA-AutoSys utilities that you may encounter when running a conversion.  The most common utility is SENDEVENT which is used to manipulate the CA-AutoSys definitions and live schedule.  Utility Name  Description  Action  archive_events  Archives data from AutoSys database  Delete job  as_info  List AutoSys installation information  Delete job  as_safetool  Manage AutoSys authentication certificates  Delete job  as_server  Runs AutoSys Application Server  Delete job  auto_svcdesk  Open Service Desk helpdesk tickets  Create script to call Service Desk Helpdesk to open incidents and replace CLI  auto_timezone  Maintains the AutoSys time-zones table  Delete job  autoaggr  Aggregates AutoSys data  Replace with ctmjsa *  autocal_asc  AutoSys calendar utility  Delete job  autodwp  AutoSys workload utility\\t  Delete job  autoflags  Print AutoSys system configuration information  Delete job  autoping  Verifies the connectivity  of AutoSys server and client machines  Replace with ctmping or delete job  autorep  Reports information about AutoSys jobs  Delete job  autosec_test  Obtain the access level AutoSys Job assets from the security subsystem  Delete job  autostatad  Retrieves the status of Adapter jobs  Delete job  autostatus  Reports the status  of AutoSys jobs or global variables  Delete job  autosys_secure  Maintain AutoSys security features  Delete job  autosyslog  Displays AutoSys log files  Delete job  autotrack  Tracks changes AutoSys database  Delete job  chase  Verifies the status of AutoSys environment  Delete job  check_auto_up  Verifies status of the AutoSys Scheduler and database  Delete job  clean_files  Removes AutoSys Agent log files  Delete job  cron2jil\\t  Translates crontab files into JIL format  Delete job  eventor\\t  Starts AutoSys  Delete job  jil  Defines AutoSys jobs and objects  Investigate use of job, and replace with Control-M ctmdefine/ctmcreate or other utility  job_delete  Cleans the AutoSys job_delete database table  Delete job  job_depends  Reports on AutoSys job dependencies and conditions  Delete job  monbro\\t  Runs an AutoSys monitor or report (browser)  Delete job  sendevent  STARTJOB  KILLJOB  DELETEJOB  FORCE_STARTJOB  JOB_ON_ICE  JOB_OFF_ICE  JOB_ON_HOLD  JOB_OFF_HOLD  CHANGE_STATUS  STOP_DEMON  CHANGE_PRIORITY  COMMENT  ALARM  SET_GLOBAL  SEND_SIGNAL  ctmcontb &#8211;ADD  execute the ctmkilljob script  Delete job  ctmcontb &#8211;ADD  ctmcontb &#8211;DELETE  Delete job  Delete job  Delete job  ctmvar &#8211;ACTION SET  Delete job  time 0  Calculates AutoSys time  xql  Provides access to the Sybase database  Review use of this command, potentially delete job, or create Control-M equivalent  zql  Provides access to the Oracle database  Review use of this command, potentially delete job, or create Control-M equivalent  \"},{\"id\":49,\"title\":\"CA Dollar Universe\",\"url\":\"99696.htm\",\"text\":\"The following topics describe how to extract Dollar Universe data, define a new project, additional settings, and post conversion steps:  Configuring the ORSYP Dollar Universe environment  Defining a new Dollar Universe conversion project setup  Setting additional Dollar Universe rules  Post Conversion Steps: Dollar Universe HDP jobs  \"},{\"id\":50,\"title\":\"Extracting CA Dollar Universe data\",\"url\":\"46066.htm\",\"text\":\"This procedure describes how to manually extract CA Dollar Universe (Dollar Universe) data before starting a new project. After extracting data, you can then define a new conversion project.  To extract Dollar Universe data:  Create the following files by running the following commands:  Session list file: \\\"uxlst ses ses=* vses=* full\\\"  Session details file: \\\"uxshw ses ses=* lnk vses=*\\\"  Task details file: \\\"uxshw tsk upr=* mu=* ses=* vupr=000 nomodel partage\\\"  UPR file: \\\"uxshw upr upr=* vupr=* partage\\\"  Rule file: \\\"uxshw rul rul=*\\\"  Resource file: \\\"uxshw res res=*\\\"  Calendar file: \\\"uxshw cal exp mu=* since=2010 before=2014 nomodel\\\"  Management unit details file: \\\"uxshw mu mu=*\\\"  Management unit dependencies: \\\"uxlst HDP OUTPUT=c:\\\\temp\\\\LstHdp.txt\\\"  SAP ZUXTS table file: Connects to your SAP system using the SAP Logon console. Select the transaction ID and table name and when connected to the table, extract the table into the .csv file.  NOTE: Required only if you have Dollar Universe UPROCs that use the uxstr sap command, which need to be converted to Control-M for SAP jobs.  Ensure you copy the UXSRSV.SCK agent mapping file from the MGR folder in the Dollar Universe environment.  For more information about the Dollar Universe parameters, see Dollar Universe scheduling data parameters.  Open the Conversion Tool and import the data, as described in Defining a new Dollar Universe conversion project setup.     \"},{\"id\":51,\"title\":\"Defining a new CA Dollar Universe conversion project\",\"url\":\"Define_dollar_conv.htm\",\"text\":\"This topic describes how to define a new CA Dollar Universe (Dollar Universe) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.  For more information about creating a new conversion project, see Running a new conversion project.  Before you begin  Ensure the following:  Export the Dollar Universe data, as described in Configuring the ORSYP Dollar Universe environment.  Create a new project, as described in Running a new conversion project.  To define a new Dollar Universe conversion project:  From the CA Dollar Universe - Load Data window, in the Import Scheduling Data area, select one of the following:  From the Automatically Detect Files do the following:  In the Data files directory field, click @to locate the files directory  Click Find files.  The files are loaded into the Conversion Tool.   In the Import Scheduling Data area, select the Import Scheduling Data parameters for Dollar Universe project.  The following table describes the Import Scheduling Data parameters for a new Dollar Universe conversion project. You need to click @ to locate and select parameters.   Parameter  Description  Agent mapping file  (Mandatory) Defines the mapping file (UXSRSV.SCK file) between agent logical and physical names.  Calendar file  (Mandatory) Defines a calendars definition file.  Management unit details file  (Mandatory) Contains management unit definitions.  Resource file  (Mandatory) Contains the resource definitions.  Rule file  (Mandatory) Defines an algorithm rule, which translates the required execution periodicity of a task.  Session details file  (Mandatory) Defines a detailed description for each session. It contains lists of UPRs and dependencies between UPRs that are defined with each session.  Session list file  (Mandatory) Defines a list of sessions defined in the Dollar Universe node. For each session, the volume and description is displayed.  Task file  (Mandatory) Defines a detailed description of task parameters corresponding to the UPR or session that is running.  UPR file  (Mandatory) Defines a set of parameters and conditions that define the UPROC functionality  Management unit dependencies file  Contains a hierarchy of management unit dependencies.  SAP ZUXTS table file  Contains all SAP job parameters.  NOTE: When you select Automatically Detect Files, if any files are missing, you can add them manually in the Import Data Scheduling Area.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":52,\"title\":\"Dollar Universe scheduling data parameters\",\"url\":\"33456.htm\",\"text\":\"The following table describes the Import Scheduling Data parameters for a new Dollar Universe conversion project. You need to click @ to locate and select parameters.   Parameter  Description  Agent mapping file  (Mandatory) Defines the mapping file (UXSRSV.SCK file) between agent logical and physical names.  Calendar file  (Mandatory) Defines a calendars definition file.  Management unit details file  (Mandatory) Contains management unit definitions.  Resource file  (Mandatory) Contains the resource definitions.  Rule file  (Mandatory) Defines an algorithm rule, which translates the required execution periodicity of a task.  Session details file  (Mandatory) Defines a detailed description for each session. It contains lists of UPRs and dependencies between UPRs that are defined with each session.  Session list file  (Mandatory) Defines a list of sessions defined in the Dollar Universe node. For each session, the volume and description is displayed.  Task file  (Mandatory) Defines a detailed description of task parameters corresponding to the UPR or session that is running.  UPR file  (Mandatory) Defines a set of parameters and conditions that define the UPROC functionality  Management unit dependencies file  Contains a hierarchy of management unit dependencies.  SAP ZUXTS table file  Contains all SAP job parameters.  \"},{\"id\":53,\"title\":\"Setting additional CA Dollar Universe rules\",\"url\":\"Set_addl_dollar_rules.htm\",\"text\":\"This procedure describes how to set additional CA Dollar Universe (Dollar Universe) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional Dollar Universe rules:  From the Additional DOLLAR UNIVERSE rules tab, in the Standalone jobs field, select one of the following options.  GROUP all stand alone jobs in one folder: Enables standalone jobs to be grouped into one folder.  Create a different folder for each stand alone job: Enables separate folders to be created for each job.  In the Other information field, do one of the following from the drop down lists.  In the Date format field, select the format for date input and display.  In the Server timezone field, select the time zone. Default: GMT+1.  In the Area field, select one of the following options to build the Control-M SMART folder name according to the format: <AREA>_<SESSION>_<MU>:  EXP  SIM  INT  APP  In the Priority conversion area, select one of the following options.  Convert equal priorities  Don\'t convert priorities if all equal  NOTE: All Dollar Universe jobs contain a priority value (valid values are 0-255 and the default is 100). In the event that all Dollar Universe jobs use the same value, this will degrade the performance of Control-M. To avoid this effect, you can choose to not convert priorities according to the priority conversion option that you select. Irrespective of the option chosen, if not all priorities are equal, the priorities will be converted as usual.  In the HDP Options area, select the options as described in HDP Options parameters.  The following table describes the HDP options parameters. For more information about HDP options, see: Post Conversion Steps: Dollar Universe HDP jobs.  HDP Options  Description  Append conditions for viewing links between jobs in Control-M   Enables you to view the flow between jobs in the Planning and Monitoring domains in Control-M client.  Shout destination name for ctmorder script  Defines the name of the destination file in your environment which is necessary for adding a Shout destination in Control-M client.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":54,\"title\":\"HDP Options parameters\",\"url\":\"64831.htm\",\"text\":\"The following table describes the HDP options parameters. For more information about HDP options, see: Post Conversion Steps: Dollar Universe HDP jobs.  HDP Options  Description  Append conditions for viewing links between jobs in Control-M   Enables you to view the flow between jobs in the Planning and Monitoring domains in Control-M client.  Shout destination name for ctmorder script  Defines the name of the destination file in your environment which is necessary for adding a Shout destination in Control-M client.  \"},{\"id\":55,\"title\":\"Post Conversion Steps: Dollar Universe HDP jobs\",\"url\":\"92823.htm\",\"text\":\"Before running Dollar Universe HDP (\\\"HDP\\\") jobs you need to configure Control-M otherwise these jobs cannot run correctly. For more information, see Control-M configuration HDP job.  After you have converted your HDP jobs, the jobs are loaded into Control-M. When you open Control-M client, you see all the converted jobs in a Workspace in the Planning domain. If you have selected Append conditions for viewing links between jobs in Control-M in the Conversion Tool HDP options, you see how the jobs are linked together in the Planning and Monitoring domains in Control-M client. For more information about the Conversion Tool HDP options, see HDP Options parameters.  The following table describes the HDP options parameters. For more information about HDP options, see: Post Conversion Steps: Dollar Universe HDP jobs.  HDP Options  Description  Append conditions for viewing links between jobs in Control-M   Enables you to view the flow between jobs in the Planning and Monitoring domains in Control-M client.  Shout destination name for ctmorder script  Defines the name of the destination file in your environment which is necessary for adding a Shout destination in Control-M client.  Control-M links HDP jobs through the following Job Prerequisites and job actions in Control-M client:  In Conditions: Specifies one or more In conditions which correspond to the successful completion of another job. An In Condition is usually associated with an Out Condition of a successful completion of a predecessor job. For more information, see In Conditions in Using Control-M.   Out Conditions: Defines conditions which are added or deleted to the Conditions table when the job ends for a predecessor job. For more information, see Out Conditions in Using Control-M.  On Do Action: Defines automatic interventions such as rerunning a job or ordering a remedial job. For more information, see Job Actions in Using Control-M.  If you want to add or delete an HDP job, see HDP job management.  When a job runs on several hosts, a message is sent to Control-M script, using the Shout to Program functionality.   EXAMPLE:   -host_group T_1 -job_to_order HDP_TEST_02#0002 -folder EXP_HDP_SES_01_T_1 -MU_type T  -relationship CHILDREN -condition_variable %%ORDERID  NOTE: All parameters are mandatory. &#8211;condition_variable must be defined as %%ORDERID. For further information about the parameters, see Message parameters.  When the script receives the message, it finds host groups that match the criteria by scanning the MUdependencies.txt file (which contains relations between hosts). The script then performs CTM order on every host group that matches the criteria. The MUdependencies are performed according to the following parameters:  -host_group   -MU_type    -Relationship  EXAMPLE: MUdependencies.txt contains the following values:  HOSTGRP                                                      CHILD  ----------------------------------------------------------------   T_1                                                                 T_2  T_1                                                                 T_3  T_1                                                                 K_1  T_1                                                                 T_4  T_2                                                                 T_5  T_2                                                                 T_6  T_4                                                                 T_7  The script contains the following message:  -host_group T_1 -job_to_order HDP_TEST_02#0002 -folder EXP_HDP_SES_01_T_1 -MU_type T  -relationship CHILDREN -condition_variable %%ORDERID  The script performs ctmorder on the Child relationship with Type T, related to Host T_1. The script starts scanning the MUdependcies.txt and then performs ctmorder for Job HDP_TEST_02#0002 from Folder EXP_HDP_SES_01_T_1 on 3 host groups:  T_2 , T_3 , T_4 but not on K_1 that has a different type.  \"},{\"id\":56,\"title\":\"Control-M configuration HDP job\",\"url\":\"69361.htm\",\"text\":\"To configure HDP jobs on Control-M you need to do the following:  Run the Host Group script that was generated in the Conversion. The Host Group script defines where the converted jobs are ordered on specific host groups. For more information about generating the Host Group script, see Generating scripts for Control-M/Server.  Configure the Control-M environment. After you have converted HDP jobs, you need to add the shout destination otherwise after the first job is ordered, the next job may not run as the destination has not been defined. A shout is a notification of the job\'s status. There are two types of shouts. Shouts that are sent out before a job ends, and shouts that are sent out after a job ends.  For more information about Shout destination, see Shout destination management in Control-M Administration. To the configure Control-M environment, see Configuring the Control-M environment.   \"},{\"id\":57,\"title\":\"Configuring the Control-M environment\",\"url\":\"64837.htm\",\"text\":\"This procedure describes how to prepare the Control-M environment before you can start running converted HDP jobs in Control-M client.  Before you begin  Ensure that you have generated the Host Group script and you have move it to your Control-M/Server location, as described in Generating scripts for Control-M/Server.  To configure the Control-M environment:  Run the generated Host Group script in the Control-M/Server.  In the <conversion home>/workarea/datasources/<project name>/CONVERSIONS/<conversion result name>/HDP folder, copy the following files to your Control-M/Server machine:  Windows: orderJob.pl, orderscript.bat, and MuDependencies.txt  UNIX: orderJob.pl, orderJob.sh, and MuDependencies.txt   Start Control-M Configuration Manager.  For more information about starting the Control-M Configuration, see Introduction to Control-M Configuration Manager in Control-M.  Create a shout destination, as described in Creating a shout destination.  \"},{\"id\":58,\"title\":\"Creating a shout destination\",\"url\":\"64839.htm\",\"text\":\"This procedure describes how to create a shout destination.   To create a shout destination:  From the Manage tab, in the Alerts group, click Shout Destination.  The Shout Destination Manager window appears.  From the list of shout destination tables, select the shout destination table to edit.  From the Actions menu, select Add Shout Destination.  The New Destination properties window appears.  In the Logical Name field, type a logical name up to 16 characters, case sensitive.  NOTE: The name needs to match the Shout destination name for \'ctmorder script\' in the HDP Options area in the Conversion Tool, as described in HDP Options parameters.  The following table describes the HDP options parameters. For more information about HDP options, see: Post Conversion Steps: Dollar Universe HDP jobs.  HDP Options  Description  Append conditions for viewing links between jobs in Control-M   Enables you to view the flow between jobs in the Planning and Monitoring domains in Control-M client.  Shout destination name for ctmorder script  Defines the name of the destination file in your environment which is necessary for adding a Shout destination in Control-M client.  From the Address drop-down list, select Server or Agent.  From the Destination drop-down list, select Program.  In the Value field, type the destination where you placed the orderjobs.bat file, as described in Configuring the Control-M environment.  Click OK.  The shout destination is created.  Repeat for each Shout Destination table.  \"},{\"id\":59,\"title\":\"HDP job management\",\"url\":\"69363.htm\",\"text\":\"After you have imported the HDP jobs into Control-M and configured the Control-M environment, you may want to add or delete an HDP job. If so you need to change the Job Prerequisites and job actions in Control-M to include a new job in the current workflow, otherwise the new job is not ordered. For more information about adding an HDP job, see: Adding an HDP job in Control-M client.   NOTE: When converting HDP jobs to Control-M, the Conversion Tool builds the ctmorder utility, which orders or forces one or more jobs from a SMART folder into Control-M/Server. The parameters for the ctmorder utility appear in the Message field in the On Do Action. When adding or deleting an HDP job you need to change the Message parameters, as described in Message parameters. For more information about the ctmorder utility see ctmorder in Control-M Utilities.   To delete an HDP job from the workflow, see Removing an HDP job.  NOTE: In the General tab of the Job Properties Pane, in the Host/Host Group field, a Hostgroupplaceholder appears. This field is overridden according to the Host group used in the On Do Action of the ordered job.  \"},{\"id\":60,\"title\":\"Adding an HDP job in Control-M client\",\"url\":\"64841.htm\",\"text\":\"This procedure describes how to add an HDP job in Control-M client, which has not been converted to Control-M. For more information about creating a job, see Creating a job in Using Control-M.  NOTE: If the HDP job is the first job in your Workflow you do not need to create an In Condition.  To add an HDP job:  From the Workspace tab, New area, drag and drop one of the job templates from the Job Palette into an existing folder.  A job is created in the existing folder.  Link the preceding job to the current Workflow, as described in Linking a preceding job to the new job.  Create In Conditions, as described in Creating In Conditions.  Create an On Do Action, as described in Creating an On-Do Action.  Create an out condition, as described in Creating an Out Condition.  (Optional) Link the successor job to the current workflow, by creating an In Condition in step 3.  \"},{\"id\":61,\"title\":\"Linking a preceding job to the new job\",\"url\":\"64858.htm\",\"text\":\"This procedure describes how to link a preceding job to the new job you have created in the Workflow in the Planning domain in Control-M client.  EXAMPLE: In a Workflow you have 2 jobs: Job A and Job B. If you want to add Job A1, the new job flow is JOB A, JOBA1 and JOBB. Click Job A to link JOBA to JOBA1.  To link a preceding job to the new job:  Click the preceding job in the Workflow that you want the new job to link to.  The Job Properties pane appears.  Click Actions.  In the On-Do Actions field, click the On Do Action.   The On-Do Actions window appears.  NOTE: If there is more than one On Do Action, select the On Do Action which contains the order job command.  In the Message field, do the following:  Change the jobName parameter to the new job name that you have created.  (Optional) Edit the HOST ID/HOST GROUP variables, if you want to change the host or host group where you want to run the job.  (Optional) Change the parameters as necessary, as described in Message parameters.  Click OK.  In the Out Conditions field, click @.  The Condition Details window appears.  Complete the following fields:   In the Name field: Defines the name of the out condition in the following format: <condition name>%%ORDERID  NOTE: The Name must be identical to the In Condition name that you want the job to link to. Control-M searches for the job name to link the condition.  Change the Order Date and Add/Remove The Condition fields, if necessary, as described in Creating an Out Condition in Using Control-M.  \"},{\"id\":62,\"title\":\"Message parameters\",\"url\":\"64855.htm\",\"text\":\"After conversion if you want to add or delete an HDP job you need to change the Message field in the On-Do Action. The Message field contains the ctmorder utility parameters which enables you to order or force jobs in Control-M. For more information about ctmorder parameters, see ctmorder parameters in Control-M Parameters. The following table describes the Message parameters.  Parameter  Description  -folder  Defines the folder name. For the current folder use %%SCHEDTAB.  -job_to_order  Defines the name of job that the current job connects.  -host_group  Defines the name of the host group where you want to run the job. This variable is overridden for the specified job when it is run.   -relationship  Defines the relationship between the value specified in the -host_group parameter and the host groups that the job specified in the -job_to_order will run on. One of 5 possible values:  Children  Brothers  Parents  Specific  None  -MU_type  Defines the type of host groups that the specified job will run on.  -condition_variable  Includes the %%Monitoring_view_variable, which enables you to link jobs in the Monitoring domain in Control-M client. For more information, see Creating In Conditions.  \"},{\"id\":63,\"title\":\"Creating In Conditions\",\"url\":\"64883.htm\",\"text\":\"This procedure describes how to create In Conditions, which links the conditions between the predecessor job and the new job you want to add.   To create In Conditions:  In the In Conditions area, click @.  From the Conditions Details window, in the Name field,  type the name in the following format:  <condition name>%%ORDERID   NOTE: The Name must be identical to the Out Condition name in the predecessor job that you want the job to link to. Control-M searches for the name job to link the condition.   Complete the remaining parameters, as described in Creating an In Condition in Using Control-M.  Click OK.  Add another In Condition by repeating step 1.  From the Conditions Details window, in the Name field, type the name in the following format:  <job_name> %% <Monitoring_view_variable>  NOTE: The Monitoring_view_variable enables you to link jobs in the Monitoring domain in Control-M client.  To locate the Monitoring_view_variable, from the predecessor job, click the On Do Action and copy the variable from the Message field. If there is more than one On Do Action, select the On Do Action, which contains the order job command.    Repeat Step 3 and 4.  Continue with Linking In Conditions.  \"},{\"id\":64,\"title\":\"Linking In Conditions\",\"url\":\"64888.htm\",\"text\":\"This procedure describes how to link conditions, which links the conditions between the predecessor job and the new job you want to add.   To link In Conditions:  In the In Conditions area, in the Conditions Relationship field, select Set Manually.  Double click the first condition.  Conditions Details window appears.  NOTE: For descriptions of all the fields see Creating an In Condition in Using Control-M. Only the relevant fields for HDP jobs are described here.  In the Opening Bracket field and select (.  In the Relationship field select OR.  Click OK  Double click the last condition.  Conditions Details window appears.  Relationship select AND.  Closing bracket select ).  Click OK.  \"},{\"id\":65,\"title\":\"Creating an On Do Action\",\"url\":\"64885.htm\",\"text\":\"This procedure describes how to create an On-Do Action for a new HDP job.  NOTE: You need to copy the destination and message parameters from the predecessor job by clicking the On Do Action which contains NOTIFY in the Do field and Destination as the destination that has been defined in the CCM in the Shout Destination.   To add an On-Do Action:  In the Actions area, from the On-Do Actions field, click @.  In the On field select one of the following:  Job Ended OK  Job Ended Not OK  In the Do field select Notify.  In the Destination field copy the destination from the predecessor job.  In the Message field copy the message from the predecessor job and do the following:  Change the -job_to_order parameter to the new job name that you have created.  (Optional) Change the parameters as necessary, as described in Message parameters.  In the Urgency field select the Urgency you require.  Click OK.  For more information about the On-Do Action fields, see On/Do Actions in Control-M Parameters.  \"},{\"id\":66,\"title\":\"Creating an Out Condition\",\"url\":\"64890.htm\",\"text\":\"This procedure describes how to create an Out Condition link the new job to the successor job.  To create an Out Condition:  From Action, in the Out Conditions area, click @.  From the Conditions Details window, in the Name field, type the name in the following format:  <job_name>%%ORDERID   NOTE: The Name must be identical to the In Condition name in the successor job that you want the job you want to link to. Control-M searches for the name job to link the condition.   Complete the remaining parameters, as described in Creating an Out Condition in Using Control-M.    Click OK.  \"},{\"id\":67,\"title\":\"Removing an HDP job\",\"url\":\"64842.htm\",\"text\":\"This procedure describes how to remove an HDP job from your Workflow in Control-M client.  To remove an HDP job:  Right click the job you want to remove and click Delete.  A Confirmation window appears and click Yes.  After the second confirmation appears, click Yes to delete all conditions that are connected to the job.  If the deleted job was linked to a predecessor or successor job, follow the procedure described in Adding an HDP job in Control-M client.  \"},{\"id\":68,\"title\":\"CA Jobtrac\",\"url\":\"99707.htm\",\"text\":\"The following topics describe how to extract Jobtrac data, define a new project, and additional settings:  Defining a new CA Jobtrac conversion project  Setting additional CA Jobtrac rules  \"},{\"id\":69,\"title\":\"Defining a new CA Jobtrac conversion project\",\"url\":\"Define_jobtrac_conv_project.htm\",\"text\":\"This topic describes how to define a new CA Jobtrac (Jobtrac) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.  Before you begin  Create a new project, as described in Running a new conversion project.  To define a new Jobtrac conversion project:  From the CA Jobtrac - Load Data window, select one of the following:   Define new Jobtrac conversion data   Load existing Jobtrac conversion data  Click Next.  If you select Define new Jobtrac conversion data, do the following:  From the CA Jobtrac - Load Data window in the JCL Parameters area, complete the JCL parameters.  The following table describes the JCL parameters for Defining new Jobtrac conversion data and Setting additional CA Jobtrac rules.  Parameter  Description  JCL created file (project set up only)  (Mandatory) Defines a filename for the JCL file created on the Mainframe.  Output data file name (project set up only)  (Mandatory) Defines a filename for the output file or use the default CTM.JBT.OUT.  Job card (project set up only)  (Mandatory) Defines the job card that you want, for example, //COLLECTED JOB.  You can also click @ to enter multiple job cards.  Allocate converted JCL libraries (Mainframe Editor rules only)  Enables you to allocate new JCL libraries. If this parameter is not selected, the Conversion Tool overrides the original JCL libraries.  JCL library Prefix (Mainframe Editor rules only)  (Mandatory) Defines a prefix value. For example, CTM.  UNIT  Defines the volser unit.  VOLSER  Defines the volume on which to allocate the output file.  SMS DATA CLASS  Defines the SMS data class  SMS STORAGE CLASS  Defines the SMS storage class  SMS MANAGEMENT CLASS  Defines the SMS management class  Primary Allocation (CYL):   (Mandatory) Defines a value, for example, 100.  Secondary Allocation (CYL)  (Mandatory) Defines a value, for example, 100.  Number of Directory Blocks (Mainframe Editor Rules only)  Defines the number of directory blocks allocated to the converted JCL library. This should must be the same as the number of directory blocks in the original Jobtrac JCL library.  Click Next and complete the Parameters environment.  The following table describes the Jobtrac Environment parameters.  Parameters  Description  SCL  (Mandatory) Defines the SCL library (Jobtrac job definitions).   You can add a library by clicking @ and then clicking the blank line to enter the library name. You can also edit a library name, by clicking the library and changing the name. To delete a library, you can click the library that you want to delete and then click @.  JCL   (Mandatory) (Job Control Language) Enables you to enter the JCL library(s) for applying variable substitution.  You can add a library by clicking @ and then click in the blank line to enter the library name. You can also edit a library name by clicking the library and change the name. To delete a library, you can click the library that you want to delete and then click @.  JMF   (JCL Management Facility) Defines global variables.   The JMF enables allows variables to be added to control JCL statements and the assignment of Current Day Dynamic Variables. These Jobtrac variable definitions are stored in the JMFSYM01 member of DATELIB. Variable replace the JMF definitions in JCL.  The JMF location is, for example, <DATELIB library name>(JMFSYM01).  ADI   (Automatic Date Insertion) Defines Jobtrac variables that are stored in the PRODDATE member of DATELIB.   The ADI location is, for example, <DATELIB library name>(PRODDATE)  CCPF   (Condition Code Program Filter) Enables values to be converted to ON PGMST and DO ACTION OK.  ADR   (Automatic Dataset Recognition) Defines the table used for creating the Control-M/EM input file.  AMR  (Automatic Message Recognition) Defines the table used to create the Control-O input file.  SCS  (System Command Scheduling) Enables scheduling system commands to be issued by time, processing periods (days, week days, etc) or intervals.  RESOURCE  Defines resource conditions that must be met before the job can be submitted. The RESOURCE location is, for example, <RESOURCE library>(RESOURCE)  EXCLPARM  Contains lists of event names or prefixes that are grouped for mutual exclusion recognition by controlling all job resource sharing or preventing concurrent runs of jobs. The EXCLPARM location is, for example, <EXCLPARM LIBRARY>(EXCLPARM).  Click Next and complete the on-screen instructions to Collect Jobtrac data.  Click Next.  From the CA Jobtrac - Load Data window in the Jobs definitions field, click @ to locate and select the jobs definitions file.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":70,\"title\":\"JCL parameters\",\"url\":\"33401.htm\",\"text\":\"The following table describes the JCL parameters for Defining new Jobtrac conversion data and Setting additional CA Jobtrac rules.  Parameter  Description  JCL created file (project set up only)  (Mandatory) Defines a filename for the JCL file created on the Mainframe.  Output data file name (project set up only)  (Mandatory) Defines a filename for the output file or use the default CTM.JBT.OUT.  Job card (project set up only)  (Mandatory) Defines the job card that you want, for example, //COLLECTED JOB.  You can also click @ to enter multiple job cards.  Allocate converted JCL libraries (Mainframe Editor rules only)  Enables you to allocate new JCL libraries. If this parameter is not selected, the Conversion Tool overrides the original JCL libraries.  JCL library Prefix (Mainframe Editor rules only)  (Mandatory) Defines a prefix value. For example, CTM.  UNIT  Defines the volser unit.  VOLSER  Defines the volume on which to allocate the output file.  SMS DATA CLASS  Defines the SMS data class  SMS STORAGE CLASS  Defines the SMS storage class  SMS MANAGEMENT CLASS  Defines the SMS management class  Primary Allocation (CYL):   (Mandatory) Defines a value, for example, 100.  Secondary Allocation (CYL)  (Mandatory) Defines a value, for example, 100.  Number of Directory Blocks (Mainframe Editor Rules only)  Defines the number of directory blocks allocated to the converted JCL library. This should must be the same as the number of directory blocks in the original Jobtrac JCL library.  \"},{\"id\":71,\"title\":\"Parameters environment\",\"url\":\"33446.htm\",\"text\":\"The following table describes the Jobtrac Environment parameters.  Parameters  Description  SCL  (Mandatory) Defines the SCL library (Jobtrac job definitions).   You can add a library by clicking @ and then clicking the blank line to enter the library name. You can also edit a library name, by clicking the library and changing the name. To delete a library, you can click the library that you want to delete and then click @.  JCL   (Mandatory) (Job Control Language) Enables you to enter the JCL library(s) for applying variable substitution.  You can add a library by clicking @ and then click in the blank line to enter the library name. You can also edit a library name by clicking the library and change the name. To delete a library, you can click the library that you want to delete and then click @.  JMF   (JCL Management Facility) Defines global variables.   The JMF enables allows variables to be added to control JCL statements and the assignment of Current Day Dynamic Variables. These Jobtrac variable definitions are stored in the JMFSYM01 member of DATELIB. Variable replace the JMF definitions in JCL.  The JMF location is, for example, <DATELIB library name>(JMFSYM01).  ADI   (Automatic Date Insertion) Defines Jobtrac variables that are stored in the PRODDATE member of DATELIB.   The ADI location is, for example, <DATELIB library name>(PRODDATE)  CCPF   (Condition Code Program Filter) Enables values to be converted to ON PGMST and DO ACTION OK.  ADR   (Automatic Dataset Recognition) Defines the table used for creating the Control-M/EM input file.  AMR  (Automatic Message Recognition) Defines the table used to create the Control-O input file.  SCS  (System Command Scheduling) Enables scheduling system commands to be issued by time, processing periods (days, week days, etc) or intervals.  RESOURCE  Defines resource conditions that must be met before the job can be submitted. The RESOURCE location is, for example, <RESOURCE library>(RESOURCE)  EXCLPARM  Contains lists of event names or prefixes that are grouped for mutual exclusion recognition by controlling all job resource sharing or preventing concurrent runs of jobs. The EXCLPARM location is, for example, <EXCLPARM LIBRARY>(EXCLPARM).  \"},{\"id\":72,\"title\":\"Collecting Jobtrac data\",\"url\":\"Collect_Jobtrac_data.htm\",\"text\":\"This procedure describes how to collect Jobtrac data, after you have defined new Jobtrac conversion data.   To collect Jobtrac data:  Locate the JCL file, and then transfer it to your Jobtrac machine via FTP with ASCII mode. On the FTP you can use the following commands:  ftp> ascii  ftp> put <file location><library>(<Member>)  Submit the job that collects all the required Jobtrac data into one sequential file with the <file name>.  When the job is successfully completed, transfer the output file, <file name>, from the Jobtrac machine to the conversion system in ASCII mode. On the FTP, you can use the following commands:  ftp> ascii  ftp> get <file name> <local data file>  The downloaded file is used to create a conversion data source.  Continue the conversion process by going to Defining a new CA Jobtrac conversion project.  \"},{\"id\":73,\"title\":\"Setting additional CA Jobtrac rules\",\"url\":\"Set_addl_jobtrac_rules.htm\",\"text\":\"This procedure describes how to set additional CA Jobtrac rules.  After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules.  Before you begin  Ensure that the Conversion Settings window is open. For more information, see Selecting or creating a conversion rules file.  To set additional CA Jobtrac rules:  From the Additional Jobtrac Rules tab, type or select the Jobtrac rules as described in Additional Jobtrac rules.  The following table describes the additional Jobtrac rules parameters.  Parameter  Description  Convert DS jobs  Enables you to perform a conversion of the Distributed Systems (DS) job definition by selecting the Convert DS jobs checkbox.   In the Date format field, you can select how to view the date through either ddmm or mmdd (default).  Convert DS jobs check box to perform a conversion of the DS jobs.  Conditions  JOBA_JOBB: Enables you to define how two jobs are connected by creating unique condition in the format: JOBA_JOBB.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  JOBA_OK: Enables you to set a successful dependence condition between many jobs according its end status.   For more details see Job Dependencies in Using Control-M.  Start Day of the Week  Enables you to select the start day of the week for scheduling.   The value is used for Date Scheduling parameters Ln, -Ln, Dn, -Dn, DnPi, -DnPi, LnPi, -LnPi, DnWm.   NOTE: BMC Software recommends that you do not change this parameter once Control-M has been in operation in a production environment, as it may affect scheduling.  New Day time  Enables you to type the value in the New Day time value specified in CTMPARM field.  NOTE: When a positive number is specified as a New day time value, the conversion avoids scheduling date discrepancies for jobs that are scheduled by Jobtrac between Midnight and the specified Newday time by moving them one day earlier.  When a negative number is specified, jobs that are scheduled by Jobtrac between the specified New day and Midnight are scheduled one day later  Customize Control-M jobname  Use Alternative JCL member name as JOBNAME: Enables you to use the Alternate JCL member name (if it exists) as the jobname, instead of the event name for the converted jobs and their connecting conditions.  SCL libraries processing  Process each SCL library independently: Enables you to process each SCL library separately.   By default, the Conversion Tool loads and processes all of the libraries as a single repository.   By selecting the checkbox you can process each SCL library separately, which is useful where SCL libraries are large, and it is not possible to convert all libraries together. If there are cross SCL dependencies they are not resolved as part of the conversion. A manual adjustment has to be made.  To set mainframe rules, select the Mainframe Editor tab. Type the following parameters:  Jobtrac Additional Rules  The following table describes the Jobtrac Additional Rules parameters in the Mainframe Editor tab. For more information, see Setting additional Jobtrac rules.  Parameter  Description  SCHED TAB &#8211; Scheduling Table Library  Defines the Control-M scheduling table that stores job definitions. Default value: CTM.SCHEDULE.  NOTE: You can use the Scheduling Table Library that was allocated during Control-M installation. You must verify that the Scheduling Table Library is allocated in the Mainframe.  OVERLIB &#8211; JCL Over Lib  Defines the value as OVERLIB for converted jobs. Default value: CTM.OVERLIB.   NOTE: You must verify that the JCL Overlib Library is allocated in the Mainframe.  INCLIB &#8211; Control-M Include Library  Defines the value as INCLIB for converted jobs. Default value: CTM.INCLIB.  NOTE: You must verify that Control-M Include Library is allocated in the Mainframe.  JCLLIB &#8211; Alternate Memname  Defines the value of an additional Memname, which is used for saving converted jobs. Default value: CTM.JCLLIB.  NOTE: You can use the JCL Library for alternate members allocated during Control-M installation. You must verify that the Control-M JCL Library for alternate members is allocated in the Mainframe.  CTODSN &#8211; Control-O rule library  Defines the Control-O rules library containing Dataset and messages triggering events for ADR, AMR and SCS. Default value: CTM.CTODSN.  NOTE: You can use the Control-O rules library allocated during Control-O installation. You must verify that Control-O rules library is allocated in the Mainframe.  IOAENV - Library full path  Defines the name of the IOA/Control-M production environment&#8217;s  IOAENV library.  CMEM &#8211; CMEM rule library  Defines the CMEM rules library containing Job Arrival events for RESOURCE file conversion. Default value: CTM.CMEM.  NOTE: You must verify that the CMEM rules library is allocated in the Mainframe.  Control-O run JCL library  Defines the JCL library name containing JCL files running from Control-O rules. Default value: CTM.CTO.JCL.  NOTE: You can use the Control-O JCL library allocated during Control-O installation. You must verify that Control-O run JCL library is allocated in the Mainframe.  Control-O rule user  Defines the user name for invoking the CONTROL-O rules. Default value: USERNAME.   Enter a maximum of 8 characters.  (Mandatory) JOB CARD - Job card for output JCL  Enables you to use job cards for the output JCL that is created to run at the end of the conversion for returning the converted data to the appropriate files.  In the Job Card field, enter the job card that you want, for example, //CTMJOB JOB.  You can also click Edit @ to enter multiple job cards.  For JCL parameters and Advanced parameters, see Jobtrac JCL parameters and Advanced Parameters for Jobtrac.  JCL parameters  The following table describes the JCL parameters for Defining new Jobtrac conversion data and Setting additional CA Jobtrac rules.  Parameter  Description  JCL created file (project set up only)  (Mandatory) Defines a filename for the JCL file created on the Mainframe.  Output data file name (project set up only)  (Mandatory) Defines a filename for the output file or use the default CTM.JBT.OUT.  Job card (project set up only)  (Mandatory) Defines the job card that you want, for example, //COLLECTED JOB.  You can also click @ to enter multiple job cards.  Allocate converted JCL libraries (Mainframe Editor rules only)  Enables you to allocate new JCL libraries. If this parameter is not selected, the Conversion Tool overrides the original JCL libraries.  JCL library Prefix (Mainframe Editor rules only)  (Mandatory) Defines a prefix value. For example, CTM.  UNIT  Defines the volser unit.  VOLSER  Defines the volume on which to allocate the output file.  SMS DATA CLASS  Defines the SMS data class  SMS STORAGE CLASS  Defines the SMS storage class  SMS MANAGEMENT CLASS  Defines the SMS management class  Primary Allocation (CYL):   (Mandatory) Defines a value, for example, 100.  Secondary Allocation (CYL)  (Mandatory) Defines a value, for example, 100.  Number of Directory Blocks (Mainframe Editor Rules only)  Defines the number of directory blocks allocated to the converted JCL library. This should must be the same as the number of directory blocks in the original Jobtrac JCL library.  Advanced Parameters  The following table describes the Advanced parameters in the Mainframe Editor tab. For more information, see Setting additional CA Jobtrac rules.  Parameter  Description  Prefix for Maybe condition  Defines an in condition dependency, which is required only on days when a job is released as an out condition.  Prefix for Global Conditions added by MF  Defines Global conditions that are propagated from Mainframe Control-M to Distributed Control-M.  Prefix to Global Conditions added by DS  Defines Global conditions that are propagated from Distributed Control-M to Mainframe Control-M.  Prefix for Global Conditions added by MF and DS  Defines Global conditions that are propagated in both directions between Mainframe and Distributed Control-M.  Control-R installed  Enables you to select if Control-R is installed on the mainframe  Automatic restart  Enables you to automatically restart the mainframe  MAXCC:  Defines the Maximum condition code for OK status. Valid range: 0-4095 (integers).  Sysout From Class  Defines a blank space or single character to specify the Sysout class.  Sysout To Class  Defines a blank space or single character to specify the Sysout class. The Sysout is moved to the end of the job. The default value is &#8216;*&#8217;.  Sysout option  Defines the Sysout action when a job finishes. Valid values:   Release  Delete  None  For Jobtrac additional rule parameters and JCL parameters, see Jobtrac Additional Rules and JCL parameters.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  NOTE: When there are DS and MF jobs:  If Convert DS jobs is not selected, only MF jobs are converted.  If Convert DS jobs is selected, both MF and DS jobs are converted.  \"},{\"id\":74,\"title\":\"Additional Jobtrac rules\",\"url\":\"89683.htm\",\"text\":\"The following table describes the additional Jobtrac rules parameters.  Parameter  Description  Convert DS jobs  Enables you to perform a conversion of the Distributed Systems (DS) job definition by selecting the Convert DS jobs checkbox.   In the Date format field, you can select how to view the date through either ddmm or mmdd (default).  Convert DS jobs check box to perform a conversion of the DS jobs.  Conditions  JOBA_JOBB: Enables you to define how two jobs are connected by creating unique condition in the format: JOBA_JOBB.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  JOBA_OK: Enables you to set a successful dependence condition between many jobs according its end status.   For more details see Job Dependencies in Using Control-M.  Start Day of the Week  Enables you to select the start day of the week for scheduling.   The value is used for Date Scheduling parameters Ln, -Ln, Dn, -Dn, DnPi, -DnPi, LnPi, -LnPi, DnWm.   NOTE: BMC Software recommends that you do not change this parameter once Control-M has been in operation in a production environment, as it may affect scheduling.  New Day time  Enables you to type the value in the New Day time value specified in CTMPARM field.  NOTE: When a positive number is specified as a New day time value, the conversion avoids scheduling date discrepancies for jobs that are scheduled by Jobtrac between Midnight and the specified Newday time by moving them one day earlier.  When a negative number is specified, jobs that are scheduled by Jobtrac between the specified New day and Midnight are scheduled one day later  Customize Control-M jobname  Use Alternative JCL member name as JOBNAME: Enables you to use the Alternate JCL member name (if it exists) as the jobname, instead of the event name for the converted jobs and their connecting conditions.  SCL libraries processing  Process each SCL library independently: Enables you to process each SCL library separately.   By default, the Conversion Tool loads and processes all of the libraries as a single repository.   By selecting the checkbox you can process each SCL library separately, which is useful where SCL libraries are large, and it is not possible to convert all libraries together. If there are cross SCL dependencies they are not resolved as part of the conversion. A manual adjustment has to be made.  \"},{\"id\":75,\"title\":\"Jobtrac mainframe parameters\",\"url\":\"Set_rules_jobtrac_mainframe.htm\",\"text\":\"The following table describes the Jobtrac Additional Rules parameters in the Mainframe Editor tab. For more information, see Setting additional Jobtrac rules.  Parameter  Description  SCHED TAB &#8211; Scheduling Table Library  Defines the Control-M scheduling table that stores job definitions. Default value: CTM.SCHEDULE.  NOTE: You can use the Scheduling Table Library that was allocated during Control-M installation. You must verify that the Scheduling Table Library is allocated in the Mainframe.  OVERLIB &#8211; JCL Over Lib  Defines the value as OVERLIB for converted jobs. Default value: CTM.OVERLIB.   NOTE: You must verify that the JCL Overlib Library is allocated in the Mainframe.  INCLIB &#8211; Control-M Include Library  Defines the value as INCLIB for converted jobs. Default value: CTM.INCLIB.  NOTE: You must verify that Control-M Include Library is allocated in the Mainframe.  JCLLIB &#8211; Alternate Memname  Defines the value of an additional Memname, which is used for saving converted jobs. Default value: CTM.JCLLIB.  NOTE: You can use the JCL Library for alternate members allocated during Control-M installation. You must verify that the Control-M JCL Library for alternate members is allocated in the Mainframe.  CTODSN &#8211; Control-O rule library  Defines the Control-O rules library containing Dataset and messages triggering events for ADR, AMR and SCS. Default value: CTM.CTODSN.  NOTE: You can use the Control-O rules library allocated during Control-O installation. You must verify that Control-O rules library is allocated in the Mainframe.  IOAENV - Library full path  Defines the name of the IOA/Control-M production environment&#8217;s  IOAENV library.  CMEM &#8211; CMEM rule library  Defines the CMEM rules library containing Job Arrival events for RESOURCE file conversion. Default value: CTM.CMEM.  NOTE: You must verify that the CMEM rules library is allocated in the Mainframe.  Control-O run JCL library  Defines the JCL library name containing JCL files running from Control-O rules. Default value: CTM.CTO.JCL.  NOTE: You can use the Control-O JCL library allocated during Control-O installation. You must verify that Control-O run JCL library is allocated in the Mainframe.  Control-O rule user  Defines the user name for invoking the CONTROL-O rules. Default value: USERNAME.   Enter a maximum of 8 characters.  (Mandatory) JOB CARD - Job card for output JCL  Enables you to use job cards for the output JCL that is created to run at the end of the conversion for returning the converted data to the appropriate files.  In the Job Card field, enter the job card that you want, for example, //CTMJOB JOB.  You can also click Edit @ to enter multiple job cards.  For JCL parameters and Advanced parameters, see Jobtrac JCL parameters and Advanced Parameters for Jobtrac.  \"},{\"id\":76,\"title\":\"Advanced Parameters\",\"url\":\"33402.htm\",\"text\":\"The following table describes the Advanced parameters in the Mainframe Editor tab. For more information, see Setting additional CA Jobtrac rules.  Parameter  Description  Prefix for Maybe condition  Defines an in condition dependency, which is required only on days when a job is released as an out condition.  Prefix for Global Conditions added by MF  Defines Global conditions that are propagated from Mainframe Control-M to Distributed Control-M.  Prefix to Global Conditions added by DS  Defines Global conditions that are propagated from Distributed Control-M to Mainframe Control-M.  Prefix for Global Conditions added by MF and DS  Defines Global conditions that are propagated in both directions between Mainframe and Distributed Control-M.  Control-R installed  Enables you to select if Control-R is installed on the mainframe  Automatic restart  Enables you to automatically restart the mainframe  MAXCC:  Defines the Maximum condition code for OK status. Valid range: 0-4095 (integers).  Sysout From Class  Defines a blank space or single character to specify the Sysout class.  Sysout To Class  Defines a blank space or single character to specify the Sysout class. The Sysout is moved to the end of the job. The default value is &#8216;*&#8217;.  Sysout option  Defines the Sysout action when a job finishes. Valid values:   Release  Delete  None  For Jobtrac additional rule parameters and JCL parameters, see Jobtrac Additional Rules and JCL parameters.  \"},{\"id\":77,\"title\":\"CA Unicenter WLM (TNG)\",\"url\":\"99697.htm\",\"text\":\"The following topics describe how to extract TNG data, define a new project, and additional settings:  Extracting CA Unicenter WLM  Defining a new CA Unicenter WLM  Setting additional CA Unicenter WLM  \"},{\"id\":78,\"title\":\"Extracting CA Unicenter WLM (TNG) data\",\"url\":\"46060.htm\",\"text\":\"This procedure describes how to extract CA Unicenter WLM (TNG) data before starting a new conversion project. After extracting data, you can then define a new conversion project.  To Extract TNG data:  Create the cauexpr.txt file by running the command:  cauexpr -a.  Import calendar definitions, by running the following command:  caldb save cal_filename.dsb  caldb script cal_filename.dsb > cal_filename.txt  Open the Conversion Tool and import the data, as described in Defining a new CA Unicenter WLM.  \"},{\"id\":79,\"title\":\"Defining a new CA Unicenter WLM (TNG) conversion project\",\"url\":\"Define_unicenter_conv.htm\",\"text\":\"This topic describes how to define a new CA Unicenter WLM (TNG) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   Before you begin  Ensure the following:   Export your data, as described in Configuring the CA Unicenter WLM (TNG) environment.  Create a new project, as described in Running a new conversion project.  To define a new CA Unicenter WLM (TNG) conversion project:  From the CA Unicenter WLM (TNG) - Load Data window, in the Import Scheduling Data area complete the following:  Jobs definitions (cauexpr.txt) field (mandatory): Click @ to locate the cauexpr.txt file.  Calendar definitions field: Click @ to locate the standard calendars definitions file, .CAL.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":80,\"title\":\"Setting additional CA Unicenter WLM (TNG) rules\",\"url\":\"Set_addl_unicenter_rules.htm\",\"text\":\"This procedure describes how to set additional Unicenter WLM (TNG) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying settings and rules, see Selecting or creating a conversion rules file.  To set additional CA Unicenter WLM (TNG) rules:  From the Additional WLM Rules tab, in the General area, enter the General parameters for CA Unicenter WLM (TNG).  The following table describes the General parameters in the Additional WLM Rules tab.  For more information, see Setting additional Unicenter WLM (TNG) rules  Parameter  Description  Date format  Defines the WLM date format for your conversion project.  Application/Sub-Application separator  Defines a separator character that converts WLM grouping to Control-M hierarchy format.  EXAMPLE: PROD#SET1 where the separator is #, the Control-M Application entity is set to PROD and the Sub-application is set to SET1  Resources  Defines the following target Control-M resource types:  Auto  Control Resource   Quantitative Resource  If you select Auto it automatically selects a target Control-M resource type.  PRIOR handling  Enables you to set the following conditions:  Prev: Sets the condition to a previous scheduling date.  Dummy job: Creates the condition the following day.  Condition date for Everyday job  Sets the following options for the generated Control-M in or out condition dates for everyday jobs.  NOTE: Only available when PRIOR handling is set to Prev.  Any: Enables the subsequent job to be set with an in condition date, so the condition is deleted when the job ends.  Prev - Enables the subsequent job to be set with an in condition date, so that the condition is not deleted when the job ends.  NOTE: For both options, the predecessor job sets the out condition to Order Date.  Keep active for  Defines the maximum number of days a job can wait for execution after order date. Valid value: Integer between 1 and 99.   This parameter influences Control-M jobs only if the WLM job definition BACKLOG value is set to YES.  First day of the week  Defines the first day of the week of your work environment.  In the Condition convention area, enter the Condition Name Convention parameters for CA Unicenter WLM.  The following table describes the TNG Condition Name Convention parameters in the Additional WLM rules tab.  Parameter  Description  Delimiter  Defines the character used to separate the prefix, suffix, and conditions.  Prefix  Defines the prefix used to separate the conditions.  Suffix  Defines the suffix used to separate the conditions.  Format  Defines the default format used for creating job dependencies.  NOTE: The Default format has 2 different conventions:  JOBA-TO-JOBB  JOBA-ENDED-<Status>  Condition name format  Displays the resulting format based on the changes that you made to the other options in the Condition Name Convention area.  Cleanup Conditions  Enables you to delete the condition after the next job has finished running. By selecting the Cleanup conditions check box, jobs which trigger more than one job may cause some successor jobs not to be triggered.  In the Calendar area, enter the required information.  (Mandatory) All days calendar name  Holidays calendar name  Number of years: Defines the number of years to create converted calendars in Control-M. A valid value is a positive integer between 1 and 10.  In the Trigger jobs conversion area, type the Trigger jobs conversion parameters for CA Unicenter WLM (TNG).  This table describes the Trigger jobs conversion parameters in the Additional WLM rules tab.  Parameter  Description  Enable  Activates the conversion of WLM trigger jobs. The Control-M File Watcher utility is used for the conversion of trigger jobs.  Interval  Defines the interval time in seconds between each file check. Valid value: An integer between 1 and 99.  Time stop  Defines the stop time in the format, \\\"hh:mm\\\" to end file watching.  Station ID and Owner table  Defines name of the station and person who has permissions to execute File Watcher jobs for each station. You can add a Station ID and Owner to the table by clicking @. You can delete a Station ID and Owner from the table, by clicking the row that you want to delete, and then click @.  You can use wildcards for both the Station ID and Owner fields: * for any word, and ? for any character.  EXAMPLE: station*- all stations that start with \\\"station\\\"  Create File Watcher job per trigger  Enables you to create a file watcher job per trigger. If you want to create a file watcher job per station leave the check box unchecked.  In the Parameter Configuration area, select Enable to type the Control-M values to replace WLM values.  NOTE: Key: Defines the WLM original value. Value: Defines the replacement value.  If you want to add an entry, click @.  To delete an entry, click the row that you want to delete, and then click @.  In the SAP area, select the Enable SAP conversion check box to convert SAP jobs using the Control-M SAP forms.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":81,\"title\":\"CA Unicenter WLM (TNG) General parameters\",\"url\":\"64996.htm\",\"text\":\"The following table describes the General parameters in the Additional WLM Rules tab.  For more information, see Setting additional Unicenter WLM (TNG) rules  Parameter  Description  Date format  Defines the WLM date format for your conversion project.  Application/Sub-Application separator  Defines a separator character that converts WLM grouping to Control-M hierarchy format.  EXAMPLE: PROD#SET1 where the separator is #, the Control-M Application entity is set to PROD and the Sub-application is set to SET1  Resources  Defines the following target Control-M resource types:  Auto  Control Resource   Quantitative Resource  If you select Auto it automatically selects a target Control-M resource type.  PRIOR handling  Enables you to set the following conditions:  Prev: Sets the condition to a previous scheduling date.  Dummy job: Creates the condition the following day.  Condition date for Everyday job  Sets the following options for the generated Control-M in or out condition dates for everyday jobs.  NOTE: Only available when PRIOR handling is set to Prev.  Any: Enables the subsequent job to be set with an in condition date, so the condition is deleted when the job ends.  Prev - Enables the subsequent job to be set with an in condition date, so that the condition is not deleted when the job ends.  NOTE: For both options, the predecessor job sets the out condition to Order Date.  Keep active for  Defines the maximum number of days a job can wait for execution after order date. Valid value: Integer between 1 and 99.   This parameter influences Control-M jobs only if the WLM job definition BACKLOG value is set to YES.  First day of the week  Defines the first day of the week of your work environment.  \"},{\"id\":82,\"title\":\"CA Unicenter WLM (TNG) Condition Name Convention parameters\",\"url\":\"33411.htm\",\"text\":\"The following table describes the TNG Condition Name Convention parameters in the Additional WLM rules tab.  Parameter  Description  Delimiter  Defines the character used to separate the prefix, suffix, and conditions.  Prefix  Defines the prefix used to separate the conditions.  Suffix  Defines the suffix used to separate the conditions.  Format  Defines the default format used for creating job dependencies.  NOTE: The Default format has 2 different conventions:  JOBA-TO-JOBB  JOBA-ENDED-<Status>  Condition name format  Displays the resulting format based on the changes that you made to the other options in the Condition Name Convention area.  Cleanup Conditions  Enables you to delete the condition after the next job has finished running. By selecting the Cleanup conditions check box, jobs which trigger more than one job may cause some successor jobs not to be triggered.  \"},{\"id\":83,\"title\":\"CA Unicenter WLM (TNG) Trigger jobs conversion (DSCLOSEU) parameters\",\"url\":\"33414.htm\",\"text\":\"This table describes the Trigger jobs conversion parameters in the Additional WLM rules tab.  Parameter  Description  Enable  Activates the conversion of WLM trigger jobs. The Control-M File Watcher utility is used for the conversion of trigger jobs.  Interval  Defines the interval time in seconds between each file check. Valid value: An integer between 1 and 99.  Time stop  Defines the stop time in the format, \\\"hh:mm\\\" to end file watching.  Station ID and Owner table  Defines name of the station and person who has permissions to execute File Watcher jobs for each station. You can add a Station ID and Owner to the table by clicking @. You can delete a Station ID and Owner from the table, by clicking the row that you want to delete, and then click @.  You can use wildcards for both the Station ID and Owner fields: * for any word, and ? for any character.  EXAMPLE: station*- all stations that start with \\\"station\\\"  Create File Watcher job per trigger  Enables you to create a file watcher job per trigger. If you want to create a file watcher job per station leave the check box unchecked.  \"},{\"id\":84,\"title\":\"CA Workload Automation DE\",\"url\":\"99698.htm\",\"text\":\"The following topics describe how to extract CA Workload Automation DE data, define a new project and additional settings:  CA Workload Automation DE data extraction  Defining a new CA Workload Automation DE project  Setting additional CA Workload Automation DE rules  \"},{\"id\":85,\"title\":\"CA Workload Automation DE data extraction\",\"url\":\"94681.htm\",\"text\":\"The Conversion Tool converts CA Workload Automation DE (dSeries) XML files to Control-M data.  Before using the Conversion Tool, you need to extract dSeries\' data into XML data. In dSeries, you extract data by using the imexutil utility, which enables you to export artifact definitions (such as applications, events, calendars, and variable contexts) through the following modes:  Batch mode: Enables you to issue commands to import or export multiple artifacts at one time. You can specify multiple artifacts at the command, or you can specify the name of a file that contains the multiple command. To export data using the imexutil utlity using the batch mode, see Extracting CA Workload Automation DE data in batch mode.  Interactive Mode: Enables you to issue import and export commands at the command prompt and view the server response for each command you issue. For more information, see CA Workload Automation DE documentation.  NOTE: You must export Events and Applications definitions to run the conversion. All artifact definitions are stored as XML files. The imexutil utility must be run where the server is installed.   For imexutil utility examples, see CA Workload Automation DE data extraction examples.  \"},{\"id\":86,\"title\":\"Extracting CA Workload Automation DE data in batch mode\",\"url\":\"94677.htm\",\"text\":\"This procedure describes how to extract CA Workload Automation DE (dSeries) data using the imexutil utility in batch mode.  After extracting data, you can then define a new conversion project.  To extract dSeries data in batch mode:  Do one of the following:  UNIX: Navigate to the install_dir/bin directory (where the server is installed) and type the following:  imexutil.sh -h host -p port -u user -w password -c @cmdfilename|cmds  Windows: Go to the install install_dir\\\\bin directory (where the server is installed) and type the following:  imexutil.bat -h host -p port -u user -w password -c @cmdfilename|cmds  For information about the parameters, see dSeries data extraction parameters  \"},{\"id\":87,\"title\":\"CA Workload Automation DE data extraction parameters\",\"url\":\"94678.htm\",\"text\":\"The following table describes the dSeries data extraction parameters for the imexutil utillity.  Parameter  Description  -h  Specifies the IP address or DNS name for the server.  -p  Specifies the port for the server.  -u  Specifies the CA Workload Automation user ID  -w  Specifies the password for the user ID.  NOTE: The user ID and password are optional if you specify a file name instead of commands in the -c switch. Instead of specifying the -u and -w values, you can specify the user command in the file.  -c   Specifies the export commands or a file containing the export commands.  @cmdfilename  Specifies the file containing the commands. If the file name contains a space, enclose the name with double quotes.  EXAMPLE: -c \\\"@input file.txt\\\"  cmds  Specifies one or more commands. To specify multiple commands, separate each command with a semi-colon. If the command contains a space, enclose the command with double quotes. Export command options are as follows:  exportartifact: exportagent, exportagentgrp, exportalert, exportapplication, exportcalendar, exportevent, exportforecast, exportgroup, exportjavascript, exportresource, exportsundry, exportuser, exportreportdesign, and exportvarctx.  EXAMPLE: -c \\\"exportapplication -outdir c:\\\\applications;exportvarctx -outdir c:\\\\contexts\\\"  The import/export utility runs in batch mode.  \"},{\"id\":88,\"title\":\"CA Workload Automation DE data extraction examples\",\"url\":\"94679.htm\",\"text\":\"The following examples describe how to run the imexutil utility, when extracting CA Workload Automation DE data.  EXAMPLE: Exports artifacts from a server named prodserv in batch mode. The command exports all Applications to c:\\\\applications and all calendars to c:\\\\calendars.  imexutil.bat -h prodserv -p 7500 -u schedmaster -w schedmaster -c \\\"exportapplication -outdir c:\\\\applications;exportcalendar -outdir c:\\\\calendars\\\"  EXAMPLE: Exports artifacts from a server named prodserv in batch mode using a command file. The command uses a file named commandfile.txt, which contains the client user ID, password, and the commands to export all Applications to c:\\\\applications and all calendars to c:\\\\calendars.  imexutil.bat -h prodserv -p 7500 -c @c:\\\\commandfile.txt  The commandfile.txt file contains the following commands:  user schedmaster schedmaster  exportapplication -outdir c:\\\\applications  exportcalendar -outdir c:\\\\calendars  \"},{\"id\":89,\"title\":\"Defining a new CA Workload Automation DE project\",\"url\":\"60051.htm\",\"text\":\"This topic describes how to define a new CA Workload Automation DE (dSeries) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   Before you begin  Ensure the following:  Extract dSeries data, as described in CA Workload Automation DE data extraction.  Create a new project, as described in Running a new conversion project.  To define a new CA Workload Automation DE conversion project:  From the CA Workload Automation DE - Load Data window, in the Import Scheduling Data area complete the following:  Application directory field (mandatory): Click @ to locate the directory that contains the Application XML files.  Calendar directory field: Click @ to locate the directory that contains the Calendar XML files.  Event directory field: Click @ to locate the directory that contains the Event XML files.  Global variables directory field: Click @ to locate the directory that contains the Global variables XML files.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":90,\"title\":\"Setting additional CA Workload Automation DE rules\",\"url\":\"60056.htm\",\"text\":\"This procedure describes how to set additional CA Workload Automation DE rules.  After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules.  Before you begin  Ensure that the Conversion Settings window is open. For more information, see Selecting or creating a conversion rules file.  To set additional CA Workload Automation DE rules:  From the Additional dSeries rules tab, in the General area, select or modify the following options:  First day of the week: Defines the first day of the week of your Control-M work environment.  Shouts Urgency: Defines the urgency for converted job notifications. Select the urgency for notifications set by Control-M.  In the Conditions area, select one of the following condition names:  JOBA-TO-JOBB: Enables you to define how two jobs are connected by creating unique condition in the format: JOBA_JOBB.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  JOBA-ENDED-<status>: Enables you to set a successful dependence condition between many jobs according its end status.   For more details see Job Prerequisites in Using Control-M.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":91,\"title\":\"Cron\",\"url\":\"98243.htm\",\"text\":\"The following topics describe how to extract Cron data, define a new Cron Conversion project, setting additional Cron rules and disabling Cron jobs:  Cron conversion project setup  Defining a new Cron conversion project  Setting additional Cron rules  Post conversion: disabling Cron jobs   \"},{\"id\":92,\"title\":\"Cron conversion data extraction\",\"url\":\"20800.htm\",\"text\":\"You can extract Cron data by using the following discovery options:  BMC Discovery: Enables you find Cron jobs that reside in crontabs files using BMC Discovery. For more information, see Cron data extraction using BMC Discovery.  Control-M/Agents: Enables Control-M Agent (installed on the same machine as the Conversion Tool) to collect Cron data from available Agents and Remote Hosts. Before extracting data, you need to set up a Cron conversion project, see Configuring the Cron conversion environment.  Extract data manually: Enables you to extract Cron data manually. You can then import the data into the Conversion Tool by adding data from multiple locations and users.   When converting Cron data to Control-M, the Conversion Tool creates tasks as part of any conversion using the Discovery functionality. These tasks are added to Active Jobs and applied to your overall task count for the day in which the Discovery/Data Collection is being run.  A warning message is displayed indicating the number of tasks that are created as part of the Discovery/Data Collection and you can cancel the Discovery/Data Collection at that time.  Ensure that you understand the possible implications of this prior to proceeding with the Discovery/Data Collection.    You can analyze the complexity of the conversion project by viewing the assessment report once your data is retrieved and/or imported.  You can configure Control-M fields, (such as Folder, Application, and Sub Application) so you can see which jobs are running on your environment. To configure Control-M fields for a new Cron conversion project, see Configuring Control-M fields for Cron and MS Task Scheduler jobs.   \"},{\"id\":93,\"title\":\"Cron data extraction using BMC Discovery\",\"url\":\"98133.htm\",\"text\":\"BMC Discovery automatically discovers configuration and relationship data on every server in your environment. You can use BMC Discovery to find Cron jobs that reside in crontabs files. The Conversion Tool enables you to connect to BMC Discovery and converts Cron jobs that are found by BMC Discovery to Control-M  For information about how to install and use BMC Discovery, see https://docs.bmc.com/docs/display/DISCO110.  When using the Conversion Tool you need to supply the following:  Discovery Server Host  Discovery User  Discovery Password  For more information about using BMC Discovery to extract data in the Conversion Tool, see Defining a new Cron conversion project.  \"},{\"id\":94,\"title\":\"Cron data extracting using Control-M/Agents\",\"url\":\"98135.htm\",\"text\":\"You can use the Control-M Agent (installed on the same machine as the Conversion Tool) to collect Cron data from available Agents and Remote Hosts.   NOTE: Relevant for Cron conversion which runs on Microsoft Windows where Control-M Agent is installed.   The Control-M Agent uses Control-M jobs and Agent utilities to collect the Cron data. The Control-M jobs execute a script file to collect data and to view a list of available hosts. The following script files are used, which are dependent on the host\'s platform:   UNIX: captureScriptUnix.txt  Windows: captureScriptWindows.txt.  To start the collection of data by Control-M/Agents, a job is submitted to the Agent&#8217;s primary Control-M Server. Once a list of available hosts is created, in the Conversion Tool, you can select from which hosts you want to collect data. A job is then submitted to each selected host to retrieve the Cron data.  To start data collection by Control-M/Agents, see Configuring the Cron conversion environment.  \"},{\"id\":95,\"title\":\"Setting up the Cron conversion environment using Control-M/Agents\",\"url\":\"46115.htm\",\"text\":\"If you want to use Control-M/Agents to extract your Cron data, you need to set up your Cron environment.  Before you begin  Ensure the following:  Control-M Agent is installed and running on the same environment as the Conversion Tool.   Control-M Agent is connected to a Control-M Server and that the Agent is available.  Control-M Server allows execution of the ctmpsm and ctmcreate utilities by the Agent.   To set up the Cron conversion environment:  Copy the following script files from the Conversion Tool\'s script folder, <Conversion Home>/scripts/DataCollection, to your Control-M Server:  captureScriptUNIX.txt   captureScriptWindows.txt  Open the Conversion Tool and start defining a Cron conversion project, as described in Defining a new Cron conversion project.  \"},{\"id\":96,\"title\":\"Configuring Control-M fields for Cron jobs\",\"url\":\"20801.htm\",\"text\":\"This procedure describes how to configure Control-M fields for Cron jobs (Discovery jobs).  You can configure Control-M fields (such as Folder, Application and Sub Application) by changing the default values in the setting.cfg file. You can enter specific values so they can be identified in the Monitoring domain in Control-M client, so you know exactly how many jobs the discovery tool is running on your environment.  To Configure Control-M Fields:  Close the Conversion Tool.  Locate the setting.cfg file in <Conversion Home>\\\\data\\\\ and set one or more of the following parameters:  CRON_DISCOVERY_JOBS_FOLDER_NAME=Conversion_discovery_CRON  CRON_DISCOVERY_JOBS_APPLICATION=Conversion_discovery  CRON_DISCOVERY_JOBS_SUB_APPLICATION=CRON  Continue with Defining a new Cron conversion project.  \"},{\"id\":97,\"title\":\"Defining a new Cron conversion project\",\"url\":\"Define_cron_conv.htm\",\"text\":\"This topic describes how to define a new Cron conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   For more information about Cron conversion project see Cron conversion project setup. To create a new conversion project, see Running a new conversion project.  Before you begin  Ensure the following:  If using BMC Discovery, extract your data as described in Cron data extraction using BMC Discovery.  If using Control-M/Agents to extract your data, set up your Cron environment, as described in Configuring the Cron conversion environment.  Configure Control-M fields, as described in Configuring Control-M fields for Cron and MS Task Scheduler jobs  Create a new project, as described in Running a new conversion project.  To define a new Cron conversion project:  From the Cron - Load Data window, in the Import Scheduling Data area, select one of the following options:  Import data from BMC Discovery  Import data using Control-M/Agents: Do the following:   (Mandatory) In the Control-M Server platform field, select your platform from the drop down list.  (Mandatory) In the Script location field, select whether the script files are in the default location, or in a custom location. If they are in a custom location, enter the location in the Custom location field.  Import data manually: Imports files by entering the location of the files.  Click Next.  (Import data automatically only) The Confirmation Jobs Submission dialog box appears and click Yes to execute 3 jobs to prepare for automatic data collection.  NOTE: These jobs are added to Active Jobs in Control-M client and are applied to your overall task count for the day.  Continue with one of the following procedures:  Import data from BMC Discovery, by typing the BMC Discovery parameters.  Import data using Control-M/Agents, as described in Adding data automatically to a Cron conversion project.  Import data manually, as described in Adding data manually to a Cron conversion project.  \"},{\"id\":98,\"title\":\"Importing Cron data using Control-M/Agents\",\"url\":\"Add_data_auto_Cron.htm\",\"text\":\"This procedure describes how to import Cron data using Control-M/Agents.  For more information about defining a new Cron conversion project, see Defining a new Cron conversion project.  To import Cron data using Control-M/Agents:  In the Cron - Load Data window, select the agents from which you want to retrieve data.   You can do one or more of the following:  Select all available agents at one time, click Select All.  Clear the check box(es) of all available agents, click Clear All.  Select the agents that are not currently selected, and clear the check boxes for agents that are currently selected, click Invert Selection.  For example, if you have 50 agents and want to select 40 of them quickly, you can select the 10 agents that you don\'t want, and then click Invert Selection.  Refresh the Agents list, and view agents that were not available previously, click Refresh.  Filter a column, click @.   If the status of an agent is Available in the Agent Status column, but you are not able to select the check box for the agent, you need to make sure the correct platform is selected for that agent.  NOTE: In the Cron - Load Data window, you can also add data manually. For more information, see Using the Add Data Manually button.  You can only retrieve data from agents that are available and connected to the server.  Select the agent you want, and click Next.  The Confirmation Jobs Submission dialog box appears.  Click Yes to execute the number of jobs to be retrieved in Control-M.  These jobs are added to Active Jobs in Control-M and are applied to your overall count for the day.  The Cron - Load Data window appears.  You can view the status of the data retrieval. For more information, see Viewing the Results list.  In the Cron - Load Data window, you can also add data manually. For more information, see Using the Add Data Manually button.  Click Import to complete the data import phase.  NOTE: The Import button is only available when data is successfully retrieved. Once you click Import, you cannot add more data to this conversion project.  The data is loaded into the Conversion Tool and in Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":99,\"title\":\"Data Retrieval status\",\"url\":\"View_results_list_Cron.htm\",\"text\":\"The following table describes the status of the data retrieval after you have loaded data into the Conversion Tool. For data that could not be retrieved, you can fix the environment, and then try to retrieve the data again. Or, you can import the data manually using the Add Data Manually button. If for any reason you need to stop the retrieval process, click the Stop button.  Tab  Description  Running  Lists the agents from which you are retrieving data  Success   Lists the agents from which data was successfully retrieved  Failed   Lists the agents from which data could not be retrieved  \"},{\"id\":100,\"title\":\"Importing Cron data using the Add Data Manually button\",\"url\":\"Using_add_data_manually_button_Cron.htm\",\"text\":\"This procedure describes how to import data manually by using the Add Data Manually button.   You can import data manually when you click the Add Data Manually button. When you are defining a Cron conversion project, you can add data manually at any time during the Data Import phase. You can also add data from multiple locations and users.  To import data using the Add Data Manually button:  From the Cron - Load Data Window, click the Add Data Manually button at the bottom of the screen.  The Import data manually screen appears.  From the Import data manually window, click Add.  The Add Data Manually window appears.  Complete the following fields:  (Mandatory) In the Machine name field, enter the name of the machine where the files are located.  (Mandatory) In the User Name field, enter the user name for the machine.  (Mandatory) In the Data file, click @ to locate the data file you want to use.  Click Apply & Close.  Repeat steps 2-5 as needed.  To delete an entry from the table, click the entry, and then click Delete.  Close the window after you have completed adding the files that you want.  \"},{\"id\":101,\"title\":\"Importing Cron data manually\",\"url\":\"Add_data_man_Cron.htm\",\"text\":\"This procedure describes how to import data manually to a Cron conversion project. You can add data from multiple locations and users.  For more information about defining a new Cron conversion project, see Defining a new Cron conversion project. You can add data from multiple locations and users.  Before you begin  Run the following command to create a text file containing the machine\'s jobs:  crontab -l >> {OutputFileName}.txt  NOTE: If you are a root user, you can extract another user\'s jobs by running the command crontab -l {username} >> {OutputFileName}.txt  To import data manually to a Cron conversion project:  In the Cron - Load Data window, click Add.  The Add Data Manually dialog box appears.   Do the following:  (Mandatory) In the Machine name field, type the name of the machine where the files are located.  (Mandatory) In the User Name field, enter the user name for the machine.  (Mandatory) In the Data file, click @ to locate the data file you want to use.  Click Apply & Close.  Repeat steps 2-5 as needed.  To delete an entry from the table, click the entry, and then click Delete.  When you have completed entering all of the locations that you want, click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":102,\"title\":\"Setting additional Cron rules\",\"url\":\"Set_addl_cron_rules.htm\",\"text\":\"This procedure describes how to set additional Cron rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying settings and rules, see Selecting or creating a conversion rules file.  To set additional Cron rules:  From the Additional Cron Rules tab, in the General area, select the first day of the week from the drop-down list, as defined in the Control-M environment.  In the Do mail statement generation area, select one of the following email job notification options:  Never  Only if $MAILTO was defined in crontab: Sends email notifications to the email address that is defined in the $MAILTO variable in crontab.  When this option is selected, it overrides any email address that you may have entered in the default email address field.  For all jobs: Sends email notifications to the email address that you enter. You can also enter variables as part of the email address, for example, {User}@domain.com.  Click > to automatically enter the machine and user variable formats: {Machine} or {User Name}.  Click Reset to clear the default email address field.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":103,\"title\":\"Post conversion: disabling Cron jobs\",\"url\":\"21420.htm\",\"text\":\"After you complete the conversion process, the Conversion_discovery_Cron folder and converted jobs appear in Control-M client.   If you want to disable the original jobs that run on Cron (as they are now running in Control-M), you can manually order disable jobs that were defined during conversion. This deactivates the original jobs from the Cron servers, causing them to stop running.   The following example shows the original and converted jobs in the Planning domain in Control-M client together with details of the converted job. For more information about how to order jobs in Control-M, see Ordering Jobs in Using Control-M.   \"},{\"id\":104,\"title\":\"IBM Tivoli Workload Scheduler\",\"url\":\"99699.htm\",\"text\":\"The following topics describe how to extract Tivoli data, define a new project, additional settings, and recommended practices:  Extracting IBM Tivoli Workload Scheduler data  Defining a new IBM Tivoli Workload Scheduler conversion project  Setting additional Tivoli Workload Scheduler  TWS recommended practices  \"},{\"id\":105,\"title\":\"Extracting IBM Tivoli Workload Scheduler data\",\"url\":\"46063.htm\",\"text\":\"This procedure describes how to extract IBM Tivoli Workload Scheduler (TWS) data before starting a new project. After extracting data, you can then define a new conversion project.  For more information about recommended practices, see TWS recommended practices.  To extract TWS data:  In the TWS environment, create the following files:  Job definitions file (Mandatory): Run the following command:  composer create <jobs file> from JOBS or if the command creates an empty file: composer create <jobs file> from jobs=@#@  CPU definitions file (Mandatory): Run following command:  composer create <cpu file> from CPU or if the command creates an empty file: composer create <cpu file> from cpu=@  Parameters definitions file (Mandatory): Run the following command:  composer create <parms file> from PARMS   Schedule definitions file (Mandatory): Run the following command:  composer create <schedule file> from SCHED or if the command creates an empty file: composer create <schedule file> from sched=@#@  Resource definitions file (Optional): Run the following command:  composer create <resource file> from RESOURCES  Calendar definitions file (Optional): Run the following command:  composer create <calendars file> from CALENDARS  Variable tables definitions file (Optional): Run the following command:  composer create <variables file> from VARIABLES  Workstation parameters (Optional): Run the following command:  <Workstation_name>_parms.txt  Create the following optional files:   Open the Conversion Tool and import the data, as described in Defining a new Tivoli conversion project setup.  \"},{\"id\":106,\"title\":\"Defining a new IBM Tivoli Workload Scheduler conversion project\",\"url\":\"Define_tivoli_conv.htm\",\"text\":\"This topic describes how to define a new IBM Tivoli Workload Scheduler (TWS) conversion project. You can also analyze the complexity of the conversion project by viewing the assessment report.  For more information about creating a new conversion project, see Running a new conversion project.  Before you begin  Ensure the following:  Create and export Definition files in the Tivoli environment, as described in Configuring the IBM Tivoli Workload Scheduler environment.  Define a new project, as described in Running a new conversion project.  To define a new TWS conversion project:  From the IBM Tivoli Workload Scheduler - Load Data window, in the Import Scheduling Data area, click @ to locate and select the Import Scheduling Data parameters for TWS.  The following table describes the TWS scheduling data parameters.  Parameter  Description  Job definitions  (Mandatory) Contains all the job attributes that relate to the job\'s functioning and/or how each job should be submitted. For example, which agent to submit the job to, which script to run, the owner of the job (the user who has the credentials for the job\'s functions), and the job description.  CPU definitions  (Mandatory) Contains the physical host name for each logical CPU mentioned in schedule.txt, see below. The Control-M Conversion Tool uses this value for the Host ID field in the Control-M job definition.  Parameter definitions  (Mandatory) Contains the actual value for each parameter mentioned in the jobs.txt file. The Control-M Conversion Tool defines each parameter mentioned in the jobs.txt file as a Variable expression.  Schedule definitions  (Mandatory) Defines the main file to be imported, which includes the scheduling criteria of each job, and the dependencies between the jobs. Each job in the jobs.txt file can be scheduled more than once.  Resource definitions file  Defines the resources which is required by tables and jobs and used by the Conversion Tool.    TWS command: composer create <resource file> from RESOURCES.  Calendar definitions file  Translates the information in this file from the Conversion Tool into Control-M calendars.  TWS command: composer create <calendars file> from CALENDARS.  Variable tables definitions file  Defines the variables which are used by the Conversion Tool.   TWS command: composer create <variables file> from VARIABLES.  Workstation parameters directory  Defines the workstation variables. The file names in this folder should be in the following format: <CPU_name>_parms.txt (for example: Workstation1_parms.txt). This should convert  Workstation specific variables during the conversion.   TWS format: <CPU_name>_parms.txt  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   NOTE: (Optional) In the Validation phase, you can compare your scheduler\'s forecast report to the Control-M forecast report created during validation. To create the report, use any of the report parameter files below.  If you want a report for three months from specific workstations, use: rep11 -m mmyyyy mmyyyy mmyyyy -c workstation1 workstation2 workstation3. For example, rep11 -m 062004 072004 082004 -c workstation1 workstation2 workstation3.  If you want a report for three months of the current year from all workstations, which directly outputs to a file, use: rep11 -m mm mm mm -o output. For example, rep11 -m 06 07 08 -o output.  If you want a report for the current month for a specific workstation, use: rep11 -c workstation1.  For more information, see Validation.  \"},{\"id\":107,\"title\":\"TWS scheduling data parameters\",\"url\":\"33466.htm\",\"text\":\"The following table describes the TWS scheduling data parameters.  Parameter  Description  Job definitions  (Mandatory) Contains all the job attributes that relate to the job\'s functioning and/or how each job should be submitted. For example, which agent to submit the job to, which script to run, the owner of the job (the user who has the credentials for the job\'s functions), and the job description.  CPU definitions  (Mandatory) Contains the physical host name for each logical CPU mentioned in schedule.txt, see below. The Control-M Conversion Tool uses this value for the Host ID field in the Control-M job definition.  Parameter definitions  (Mandatory) Contains the actual value for each parameter mentioned in the jobs.txt file. The Control-M Conversion Tool defines each parameter mentioned in the jobs.txt file as a Variable expression.  Schedule definitions  (Mandatory) Defines the main file to be imported, which includes the scheduling criteria of each job, and the dependencies between the jobs. Each job in the jobs.txt file can be scheduled more than once.  Resource definitions file  Defines the resources which is required by tables and jobs and used by the Conversion Tool.    TWS command: composer create <resource file> from RESOURCES.  Calendar definitions file  Translates the information in this file from the Conversion Tool into Control-M calendars.  TWS command: composer create <calendars file> from CALENDARS.  Variable tables definitions file  Defines the variables which are used by the Conversion Tool.   TWS command: composer create <variables file> from VARIABLES.  Workstation parameters directory  Defines the workstation variables. The file names in this folder should be in the following format: <CPU_name>_parms.txt (for example: Workstation1_parms.txt). This should convert  Workstation specific variables during the conversion.   TWS format: <CPU_name>_parms.txt  \"},{\"id\":108,\"title\":\"Setting additional Tivoli Workload Scheduler (TWS) rules\",\"url\":\"Set_addl_tivoli_rules.htm\",\"text\":\"This procedure describes how to set additional Tivoli Work Scheduler (TWS) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file. For more information about TWS recommended practices, see TWS recommended practices.  To set additional TWS rules:  From the Additional TWS Rules tab, in the General area type the General parameters for TWS.  The following table describes the General parameters in the Additional TWS rules tab.   For more information see Setting additional Tivoli Workload Scheduler (TWS) rules.  Parameter  Description  Keep active for  Determines the maximum number of days that a Control-M job can wait for execution after order date.   Valid values: 0-99 (integer) Default: 1  NOTE: The Keep active for parameter has an effect on Control-M jobs only when the TWS parent container has the CARRYFORWARD attribute.  First day of the week  Determines the first day of the week according to your work environment.  Date format  Enables you to select the format for date input and display.  Convert OPENS statement to File Watcher  Enables you to convert an OPENS Statement in TWS to Control-M File Watcher.  In the Standalone jobs area, select one of the following options.  Group all stand alone jobs in one folder: standalone jobs are grouped into one folder.  Create a different folder for each stand alone job: separate folders are created for each job.  In the Calendar area, specify the default names for calendars in this conversion project.  Work days calendar  Free days calendar  All days calendar  In the Scheduling Conversion area, select one of the options in Scheduling Conversion parameters for TWS.  This table describes the Scheduling Conversion parameters for TWS rules. For more information, see Setting additional Tivoli Workload Scheduler (TWS) rules.  Parameter  Description  Use \'Exclude\' RBCs (Control-M V8 FP1 or later)  Enables the Conversion Tool to convert TWS EXCEPT statements using the Rule Based Calendars feature added in Control-M V8 Fix Pack 1.  Do not convert \\\"EXCEPT\\\" statements  Determines that except statements are not converted to Control-M (default). An Error message WRN6022 is issued for each statement that is not converted. TWS ON statements are converted to Control-M rule-based calendars.  Convert \\\"EXCEPT\\\" statements to dummy jobs  Determines that a dummy job is created for each \\\"EXCEPT\\\" statement. The converted SMART folder depends on the condition(s) released by the dummy job(s). TWS \\\"ON\\\" statements are converted to Control-M rule-based calendars.  Convert \\\"ON\\\" and \\\"EXCEPT\\\" statements to dummy jobs  Determines that a dummy job is created for any \\\"ON\\\" or \\\"EXCEPT\\\" statement. This dummy job derives scheduling definitions from the corresponding statement.   The converted SMART folder depends on the conditions released by the dummy jobs, with an \\\"OR\\\" between conditions created from \\\"ON\\\" statements, and a logical \\\"AND\\\" between conditions created from \\\"EXCEPT\\\" statements.  In addition to the dummy jobs, \\\"ON\\\" statements are converted to rule-based calendars (otherwise the SMART folders are not ordered).  To define the condition format in Control-M, in the Convert to format field, from the dropdown list, select one of the following condition format options:  {Job/Folder Name}_Status  {Job/Folder Name}-TO-{TargetJob:Job/Folder Name}   If you need to convert SAP data, click the SAP Editor - TWS tab. For more information, see SAP Editor rules for TWS.  The following table describes the SAP editor rules for Tivoli Workload Scheduler (TWS) when selecting the SAP Editor -TWS tab.    NOTE: Select the Enable SAP conversion check box to enable conversion of SAP jobs using the Control-M for SAP forms.  Parameter  Description  Job Count   -i = <account_name> SAP account name  User   -user = the SAP job owner  Job Class   -c = <class_name> SAP job class  Job Name  -job = <job_name> the SAP job name  NOTE: These parameters must appear in the DOCOMMAND in SAP. A job converts to a SAP job when the DOCOMMAND contains all the values in the SAP filter list. SAP jobs are converted to Task Type JOB. The set of conversion rules appears in the Conversion rules list. You can use these rules in future conversions.  If you need to convert PeopleSoft data, click the PeopleSoft Editor. For more information, see PeopleSoft Editor rules for TWS.  The following table describes the PeopleSoft editor rules for Tivoli Workload Scheduler (TWS) in the PeopleSoft Editor tab.    NOTE: Select the Enable PeopleSoft conversion check box to enable conversion of PeopleSoft jobs using the Control-M for PeopleSoft forms. If unchecked these jobs are converted to regular OS jobs in Control-M.  Parameter  Description  Process name  Defines the process name to be scheduled.  Type  Defines the output destination type, specifying the file path, printer destination URL or email address.  Run Control  Defines the Run control attributes that are associated with a process or job.  Run Location  Identifies the name of the server to be used for running the process or job.  If you need to convert OS400 data, click the OS400 Editor. For more information, see OS/400 Editor rules for TWS.  The following table describes the OS/400 editor rules for Tivoli Workload Scheduler (TWS) in the OS400 Editor tab.    NOTE: Select the Enable OS400 conversion check box to enable conversion of OS/400 jobs using the Control-M for OS/400 forms. If unchecked these jobs are converted to regular OS jobs in Control-M.  Parameter  Description  Convert CALL commands to object type program  Enables the Conversion Tool to convert command line CALL <program> … to job type OS400 Program rather than OS/400 command line jobs.  NOTE: Any TWS command line job that starts with the CALL command, the job type can be set to OS400 Program. The CALL command program name and the parameters are extracted from the command line into the appropriate job attributes.  Keyword for SUBMIT  Enables TWS to submit the job to batch, including the submit jobs attributes.  Keyword for DOCOMMAND  Enables TWS to run the command directly without submitting it to batch. There are no submit job attributes.  Control-M submits the job to batch. For SUBMIT mode, the submit job attributes are extracted from the SUBMIT string. For DOCOMMAND mode, the default submit job attributes are used.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":109,\"title\":\"TWS General parameters\",\"url\":\"33421.htm\",\"text\":\"The following table describes the General parameters in the Additional TWS rules tab.   For more information see Setting additional Tivoli Workload Scheduler (TWS) rules.  Parameter  Description  Keep active for  Determines the maximum number of days that a Control-M job can wait for execution after order date.   Valid values: 0-99 (integer) Default: 1  NOTE: The Keep active for parameter has an effect on Control-M jobs only when the TWS parent container has the CARRYFORWARD attribute.  First day of the week  Determines the first day of the week according to your work environment.  Date format  Enables you to select the format for date input and display.  Convert OPENS statement to File Watcher  Enables you to convert an OPENS Statement in TWS to Control-M File Watcher.  \"},{\"id\":110,\"title\":\"Scheduling Conversion parameters for TWS\",\"url\":\"33418.htm\",\"text\":\"This table describes the Scheduling Conversion parameters for TWS rules. For more information, see Setting additional Tivoli Workload Scheduler (TWS) rules.  Parameter  Description  Use \'Exclude\' RBCs (Control-M V8 FP1 or later)  Enables the Conversion Tool to convert TWS EXCEPT statements using the Rule Based Calendars feature added in Control-M V8 Fix Pack 1.  Do not convert \\\"EXCEPT\\\" statements  Determines that except statements are not converted to Control-M (default). An Error message WRN6022 is issued for each statement that is not converted. TWS ON statements are converted to Control-M rule-based calendars.  Convert \\\"EXCEPT\\\" statements to dummy jobs  Determines that a dummy job is created for each \\\"EXCEPT\\\" statement. The converted SMART folder depends on the condition(s) released by the dummy job(s). TWS \\\"ON\\\" statements are converted to Control-M rule-based calendars.  Convert \\\"ON\\\" and \\\"EXCEPT\\\" statements to dummy jobs  Determines that a dummy job is created for any \\\"ON\\\" or \\\"EXCEPT\\\" statement. This dummy job derives scheduling definitions from the corresponding statement.   The converted SMART folder depends on the conditions released by the dummy jobs, with an \\\"OR\\\" between conditions created from \\\"ON\\\" statements, and a logical \\\"AND\\\" between conditions created from \\\"EXCEPT\\\" statements.  In addition to the dummy jobs, \\\"ON\\\" statements are converted to rule-based calendars (otherwise the SMART folders are not ordered).  \"},{\"id\":111,\"title\":\"SAP Editor - TWS parameters\",\"url\":\"Set_sap_rules_for_tivoli.htm\",\"text\":\"The following table describes the SAP editor rules for Tivoli Workload Scheduler (TWS) when selecting the SAP Editor -TWS tab.    NOTE: Select the Enable SAP conversion check box to enable conversion of SAP jobs using the Control-M for SAP forms.  Parameter  Description  Job Count   -i = <account_name> SAP account name  User   -user = the SAP job owner  Job Class   -c = <class_name> SAP job class  Job Name  -job = <job_name> the SAP job name  NOTE: These parameters must appear in the DOCOMMAND in SAP. A job converts to a SAP job when the DOCOMMAND contains all the values in the SAP filter list. SAP jobs are converted to Task Type JOB. The set of conversion rules appears in the Conversion rules list. You can use these rules in future conversions.  \"},{\"id\":112,\"title\":\"PeopleSoft Editor parameters\",\"url\":\"Set_peoplesoft_rules_for_tivoli.htm\",\"text\":\"The following table describes the PeopleSoft editor rules for Tivoli Workload Scheduler (TWS) in the PeopleSoft Editor tab.    NOTE: Select the Enable PeopleSoft conversion check box to enable conversion of PeopleSoft jobs using the Control-M for PeopleSoft forms. If unchecked these jobs are converted to regular OS jobs in Control-M.  Parameter  Description  Process name  Defines the process name to be scheduled.  Type  Defines the output destination type, specifying the file path, printer destination URL or email address.  Run Control  Defines the Run control attributes that are associated with a process or job.  Run Location  Identifies the name of the server to be used for running the process or job.  \"},{\"id\":113,\"title\":\"OS400 Editor parameters\",\"url\":\"46221.htm\",\"text\":\"The following table describes the OS/400 editor rules for Tivoli Workload Scheduler (TWS) in the OS400 Editor tab.    NOTE: Select the Enable OS400 conversion check box to enable conversion of OS/400 jobs using the Control-M for OS/400 forms. If unchecked these jobs are converted to regular OS jobs in Control-M.  Parameter  Description  Convert CALL commands to object type program  Enables the Conversion Tool to convert command line CALL <program> … to job type OS400 Program rather than OS/400 command line jobs.  NOTE: Any TWS command line job that starts with the CALL command, the job type can be set to OS400 Program. The CALL command program name and the parameters are extracted from the command line into the appropriate job attributes.  Keyword for SUBMIT  Enables TWS to submit the job to batch, including the submit jobs attributes.  Keyword for DOCOMMAND  Enables TWS to run the command directly without submitting it to batch. There are no submit job attributes.  Control-M submits the job to batch. For SUBMIT mode, the submit job attributes are extracted from the SUBMIT string. For DOCOMMAND mode, the default submit job attributes are used.  \"},{\"id\":114,\"title\":\"TWS recommended practices\",\"url\":\"46153.htm\",\"text\":\"Since TWS is a command line driven scheduler, it is advisable to retain this way of working and set the rules file to convert all jobs to command line jobs. The conversion tool automatically adjusts or reports TWS jobs RECOVERY conditional statements as found in the jobs txt.file. For the RECOVERY options, see TWS recovery options.  The following topics describe the recommended practices for converting TWS jobs to Control-M, warning messages and IBM TWS utilities.  Converting TWS to Control-M  TWS warning messages - corrective action  TWS utilities  \"},{\"id\":115,\"title\":\"Converting TWS to Control-M\",\"url\":\"46154.htm\",\"text\":\"This procedure describes the recommended practices for converting TWS jobs to Control-M.  To convert TWS jobs to Control-M:  Before converting jobs, it is recommended that you do the following:  A full scan of all scripts run by TWS to look for occurrences of TWS command lines, executables and variables within the scripts.  Identify any external interfaces to things such as monitoring and alerting tools, reporting tools, help desk incident management tools and CMDB&#8217;s.  A Precursory Scan of the TWS environment. If you have amended the .jobmanrc file to perform pre-execution actions, check if anything has been modified in the .jobmanrc file.    EXAMPLE: A popular example of modification to the .jobmanrc is to provide the ability of job-step level restarts for UNIX and Windows jobs.  The .jobmanrc file should be checked for this added feature.  Users will typically be requested to use the &#8216;conman rr jobname step=restart-step-name&#8217; command.  Create TWS variables.  These are equivalent to Control-M variables and can be embedded in the job definition or script.  These can be found in the Parms.txt file  EXAMPLE:   $PARM  PROD_E_SCR\\t\\\"c:\\\\schedules\\\\e-commerce\\\\filecopy.txt\\\"  EXAMPLE: Conversion to Control-M Server for Windows:  ctmvar -ACTION SET -VAR \\\"%%%%\\\\PROD_E_SCR\\\"     &#8211;VAREXPR &#8220;C:\\\\schedules\\\\e-commerce\\\\filecopy.txt&#8221;  In the Conversion Tool, it is recommended that you do the following:  From the Conversion Settings window, in the General tab in the Job Type Conversion area, select Convert all jobs to Control-M command line jobs. For more information, see Setting General rules.  From the Additional TWS Rules tab, select the following:  In the General field, select Convert OPENs statements to Control-M File Watcher.  In the Scheduling Conversion field, select \'Exclude\' RBC\'s (Control-M V8 FP1 or later).   NOTE: This converts calendars to Rule Based Calendars and places logical names as far as possible. For example ON &#8220;MO,TU,WE,TH,FR&#8221; converts this to &#8220;Weekdays&#8221;   If SAP jobs are identified, from the SAP Editor - TWS tab, type the SAP parameters as required.  If PeopleSoft jobs are identified, from the PeopleSoft editor tab, type the Peoplesoft parameters are required.  For more information, see Setting additional Tivoli Workload Scheduler (TWS) rules  NOTE: You may wish to see the schedules in a slightly different way in the Planning Domain in Control-M.  Using the Field Editor on the Application and Sub_Application fields enables slightly different views after conversion.  It is worth experimenting with these if you do not like the default view. For more information, see Setting Fields Editor rules.  After the conversion, from the Conversion Results window, in the Actions tab, click Generate Scripts to add automatically Quantitative resources, Global variables or Node Groups. For more information, see Generating scripts for Control-M/Server.  EXAMPLE: Batch file to load Quantitative Resources:  $RESOURCE  PROD-NPDS01B#TSMPBKP\\t   4\\t\\\"For NDA backups\\\"  PROD-ONNM001A#TSMPBKP\\t   4\\t\\\"TSM prod backups so not too many run at the same time\\\"  PROD-DTCAH05A#FTFRES1\\t   1\\t\\\"Prevents FTF_WKLY clashing with FTF\\\"  \"},{\"id\":116,\"title\":\"TWS recovery options\",\"url\":\"46156.htm\",\"text\":\"The Conversion tool automatically adjusts or report TWS job RECOVERY conditional statements as found in the jobs.txt file.  The possible options for RECOVERY are:  Recovery Sub-parameter  Function  Control-M equivalent  STOP  If the job fails, do not continue processing  Handled by Conversion tool  CONTINUE  If the job fails, continue with the next job in the sequence\\t  Handled by Conversion tool  RERUN  If the job fails, rerun it\\t  Handled by Conversion tool  AFTER [WORKSTATION] jobname  If the job fails, submit a recovery job\\t  ON NOTOK DO FORCEJOB  ABENDPROMPT &#8220;text&#8221;  If the job fails, issue a message to the operator  ON NOTOK DO SHOUT  NOTE: RECOVERY AFTER statements issue a conversion message WRN0016 - Unable to create an assisting job to enable the RECOVERY AFTER option. Scan the jobs.txt file for occurrences of &#8216;RECOVERY AFTER&#8217;, and apply the required job-name as the DO FORCEJOB parameters for Control-M.  The ABENDPROMPT statement can also issue messages in different ways.  &#8220;text&#8221;= a maximum of 64 characters to be displayed in the event of job failure  &#8220;:text&#8221;= the prompt is displayed but requires no intervention  &#8220;!text&#8221;= the prompt is not displayed but requires a reply to continue the schedule  In each scenario, it is advised to issue ON NOTOK, DO SHOUT messages that advise the operator on the appropriate course of action.  \"},{\"id\":117,\"title\":\"TWS warning messages - corrective action\",\"url\":\"46160.htm\",\"text\":\"The following table describes the TWS warning messages and the corrective action.  NOTE: This does not include all of the TWS information, warning, and error messages.  Product  Product Message ID  Message Description  Action  Generic  WRN0002  <vendor> <attribute name> is not supported by Control-M  Reports a function in TWS that is not available with Control-M. For more information, see Warning WRN002.  Generic  WRN0005  <vendor> <attribute name> and <value> cannot be implemented in Control-M  Recovery options (AFTER or ABENDPROMPT have been defined within the job definition.  These are not supported by Control-M.  These should be manually updated ON DO FORCEJOB and ON DO SHOUT statements  Generic  WRN0016  Unable to create assisting job  RECOVERY AFTER - Manually update the job definition with ON/ DOFORCEJOB  TWS  WRN1005  The command line exceeds 512 characters.   You can shorten the command line or manually change it to Control-M embedded script.  TWS  WRN4017  Reports errors in the TWS data.  For example the AT or UNTIL parameter should be in the format hhmm. Sometimes TWS users forget to fully qualify the time. You need to identify the correct time, and either fix TWS or modify the input file to have the correct times.  TWS  WRN6007  Runcycle definition cannot be converted.  Typically, the required dates are in the past and not an issue.  The job is converted with no scheduling criteria as it is assumed these are ad-hoc jobs.  TWS  WRN6013  Attribute converted partially  Typically these relate to scheduling days/dates/calendars.  These need to be resolved manually by creating or updating a calendar to meet the required criteria.  TWS  WRN6018  Unable to retrieve job definitions  You need to verify that this job is no longer required and either clean-up TWS, remove it from the source data or ignore this error.  TWS  WRN6024  TWS OPENS statement cannot be convert  These are equivalent to the CTMFW.  These are typically due to variables being included within the OPENS statement, review and correct  \"},{\"id\":118,\"title\":\"Warning WRN002\",\"url\":\"46169.htm\",\"text\":\"WRN0002 message reports a function in TWS that is not available with Control-M.  EXAMPLE: NDA_CNR_VIP#QTAB_NON_DEQ           AT      0000           EVERY   0100           UNTIL   2359           ONUNTIL SUPPR  ONUNTIL SUPPR: The SUPPRess statements set any job(s) with the SUPPR condition to a state of success once the ONUNTIL time is passed, even though they have not yet started.  Control-M handles this condition by following the same rules as ONUNTIL CANC.  suppr: The final job stream state is HOLD if the job stream contains at least one every job. Otherwise the final state is calculated using the normal rules and the jobs with the optiononuntil suppr are considered in SUCC state when the until time occurs, even if their dependencies have actually not been released.  ONUNTIL CANC: The CANCEL command is effective for a job or job stream and is related to jobs that have not yet dispatched. The job or job stream is canceled when the until time specified expires.  Any job or job stream that was dependent on the completion of a job or job stream that was canceled runs because the dependency no longer exists in TWS. To handle this with Control-M, it requires a combination to use CTMPSM parameters.  EXAMPLE: With a script on the Control-M Server or Control-M Agent machine with a content of:  Windows: \\t&#8220;ctmpsm_script_location&#8221;\\\\ctmpsm -UPDATEAJF %2 SETTOOK  UNIX: &#8220;ctmpsm_script_location&#8221;\\\\ctmpsm -UPDATEAJF $2 SETTOOK  This is an alert mechanism that allows the job to continue.  The job or job stream runs when all necessary conditions are met and a notification message is written to the log when the until time elapses.  This can be simply addressed using the Control-M Shout options.  \"},{\"id\":119,\"title\":\"TWS utilities\",\"url\":\"46163.htm\",\"text\":\"The following table describes a list of the most common TWS utilities that you may encounter when running a conversion.   Utility Name  Description  Action  conman  Issues commands directly to TWS. For more information on common Conman options, see Common Conman options.  Replace with Control-M commands  datecalc  Converts date and time information into the required format.  Replace with ctmcaldate  delete  Removes scripts and output by name  None required  jobinfo  Reports job information\\t  None required  makecal\\t  Creates calendars  None required  parms  Displays, adds and updates parameters  Replace with ctmsetvar  release  Frees up resources  Replace with ecaqrtab update statements  sendevent  Issues events to the TWS environment  Possible Global Conditions  \"},{\"id\":120,\"title\":\"Common Conman options\",\"url\":\"46167.htm\",\"text\":\"The following table describes the common conman options in a TWS environment.  Command Name  Description  Control-M Action  adddep  Adds a dependency to jobs or schedules  ctmcontb -add  cancel  Cancels the required job or schedule  Options could be ctmkilljob or ctmpsm &#8216;hold & delete&#8217;  confirm\\t  Confirms a job start  None required  delpred  Deletes a job or schedule predecessor  ctmcontb -delete  kill  Kills a job  ctmkilljob  release\\t  Releases a job or schedule to run  Options could be to do nothing and let the operator make the decision or use ctmcontb to dynamically add a condition  reply  Reply to a message prompt  No Control-M equivalent. May need to consider CONFIRM  submit\\t  Submits jobs, schedules or DOCOMMAND statements.  ctmorder/force. If Submit DOCOMMAND, there is no equivalent in Control-M.  \"},{\"id\":121,\"title\":\"JP1 Automatic Job Scheduler\",\"url\":\"99709.htm\",\"text\":\"The following topics describe how to define a new project, additional settings, and mapping JP1 jobs:  Defining a new JP1 Automatic Job Scheduler project  Setting additional JP1 Automatic Job Scheduler rules  JP1 Automatic Job Scheduler mapping  \"},{\"id\":122,\"title\":\"Defining a new JP1 Automatic Job Scheduler project\",\"url\":\"80283.htm\",\"text\":\"This topic describes how to define a new JP1 Automatic Job Scheduler (AJS) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   To define a new JP1 AJS conversion project:  From the JP1 - Load Data window, in the Import Scheduling Data area, complete the following field:  (Mandatory) Unit Definition File: Click @ to locate the Unit Definition file.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":123,\"title\":\"Setting additional JP1 Automatic Job Scheduler rules\",\"url\":\"83062.htm\",\"text\":\"This procedure describes how to set additional JP1 Automatic Job Scheduler (AJS) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional JP1 AJS rules:  In the Conditions area, select one of the following condition names:  CID<Unique number>@JOBA-TO-JOBB: Enables you to define how two jobs are connected by creating a unique condition in the format: CID<Unique number>@JOBA@JOBB.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  CID<Unique number>@JOBA-ENDED-<Status>: Enables you to set a dependence condition between many jobs according its end status.    For more details see Job Dependencies in Using Control-M.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":124,\"title\":\"JP1 Automatic Job Scheduler mapping\",\"url\":\"83632.htm\",\"text\":\"The following sections describe how the Conversion Tool converts job types, job folders, OS jobs, variables, prerequisites and actions from  JP1 Automatic Job Scheduler (AJS) to Control-M:  Folders and jobs  Job types  OS jobs  Variables  Prerequisites and action  Scheduling  \"},{\"id\":125,\"title\":\"Folders and jobs\",\"url\":\"83646.htm\",\"text\":\"The following table describes how the Conversion Tool converts folders and jobs from JP1 AJS to Control-M.  JP1 AJS   Control-M  Root jobnet  SMART Folder  Jobnet\\t  Sub Folder  Job\\t  Job  unit name (Job/Jobnet)  Job/Folder name  ex (execution-agent-name)  Host/Host group  eu  un (execution-user-name)  JP1-user-name  Run As  JP1-user-name  Created by  Group unit name (ty=g) (contains a chain of all grandparent groups)  Application  NOTE: Where there are more than 2 level groups, the Application contains the grandparent group path.  Sub Group unit name (ty=g) - closest parent group  Sub Application   cm (comment)  Description  \"},{\"id\":126,\"title\":\"Job types\",\"url\":\"83633.htm\",\"text\":\"The following table describes how the Conversion Tool converts JP1 AJS job types to Control-M.  JP1 AJS  Control-M  UNIX/Windows jobs (ty=j,rj,pc,rp)  OS job  All other job types (such as ty=flwj, evsj, evwj, jdj, mlsj)   Dummy jobs  NOTE: These jobs are not supported and converted to Dummy jobs. Manual conversion may be required.  Jobnet Connector (ty=nc)  Dummy jobs  NOTE: These jobs are not supported and converted to Dummy jobs. Manual conversion may be required.  \"},{\"id\":127,\"title\":\"OS jobs\",\"url\":\"83635.htm\",\"text\":\"The following table describes how the Conversion Tool converts OS jobs from JP1 AJS to Control-M.  JP1 AJS  Control-M  command-text (te)  NOTE: script-file-name with no path (sc)  Command  NOTE: JP1 commands and variables in the command line are not supported.   script-file-name (sc)  script - File Name\\t  script-file-name (sc)  work-path-name (wkp)  script - File path  \"},{\"id\":128,\"title\":\"Variables\",\"url\":\"83636.htm\",\"text\":\"The following table describes how the Conversion Tool converts variables from JP1 AJS to Control-M.  JP1 AJS  Control-M  parameter (prm)  PARM  NOTE: All other variables (such as env, SYSTEM variables) are not currently supported by the Conversion Tool. Manual conversion may be required.  \"},{\"id\":129,\"title\":\"Prerequisites and action\",\"url\":\"83637.htm\",\"text\":\"The following table describes how the Conversion Tool converts prerequisites and actions from JP1 AJS to Control-M.  JP1 AJS  Control-M  ar=(f=[from unit], t=[to unit], [relation-type])  Conditions (In/Out)  NOTE: The following are not supported:  Conditions of relation-type=con (from a judgment job).   Conditions of OR job are not converted as expected.  ar=(f=[from unit], t=[to Recovery unit], [relation-type])  On Do Actions  \"},{\"id\":130,\"title\":\"Scheduling\",\"url\":\"83639.htm\",\"text\":\"The following table describes how the Conversion Tool converts scheduling attributes from JP1 AJS to Control-M.  JP1 AJS  Control-M  Group- open days (op)  Calendar- WORKDAYS-[group]  Group- closed days (cl)  Calendar- NON_WORKDAYS-[group]  st  From Time  NOTE: The following is not supported:  48 hour format (st>23:59)  Relative start time (st contains \\\"+\\\")  Multiple start times  sd, cy  Rule Based Calendars (RBC)  NOTE: The following is not supported:  ed (expiration date).  Sd and no cy (Specific date).  Sd contains \'+\' (Relative date)  sh+shd (shifts)  jc (Reference to a calendar of another job group)  ejn (Exclusive schedule)  de  cy=N,(1,d)  RBC - Everyday (daily)  cy=N,(1,d) + sd contains \'*\'  RBC - WORKDAYS (daily)  Based on Calendar WORKDAYS [group]  NOTE: If no calendar is found, open/closed days are converted to Everyday.  cy=N,(1,d) + sd contains \'@\'  RBC- NON WORKDAYS (daily)  Based on Calendar   NON_WORKDAYS [group]  NOTE: If no calendar is found, open/closed days are converted to Everyday.  cy=N,(1,w), sd={su|mo|tu|we|th|fr|sa}  RBCs- Sunday, Monday, Tuesday,  Wednesday, Thursday, Friday, Saturday (Weekly)  NOTE: The following is not supported:  If sd contains dd (e.g. 2015/11/26)  If sd contains {su|mo|tu|we|th|fr|sa}:n, n>1 (nth week of the month)  cy=N,(1,m)  RBC (Monthly)  NOTE: The following is not supported:  If sd contains weekday (e.g. sd=yyyy/mm/{su|mo|tu|we|th|fr|sa})  cy=N,(1,m), sd=yyyy/mm/dd | mm/dd| dd  RBC- Nth_of _month (Monthly)  cy=N,(1,m), sd=yyyy/mm/b | mm/b| b  RBC- Last_of_month (Monthly)  cy=N,(1,m), sd=yyyy/mm/b-DD | mm/b-DD| b-DD  RBC- Nth_from_month_end (Monthly)  cy=N,(1,m) + sd contains \'*\'  RBC- Nth_workday (Monthly)  Based on Calendar   WORKDAYS-[group]  cy=N,(1,m) + sd contains \'*b\'  RBCs-  NthLastWorkday/ LastWorkday (Monthly)  Based on Calendar   WORKDAYS-[group]  cy=N,(1,m) + sd contains \'@\'  RBC- Nth_non_workday (Monthly)  Based on Calendar   NON_WORKDAYS-[group]  cy=N,(1,m) + sd contains \'@b\'  RBC-  NthLastNonWorkday/ LastNonWorkday  (Monthly)  Based on Calendar   NON_WORKDAYS-[group]  cy=N, (n,y)  Currently not supported.   cy=N,(n,d|w|m) where n>1 (Interval)  Currently not supported.  sd=0,ud  Scheduling is taken from the parent.  \"},{\"id\":131,\"title\":\"MS Task Scheduler\",\"url\":\"98244.htm\",\"text\":\"The following topics describe how to extract MS Task data, define a new MS Task Scheduler project, additional settings, and disabling MS Task Scheduler jobs:  MS Task Scheduler data extraction  Defining a new MS Task Scheduler conversion project  Setting additional MS Task Scheduler rules  Post conversion: disabling MS Task Scheduler jobs     \"},{\"id\":132,\"title\":\"MS Task Scheduler data extraction\",\"url\":\"20804.htm\",\"text\":\"You can extract MS Task Scheduler data by using the following discovery options:  BMC Discovery: Enables you find to MS Task Scheduler tasks that reside in task folders using BMC Discovery. For more information, see MS Task Scheduler data extraction using BMC Discovery.  Control-M/Agents: Enables Control-M Agent (installed on the same machine as the Conversion Tool) to collect MS Task Scheduler data from available Agents and Remote Hosts. Before extracting data you need to set up a MS Task Scheduler environment, as described in MS Task Scheduler data extraction using Control-M/Agents.  Extract data manually: Enables you to extract data manually. You can then import the data into the Conversion Tool by adding data from multiple locations and users.  When converting MS Task Scheduler data to Control-M, the Conversion Tool creates tasks as part of any conversion using the Discovery functionality. These tasks are added to Active Jobs and applied to your overall task count for the day in which the Discovery/Data Collection is being run.  A warning message is displayed indicating the number of tasks that are created as part of the Discovery/Data Collection and you can cancel the Discovery/Data Collection at that time.  Ensure that you understand the possible implications of this prior to proceeding with the Discovery/Data Collection.    You can analyze the complexity of the conversion project by viewing the assessment report once your data is retrieved and/or imported.  You are able to configure Control-M Fields, (such as Folder, Application, and Sub Application) so you can see which jobs are running on your environment. To configure MS Task Scheduler conversion project, see Configuring Control-M fields for Cron and MS Task Scheduler jobs.  \"},{\"id\":133,\"title\":\"MS Task Scheduler data extraction using BMC Discovery\",\"url\":\"98138.htm\",\"text\":\"BMC Discovery automatically discovers configuration and relationship data on every server in your environment. You can use BMC discovery to find MS Task Scheduler\'s tasks that reside in Task Folders. The Conversion Tool enables you to connect to BMC Discovery and converts the Cron jobs that are found by BMC Discovery.   For information about how to install and use BMC Discovery, see https://docs.bmc.com/docs/display/DISCO110.  When using the Conversion Tool, you need to supply the following:  Discovery Server Host  Discovery User  Discovery Password  For more information about using Discovery to extract data in the Conversion Tool, see Defining a new MS Task Scheduler conversion project.  \"},{\"id\":134,\"title\":\"MS Task Scheduler data extraction using Control-M/Agents\",\"url\":\"98140.htm\",\"text\":\"You can use the Control-M Agent (installed on the same machine as the Conversion Tool) to collect MS Task Scheduler data from available Agents and Remote Hosts.   NOTE: Relevant for MS Task Scheduler conversion which runs on Microsoft Windows where Control-M Agent is installed.  The Control-M Agent uses Control-M jobs and Agent utilities to collect the MS Task Scheduler data. The Control-M jobs execute a script file to collect data and to view a list of available hosts. The following script files are used, which are dependent on the host\'s platform:   UNIX: captureScriptUnix.txt  Windows: captureScriptWindows.txt.  To start the collection of data by Control-M/Agents, a job is submitted to the Agent&#8217;s primary Control-M Server. Once a list of available hosts is created, in the Conversion Tool, you can select from which hosts you want to collect data. A job is then submitted to each selected host to retrieve the MS Task Scheduler data.  To start data collection by Control-M/Agents, see Configuring the Cron conversion environment.  \"},{\"id\":135,\"title\":\"Setting up the MS Task Scheduler environment using Control-M/Agents\",\"url\":\"46118.htm\",\"text\":\"Before you set up an MS Task Scheduler conversion project you need to set up your MS Task Scheduler environment.  Before you begin  Do the following:  Control-M Agent is installed and running on the same environment as the Conversion Tool.   Control-M Agent is connected to a Control-M Server (version 6.4 or later), and that the Agent is available.  Control-M Server allows execution of the ctmpsm and ctmcreate utilities by the Agent.   To set up MS Task Scheduler:  Copy the following script files from the Conversion Tool\'s script folder, <Conversion Home>/scripts/DataCollection to your Control-M Server:  captureScriptUNIX.txt   captureScriptWindows.txt  Open the Conversion Tool and continue with Capturing data.  \"},{\"id\":136,\"title\":\"Configuring Control-M fields for MS Task Scheduler jobs\",\"url\":\"20867.htm\",\"text\":\"This procedure describes how to configure Control-M fields for MS Task Scheduler jobs. You can configure Control-M fields (such as Folder, Application and Sub Application) by changing the default values in the setting.cfg file.   You can enter specific values so they can be identified in the Monitoring domain in Control-M client, so you know exactly how many jobs the discovery tool is running on your environment.  To Configure Control-M Fields for MS Task Scheduler jobs:  Close the Conversion Tool.  Locate the setting.cfg file in <Conversion Home>\\\\data\\\\ and set one or more of the following parameters:  MS_DISCOVERY_JOBS_FOLDER_NAME=Conversion_discovery_MS  MS_DISCOVERY_JOBS_APPLICATION=Conversion_discovery  MS_DISCOVERY_JOBS_SUB_APPLICATION=MS  Open the Conversion Tool and continue with Defining a new MS Task Scheduler conversion project.  \"},{\"id\":137,\"title\":\"Defining a new MS Task Scheduler conversion project\",\"url\":\"Define_MSTS_conv.htm\",\"text\":\"This topic describes how to define a new MS Task Scheduler conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.  For more information about MS Task Scheduler conversion project, see MS Task Scheduler project Set up. To create a new conversion project, see Running a new conversion project.  Before you begin  Ensure the following:   If using BMC Discovery, extract your data, as described in MS Task Scheduler data extraction using BMC Discovery.  If using Control-M/Agents to extract your data, set up your MS Task Scheduler environment, as described in Configuring the MS Task Scheduler environment.  You have configured Control-M fields, as described in Configuring Control-M fields for MS Task Scheduler jobs.  You have created a new project, as described in Running a new conversion project.  To define a new MS Task Scheduler conversion project:  From the MS Task Scheduler - Load Data window, in the Import Scheduling Data area, select one of the following options:  Import data from BMC Discovery  Import data using Control-M Agents: Do the following:   (Mandatory) In the Control-M Server platform field, select your platform from the drop down list.  (Mandatory) In the Script location field, select whether the script files are in the default location, or in a custom location. If they are in a custom location, enter the location in the Custom location field.  Import data manually: Imports files by entering the location of the files.  Click Next.  (Import data automatically only) The Confirmation Jobs Submission dialog box appears and click Yes to execute 3 jobs to prepare for automatic data collection.  NOTE: These jobs are added to Active Jobs in Control-M client and are applied to your overall task count for the day.  Do one of the following:    Import Data from BMC Discovery by typing the BMC Discovery parameters.  Import Data using Control-M Agents, as described in Adding data automatically to a MS Task Scheduler conversion project  Import data manually, as described in  Adding data manually to a MS Task Scheduler conversion project.  \"},{\"id\":138,\"title\":\"BMC Discovery parameters\",\"url\":\"98117.htm\",\"text\":\"The following table describes the BMC Discovery parameters when importing data using the BMC Discovery Tool:  Parameter  Description  Host  Defines the BMC Discovery host.  NOTE: Requires a HTTPS connection.  User name  Defines the BMC Discovery user name.  NOTE: The user mast have API access permissions, as the Conversion tool needs to connect to the Discovery Server and retrieves the data.  Password  Defines the user name password.  \"},{\"id\":139,\"title\":\"Importing MS Task Scheduler data using Control-M/Agents\",\"url\":\"Add_data_auto_MSTS.htm\",\"text\":\"This procedure describes how to import data to a MS Task Scheduler conversion project using Control-M/Agents. Once you have entered the information for your Control-M Server and the script location, and then clicked Next, you are ready to begin retrieving data.  To import data using Control-M/Agents:  In the MS Task Scheduler - Load Data window, select the agents from which you want to retrieve data.   You can do one or more of the following:  Select all available agents at one time, click Select All.  Clear the check box(es) of all available agents, click Clear All.  Select the agents that are not currently selected, and clear the check boxes for agents that are currently selected, click Invert Selection.  For example, if you have 50 agents and want to select 40 of them quickly, you can select the 10 agents that you don\'t want, and then click Invert Selection.  Refresh the Agents list, and view agents that were not available previously, click Refresh.  Filter a column, click @.   If the status of an agent is Available in the Agent Status column, but you are not able to select the check box for the agent, you need to make sure the correct platform is selected for that agent.  NOTE: In the MS Task Scheduler - Load Data window, you can also add data manually. For more information, see Importing data using the Add Data Manually button - MS Task Scheduler.  NOTE: You can only retrieve data from agents that are available and connected to the server.  Select the Agent you want and click Next.  The Confirmation Jobs Submission dialog box appears.  Click Yes to execute the number of jobs to be retrieved in Control-M.   NOTE: These jobs are added to Active Jobs in Control-M client and are applied to your overall task count for the day.  The MS Task Scheduler - Load Data window appears.   You can view the status of the data retrieval. For more information, see Viewing the Results list.  In the MS Task Scheduler - Load Data window, you can also add data manually. For more information, see Adding data manually to a MS Task Scheduler conversion project.  Click Import to complete the data import phase.  NOTE: The Import button is only available when data is successfully retrieved. Once you click Import, you cannot add more data to this conversion project.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":140,\"title\":\"Importing MS Task Scheduler data using the Add Data Manually button\",\"url\":\"46365.htm\",\"text\":\"This procedure describes how to import data manually by using the Add Data Manually button. You can import data manually when you click the Add Data Manually button. When you are defining a MS Task Scheduler project, you can add data manually at any time during the Data Import phase. You can also add data from multiple locations and users.  To import data using the Add Data Manually button:  From the MS Task Scheduler - Load Data Window or click the Add Data Manually button at the bottom of the screen.  The Import data manually screen appears.  From the Import data manually window, click Add.  The Add Data Manually window appears.  Complete the following fields:  (Mandatory) In the Machine Name field, enter the name of the machine where the files are located.  (Mandatory) In the Data file field, click @ to locate the Data file that you want to use.  (Mandatory) In the Date Format field, if you select a CSV file, enter the date format you want to use.  Click Apply & Close.  Repeat steps 2-5 as needed.  To delete an entry from the table, click the entry, and then click Delete.  Close the window after you have completed adding the files that you want.  \"},{\"id\":141,\"title\":\"Importing MS Task Scheduler data manually\",\"url\":\"Add_data_man_MSTS.htm\",\"text\":\"This procedure describes how to import data manually to a MS Task Scheduler conversion project. You can add data from multiple locations and users.  For more information about defining a new MS Task Scheduler conversion project, see Defining a new MS Task Scheduler conversion project.  Before you begin  Run one of the following commands:   schtasks /Query /XML >> {OutputFileName}.xml  schtasks /Query /V /FO CSV >> {OutputFileName}.csv  To import data manually to a MS Task Scheduler conversion project:  In the Import data manually window, click Add.  The Add Data Manually dialog box appears.   Do the following:  (Mandatory) In the Machine name field, enter the name of the machine where the files are located.  (Mandatory) In the Data file field, click @ to locate the Data file that you want to use.  (Mandatory) If you select a CSV file, in the Data Format field, type the date format you want to use.  Click Apply & Close.  Repeat steps 2-5 for each location that you want to import data from.  To delete an entry from the table, click the entry, and then click Delete.  When you have completed entering all of the locations that you want, click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":142,\"title\":\"Setting additional MS Task Scheduler rules\",\"url\":\"Set_addl_MSTS_rules.htm\",\"text\":\"This procedure describes how to set additional MS Task Scheduler rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional MS Task Scheduler rules:  From the Additional MS Rules tab, in the General area, select the options that you want:  Ignore disabled tasks: disabled tasks are not included as part of the converted data. By default this option is selected.  Ignore disabled triggers: disabled triggers are not included as part of the converted data. By default this option is selected.  In the Job/Folder name manipulation area, select or modify the options that you want:  Change prefix/suffix: the character that you want to use to indicate the location in the filename where characters were removed.  Select one of the following options to shorten a filename that is too long:  Truncate characters from the beginning  Truncate characters from the end  Uniqueness suffix separator: the character that you want to use to separate the original file name from the numbers that are added to the end of the file name.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":143,\"title\":\"Post conversion: disabling MS Task Scheduler jobs\",\"url\":\"20885.htm\",\"text\":\"After you complete the conversion process, Conversion_discovery_MS jobs folder and the converted jobs appear in the Planning domain in Control-M client. If you want to disable the original jobs that run on MS Task Scheduler (as they are now running in Control-M), you can manually order the original jobs that were defined during conversion. This deactivates the original jobs causing them to stop running on MS Task Scheduler.   The following example shows the original and converted jobs in the Planning domain in Control-M client together with details of the disabled job. For more information about how to order jobs in Control-M, see Ordering Jobs in Using Control-M.  \"},{\"id\":144,\"title\":\"Redwood CPS\",\"url\":\"99700.htm\",\"text\":\"The following topics describe how to extract Redwood CPS data, define a new project, and additional settings:  Redwood CPS data extraction  Defining a new Redwood CPS project  Setting additional Redwood CPS rules  \"},{\"id\":145,\"title\":\"Redwood CPS data extraction\",\"url\":\"46101.htm\",\"text\":\"You need to extract Redwood CPS data if you want to manually import your data before starting a conversion project.  The following procedures describe how to extract Redwood CPS data, depending on whether you are running an Oracle SQL Developer or an MSSQL Server.  Extracting the Redwood CPS data on Oracle SQL Developer  Extracting Redwood CPS data on MSSQL Server  \"},{\"id\":146,\"title\":\"Extracting the Redwood CPS data on Oracle SQL Developer\",\"url\":\"46104.htm\",\"text\":\"This procedure describes how to extract Redwood CPS data on an Oracle SQL Developer. Before starting a new conversion project, you need to set up tables and export the data from the Redwood CPS environment. After extracting data, you can then define a new conversion project.  To extract Redwood CPS:  Log in to the database.  From the SYSJCS file, select, Table.  Select the following tables:  RWS_CALL  RWS_JOB  RWS_OBJ  RWS_PAR  RWS_SEL  RWS_SRC  RWS_STEP  RWS_WEL  Right click and select Export.  From the Export window, do the following:  Uncheck the Export DDL checkbox.  Check the Export data checkbox  From the Format list select csv.  From the Save As list select Separate Files.  From the File box enter the location where the export file is to be created.  Click Next, then Next again and Finish.  Open the Conversion Tool and import the data, as described in Defining a new Redwood CPS project.  \"},{\"id\":147,\"title\":\"Extracting Redwood CPS data on MSSQL Server\",\"url\":\"46100.htm\",\"text\":\"This procedure describes how to extract Redwood CPS data on a MSSQL Server. Before starting a new conversion project, you need to set up tables and export the data from the Redwood CPS environment. After extracting data, you can then define a new conversion project.  To extract Redwood CPS data:  From the <Conversion Home>/scripts/<Redwood> directory, type the following command:  redwood_MsSQL_export -U <username> -P <password> -S <database server> -D <database/schema name> [-T <table names list>  EXAMPLE: -T table1,table2,table3  NOTE: Once you run the command, a batch script exports the table from the Redwood MSSQL server.  Open the Conversion Tool and import the data, as described in Defining a new Redwood CPS project.  \"},{\"id\":148,\"title\":\"Defining a new Redwood CPS project\",\"url\":\"46023.htm\",\"text\":\"This topic describes how to define a new Redwood CPS Software (Redwood CPS) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report. You can either import the by extracting the files manually or extract the files from the Redwood database into the Conversion Tool without having to configure your environment.  Before you begin  Ensure the following:  (Manual import only) Export your Redwood data, as described in Redwood environment configuration.  Create a new project, as described in Running a new conversion project.  To define a new Redwood CPS conversion project:  From the Redwood - Load Data window, select one of the following:  Automatic: Enables you to automatically import the data from the Redwood database by doing the following:  Complete the Redwood CPS scheduling data parameters.  The following table describes the automatic import scheduling data parameters for Redwood CPS.  Parameter  Description  Type  Defines the database type. From the dropdown list select either Oracle or MSSQL.  Host name  Defines the host name for the database.  User name  Defines the user name for the database.  Password  Defines the password for the database.  Port  Defines the port number. For MSSQL, a default value appears.  Database server  Defines the database server or service name.  Schema name  Defines the database Schema Name (optional). A schema name is needed if no Database owner credentials are entered.  (Optional) Click Test to test the connection to the database.  Manual: Enables you to manually import the data by selecting one of the following:  From the Automatic Detect Files area, in the Data files directory field, click @to locate the files directory and then click Find files.  In the Import Scheduling Data area, click @ next to each filed to locate the .csv files.  NOTE: When you select Automatically Detect Files, if any files are missing, you can add them manually in the Import Data Scheduling Area.  Click Import.  The data is loaded into the Conversion Tool and in Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":149,\"title\":\"Redwood CPS scheduling data parameters\",\"url\":\"94412.htm\",\"text\":\"The following table describes the automatic import scheduling data parameters for Redwood CPS.  Parameter  Description  Type  Defines the database type. From the dropdown list select either Oracle or MSSQL.  Host name  Defines the host name for the database.  User name  Defines the user name for the database.  Password  Defines the password for the database.  Port  Defines the port number. For MSSQL, a default value appears.  Database server  Defines the database server or service name.  Schema name  Defines the database Schema Name (optional). A schema name is needed if no Database owner credentials are entered.  \"},{\"id\":150,\"title\":\"Setting additional Redwood CPS rules\",\"url\":\"46051.htm\",\"text\":\"This procedure describes how to set additional Redwood Software (Redwood CPS) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional Redwood CPS rules:  In the General information area, select or modify the options that you want:  First day of the week: Defines the first day of the week of your Control-M work environment.  Keep active for: Defines the maximum number of days that a Control-M job can wait for execution after order date (default: 0). Valid values:  0-99 (integer).  In the Standalone jobs section select one of the following:  GROUP all standalone jobs in one folder: Enables standalone jobs to be grouped into one folder.  Create a different folder for each standalone job: Enables you to create a different folder for each standalone job.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":151,\"title\":\"Tidal\",\"url\":\"99701.htm\",\"text\":\"The following topics describe how to extract Tidal, define a new project, additional settings, and mapping Tidal jobs:  Tidal data extraction  Defining a new Tidal Software Enterprise Scheduler conversion project  Setting additional Tidal Software Enterprise Scheduler rules  Tidal variables mapping  \"},{\"id\":152,\"title\":\"Tidal data extraction\",\"url\":\"64843.htm\",\"text\":\"You need to extract Tidal data if you want to manually import your data before setting up a conversion project.  The following procedures describe how to extract Tidal data depending on whether you are running an Oracle SQL Developer or an MSSQL Server.  Extracting Tidal data on MSSQL Server  Configuring the Tidal environment using Oracle SQL Developer  If you want to automatically import your data, see Defining a new Tidal conversion project setup.  \"},{\"id\":153,\"title\":\"Extracting Tidal data on MSSQL Server\",\"url\":\"64844.htm\",\"text\":\"This procedure describes how to extract data on a Tidal MSSQL Server. Before starting a new conversion project, you need to set up tables and export the data from the Tidal environment. After extracting data, you can then define a new conversion project.  To extract Tidal data:  From the <Conversion Home>/scripts/Tidal directory, type the following command:  tidal_MsSQL_export(-U <username> -P <password>| -W <Windows credentials>)-S <database server> -D <database/schema name>  NOTE: Once you run the command, a batch script exports the table from the Tidal MSSQL server.  Open the Conversion Tool and import the data, as described in Defining a new Tidal conversion project setup.  \"},{\"id\":154,\"title\":\"Extracting Tidal data using Oracle SQL Developer\",\"url\":\"64846.htm\",\"text\":\"This procedure describes how to extract data on an Oracle SQL Developer. Before starting a new conversion project, you need to set up tables and export the data from the Tidal environment. After extracting data, you can then define a new conversion project.  To extract Tidal data:  Log in to the database from Oracle SQL developer.  NOTE: BMC recommends logging in as DBO user, but you can log in with any user with read permissions on the Tidal database.  Expand the table group  Select the following tables:  JOBDTL  NODMST  OWNER  USRMST  RESMST  VARMST  TRGMST  TRGJOB  EVNTMST  EVNTYEAR  EVNTCOND  EVNTFSCL  EVNTCHLD  WORKUSR  WORKGRP  JOBCLS  RESJOB  JOBMST  JOBDEP  NODLSTDT  NODLSTMS  TRGTSK  TSKALRT  TSKLOG  TSKMAIL  TSKMST  TSKSCH  TSKVAR  Right click and select Export.  From the Export window, do the following:  Uncheck the Export DDL checkbox.  Check the Export data checkbox  From the Format list select csv.  From the Save As list select Separate Files.  From the File box enter the location where the export file is to be created.  Click Next, then Next and Finish.  Open the Conversion Tool and import the data, as described in Defining a new Tidal Software Enterprise Scheduler conversion project.  \"},{\"id\":155,\"title\":\"Defining a new Tidal Software Enterprise Scheduler conversion project\",\"url\":\"Define_tidal_conv.htm\",\"text\":\"This topic describes how to define a new Tidal Software Enterprise Scheduler (Tidal) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report. You can either import the data by extracting the files manually or automatically extract the files from the Tidal database into the Conversion Tool, without having to configure your environment.  Before you begin  Do the following:  Ask your DBA to supply all the relevant information in this screen.  Perform the connection test before importing the data.  Create a new conversion project, as described in Running a new conversion project.  For manual data import, export the JOBDTL table from your Tidal environment, as described in Tidal data extraction.  To define a new Tidal conversion project:  From the Tidal Software Enterprise Scheduler - Load Data window, select one of the following:  Automatic: Enables the Conversion Tool to automatically import the data from the Tidal database by doing the following:  Complete the Tidal scheduling parameters.  The following table describes the automatic import scheduling data parameters for a new Tidal conversion project.   Parameter  Description  Type  Defines the database type. From the dropdown list select either Oracle or MSSQL.  Authentication type  (MSSQL only) Enables you to one of the following authentication types:  SQL authentication: Enables you to enter the user name and password details.  Windows credentials: Use the Windows credentials, which are used to run the Conversion Tool to connect to the MSSQL Server.  Host name  Defines the host name for the database.  User name  Defines the user name for the database.  NOTE: Not relevant if you select Windows credentials in the Authentication Type.  Password  Defines the password for the database.  NOTE: Not relevant if you select Windows credentials in the Authentication Type.  Port  Defines the port number. For MSSQL, a default value appears.  Database server   Defines the database server or service name.  Schema name  Defines the database Schema Name (optional). A schema name is needed if no Database owner credentials are entered.  (Optional) To test that the connection to the database is successful, click Test.  Manual: Enables you to manually import the data by selecting one of the following:  In the Automatically Detect Files area, click @to locate the files directory and then click Find files.  In the Import Scheduling Data area, click @ next to each field to locate the .csv files.  NOTE: When you select Automatically Detect Files, if any files are missing, you can add them manually in the Import Data Scheduling Area.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":156,\"title\":\"Tidal data scheduling parameters\",\"url\":\"94414.htm\",\"text\":\"The following table describes the automatic import scheduling data parameters for a new Tidal conversion project.   Parameter  Description  Type  Defines the database type. From the dropdown list select either Oracle or MSSQL.  Authentication type  (MSSQL only) Enables you to one of the following authentication types:  SQL authentication: Enables you to enter the user name and password details.  Windows credentials: Use the Windows credentials, which are used to run the Conversion Tool to connect to the MSSQL Server.  Host name  Defines the host name for the database.  User name  Defines the user name for the database.  NOTE: Not relevant if you select Windows credentials in the Authentication Type.  Password  Defines the password for the database.  NOTE: Not relevant if you select Windows credentials in the Authentication Type.  Port  Defines the port number. For MSSQL, a default value appears.  Database server   Defines the database server or service name.  Schema name  Defines the database Schema Name (optional). A schema name is needed if no Database owner credentials are entered.  \"},{\"id\":157,\"title\":\"Setting additional Tidal Software Enterprise Scheduler rules\",\"url\":\"83866.htm\",\"text\":\"This procedure describes how to set additional Tidal Software Enterprise Scheduler (Tidal) rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional Tidal rules:  In the General area, select the options that you want:  Remove job\'s in conditions after job\'s completion: Removes each In Condition for every Control-M entity in the Control-M conditions, which prevents irrelevant jobs (instances) from running.  Do not convert Tidal disabled jobs (Inactive jobs): Ignores all disabled Tidal jobs, which are not converted to Control-M.   NOTE: If a Tidal job group is disabled, its children are ignored, regardless of whether they are disabled.  First day of the week: Defines the first day of the week of your Control-M environment.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":158,\"title\":\"Tidal variables mapping\",\"url\":\"86489.htm\",\"text\":\"The following sections describe how the Conversion Tool converts Tidal time and date variables into Control-M, together with examples:  Tidal time and date format mapping  Variable resolution examples  NOTE: If a job is converted to a Control-M embedded script, ensure that the variable does not contain spaces in the format, otherwise it results in an error when Control-M tries to resolve the variable at runtime.   EXAMPLE: <JobStart.hh:mm AM/PM>  \"},{\"id\":159,\"title\":\"Tidal time and date format mapping\",\"url\":\"86490.htm\",\"text\":\"The following describes the Tidal time and date formats that are converted to Control-M variables. For Tidal date format descriptions, see Cisco Tidal Enterprise Scheduler User Guide.  Tidal format  Control-M variable  d  %%NUMBER%%DD..  dd  %%DD.  ddd  Not supported  dddd  Not supported  j  %%SHORT_JULDAY.  %%SHORT_JULDAY=%%JULDAY %%MINUS 0  jj  %%SHORT_JULDAY.  %%SHORT_JULDAY=%%JULDAY %%MINUS 0  NOTE: It may not be an accurate conversion,  as leading zeros are removed for Julian dates from 0-9.  jjj  %%JULDAY.  m  %%NUMBER%%MM.  mm  %%MM.   mmm  %%MMM%%MM..  mmmm  %%MMMM%MM..  yy  %%YY.  yyyy  %%YYYY.  fm  Not supported  fmm  Not supported  q  Not supported  fq  Not supported  fyy  Not supported  fyyy  Not supported  h  %%H%%HH.. For more information, see Global time variables.  hh  %%HL%HH..  H  %%NUMBER%%HH..  HH  %%HH.  AM/PM  %%AP%%HH... For more information, see Global time variables.  mm  %%MM. as a substring of %%TIME  ss  %%SS.  \"},{\"id\":160,\"title\":\"Global time variables\",\"url\":\"86492.htm\",\"text\":\"The following table described the Global time variables in Control-M.  NOTE: You can add global variables automatically for your Control-M environment, as described in Generating scripts for Control-M/Server.  Variable  Value  %%AP00 - %%AP11  AM  %%AP12 - %%AP23  PM  %%H00  12  %%H01-%%H12  1-12  %%H13 - %%H23  1-11  %%HL00  12  %%HL01-HL%%HL12  01-12  %%HL13-%%%HL23  01-11  \"},{\"id\":161,\"title\":\"Global date variables\",\"url\":\"86493.htm\",\"text\":\"The following table describes the global date variables in Control-M.  NOTE: You can add global variables automatically for your Control-M environment, as described in Generating scripts for Control-M/Server.\\t  Variable  Value  %%MMM01  Jan  %%MMM02  Feb  %%MMM03  Mar  %%MMM04  Apr  %%MMM05  May  %%MMM06  Jun  %%MMM07  Jul  %%MMM08  Aug  %%MMM09  Sep  %%MMM10  Oct  %%MMM11  Nov  %%MMM12  Dec  %%MMMM01  January  %%MMMM02  February  %%MMMM03  March  %%MMMM04  April  %%MMMM05  May  %%MMMM06  June  %%MMMM07  July  %%MMMM08  August  %%MMMM09  September  %%MMMM10  October  %%MMMM11  November  %%MMMM12  December  %%NUMBER00  0  %%NUMBER01  1  %%NUMBER02  2  %%NUMBER03  3  %%NUMBER04  4  %%NUMBER05  5  %%NUMBER06  6  %%NUMBER07  7  %%NUMBER08  8  %%NUMBER09  9  %%NUMBER10  10  %%NUMBER11  11  %%NUMBER12  12  %%NUMBER13  13  %%NUMBER14  14  %%NUMBER15  15  %%NUMBER16  16  %%NUMBER17  17  %%NUMBER18  18  %%NUMBER19  19  %%NUMBER20  20  %%NUMBER21  21  %%NUMBER22  22  %%NUMBER23  23  %%NUMBER24  24  %%NUMBER26  25  %%NUMBER26  26  %%NUMBER27  27  %%NUMBER28  28  %%NUMBER29  29  %%NUMBER30  30  %%NUMBER31  31  \"},{\"id\":162,\"title\":\"Variable resolution examples\",\"url\":\"86494.htm\",\"text\":\"The following examples describe the date and time system variables, date variables with offset and Julian dates.  System variable - time (simple)  System variable - time (advanced)  System variable - date (simple)  System variable - date (advanced)  Date variable (user defined) with offset  Julian dates  \"},{\"id\":163,\"title\":\"System variable - time (simple)\",\"url\":\"86495.htm\",\"text\":\"Tidal variable: <SysTime.HH:mm:ss>  Converts to the following:  <VARIABLE NAME=\\\"%%RESULT_HH_mm_ss_SysTime\\\" VALUE=\\\"%%TIME\\\" />  <VARIABLE NAME=\\\"%%HH_HH_mm_ss_SysTime\\\" VALUE=\\\"%%SUBSTR %%RESULT_HH_mm_ss_SysTime 1 2\\\" />  <VARIABLE NAME=\\\"%%MM_HH_mm_ss_SysTime\\\" VALUE=\\\"%%SUBSTR %%RESULT_HH_mm_ss_SysTime 3 2\\\" />  <VARIABLE NAME=\\\"%%SS_HH_mm_ss_SysTime\\\" VALUE=\\\"%%SUBSTR %%RESULT_HH_mm_ss_SysTime 5 2\\\" />  <VARIABLE NAME=\\\"%%HH_mm_ss_SysTime\\\" VALUE=\\\"%%HH_HH_mm_ss_SysTime.:%%MM_HH_mm_ss_SysTime.:%%SS_HH_mm_ss_SysTime.\\\" />  If %%TIME = 141502 then:  %%HH_HH_mm_ss_SysTime = 14  %%MM_HH_mm_ss_SysTime = 15  %%SS_HH_mm_ss_SysTime = 02  Then %%HH_mm_ss_SysTime = %%HH_HH_mm_ss_SysTime.:%%MM_HH_mm_ss_SysTime.:%%SS_HH_mm_ss_SysTime.= 14:15:02  The dot (&#8216;.&#8217;) is a concatenation operator that concatenates a variable with some other string.  So %%VariableName.STRING will be resolved to VariableValueSTRING  If there is no string after the concatenation operator, it is removed so %%VariableName. will be resolved to VariableValue.  \"},{\"id\":164,\"title\":\"System variable - date (simple)\",\"url\":\"86497.htm\",\"text\":\"Tidal variable: <SysDate.mmddyy>  Converts to:  <VARIABLE NAME=\\\"%%RESULT_mmddyy_SysDate\\\" VALUE=\\\"%%$DATE\\\" />  <VARIABLE NAME=\\\"%%YYYY_mmddyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmddyy_SysDate 1 4\\\" />  <VARIABLE NAME=\\\"%%YY_mmddyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmddyy_SysDate 3 2\\\" />  <VARIABLE NAME=\\\"%%MM_mmddyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmddyy_SysDate 5 2\\\" />  <VARIABLE NAME=\\\"%%DD_mmddyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmddyy_SysDate 7 2\\\" />  <VARIABLE NAME=\\\"%%mmddyy_SysDate\\\" VALUE=\\\"%%MM_mmddyy_SysDate.%%DD_mmddyy_SysDate.%%YY_mmddyy_SysDate.\\\" />  When  %%$DATE = 20150506   Local variables are resolved to:   %%YYYY_mmddyy_SysDate  = 2015  %%YY_mmddyy_SysDate  = 15  %%MM_mmddyy_SysDate  = 05  %%DD_mmddyy_SysDate  = 06  Then %%mmddyy_SysDate => %%MM_mmddyy_SysDate.%%DD_mmddyy_SysDate.%%YY_mmddyy_SysDate.  %%MM_mmddyy_SysDate.%%DD_mmddyy_SysDate.%%YY_mmddyy_SysDate. => %%MM_mmddyy_SysDate.%%DD_mmddyy_SysDate.15  %%MM_mmddyy_SysDate.%%DD_mmddyy_SysDate.15 => %%MM_mmddyy_SysDate.0615  %%MM_mmddyy_SysDate.0615 => 050615  \"},{\"id\":165,\"title\":\"System variable - time (advanced)\",\"url\":\"86496.htm\",\"text\":\"Tidal variable: <SysTime.HmmAM/PM>  Converts to:  <VARIABLE NAME=\\\"%%RESULT_HmmAM_PM_SysTime\\\" VALUE=\\\"%%TIME\\\" />  <VARIABLE NAME=\\\"%%HH_HmmAM_PM_SysTime\\\" VALUE=\\\"%%SUBSTR %%RESULT_HmmAM_PM_SysTime 1 2\\\" />  <VARIABLE NAME=\\\"%%MM_HmmAM_PM_SysTime\\\" VALUE=\\\"%%SUBSTR %%RESULT_HmmAM_PM_SysTime 3 2\\\" />  <VARIABLE NAME=\\\"%%SS_HmmAM_PM_SysTime\\\" VALUE=\\\"%%SUBSTR %%RESULT_HmmAM_PM_SysTime 5 2\\\" />  <VARIABLE NAME=\\\"%%HmmAM_PM_SysTime\\\" VALUE=\\\"%%NUMBER%%HH_HmmAM_PM_SysTime..%%MM_HmmAM_PM_SysTime.%%AP%%HH_HmmAM_PM_SysTime..\\\" />  When %%TIME = 011703  Local variable is resolved to:  %%HH_HmmAM_PM_SysTime = 01  %%MM_HmmAM_PM_SysTime = 17  %%SS_HmmAM_PM_SysTime = 03  %%HmmAM_PM_SysTime => Resolving happens from right to left   %%NUMBER%%HH_HmmAM_PM_SysTime..%%MM_HmmAM_PM_SysTime.%%AP%%HH_HmmAM_PM_SysTime.. => %%NUMBER%%HH_HmmAM_PM_SysTime..%%MM_HmmAM_PM_SysTime.%%AP01.  %%NUMBER%%HH_HmmAM_PM_SysTime..%%MM_HmmAM_PM_SysTime.%%AP01. => %%NUMBER%%HH_HmmAM_PM_SysTime..%%MM_HmmAM_PM_SysTime.AM  %%NUMBER%%HH_HmmAM_PM_SysTime..%%MM_HmmAM_PM_SysTime.AM => %%NUMBER%%HH_HmmAM_PM_SysTime..17AM  %%NUMBER%%HH_HmmAM_PM_SysTime..17AM => %%NUMBER01.17AM  %%NUMBER01.17AM => 117AM  \"},{\"id\":166,\"title\":\"System variable - date (advanced)\",\"url\":\"86498.htm\",\"text\":\"Tidal variable: <SysDate.mmmm/d/yyyy>  Converts to:  <VARIABLE NAME=\\\"%%RESULT_mmmm_d_yyyy_SysDate\\\" VALUE=\\\"%%$DATE\\\" />  <VARIABLE NAME=\\\"%%YYYY_mmmm_d_yyyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmmm_d_yyyy_SysDate 1 4\\\" />  <VARIABLE NAME=\\\"%%YY_mmmm_d_yyyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmmm_d_yyyy_SysDate 3 2\\\" />  <VARIABLE NAME=\\\"%%MM_mmmm_d_yyyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmmm_d_yyyy_SysDate 5 2\\\" />  <VARIABLE NAME=\\\"%%DD_mmmm_d_yyyy_SysDate\\\" VALUE=\\\"%%SUBSTR %%RESULT_mmmm_d_yyyy_SysDate 7 2\\\" />  <VARIABLE NAME=\\\"%%mmmm_d_yyyy_SysDate\\\" VALUE=\\\"%%MMMM%%MM_mmmm_d_yyyy_SysDate../%%NUMBER%%DD_mmmm_d_yyyy_SysDate../%%YYYY_mmmm_d_yyyy_SysDate.\\\" />  When %%$DATE = 20141203   Local variables are resolved to the following:  %%YYYY_mmmm_d_yyyy_SysDate = 2014  %%YY_mmmm_d_yyyy_SysDate = 14   %%MM_mmmm_d_yyyy_SysDate = 12  %%DD_mmmm_d_yyyy_SysDate = 03  %%mmmm_d_yyyy_SysDate => %%MMMM%%MM_mmmm_d_yyyy_SysDate../%%NUMBER%%DD_mmmm_d_yyyy_SysDate../%%YYYY_mmmm_d_yyyy_SysDate.  %%MMMM%%MM_mmmm_d_yyyy_SysDate => %%MMMM12 => December  %%NUMBER%%DD_mmmm_d_yyyy_SysDate => %%NUMBER03 => 3  %%YYYY_mmmm_d_yyyy_SysDate => 2014  \"},{\"id\":167,\"title\":\"Date variable (user defined) with offset\",\"url\":\"86499.htm\",\"text\":\"Tidal variable: <DATE-PROD-PREV.1.mmdd> _1_mmdd_DATE-PROD-PREV  Converts to:  <VARIABLE NAME=\\\"%%INPUT_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%$DATE\\\" />  <VARIABLE NAME=\\\"%%OFFSET_VALUE_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"1\\\" />  <VARIABLE NAME=\\\"%%RESULT_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%$CALCDATE %%INPUT_1_mmdd_DATE-PROD-PREV -%%OFFSET_VALUE_1_mmdd_DATE-PROD-PREV\\\" />  <VARIABLE NAME=\\\"%%YYYY_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%SUBSTR %%RESULT_1_mmdd_DATE-PROD-PREV 1 4\\\" />  <VARIABLE NAME=\\\"%%YY_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%SUBSTR %%RESULT_1_mmdd_DATE-PROD-PREV 3 2\\\" />  <VARIABLE NAME=\\\"%%MM_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%SUBSTR %%RESULT_1_mmdd_DATE-PROD-PREV 5 2\\\" />  <VARIABLE NAME=\\\"%%DD_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%SUBSTR %%RESULT_1_mmdd_DATE-PROD-PREV 7 2\\\" />  <VARIABLE NAME=\\\"%%_1_mmdd_DATE-PROD-PREV\\\" VALUE=\\\"%%MM_1_mmdd_DATE-PROD-PREV.%%DD_1_mmdd_DATE-PROD-PREV.\\\" />  When %%$DATE = 20100908  %%RESULT_1_mmdd_DATE-PROD-PREV = %%$CALCDATE %%INPUT_1_mmdd_DATE-PROD-PREV -%%OFFSET_VALUE_1_mmdd_DATE-PROD-PREV  %%$CALCDATE %%INPUT_1_mmdd_DATE-PROD-PREV -%%OFFSET_VALUE_1_mmdd_DATE-PROD-PREV => %%$CALCDATE %%INPUT_1_mmdd_DATE-PROD-PREV -1  %%$CALCDATE %%INPUT_1_mmdd_DATE-PROD-PREV -1 => %%$CALCDATE 20100908 -1 = 20100907  %%$CALCDATE is an variable function that calculates date offsets in days.  NOTE: the offset value and operator (+ or -) is taken from VARMST_OFFSETS column. The conversion only supports tidal variables with offset of days and operators + or -.  Then %%YYYY_1_mmdd_DATE-PROD-PREV = 2010, %%YY_1_mmdd_DATE-PROD-PREV = 10, %%MM_1_mmdd_DATE-PROD-PREV = 09, %%DD_1_mmdd_DATE-PROD-PREV = 07  Then %%_1_mmdd_DATE-PROD-PREV => %%MM_1_mmdd_DATE-PROD-PREV.%%DD_1_mmdd_DATE-PROD-PREV.  %%MM_1_mmdd_DATE-PROD-PREV.%%DD_1_mmdd_DATE-PROD-PREV. => %%MM_1_mmdd_DATE-PROD-PREV.07  %%MM_1_mmdd_DATE-PROD-PREV.07 => 0907  \"},{\"id\":168,\"title\":\"Julian dates\",\"url\":\"86500.htm\",\"text\":\"Tidal variable: <SysDate.jj>   Converts to:  <VARIABLE NAME=\\\"%%SHORT_JULDAY_jj_SysDate\\\" VALUE=\\\"%%JULDAY %%MINUS 0\\\" />  <VARIABLE NAME=\\\"%%jj_SysDate\\\" VALUE=\\\"%%SHORT_JULDAY_jj_SysDate.\\\" />  Then %%jj_SysDate => %%SHORT_JULDAY_jj_SysDate.  %%SHORT_JULDAY_jj_SysDate. => %%JULDAY %%MINUS 0  %%JULDAY %%MINUS 0 => 008 %%MINUS 0  %%MINUS is a variable function that subtracts two numbers. We use it here to eliminate the leading zeros.  008 %%MINUS 0=> 8  NOTE: In Tidal the format jj should have a single leading zero in this example. So it is not a perfect conversion of Tidal behavior. However the format j works ok (same solution as above) and the format jjj will just be converted to %%JULDAY.  The string \'jj_SysDate\' is just a unique number to avoid overriding each other&#8217;s values.  \"},{\"id\":169,\"title\":\"ASG Zena\",\"url\":\"99703.htm\",\"text\":\"The following topics describe how to extract Zena data, define a new project, and additional settings:  Zena conversion environment configuration  Defining a new ASG Zena project  Setting additional Zena rules  \"},{\"id\":170,\"title\":\"ASG Zena data extraction\",\"url\":\"46106.htm\",\"text\":\"You need to extract ASG Zena (Zena) data if you want to manually import your data before setting up a conversion project.  The following procedures describe how to extract Zena data depending on whether you are running an Oracle SQL Developer or an MSSQL Server.  Extracting Zena data on an Oracle SQL Developer  Extracting Zena data on an MSSQL Server  \"},{\"id\":171,\"title\":\"Extracting Zena data on an Oracle SQL Developer\",\"url\":\"46085.htm\",\"text\":\"This procedure describes how to extract Zena data on an Oracle SQL Developer. Before starting a new conversion project, you need to extract Zena data by setting up definitions and agents tables in the Zena environment.   To configure Zena:  Log in to the database and type your database name.  Select the following tables:  definitions  agents  Right click and select Export.  From the Export window, do the following:  Uncheck the Export DDL checkbox.  Check the Export data checkbox  From the Format list select csv.  From the Save As list select Separate Files.  From the File box enter the location where the export file is to be created.  Click Next, then Next and Finish.  Open the Conversion Tool and import the data, as described in Defining a new ASG Zena project.  \"},{\"id\":172,\"title\":\"Extracting Zena data on an MSSQL Server\",\"url\":\"46105.htm\",\"text\":\"This procedure describes how to extract Zena data on an MSSQL Server. Before starting a new conversion project, you need to set up definitions and agents tables using the Zena MSSQL Server.   To extract Zena data:  From the <Conversion Home>/scripts/<Zena> directory, type the following command:  zena_MsSQL_export -U <username> -P <password> -S <database server> -D <database/schema name>   NOTE: You do not have to insert <tables list> as a table default value is set to run conversion. Once you run the command, a batch script that exports the table from the Zena MSSQL server.  Open the Conversion Tool and import the data, as described in Defining a new ASG Zena project.  \"},{\"id\":173,\"title\":\"Defining a new ASG Zena project\",\"url\":\"46024.htm\",\"text\":\"This topic describes how to define a new ASG Zena (Zena) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report. You can either import the data by extracting the files manually or automatically extracting the files from the Zena database into the Conversion Tool without having to configure your environment.   Before you begin  Ensure the following:  (Manual import only) Export your Zena data, as described in Zena conversion environment configuration.  Create a new project, as described in Running a new conversion project.  To define a new Zena conversion project:  From the Zena Load Data window, select one of the following:  Automatic: Enables you to automatically import the data from the Zena database by doing the following:  Complete the Automatic import scheduling data parameters.  The following table describes the automatic import scheduling data parameters for Redwood CPS.  Parameter  Description  Type  Defines the database type. From the dropdown list select either Oracle or MSSQL.  Host name  Defines the host name for the database.  User name  Defines the user name for the database.  Password  Defines the password for the database.  Port  Defines the port number. For MSSQL, a default value appears.  Database server  Defines the database server or service name.  Schema name  Defines the database Schema Name (optional). A schema name is needed if no Database owner credentials are entered.  (Optional) Click Test to test the connection to the database.  Manual: Enables you to manually import the data by adding the following files:   Agents table:(Mandatory)  Click @ to locate the Agents table.  Definitions table: (Mandatory) Click @ to locate the definitions table.  Folders table: (Optional) Click @ to locate the definitions table.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see: Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":174,\"title\":\"Setting additional Zena rules\",\"url\":\"46052.htm\",\"text\":\"This procedure describes how to set additional Zena rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional Zena rules:  In the General area, select or modify the options that you want:  First day of the week: Defines the first day of the week of your Control-M work environment.  Keep active for: Defines the maximum number of days that a Control-M job can wait for execution after order date (default: 0). Valid values:  0-99 (integer).  Do not convert Terminator to Control-M job: Prevents you from creating a Control-M job from a Terminator.  Ignore deprecated scheduling definitions: Enables Control-M to ignore a scheduling rule if it contains an until date, which occurs in the past.  Convert sub process to ordering job: Enables Control-M to covert a Zena sub process to a Control-M ordering job.  In the Conditions area, select one of the following condition names:  JOBA-TO-JOBB: Enables you to define how two jobs are connected by creating a unique condition in the format: CID<Unique number>@JOBA@JOBB.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  JOBA-ENDED-<Status>: Enables you to set a dependence condition between many jobs according its end status.    For more details see Job Dependencies in Using Control-M.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":175,\"title\":\"Hadoop - Oozie\",\"url\":\"99706.htm\",\"text\":\"The following topics describe how to extract Hadoop - Oozie data, define a new project, and additional settings:  Extracting Hadoop - Oozie data  Defining a new Hadoop - Oozie project  Setting additional Hadoop - Oozie rules  \"},{\"id\":176,\"title\":\"Extracting Hadoop - Oozie data\",\"url\":\"95543.htm\",\"text\":\"This procedure describes how to manually extract Hadoop - Oozie data before starting a new project. After extracting data, you can then define a new conversion project.  To extract Hadoop-Oozie data:  Create the following files:  coordinator.xml: Converts to a SMART folder in Control-M. Each action in the Coorindator XML is converted to a Sub Folder which is created from the corresponding workflow.  workflow.xml: Holds the Hadoop execution types (such as Map/Reduce, sqoop, Pig, Hive) that converts to Control-M for Hadoop jobs.  bundle.xml: Enables you to batch a set of coordinator applications.  bundle.properties: Holds the variables and its values.  Open the Conversion Tool and import the data, as described in Defining a new Hadoop - Oozie project.  \"},{\"id\":177,\"title\":\"Defining a new Hadoop - Oozie project\",\"url\":\"36413.htm\",\"text\":\"This topic describes how to define a new Hadoop - Oozie conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.  Before you begin  Create a new conversion project, as described in: Creating a new conversion project.  To define a new Hadoop - Oozie project:  From the Hadoop - Oozie Load Data window, in the Import Scheduling Data area, select one of the following options:  Import data automatically: Enables you to retrieve data from the file system where Hadoop - Oozie is running. Complete the following mandatory parameters:  Host name  SSH Port number  User name  Password  Import data manually: Enables you to retrieve data from local files.  (Import data automatically only) If you want to test the connection, do the following:  Click Test Connection.   A confirmation window appears.  Click OK.  Click Next.  Continue with one of the following procedures:  Importing data automatically to a Hadoop - Oozie conversion project  Importing data manually to a Hadoop - Oozie conversion project  \"},{\"id\":178,\"title\":\"Importing data automatically to a Hadoop - Oozie conversion project\",\"url\":\"38749.htm\",\"text\":\"This procedure describes how to import data automatically to a Hadoop - Oozie conversion project.  For more information about defining a new Hadoop - Oozie conversion project, see Defining a new Hadoop - Oozie project. You can add data from multiple locations and users.  To import data automatically to a Hadoop - Oozie conversion project:  In the Hadoop - Oozie - Load Data window, click Add.  The Choose Hadoop - Oozie data files window appears.  Select the file and click Open.  Repeat steps 1 and 2 as needed.  To delete an entry from the table, click the entry, and then click Delete.  When you have completed entering all of the locations that you want, click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":179,\"title\":\"Importing data manually to a Hadoop - Oozie conversion project\",\"url\":\"38750.htm\",\"text\":\"This procedure describes how to import data manually to a Hadoop - Oozie conversion project.  For more information about defining a new Oozie conversion project, see Defining a new Hadoop - Oozie project. You can add data from multiple locations and users.  Before you begin  Ensure that you have extracted your Hadoop - Oozie data as described in Extracting Hadoop - Oozie data.  To import data manually to a Hadoop - Oozie conversion project:  In the Hadoop - Oozie - Load Data window, click Add.  The Choose Hadoop - Oozie Data Directory window appears.  Select the Hadoop - Oozie files that you have already extracted and click Open.  NOTE: To delete an entry from the table, click the entry, and then click Delete.  When you have completed entering all of the locations that you want, click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  NOTE: If you want to import data automatically, see Importing data automatically to a Hadoop - Oozie conversion project.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":180,\"title\":\"Setting additional Hadoop - Oozie rules\",\"url\":\"38745.htm\",\"text\":\"This procedure describes how to set additional Hadoop - Oozie rules.  After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Modifying conversion settings.  To set additional Hadoop - Oozie rules:  In the General area, select or modify the options that you want:  First day of the week: Defines the first day of the week of your Control-M work environment.  Keep active for: Defines the maximum number of days that a Control-M job can wait for execution after order date (default: 3). Valid values:  0-99 (integer).  In the Conditions area, select one of the following condition names:  JOBA-TO-JOBB: Enables you to define how two jobs are connected.  Select the Cleanup conditions check box to delete the condition after the next job has finished running.  JOBA-ENDED-<Status>: Enables you to set a dependence condition between many jobs according its end status.    For more details see Job Dependencies in Using Control-M.  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion results .  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  \"},{\"id\":181,\"title\":\"IBM Sterling Connect:Direct\",\"url\":\"99710.htm\",\"text\":\"The following topics describe how to define a new project, additional settings, and mapping IBM Sterling Connect:Direct jobs:  Defining a new IBM Sterling Connect:Direct project  IBM Sterling Connect:Direct mapping  \"},{\"id\":182,\"title\":\"Defining a new IBM Sterling Connect:Direct project\",\"url\":\"83536.htm\",\"text\":\"This topic describes how to define a new IBM Sterling Connect:Direct project. You can analyze the complexity of the conversion project by viewing the assessment report.   Before you begin  Create a new project as described in Running a new conversion project.  To define a new IBM Sterling Connect:Direct conversion project:  From the Sterling Connect:Direct - Load Data window, in the Process files directory field, click @ to locate the path that contains process files.  Click Import.  The data is loaded into the Conversion Tool and in the Assessment Report window, a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":183,\"title\":\"IBM Sterling Connect:Direct mapping\",\"url\":\"87600.htm\",\"text\":\"The conversion from IBM Sterling Connect:Direct (C:D) is based on having input C:D process files that contain all the file transfer logic (such as source host, target host , file to transfer etc.) and reside in your file system.  If C:D file transfers are triggered within scripts, obtains file transfer parameters from outside scripts, and dynamically creates C:D process files you need to replace all the jobs that calls those scripts with the File transfer job template that use those parameters.    The following table describes how the Conversion Tool converts job types, files, statements and parameters from IBM Sterling Connect:Direct to Control-M:  IBM Sterling Connect:Direct  Control-M  Process Files  SMART folders containing Managed File Transfer (MFT) jobs (and Dummy jobs)  COPY statements  MFT jobs  RUN statements  Dummy jobs  SUBMIT statements  Dummy jobs  GOTO, IF, EIF, EXIT, SYMBOL statements  Not converted and must be manually handled.  The Conversion Tool issues a warning message if those statements exist in the Process files.  COPY FROM and TO parameters\\t  MFT FTP-LPATH1 and FTP-RPATH1 job parameters (the source and destination locations on the host computers) corresponding to which one is defined as the PNODE (Primary node) and SNODE (Secondary node) in IBM Sterling Connect:Direct.  PNODE (Primary node) and SNODE (Secondary node)  The conversion specifies a connection profile name consisting of a combination of a PNODE and SNODE separated by a dash. The user needs to create the Connection profiles in the Control-M Configuration Manger and chose them manually from the MFT jobs created by the Conversion Tool.    \"},{\"id\":184,\"title\":\"SAP\",\"url\":\"99704.htm\",\"text\":\"The following topics describe how to extract SAP data, define a new project, and  additional settings:  SAP data extraction  Defining a new SAP Conversion project  Setting additional SAP rules  \"},{\"id\":185,\"title\":\"SAP data extraction\",\"url\":\"34895.htm\",\"text\":\"You need to import your data either automatically or manually before you can define a SAP conversion project. If you want to import data automatically you need to download SAP Java connector files. If you want to import data manually you need to use the Control-M SAP jobs extractor.    After you have imported your data you can define a new SAP conversion project. For more information, see Defining a new SAP Conversion project.  The following topics describe how to download the SAP Java connector files and how to use the Control-M SAP job extractor:  Downloading the SAP Java Connector files  Manually extracting SAP jobs using the BMC Control-M SAP jobs extractor  \"},{\"id\":186,\"title\":\"Downloading the SAP Java Connector files\",\"url\":\"34896.htm\",\"text\":\"This procedure describes how to download the required SAP Java Connector files so that you can import your data automatically to Control-M.   To download the SAP Java Connector library files:  Download the sapjco3.jar and sapjco3.dll C library files from http://service.sap.com/connectors.  In the left pane, under Connectors, click SAP Java Connector and then click Tools & Services.  In the right pane, under SAP Java Connector (SAP JCo), click the quick link to download SAP JCo Release 3.x.  Download the sapjco3.jar and sapjco3.dll C library files from that section.  NOTE: Ensure that you download the appropriate files for your computer architecture (32 bit or 64 bit).  Copy the sapjco3.jar and sapjco3.dll C library files to the following directory:  <Conversion Home>\\\\lib  (Windows only) Obtain and install the Visual Studio .Net C/C++ runtime libraries required by JCo.  For more information about how to obtain and install the Visual Studio runtime libraries, see the Support and Release Strategy section in the SAP Java Connector download page.   NOTE: Starting with JCo 3.0.00, JCo running on Windows requires the Visual Studio 2005 C/C++ runtime libraries. See SAP note 684106 for details on how to install them.  After adding the files, restart the Conversion Tool (if open) and continue with automatic data import.  \"},{\"id\":187,\"title\":\"Manually extracting SAP data using the Control-M SAP jobs extractor\",\"url\":\"35657.htm\",\"text\":\"This procedure describes how to extract SAP data using the Control-M SAP jobs extractor so that you can import your data manually to Control-M.  To extract SAP data:  Extract the BMC Control-M SAP jobs extractor.zip file from the following location:  <Conversion Home>\\\\scripts\\\\SAP\\\\BMC_CONTROL-M_SAP_jobs_extractor.zip  Download the sapjco3.jar and sapjco3.dll C library files from http://service.sap.com/connectors.  In the left pane, under Connectors, click SAP Java Connector and then click Tools & Services.  In the right pane, under SAP Java Connector (SAP JCo), click the quick link to download SAP JCo Release 3.x.  Download the required files from that section and copy the sapjco3.jar and sapjco3.dll C library files to the following path:  <BMC Control-M SAP Jobs extractor folder>  Run the sapextgui.cmd command.  The BMC Control-M SAP Jobs Extractor window appears.  In the SAP Connection field, complete the SAP parameters.  NOTE: To test the connectivity to the SAP system, click Test Connection.  In the Jobs Filter field, complete the mandatory parameters:  Job Name  User Name  Job Status  NOTE: The remaining parameters are optional. \\\"*\\\" characters can be used for Job Name and Job Count.   Once the data is completed you can save the file and retrieve it at later stage by using the Load Rule File and Save Rule File buttons.  To extract jobs, click Get Jobs.  A confirmation message appears.  Click Yes.  NOTE: When jobs have extracted successfully, the bar at the bottom of the screen reaches 100% and a confirmation message appears.  To save the output file click Yes.  The jobs have been successfully extracted.  Open the Conversion Tool and import the data, as described in Defining a new SAP Conversion project.  \"},{\"id\":188,\"title\":\"Defining a new SAP Conversion project\",\"url\":\"34917.htm\",\"text\":\"This topic describes how to define a new SAP conversion project. You can analyze the complexity of the conversion project by viewing the assessment report.   NOTE: When defining a new project, in the Description field, it is recommended to type a change or service ticket number for audit or life cycle change management purposes.  Before you begin  Ensure that you do the following:  Extract SAP data, as described in SAP conversion project configuration.  Create a new conversion project, as described in Running a new conversion project.  To define a new SAP conversion project:  From the SAP - Load Data window, in the Import Scheduling Data area, select one of the following options:  Import data automatically: Retrieves data from the SAP environment. Complete the following SAP parameters:  Host name  System number  Client number  User name  Password  For more information, see Set Connection details parameters for specific application server in Control-M For SAP Administrator Guide.  Import data manually: Imports files using the BMC Control-M SAP jobs extractor.  (Import data automatically only) If you want to test the connection, do the following:  Click Test Connection.   A confirmation window appears.  Click OK.  Click Next.  Continue with one of the following procedures:  Importing data automatically to SAP conversion project  Importing data manually to SAP conversion project  \"},{\"id\":189,\"title\":\"Importing data automatically to SAP conversion project\",\"url\":\"34919.htm\",\"text\":\"This procedure describes how to import data automatically to a SAP conversion project.   Before you begin  Ensure that you have defined a new SAP Conversion project, as described in Defining a new SAP Conversion project.  To import data automatically to a SAP conversion project:  From the SAP - Load Data window, in the General area complete the following fields:  Job Name: Defines the name of the job to be imported. Wildcards enabled. Mandatory.  User Name: Defines the job owner in SAP. Wildcards enabled. Mandatory.  Job Count: Defines a unique SAP job ID number.  From/To Date: Defines the scheduled start and end time for the SAP jobs to be imported.  After Events: Enables you to select a filter to run a SAP job that has a specific after command it is definition.  In the Statuses field select one of the SAP job status.   NOTE: At least one status must be selected. If you select Finished status, a substantial amount of jobs may be extracted since the system became active.  Click Import.  The data is loaded into the Conversion Tool and a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue to convert your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":190,\"title\":\"Importing data manually to SAP conversion project\",\"url\":\"34920.htm\",\"text\":\"This procedure describes how to import data manually to a SAP Conversion project. You can add data from multiple locations and users.  Before you begin  Ensure the following:   (Manual import only) Extract SAP data, as described in SAP data extraction.  Define a new SAP Conversion project, as described in Defining a new SAP Conversion project.  To import data manually to a SAP conversion project:  In the SAP - Load Data window, click Add.  The Choose SAP Data file dialog box appears.   Select the file and click Open.  Repeat steps 1 and 2 as needed.  To delete an entry from the table, click the entry, and then click Delete.  Click Import.  The data is loaded into the Conversion Tool and a summary of the imported data appears. For more information, see Evaluate data.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue to convert your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":191,\"title\":\"Setting additional SAP rules\",\"url\":\"35656.htm\",\"text\":\"This procedure describes how to set additional SAP rules.   After you have imported your data, you can modify conversion rules by setting general rules and Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional SAP rules:   From the General area, select the parameters you require, as described in SAP additional general rules parameters.  The following table describes the SAP additional general rules parameters.  Parameter  Description  Default account  (Mandatory) Defines the connection profile name, which appears in the Connection Profile field in the Job Properties pane in Control-M.  By adding a Default account value, the connection profile is automatically added to a Control-M for SAP R/3 job.   NOTE: You still need to define the connection profile in the Control-M Configuration Manager (CCM).  Default target server  Defines the default target server. By adding a default target server value, this value appears in the Exec. Target field in the Job Properties pane in Control-M client. If unspecified, SAP determines a parameter value during runtime.  NOTE: If you want to change the target server to group, after loading the converted data into Control-M, in Control-M client use the find and update feature to search for the target server and replace it with group.  First day of the week  Defines the first day of the week of your Control-M work environment.  Set starting condition from Event id and parameters  Converts the SAP job Event ID and EVENT param to the After event parameter in the Start Condition field in the Job Properties Pane in Control-M.   NOTE: When the check box is selected, if the Event ID is SAP_END_OF_JOB, a Control-M condition is created between the predecessor and the successor jobs.  Include periodic values  Indicates whether SAP periodic values should be converted to Control-M cyclic values.  Convert SAP planned start date/time to Control-M SAP jobs  Converts SAP Application jobs start date and/or time to Control-M for SAP start date and/or time.   In the Job mode area select one of the following:  Copy: Copies an existing job in SAP, which enables you to set the job count setting from the drop-down list.  Create: Creates a new SAP job  Click Next to start the conversion.  A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in Conversion.  NOTE: The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the Run Conversion window. You can use these rules in future conversions.  After jobs have been converted to Control-M, jobs that are defined on the SAP system still run. These jobs need to be disabled.  \"},{\"id\":192,\"title\":\"SAP additional general rules parameters\",\"url\":\"89608.htm\",\"text\":\"The following table describes the SAP additional general rules parameters.  Parameter  Description  Default account  (Mandatory) Defines the connection profile name, which appears in the Connection Profile field in the Job Properties pane in Control-M.  By adding a Default account value, the connection profile is automatically added to a Control-M for SAP R/3 job.   NOTE: You still need to define the connection profile in the Control-M Configuration Manager (CCM).  Default target server  Defines the default target server. By adding a default target server value, this value appears in the Exec. Target field in the Job Properties pane in Control-M client. If unspecified, SAP determines a parameter value during runtime.  NOTE: If you want to change the target server to group, after loading the converted data into Control-M, in Control-M client use the find and update feature to search for the target server and replace it with group.  First day of the week  Defines the first day of the week of your Control-M work environment.  Set starting condition from Event id and parameters  Converts the SAP job Event ID and EVENT param to the After event parameter in the Start Condition field in the Job Properties Pane in Control-M.   NOTE: When the check box is selected, if the Event ID is SAP_END_OF_JOB, a Control-M condition is created between the predecessor and the successor jobs.  Include periodic values  Indicates whether SAP periodic values should be converted to Control-M cyclic values.  Convert SAP planned start date/time to Control-M SAP jobs  Converts SAP Application jobs start date and/or time to Control-M for SAP start date and/or time.   \"},{\"id\":193,\"title\":\"Control-M OS to Application Jobs\",\"url\":\"99713.htm\",\"text\":\"The following topics describe how to define a new project, and additional settings:  Control-M OS to Application Jobs  \"},{\"id\":194,\"title\":\"Control-M OS to Application Jobs overview\",\"url\":\"88783.htm\",\"text\":\"Control-M OS to Application Jobs enables a mass update at Control-M flow level, which finds jobs according to specified criteria and replaces them with user defined Control-M job or jobs. Rather than search, add, or replace each job manually in Control-M, Control-M OS to Application Jobs enables you to update automatically the whole job flow in one go.   For more information about updating the job flow using Control-M OS to Application Jobs, see Updating a Control-M job flow.   You can use this feature for a number of different applications. For example, you can replace Control-M OS Jobs that call scripts to trigger File transfer using IBM Sterling Connect:Direct API with Control-M File Transfer jobs. You can also use this feature when converting from an OS job running an Informatica job to a Control-M for Informatica job type. For an example that calls scripts to trigger a file transfer using IBM Sterling Connect:Direct API with Control-M File Transfer jobs , see Control-M OS to Application Jobs example.  After running the Conversion Tool, Control-M OS to Application Jobs updates the Control-M input data and replaces all jobs that meets the search criteria with the new Control-M data provided. The data is then loaded into Control-M and a new Workspace is created, containing the new job flow. For more information about loading data into Control-M, see Loading validated conversion results to Control-M. If you want to attach the replaced job Task Type information (command, Script, Embedded) with the new sub folder description when loading data into Control-M, select the check box, as described in Setting additional Control-M OS to Application Jobs rules.  NOTE: Control-M OS to Application Jobs copies variables from the replaced folder into the new injected folder. When one of the jobs in the injected folder uses those variables from within a Script or Embedded Script, for those variables to be available for use within the script during the execution in the Agent, a Control-M/Server option must be set. You should use the Control-M Configuration Manager to change the value of each relevant Control-M Server System Parameter VARIABLE_INC_SEC in the Scheduling and execution section from default LOCAL to the value GROUP. Using those variables in the MFT/AFT Panel fields does not require the above setting.  \"},{\"id\":195,\"title\":\"Converting from OS to Application Job\",\"url\":\"88784.htm\",\"text\":\"This procedure describes how to convert from OS to an Application job.  Before you begin  Do the following:  Ensure that you export to an XML file both the job flow Workspace you want to update and the Workspace containing the new job flow.  NOTE: This Workspace containing the new job flow is specifically created for this purpose.  You have created a new project as described in Running a new conversion project.  To convert from OS to an Application Job:  From the Control-M OS to Application Jobs - Load Data window, in the Import Scheduling Data area, complete the following fields:  Control-M Input data: Click @ to locate the job flow Workspace XML file you want to update.  Control-M field: Select the field you want to find and replace in the job flow  Value contains: Type the value of the Control-M field that you want to find and replace in the job flow  Control-M data to insert: Click @ to locate the Workspace XML file containing the new job flow you want to add.  Click Import.  The data is loaded into the Conversion Tool.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":196,\"title\":\"Control-M OS to Application Jobs example\",\"url\":\"88974.htm\",\"text\":\"You have a Control-M OS job, called, TransferFile that calls a script to trigger a File transfer using IBM Sterling Connect:Direct API (Direct) and you want to replace it with a Control-M Managed File Transfer job. You need to do the following:  Export the Control-M Data containing the OS jobs to XML. (Control-M Input data)  Build a Control-M flow that replaces the script logic. It can be one Managed File Transfer job flow or a flow of jobs. Export it to XML. (Control-M data to insert)  In Control-M OS to Application Jobs, in the Control-M field, select File Name and in the Value field select ConnectDirect.bat.  Run Control-M OS to Application Jobs. Control-M OS to Application Jobs converts all Control-M OS jobs that has the ConnectDirect.bat in the file name with the Control-M data to insert provided in step 2.   The new job flow appears below:  \"},{\"id\":197,\"title\":\"Setting additional Control-M OS to Application Jobs rules\",\"url\":\"88831.htm\",\"text\":\"After you have loaded the new Workspace into Control-M you can view the command line, embedded script file name or script file name, and the file path that was replaced in the description of the sub-folder in the Workspace in Control-M.  This procedure describes how to set this rule.  NOTE: After you have imported your Workspace into the Conversion Tool, you can modify conversion rules by setting Field Editor rules. For more information about modifying setting and rules, see Selecting or creating a conversion rules file.  To set additional Control-M Flow Update rules:   From the Additional Flow Update Rules tab, select the Append replaced job Task Type (command, Script, Embedded) data to the equivalent sub folder description.  NOTE: This rule is checked by default.  A message appears confirming that the update is in progress. The results appear in the Conversion Results window, as described in Conversion.  \"},{\"id\":198,\"title\":\"Conversion process overview\",\"url\":\"99722.htm\",\"text\":\"The following sections describe the conversion process overview:  Project selection  Data evaluation  Data conversion  Data validation  \"},{\"id\":199,\"title\":\"Project selection\",\"url\":\"Capturing_data_step.htm\",\"text\":\"In the Projects step, you import scheduling definitions and associated files from your source scheduler into the Conversion Tool. The data is used in the next steps of the conversion procedure, or can be saved in a file for conversion later.  When starting the Projects step, you can choose one of the following options:  Create a new project: Enables you to select the source scheduler or application and the data that you want to convert to the Control-M environment. Importing data is vendor specific.   You can also define a new Validation conversion project, which enables you to validate a draft file that was not created using the Conversion Tool. For example, this enables Mainframe conversions to use the Forecast Tool in Control-M. After loading the file into the Conversion tool, you can then proceed to validate the data and/or load into Control-M. For more information, see Defining a new Validation project.  Use an existing project: Enables you to use data that was imported previously. You can run a conversion project using the same data multiple times. Each time that you run the conversion project, you can resolve warning or error messages using the reports generated by the Conversion Tool.  Use a demo project: Enables you to run a project. You can use an existing demo data to see how data is converted and imported into Control-M.  After creating a conversion project, in the Data Import window, you can view a data report that contains an overview of the imported data. You can reload data if you want to change any data that has been imported.  \"},{\"id\":200,\"title\":\"Creating a new Conversion Tool project\",\"url\":\"Run_new_conv_project.htm\",\"text\":\"In the first step of Project phase, you can choose to either create a new conversion project or load an earlier conversion project that was created previously.    For more information, see Capturing data.  Before you begin  Export your data (where relevant), as described in Conversion project configuration.  To start a new conversion project:  In the Projects window, select Create New.  The Projects Characteristics window appears.  Type the following:   (Mandatory) Project name: Defines the name of the conversion project.  (Optional) Project description: Describes the conversion project.  In Project Type, select a scheduler, application or other type.   Click Create.  \"},{\"id\":201,\"title\":\"Defining a new Validation project\",\"url\":\"60057.htm\",\"text\":\"This procedure describes how to define a new Validation conversion project, which enables you to validate a draft file that was not created using the Conversion Tool. For example, this enables Mainframe conversions to use the Forecast Tool in Control-M.    Before you begin  Ensure the following:  Export your data to a Control-M XML file.  Create a new project as described in Running a new conversion project.  To define a new validation project:  From the Validation - Load Data window, in the Import Scheduling Data area, complete the following fields:  (Mandatory) Draft file: Click @ to locate the exported Control-M definitions file.  Calendar file: Click @ to locate the Control-M calendars file.  Click Import.  The data is loaded into the Conversion Tool.  Do one or more of the following:  Validate your data, as described in Validation.  Load data into Control-M, as described in Loading to Control-M.  \"},{\"id\":202,\"title\":\"Using an existing conversion project\",\"url\":\"Run_existing_conv.htm\",\"text\":\"In the first step of the conversion process, you can choose to load a conversion project that you saved previously.   To use an existing conversion project:  In the Projects window, from the Existing project tab, select the required conversion project from the list.  If you have already imported data, the Assessment Report window appears or if you have not already imported data, the Load Data window appears.   NOTE: In the Assessment Report window, on the left hand side of the window you can filter and search for data, such as jobs and calendars. On the right hand side of the window is a summary of the data that has been imported.   If you have not already imported data, or want to reload data, see Running a new conversion project.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":203,\"title\":\"Using a demo project\",\"url\":\"46030.htm\",\"text\":\"The following procedure describes how to use a demo project so that you can use existing demo data to see how data is converted and imported into Control-M without having to run one of your jobs.  To use a demo project:  In the Projects window, from the Demo projects tab, select the required conversion project from the list.  The Assessment Report window appears together with a summary of the imported data.  NOTE: On the left hand side of the window you can filter and search for data, such as jobs and calendars. On the right hand side of the window is a summary of the data that has been imported.  Click Next.  The Run Conversion window appears.  Select Run conversion or Load existing conversion results.   For more information about running conversion, see Conversion project results.  Click Next.  The Conversion Settings window appears.  Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in Conversion Rules.   \"},{\"id\":204,\"title\":\"Data evaluation\",\"url\":\"46358.htm\",\"text\":\"You can evaluate your imported data in the Assessment Report window. After you have loaded your data into the Conversion Tool, a summary of the data appears in the Assessment Report window.  NOTE: The Assessment Report is blank until you load your data into the Conversion Tool.  On the left-hand side of the window you can filter and search for data, such as jobs and calendars. On the right hand side of the window is a summary of the data that has been imported. The data uses the same terminology as your scheduling environment. It is recommended that you evaluate the data to see that everything has been imported correctly. You can view the Assessment report in a separate window by clicking on Open in a new window.   If you wish to change the data that has been imported, see Reloading data. If you are satisfied with the Assessment Report, click Next to continue.  \"},{\"id\":205,\"title\":\"Reloading data\",\"url\":\"46359.htm\",\"text\":\"This procedure describes how to reload data after you have imported the data into the Conversion Tool.  Before you begin  Ensure that you have selected a project, as described in Project selection.  To reload data:  From the <project name> Assessment Report window click Reload Data.  The <project name> Load Data window appears.  Continue with step 5 in Creating a new conversion project.  NOTE: Reloading data overrides the current project and any conversion.  \"},{\"id\":206,\"title\":\"Data conversion\",\"url\":\"Conv_project_results.htm\",\"text\":\"You can run a conversion project using the same data multiple times. Each time that you run the conversion project, you can resolve warning or error messages using the reports generated by the Conversion Tool. After you have imported your data into the Conversion Tool, to start the conversion process do one of the following:  Run conversion: Enables you to run a new conversion by using the data that you have imported into the Conversion Tool. You can change the conversion rules before executing the conversion, so you can manipulate the result. To run the conversion, see Rerunning a conversion.   Loading existing conversion results: Enables you to view the conversion results by loading from an existing conversion. A conversion is not executed, as you load conversion results that have been saved previously. You can view the conversion rules that you used during conversion, and the conversion report, before proceeding to the validation phase. To load an existing conversion results file, see Running an existing conversion project.  After you have started the conversion process you can then change the conversion settings, as described in Conversion Rules.  \"},{\"id\":207,\"title\":\"Running a conversion project\",\"url\":\"Rerun_conv.htm\",\"text\":\"This procedure describes how to rerun a conversion project.   For more information, see Run conversion.  To rerun a conversion:  In the Conversion Project window, select Run conversion, and complete the following fields:  Conversion Result name (mandatory)  Conversion result description  Click Next.  The Conversion Settings window appears.  Continue with Conversion settings.  \"},{\"id\":208,\"title\":\"Using existing conversion results\",\"url\":\"Using_exist_conv_results.htm\",\"text\":\"This procedure describes how to use an existing conversion results file.   For more information, see Run conversion.  To use existing conversion results:  In the Run Conversion window, select Load existing conversion results.   Select the conversion results file that you want to load.  Click Next.  The Conversion Settings window appears.  NOTE: You can only view the Conversion settings. If you want to change settings, click Back and select Run Conversion.  Click Next.  Continue with Conversion results .  \"},{\"id\":209,\"title\":\"Conversion settings\",\"url\":\"Conv_rules_step.htm\",\"text\":\"In the Conversion Settings step, you enter information for the conversion project results file, and select a set of conversion rules that are applied during the conversion. The Conversion Tool provides a default set of conversion rules that you can use for standard conversion scenarios. You can modify the conversion results by changing the conversion rules to customize how your data is converted. You can create a set of rules, import a set of rules, edit an existing set of rules, or delete a set of rules.  NOTE: For Control-M OS to Application Jobs, some rules are disabled.  You can save a set of conversion rules and use them for future conversions.  Rules enable you to:  Filter jobs to either include or exclude them from the conversion results  Select the type of Control-M job to which you want to convert your data  Edit Control-M field values  Select options specific to the source scheduler from which you are converting  Map the scheduler\'s parameters to the Control-M parameters  Specify additional scheduling definitions  The following sections describe how to modify settings and rules, set general rules and fields:  Selecting or creating a conversion rules file  Setting General rules  Setting Fields Editor rules  You can also set additional rules for each project by selecting the relevant tab.   When you click Next, the conversion process starts and the conversion results are saved in the file name that you entered.   NOTE: When you are converting large data, you can cancel loading the conversion results by clicking Cancel on the progress bar, which enables you to continue with conversion without waiting Conversion Tool to finish analyzing the data.  \"},{\"id\":210,\"title\":\"Modifying conversion settings\",\"url\":\"Select_create_conv_rules.htm\",\"text\":\"This procedure describes how to modify conversion settings. You can save your conversion results and the name of the Control-M/Server that you are using. You can also create a conversion rules file, or select an existing one.  To modify conversion rules:  In the Conversion Settings field, from the drop-down list select the following conversion rules that you want to use for this conversion:  Standard Rules: Enables you to use the standard rules of your scheduling environment.  Import from File: Enables you to Load conversion rules that have been previously defined by selecting the file that you want.  Export to File: Enables you to export any conversion rules that you have been used previously by selecting the file that you want.  In the Control-M Version field, from the dropdown list, select your Control-M version that determines the Control-M output.  NOTE: Default: Control-M version 9.0.00  In the Control-M for DS field, type the name of your Control-M/Server.  In the Control-M for ZOS field (Jobtrac only), type the name of your Control-M for Z/Os environment.  To change or view a set of conversion rules, click More.  The General, Fields Editor and Additional Rules fields appear.  To set general conversion rules, see Setting General rules.  To set Control-M fields, see Setting Fields Editor rules.  In the Additional Rules field, change the settings according to the following schedulers and applications:  Additional Autosys Rules  Additional Jobtrac Rules  Additional dSeries Rules  Additional WLM Rules  Additional Cron Rules  Additional TWS Rules  Additional JP1 Rules  Additional MS Task Rules  Additional Dollar Universe Rules  Additional UC4 Rules  Additional UC4 AppWorx Rules  Setting additional Redwood CPS rules  Setting additional Tidal Software Enterprise Scheduler rules  Setting additional Zena rules  Additional Hadoop - Oozie Rules  Additional SAP Rules  Setting additional Control-M Flow Update rules  Click Next to start the conversion.  A message appears showing that conversion is in progress.   The results appear in the Conversion Results window. For more information about conversion results, see Conversion.  \"},{\"id\":211,\"title\":\"Setting General rules\",\"url\":\"Set_general_rules.htm\",\"text\":\"This procedure describes how to set general rules when modifying settings and rules. You can filter your scheduling data, and reduce the amount of data that is converted.   You can also specify how to convert specific job types. For more information about modifying settings and rules, see Selecting or creating a conversion rules file.  To set General rules:  From the General tab, in the Filter area, select one of the following Type options:  Include: Enables you to convert all jobs that satisfy the specified filter criteria  Exclude: Enables you to exclude jobs that satisfy the specified filter criteria  In the Filter area, specify the logical relationship between fields in the field list by selecting one of the following Relationship options:  Or: Enables you to select one of the fields  And: Enables you to select both fields  NOTE: As a result of filter criteria, jobs may only have an &#8220;In Condition&#8221; without a matching &#8220;Out Condition&#8221;, or only an &#8220;Out Condition&#8221; without a matching &#8220;In Condition&#8221; due to a non-converted successor or predecessor job.  In the table you can add fields and enter values to specify converted scheduler fields.  In the table, you can do the following actions:  Click @ to add fields.  In the Field column, select a value from the list in the cell.  In the Value column, type values for the converted scheduler fields in the corresponding cell.  Click @ to remove fields.  In the Job Type Conversion area, select one of the following options:  Convert all jobs to Control-M command line jobs  Convert specific jobs to Control-M scripted jobs: Specifies the type of script by entering commands, file extensions, and other elements in the Command line contains column.   NOTE: To add rows, click @. To delete rows, click @.   If you do not want to output data, for example, for simulations, select Set all jobs to Control-M dummy jobs  (Tidal only) To convert invalid length command line jobs to Control-M embedded script jobs, select Convert invalid length command line jobs to embedded script jobs.   Control-M embedded script jobs have a longer length validation, which resolves command line length validation issues by replacing command line jobs with embedded script jobs.   NOTE: The variables inside the command line are transferred to environment variables according to the host. Default: UNIX.   Repeat this step, each time changing the selection, until you have completed the evaluation.  To continue setting rules select one or more of the following:  Select the Fields Editor tab. For more information, see Setting Fields Editor rules.  Select the Additional rules tab according to your scheduling environment. For more information, see Selecting or creating a conversion rules file.  To save this set of conversion rules and to convert to Control-M, click Next.  A message appears confirming that conversion is in progress.  The set of conversion rules appears in the Conversion rules list. You can use these rules in future conversions. For more information, see Conversion.  \"},{\"id\":212,\"title\":\"Setting Control-M field values\",\"url\":\"Set_field_editor_rules.htm\",\"text\":\"This procedure describes how to set Control-M fields by using the Field Editor. You can specify how the source scheduler job definition parameters correspond to the Control-M job definition fields.   For more information about modifying and setting rules, see Selecting or creating a conversion rules file.  To set Control-M field values:  From the Fields Editor tab, in the Control-M Field Editor area, do the following:  In the Select field to edit field, from the drop-down list, select a field to change.  In the Control-M field, enter a value or click > and select one of the field options.  NOTE: You can also add a time stamp and/or counter to the value using >. You can use the counter to ensure that you generate unique names.  To reset the value to the original value, click Reset.  In the Default value field, type a new default value.  NOTE: The default value is used if no other value is specified.  To replace substrings, do the following actions:  Click @ to open a new row, double click the From column and type the string that you want to replace.  Double click the To column and type the new string.  EXAMPLE: To replace logfile with log, type logfile in the From column and log in the To column.  NOTE: You can also use wildcard characters * and ? to change the string. To delete a substring replacement, select the substring and click @.  In the Conversion Messages area, select any of the following options:  Append message IDs to description: Includes a message\'s ID in a field\'s description.  Append message text to description: Includes a message\'s text in a field\'s description.  To continue setting rules select one or more of the following:  Select the General tab. For more information, see Setting General rules.  Select the Additional rules tab according to your scheduling environment. For more information, see Selecting or creating a conversion rules file  NOTE: To set the user whose credentials are used for Control-M job functions to be the same as that of the source scheduler, and followed by the \\\"_CONVERTED\\\" suffix, set the Control-M field value to {Run as}_CONVERTED. The default value is only used if the resolved value is zero.  To save this set of conversion rules and to convert to Control-M, click Next.  A message appears confirming that conversion is in progress.  The set of conversion rules appears in the Conversion rules list. You can use these rules in future conversions. For more information, see Conversion.  \"},{\"id\":213,\"title\":\"Conversion results\",\"url\":\"Conversion_step.htm\",\"text\":\"In the Conversion Results window, you can see how much of your data was converted successfully, how many Control-M jobs and folders were created during the conversion, view any messages and take any action if required. After analyzing the results, if you wish to reduce the warning and error messages, you can rerun the conversion by making changes to conversion settings and rules. Repeat this step until you are satisfied with the results that are generated.  NOTE: When you are converting large data, you can cancel loading the conversion results by clicking Cancel on the progress bar, which enables you to continue with conversion without waiting Conversion Tool to finish analyzing the data.  In the bottom half of the window you can see details about how many Control-M Folders, Sub Folders, and Jobs were created. You can also see percentages of successfully converted data. In the top half of the window there are two tabs:  Messages Enables you to display the results in different views. You can choose one of the following options from the View menu:  Message Type: Enables you to view the message according to the following criteria:  Information  Warning  Error  Job: Enables you to view the messages according to jobs.  For further information about AutoSys messages, see: AutoSys information and warning messages - corrective action. For further information about TWS messages, see: TWS warning messages - corrective action.  Actions: Checks the report for any issues that may have occurred during the conversion. You can see the action you need to take (if any). You can select Generate Scripts which enables you to perform the conversion more quickly and efficiently which reduces any conflicts on Control-M/Server. These scripts, which are saved in a file and after conversion are run on Control-M/Server. To generate a script, see: Generating scripts for Control-M/Server.  You can export the Conversion Results to a file by clicking on Export. Once you are happy with the conversion results, click Next to continue to the Validation phase.  UC4 jobs: If your UC4 jobs contain Post Script, you may want to map the Ondo csv file to improve the conversion results. For more information, see Post conversion: UC4 Post Script.  \"},{\"id\":214,\"title\":\"Generating scripts for Control-M/Server\",\"url\":\"46268.htm\",\"text\":\"The following procedure describes how to generate scripts to run on Control-M/Server.  To generate scripts:  From the Conversion Results window, in the Actions tab, click Generate Scripts.  The Post Conversion Actions window appears.  Do the following:  Click Quantitative Resources, review the contents and complete the Quantity column, and click Generate Script.  Click Global variables, review the contents and complete the Value column, and click Generate Script.  Click File Transfer Connection Profile, review the MFT Account Name column, and click Generate Script.  Click Data Base Connection Profile, review the Database Connection Profile Name column, and click Generate Script.  Click Host Group and review the host group tree, and click Generate Script.  The Host Group script defines the host and host group that you use in the connection process.   Click Generate Script.  The scripts are saved in a new location, which needs to be run on the Control-M/Server machine.  \"},{\"id\":215,\"title\":\"Data validation\",\"url\":\"Validation_step.htm\",\"text\":\"In the Validation step, you can view the Control-M configuration information used for the conversion, and validate the converted data which enables you to confirm that the jobs run on the same date as your original scheduler.  NOTE: Before running the conversion, when you are converting large data, you can cancel loading the conversion results and validation by clicking Cancel on the progress bar, which enables you to continue with conversion without waiting Conversion Tool to finish analyzing the data. For more information, see: Conversion Rules.  Before you validate the converted data, you can filter the data by folders, jobs, unmatched jobs and folders, applications or date ranges. You can also include calendar criteria.   The validation report enables you to do the following:  Store current validation settings (filters and file names) so they can be reused without having to re-generate the conversion project.   View the validation schedule  Validate the planned scheduling results in Control-M against the current source scheduling plan.   You can select a date from a 5-year range (the current year plus two years before and two years after), and compare the expected results of the converted jobs with the results of your jobs from the source scheduler for that specific day. As you validate results, the data changes color to visually indicate your progress. In case of a mismatch from the current scheduling plan, you can view the job or folder related conversion messages to better understand whether the mismatch is a result of a conversion warning. To validate a conversion project, see Validating a conversion project.  At any point, you may save your validation work and close the report, and reopen it later to continue the verification process.  \"},{\"id\":216,\"title\":\"Validating a conversion project\",\"url\":\"Validate_conv_project.htm\",\"text\":\"When you validate a conversion project, the Conversion Tool generates a report that enables you to compare a forecast of the results of the conversion project (as if it were run from Control-M) with the output from the original scheduler.  When a source scheduling plan is available, such as with AutoSys, you can use the Conversion Tool to make the comparison. When a source scheduling plan is not available, you can view the Control-M scheduling plan, and can perform a manual or visual comparison with the current plan.  To validate a conversion project:  From the Validation window, in the Filters area, filter the conversion project data, if required.  To include a calendar definition in the validation, click the folder @ icon next to the Input Calendars definition field, and then select the calendar definition file that you want.  For AutoSys and TWS vendors, click the folder @ icon next to the Vendor\'s forecast report field, and then select the report that you want to compare a vendor\'s forecast report to the Control-M forecast report in the validation report.  NOTE: To use the forecast report compare feature, you need to first extract the relevant report parameter files from your scheduler\'s environment.  AutoSys   If you want a report from a specific date to infinity, use: job_depends -t -J ALL -F \\\"mm/dd/yyyy\\\".  If you want a report to display all jobs scheduled to run between two dates, use: job_depends -t -J ALL -F mm/dd/yyyy hh:mm -T mm/dd/yyyy hh:mm. For example, job_depends -t -J ALL -F 01/03/2009 10:01 -T 02/15/2009 19:01.  If you want a report for a specific date, use: job_depends -t -J ALL -F mm/dd/yyyy hh:mm -T mm/dd/yyyy hh:mm. For example, job_depends -t -J ALL -F 02/01/2009 00:01 -T 02/01/2009 23:59.  TWS:  If you want a report for three months from specific workstations, use: rep11 -m mmyyyy mmyyyy mmyyyy -c workstation1 workstation2 workstation3. For example, rep11 -m 062004 072004 082004 -c workstation1 workstation2 workstation3.  If you want a report for three months of the current year from all workstations, which directly outputs to a file, use: rep11 -m mm mm mm -o output. For example, rep11 -m 06 07 08 -o output.  If you want a report for the current month for a specific workstation, use: rep11 -c workstation1.  (Optional) If you have selected Load existing conversion results in the Run Conversion window and you want to recalculate the scheduling forecast, select Recalculate Control-M forecast.  NOTE: You can also select Recalculate Control-M Forecast in the Validation Report.   To view the validation data, click Validation report.   The Validation report appears. For more information about the Validation report, see Validation report.  Click Next to load the validated conversion results to Control-M, as described in Loading validated conversion results to Control-M.  \"},{\"id\":217,\"title\":\"Validation report\",\"url\":\"Validation_report.htm\",\"text\":\"Use the Validation report to validate the scheduling plan conversion results, and to see on which dates jobs are forecast to run. A screen shot of the validation report is shown below.   The Validation Report window contains the following information.  Left pane: Contains the Smart folder or job tree. You can expand a Smart folder in the left pane to display the jobs that it contains.  Right pane: Contains the day/month/year grid.  Navigation bar at the top of the screen: Contains quick navigation buttons to the required date.  Information bar at the bottom of the screen: contains a key to the colors in the day/month/year grid, and a summary of the results.  When a Smart folder or job is scheduled to run on a specific day, the cell that represents that day is colored according to the information bar.   @ (white): no Smart folder or jobs are scheduled to run on that day  @ (single diagonal line): a job or sub folder is scheduled to run on that day  @ (multiple diagonal lines): some jobs in the table are scheduled to run on that day  @ (gray): all jobs in the folder are scheduled to run on that day  When scheduling plan data is available, for example, with Autosys, each Smart folder or job displays two scheduling plan rows, one row is the calculated Control-M plan, and the second row is the source scheduling plan.   To validate a job or table, see Validating data.  \"},{\"id\":218,\"title\":\"Validating data in the Validation Report\",\"url\":\"Validate_data.htm\",\"text\":\"This procedure describes how to validate data in the Validation Report.  To validate data in the Validation Report:  To validate a Smart folder, sub folder, or job, highlight the Smart folder, sub folder or job, right click and select Validate.  If validated, all scheduled dates are marked @.  NOTE: To validate or unvalidate any row, highlight the cell on the row you want to delete and from the Edit menu, select Validate/Unvalidate row.  To validate a specific date, highlight the date, right-click the required cell and Select Validate.  NOTE: To unvalidate any date, right click the required cell and select unvalidate, or click @, or from the Edit menu.   You can also do one or more of the following actions:  To view information about a Smart folder, Subfolder, or job, select the item that you want, right click a row and select Why.  To filter data according to criteria that you set, from the View menu select Filter.  To search for a specific item, from the View menu, select Find.  To show how many Smart folders or jobs were ordered on each day, from the View menu, select Show daily jobs count.  To view the Forecast log, from the View menu, select View Forecast log.  To save the report, from the File menu, select Save.  To discard the current validation, from the File menu, select Reset.  To recalculate the scheduling forecast, from the File menu, select Recalculate Control-M Forecast.  To close the report, from the File menu, select Exit.  \"},{\"id\":219,\"title\":\"Control-M Conversion utilities\",\"url\":\"98565.htm\",\"text\":\"The following sections describe the Control-M Conversion utilities:  General utilities  Mainframe CA ESP utilities  \"},{\"id\":220,\"title\":\"General utilities\",\"url\":\"99723.htm\",\"text\":\"The following topics describe the general utilities:  CalendarsDuplicatesRemoval utility  \"},{\"id\":221,\"title\":\"CalendarsDuplicatesRemoval utility\",\"url\":\"98580.htm\",\"text\":\"You may have a substantial number of Control-M Rule Based Calendars (RBCs) with identical data after converting your data to Control-M. The CalendarsDuplicatesRemoval utility removes all identical RBCs and updates Control-M data, which references these remaining RBCs.   After converting your data to Control-M, the Conversion Tool generates the following files:  Data XML  Calendar XML  The files are located in <conversion home>\\\\workarea\\\\datasources\\\\<name of conversion project>\\\\CONVERSIONS\\\\<name of conversion project>. You can also access these files directly from the Load to Control-M window by clicking Open Conversion result.   Alternatively, if you have imported your data into Control-M, you can use the exportdeffolder and exportdefcal utilities to export the Data and Calendar XML. For more information, see Control-M Utilities Guide.  The CalendarsDuplicatesRemoval utility reviews these files and generates the following files:   updateCalendars.xml: Contains the remaining unique RBCs.  updateCtmData.xml: Contains the updated Control-M data with new references to the remaining RBCs.  calDuplicatesRemovalReport.xlsx: Contains a list of the names of the remaining RBCs and the names of the RBCs that have been removed.  You can then import the updateCalendars.xml and updateCtmData.xml files into Control-M.   \"},{\"id\":222,\"title\":\"Running the CalendarsDuplicatesRemoval utility\",\"url\":\"98581.htm\",\"text\":\"The following procedure describes how to run the CalendarsDuplicatesRemoval utility.  Before you begin  Review the number of RBCs that have been created and whether they contain duplicate information.  To run the CalendarsDuplicatesRemoval utility:  Extract the following files and move them to a temporary file:  Calendars.xml  draft.xml  Open a command prompt and go to the <conversion home>\\\\scripts\\\\general\\\\CalendarsDuplicatesRemoval directory.   Type the following command:   CalendarsDuplicatesRemoval.bat -calendarFile <calendar file path> &#8211;ctmData <Control-M data file path>  -outputDirectory <output file path>  EXAMPLE:  CalendarsDuplicatesRemoval.bat -calendarFile c:\\\\Temp\\\\calendars.xml  &#8211;ctmData c:\\\\Temp\\\\draft.xml -outputDirectory c:\\\\NewCal\\\\  \"},{\"id\":223,\"title\":\"CaldendarsDuplicatesRemoval parameters\",\"url\":\"98582.htm\",\"text\":\"The following table describes the CalendarsDuplicatesRemoval parameters:  Parameters  Description  CalendarFile  (Mandatory) Defines the path to the Control-M calendar XML file.  ctmData  (Mandatory) Defines the path to Control-M data that contains the input calendar file references  outputDirectory  (Optional) Path to the directory where the CalendarDuplicatesRemoval output will be created.  \\t  \\t  \"},{\"id\":224,\"title\":\"Mainframe CA ESP utilities\",\"url\":\"99724.htm\",\"text\":\"The following section describes the utility for Mainframe CA ESP:  Bridge building tool for integration between CA ESP and Control-M  \"},{\"id\":225,\"title\":\"Bridge building tool for integration between CA ESP and Control-M\",\"url\":\"98566.htm\",\"text\":\"This utility automates a Bridge creation between CA ESP and Control-M, which reduces the manual work involved, when converting CA ESP data to Control-M. The bridges between CA ESP and Control-M are needed during the Conversion process when part of the flow is converted and running in Control-M and part is still running in CA ESP.  The Bridge builder utility gets CA ESP and Control-M bridges definitions information as input data and builds the following:  Control-O rules: Implements the CA ESP to Control-M Bridges   Control-M MF Jobs: Implements the Control-M to CA ESP bridges    To run the Bridge Building tool, see Running the Bridge Builder Tool.  \"},{\"id\":226,\"title\":\"Running the Bridge Builder Tool\",\"url\":\"98567.htm\",\"text\":\"This procedure describes how to run the Bridge Builder Tool from the CLI.  Before you begin  You need to Understand which bridges need to be created between CA ESP and Control-M.  To run the Bridge Builder from CLI:  Create a bridges definitions csv file that contains the following information:  CA ESP APPL/Job name  CTM Job full path name (Folder/Job name)  Bridge Type, which supports the following options:  ESPDS_CTMDS  (bridge from ESP DS to CTM DS)  ESPDS_CTMMF (bridge from ESP DS to CTM MF)  ESPMF_CTMDS (bridge from ESP MF to CTM DS)  ESPMF_CTMMF (bridge from ESP MF to CTM MF)  CTMDS_ESPMF (bridge from CTM DS to ESP MF)  CTMMF_ESPDS (bridge from CTM MF to ESP DS)  CTMDS_ESPDS (bridge from CTM DS to ESP DS)  CTMMF_ESPMF (bridge from CTM MF to ESP MF)  For more information, see Bridges Information file example.  Set the bridges conditions prefixes you want to use per bridge type in the bridgeConditionsPrefixes.cfg file in home>\\\\tools\\\\CAESP\\\\BridgeBuilder.  Create the Control-O rule template that you want to use as input for the bridge builder by using the cto_rule_template file in the home>\\\\tools\\\\CAESP\\\\BridgeBuilder\\\\Examples folder.  Create the Control-M MF SMART folder and job data that you want to use as input for the bridge builder, by using the ctm_mf_data_template file in the home>\\\\tools\\\\CAESP\\\\BridgeBuilder\\\\Examples folder.  NOTE: The templates contain place holders values (example:  @MSG_ID@ ) that are being replaced by the bridge builder. They should be kept in the same format.  Open a command prompt and go to the <conversion home>\\\\tools\\\\CAESP\\\\BridgeBuilder directory.  Type the following command:  bridgebuilder.bat -bridgesData bridgesInfo.csv -ctmTemplate ctmTemplate.xml   - ctoTemplate ctoTemplate.txt -outputDirectory c:\\\\BridgeOutput\\\\  \"},{\"id\":227,\"title\":\"Bridge Builder CLI parameters\",\"url\":\"98568.htm\",\"text\":\"The following table describes the Bridge Builder parameters:  Parameters  Description  bridgesData  (Mandatory) Path to csv file with the required bridges information. For more information, see Bridges Information file example.  ctmTemplate  (Optional) Path to Control-M MF data template that will be used to create Control-M Mainframe Bridges Jobs.  ctoTemplate  (Optional) Path to Control-O template that will be used to create Control-O Bridges rules.  outputDirectory  (Optional) Path to the directory where BridgeBuilder outputs will be created.  \\t  \\t  \"},{\"id\":228,\"title\":\"Bridges Information file example\",\"url\":\"98569.htm\",\"text\":\"CA ESP Job, CTM Job, Bridge Type  APPL1\\\\JOB1,FOLDER1\\\\JOB1,ESPDS_CTMDS  APPL2\\\\JOB2,FOLDER2\\\\JOB2,ESPMF_CTMMF  NOTE: You should keep the headers (first line)  \"},{\"id\":229,\"title\":\"Bridge builder outputs and how to use them to implement the bridges\",\"url\":\"98570.htm\",\"text\":\"The Bridge Builder creates three outputs:  Bridge_Trigger_Jobs.xml: Holds the new MF folder that contains all the additional MF jobs that trigger ESP jobs.  NOTE: Will be created only if bridges that trigger CA ESP jobs after Control-M jobs are needed.  CTORULS: A text file that holds all the Control-O Rules definitions created for triggering Control-M jobs after CA ESP jobs ends.  AdjustCtmConditions.xlsx: An excel file that contains the names of all Control-M jobs that need to rename their existing In/Out Condition to fit the Bridges Builder outputs.  To complete the bridge definitions, the following manual actions should be performed:  Copy CTORULS file to the MF Control-O Rules Library in text mode.  Add Bridge_Trigger_Jobs.xml to the workspace that contains the Control-M converted data that need to trigger CA ESP jobs and check it in.  Review AdjustCtmConditions.xlsx file and update the existing In/Out Conditions as required.  \"},{\"id\":230,\"title\":\"Copyright Notice\",\"url\":\"47359.htm\",\"text\":\"Contacting BMC Software  You can access the BMC Software website at http://www.bmc.com. From this website, you can obtain information about the company, its products, corporate offices, special events, and career opportunities.  United States and Canada  Address   BMC SOFTWARE INC  2103 CITYWEST BLVD  HOUSTON TX 77042-2827  USA  Telephone   713 918 8800   800 841 2031  Fax   713 918 8000  11/30/2021  Outside United States and Canada  Telephone   (01) 713 918 8800   Fax   (01) 713 918 8000  &copy; Copyright 1999-2020 BMC Software, Inc.   Your use of this information is subject to the terms and conditions of the applicable End User License Agreement for the product and the proprietary and restricted rights notices included in this documentation. No part of this publication may be reproduced, stored in a retrieval system, or transmitted in any form or by any means, electronic, mechanical, photocopying, recording or otherwise, without the prior written permission of BMC Software, Inc.   BMC, BMC Software, the BMC logo, the BMC Software logo, and other BMC marks, and the tagline &#8220;Bring IT to Life&#8221; are the exclusive properties of BMC Software, Inc., or its affiliates or subsidiaries and are registered or may be registered with the U.S. Patent and Trademark Office and in other countries.  All other BMC trademarks, service marks, and logos may be registered or pending registration in the U.S. or in other countries.  All other trademarks or registered trademarks are the property of their respective owners.  For BMC Control-M Products that are licensed on the &#8220;per CPU &#8211; Full Capacity&#8221; unit of measurement and installed in an Amazon Web Services (&#8220;AWS&#8221;), Microsoft Azure (&#8220;Azure&#8221;), or Google Cloud Platform (\\\"GCP\\\") cloud environment, a license is required for the total number of CPUs in each AWS, Azure, or GCP instance upon which the Product is installed or which the Product manages, either remotely or locally. For AWS and GCP, one CPU is equivalent to one vCPU, as defined by AWS. For Azure, one CPU is equivalent to up to four Virtual Cores (as defined by Azure), rounded up to the closest multiple of four.  IBM&reg; Tivoli&reg; Business Service Manager, IBM Tivoli Workload Scheduler, IBM Cognos, IBM InfoSphere DataStage, IBM i (AS/400), IBM Websphere, and AIX&reg; are the trademarks or registered trademarks of International Business Machines Corporation in the United States, other countries, or both.    UNIX&reg; is the registered trademark of The Open Group in the US and other countries.   Linux is the registered trademark of Linus Torvalds.  Oracle and Java are registered trademarks of Oracle and/or its affiliates. Other names may be trademarks of their respective owners.  SAP&reg; R/2 and SAP R/3, SAP Business Objects, and SAP NetWeaver are trademarks or registered trademarks of SAP AG in Germany and in several other countries.  Restricted rights legend  U.S. Government Restricted Rights to Computer Software. UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. Use, duplication, or disclosure of any data and computer software by the U.S. Government is subject to restrictions, as applicable, set forth in FAR Section 52.227-14, DFARS 252.227-7013, DFARS 252.227-7014, DFARS 252.227-7015, and DFARS 252.227-7025, as amended from time to time. Contractor/Manufacturer is BMC SOFTWARE INC, 2101 CITYWEST BLVD, HOUSTON TX 77042-2827, USA. Any contract notices should be sent to this address.  Customer support  You can obtain technical support by using the BMC Software Customer Support website or by contacting Customer  Support by telephone or e-mail. To expedite your inquiry, see &#8220;Before contacting BMC.&#8221;  Support website  You can obtain technical support from BMC 24 hours a day, 7 days a week at http://www.bmc.com/support. From this website, you can:  read overviews about support services and programs that BMC offers  find the most current information about BMC products  search a database for issues similar to yours and possible solutions  order or download product documentation  download products and maintenance  report an issue or ask a question  subscribe to receive proactive e-mail alerts when new product notices are released  find worldwide BMC support center locations and contact information, including e-mail addresses, fax numbers, and telephone numbers  Support by telephone or e-mail  In the United States and Canada, if you need technical support and do not have access to the web, call 800 537 1813 or send an e-mail message to customer_support@bmc.com. (In the subject line, enter SupID:<yourSupportContractID>, such as SupID:12345). Outside the United States and Canada, contact your local support center for assistance.  Before contacting BMC  Have the following information available so that Customer Support can begin working on your issue immediately:  product information  product name  product version (release number)  license number and password (trial or permanent)  operating system and environment information  machine type  operating system type, version, and service pack or other maintenance level such as PUT or PTFsystem hardware configuration  serial numbers  related software (database, application, and communication) including type, version, and service pack or maintenance level  sequence of events leading to the issue  commands and options that you used  messages received (and the time and date that you received them)  product error messages  messages from the operating system, such as file system full  messages from related software  License key and password information  If you have questions about your license key or password, contact BMC as follows:  (USA or Canada) Contact the Order Services Password Team at 800 841 2031, or send an e-mail message to ContractsPasswordAdministration@bmc.com.  (Europe, the Middle East, and Africa) Fax your questions to EMEA Contracts Administration at +31 20 354 8702, or send an e-mail message to password@bmc.com.  (Asia-Pacific) Contact your BMC sales representative or your local BMC office.  Third party Software  For the provisions described in the BMC License Agreement and Order related to third party products or technologies included in the BMC Product, select one of the following:   Locate the \\\"ThirdParty\\\" subdirectory in the installation directory of this product by clicking  ThirdParty directory.  Go to https://docs.bmc.com/docs/display/workloadautomation/Control-M+Workload+Automation+Documentation and click Third-party software (TPS).  \"}]}'
});