JSONP.response({
  responseText: '﻿<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\
<title> Setting additional CA Jobtrac rules </title>\
<script type=\"text/javascript\">\
        function isTOCLoaded() {\
            /* this function for loading the topic within the application if loaded by itself */\
            /* i.e. open the topic .htm file or as search engines link */\
            var url = window.location.href;\
            var baseUrl = url.substring(0, url.lastIndexOf(\"/\") + 1);\
            var topicFile = url.substring(url.lastIndexOf(\"/\") + 1);\
            var newUrl = baseUrl + \"index.htm#\" + topicFile;\
            location.href = newUrl;\
            return false;\
        }\
</script>\
<script language=\"javascript\" type=\"text/javascript\" src=\"dhtml_popup.js\"></script>\
</head>\
<body  onload=\"if (isTOCLoaded()) {expand(\'99707\');highlight(\'87621\')}\">\
<h2 id=\"t87621\" class=\"heading2\">Setting additional CA Jobtrac rules</h2>\
<p class=\"bodytext\">This procedure describes how to set additional CA Jobtrac rules.</p>\
<p class=\"bodytext\">After you have imported your data, you can modify conversion rules by <a id=\"h33390\" class=\"jumptemplatenosync\" title=\"Setting General rules\" href=\"Set_general_rules.htm\" target=\"_self\">setting general rules</a> and <a id=\"h33391\" class=\"jumptemplatenosync\" title=\"Setting Control-M field values\" href=\"Set_field_editor_rules.htm\" target=\"_self\">Field Editor rules</a>.</p>\
<p class=\"beforeyoubegin\">Before you begin</p>\
<p class=\"bodytext\">Ensure that the Conversion Settings window is open. For more information, see <a id=\"h33396\" class=\"jumptemplate\" title=\"Modifying conversion settings\" href=\"Select_create_conv_rules.htm\" target=\"_self\">Modifying conversion settings</a>.</p>\
<p class=\"procedureheading\">To set additional CA Jobtrac rules:</p>\
<ol class=\"listnumber\"><li class=\"listnumber\">From the <strong class=\"strong\">Additional Jobtrac Rules </strong>tab, type or select the Jobtrac rules as described in <a id=\"h89694\" class=\"expandingblocktemplate\" title=\"Additional Jobtrac rules\" href=\"javascript:toggleBlock(\'89694\')\" target=\"_self\">Additional Jobtrac rules</a>.<div id=\"d89694\" class=\"expandingblock\" style=\"display:none\"><p class=\"bodytext\">The following table describes the additional Jobtrac rules parameters.</p>\
<table class=\"tableintopic\" width=\"606\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"border-collapse:collapse; border:1px solid #010101\">\
<tr align=\"left\" valign=\"top\">\
<th bgcolor=\"#F76E00\" style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tableheading\">Parameter</p>\
</th>\
<th bgcolor=\"#F76E00\" style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tableheading\">Description</p>\
</th>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Convert DS jobs</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to perform a conversion of the Distributed Systems (DS) job definition by selecting the Convert DS jobs checkbox. </p>\
<p class=\"tablebodytext\">In the <strong class=\"strong\">Date format</strong> field, you can select how to view the date through either ddmm or mmdd (default).</p>\
<p class=\"tablebodytext\"><strong class=\"strong\">Convert DS jobs </strong>check box to perform a conversion of the DS jobs.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Conditions</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\"><strong class=\"strong\">JOBA_JOBB</strong>: Enables you to define how two jobs are connected by creating unique condition in the format: JOBA_JOBB.</p>\
<p class=\"tablebodytext\">Select the <strong class=\"strong\">Cleanup conditions </strong>check box to delete the condition after the next job has finished running.</p>\
<p class=\"tablebodytext\"><strong class=\"strong\">JOBA_OK</strong>: Enables you to set a successful dependence condition between many jobs according its end status. </p>\
<p class=\"tablebodytext\">For more details see <em class=\"emphasis\">Job Dependencies</em> in <em class=\"emphasis\">Using Control-M.</em></p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Start Day of the Week</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to select the start day of the week for scheduling. </p>\
<p class=\"tablebodytext\">The value is used for Date Scheduling parameters Ln, -Ln, Dn, -Dn, DnPi, -DnPi, LnPi, -LnPi, DnWm. </p>\
<p class=\"tablebodytext\"><strong class=\"strong\">NOTE:</strong> BMC Software recommends that you do not change this parameter once Control-M has been in operation in a production environment, as it may affect scheduling.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">New Day time</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to type the value in the<strong class=\"strong\"> New Day time value specified in CTMPARM</strong> field.</p>\
<p class=\"tablebodytext\"><strong class=\"strong\">NOTE:</strong> When a positive number is specified as a New day time value, the conversion avoids scheduling date discrepancies for jobs that are scheduled by Jobtrac between Midnight and the specified Newday time by moving them one day earlier.  When a negative number is specified, jobs that are scheduled by Jobtrac between the specified New day and Midnight are scheduled one day later</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Customize Control-M jobname</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\"><strong class=\"strong\">Use Alternative JCL member name as JOBNAME: </strong>Enables you to<strong class=\"strong\"> </strong>use the Alternate JCL member name (if it exists) as the jobname, instead of the event name for the converted jobs and their connecting conditions.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">SCL libraries processing</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\"><strong class=\"strong\">Process each SCL library independently:</strong> Enables you to process each SCL library separately. </p>\
<p class=\"tablebodytext\">By default, the Conversion Tool loads and processes all of the libraries as a single repository. </p>\
<p class=\"tablebodytext\">By selecting the checkbox you can process each SCL library separately, which is useful where SCL libraries are large, and it is not possible to convert all libraries together. If there are cross SCL dependencies they are not resolved as part of the conversion. A manual adjustment has to be made.</p>\
</td>\
</tr>\
\
</table>\
<p class=\"bodytext\"></p>\
<p class=\"bodytext\"></p>\
</div></li><li class=\"listnumber\">To set mainframe rules, select the <strong class=\"strong\">Mainframe Editor</strong> tab. Type the following parameters:<ul class=\"listbullet2\"><li class=\"listbullet2\"><a id=\"h47152\" class=\"expandingblocktemplate\" title=\"Jobtrac mainframe parameters\" href=\"javascript:toggleBlock(\'47152\')\" target=\"_self\">Jobtrac Additional Rules</a><div id=\"d47152\" class=\"expandingblock\" style=\"display:none\"><p class=\"bodytext\">The following table describes the Jobtrac Additional Rules parameters in the <strong class=\"strong\">Mainframe Editor</strong> tab. For more information, see <a id=\"h5959\" class=\"jumptemplate\" title=\"Setting additional CA Jobtrac rules\" href=\"Set_addl_jobtrac_rules.htm\" target=\"_self\">Setting additional CA Jobtrac rules</a>.</p>\
<table class=\"tableintopic\" width=\"606\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"border-collapse:collapse; border:1px solid #010101\">\
<tr align=\"left\" valign=\"top\">\
<th bgcolor=\"#F06E00\" style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tableheading\">Parameter</p>\
</th>\
<th bgcolor=\"#F06E00\" style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tableheading\">Description</p>\
</th>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">SCHED TAB &#8211; Scheduling Table Library</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the Control-M scheduling table that stores job definitions. Default value: CTM.SCHEDULE.</p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You can use the Scheduling Table Library that was allocated during Control-M installation. You must verify that the Scheduling Table Library is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">OVERLIB &#8211; JCL Over Lib</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the value as OVERLIB for converted jobs. Default value: CTM.OVERLIB. </p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You must verify that the JCL Overlib Library is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">INCLIB &#8211; Control-M Include Library</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the value as INCLIB for converted jobs. Default value: CTM.INCLIB.</p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You must verify that Control-M Include Library is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">JCLLIB &#8211; Alternate Memname</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the value of an additional Memname, which is used for saving converted jobs. Default value: CTM.JCLLIB.</p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You can use the JCL Library for alternate members allocated during Control-M installation. You must verify that the Control-M JCL Library for alternate members is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">CTODSN &#8211; Control-O rule library</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the Control-O rules library containing Dataset and messages triggering events for ADR, AMR and SCS. Default value: CTM.CTODSN.</p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You can use the Control-O rules library allocated during Control-O installation. You must verify that Control-O rules library is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">IOAENV - Library full path</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the name of the IOA/Control-M production environment&#8217;s  IOAENV library.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">CMEM &#8211; CMEM rule library</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the CMEM rules library containing Job Arrival events for RESOURCE file conversion. Default value: CTM.CMEM.</p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You must verify that the CMEM rules library is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Control-O run JCL library</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the JCL library name containing JCL files running from Control-O rules. Default value: CTM.CTO.JCL.</p>\
<p class=\"tablenote\"><strong class=\"strong\">NOTE: </strong>You can use the Control-O JCL library allocated during Control-O installation. You must verify that Control-O run JCL library is allocated in the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Control-O rule user</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the user name for invoking the CONTROL-O rules. Default value: USERNAME. </p>\
<p class=\"tablebodytext\">Enter a maximum of 8 characters.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">(Mandatory) JOB CARD - Job card for output JCL</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to use job cards for the output JCL that is created to run at the end of the conversion for returning the converted data to the appropriate files.</p>\
<p class=\"tablebodytext\">In the <strong class=\"strong\">Job Card</strong> field, enter the job card that you want, for example, //CTMJOB JOB.</p>\
<p class=\"tablebodytext\">You can also click <strong class=\"strong\">Edit</strong> <img id=\"f86635\" src=\"86635.png\" alt=\"O83584\" height=\"28\" width=\"28\" vspace=\"0\" hspace=\"0\" align=\"bottom\" border=\"0\"> to enter multiple job cards.</p>\
</td>\
</tr>\
\
</table>\
<p class=\"bodytext\">For JCL parameters and Advanced parameters, see <a id=\"h33403\" class=\"jumptemplate\" title=\"JCL parameters\" href=\"33401.htm\" target=\"_self\">JCL parameters</a> and <a id=\"h33404\" class=\"jumptemplate\" title=\"Advanced Parameters\" href=\"33402.htm\" target=\"_self\">Advanced Parameters</a>.</p>\
</div></li><li class=\"listbullet2\"><a id=\"h47153\" class=\"expandingblocktemplate\" title=\"JCL parameters\" href=\"javascript:toggleBlock(\'47153\')\" target=\"_self\">JCL parameters</a><div id=\"d47153\" class=\"expandingblock\" style=\"display:none\"><p class=\"bodytext\">The following table describes the JCL parameters for Defining new Jobtrac conversion data and <a id=\"h5959_2\" class=\"jumptemplate\" title=\"Setting additional CA Jobtrac rules\" href=\"Set_addl_jobtrac_rules.htm\" target=\"_self\">Setting additional CA Jobtrac rules</a>.</p>\
<table class=\"tableintopic\" width=\"606\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"border-collapse:collapse; border:1px solid #010101\">\
<tr align=\"left\" valign=\"top\">\
<th bgcolor=\"#DBE5F1\" style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tableheading\">Parameter</p>\
</th>\
<th bgcolor=\"#DBE5F1\" style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tableheading\">Description</p>\
</th>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">JCL created file (project set up only)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines a filename for the JCL file created on the Mainframe.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Output data file name (project set up only)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines a filename for the output file or use the default CTM.JBT.OUT.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Job card (project set up only)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines the job card that you want, for example, //COLLECTED JOB.</p>\
<p class=\"tablebodytext\">You can also click <img id=\"f83585\" src=\"o83585.png\" class=\"linkedjpegfiletemplate\" alt=\"I_ConvTool_JT_Edit_button\" height=\"16\" width=\"16\" vspace=\"0\" hspace=\"0\" align=\"bottom\" border=\"0\"> to enter multiple job cards.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Allocate converted JCL libraries (Mainframe Editor rules only)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to allocate new JCL libraries. If this parameter is not selected, the Conversion Tool overrides the original JCL libraries.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">JCL library Prefix (Mainframe Editor rules only)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines a prefix value. For example, CTM.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">UNIT</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the volser unit.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">VOLSER</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the volume on which to allocate the output file.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">SMS DATA CLASS</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the SMS data class</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">SMS STORAGE CLASS</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the SMS storage class</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">SMS MANAGEMENT CLASS</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the SMS management class</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Primary Allocation (CYL): </p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines a value, for example, 100.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Secondary Allocation (CYL)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(Mandatory) Defines a value, for example, 100.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Number of Directory Blocks (Mainframe Editor Rules only)</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the number of directory blocks allocated to the converted JCL library. This should must be the same as the number of directory blocks in the original Jobtrac JCL library.</p>\
</td>\
</tr>\
\
</table>\
<p class=\"bodytext\"></p>\
</div></li><li class=\"listbullet2\"><a id=\"h47155\" class=\"expandingblocktemplate\" title=\"Advanced Parameters\" href=\"javascript:toggleBlock(\'47155\')\" target=\"_self\">Advanced Parameters</a><div id=\"d47155\" class=\"expandingblock\" style=\"display:none\"><p class=\"bodytext\">The following table describes the Advanced parameters in the Mainframe Editor tab. For more information, see <a id=\"h5959_3\" class=\"jumptemplate\" title=\"Setting additional CA Jobtrac rules\" href=\"Set_addl_jobtrac_rules.htm\" target=\"_self\">Setting additional CA Jobtrac rules</a>.</p>\
<table class=\"tableintopic\" width=\"606\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"border-collapse:collapse; border:1px solid #010101\">\
<tr align=\"left\" valign=\"top\">\
<th bgcolor=\"#DBE5F1\" style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tableheading\">Parameter</p>\
</th>\
<th bgcolor=\"#DBE5F1\" style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tableheading\">Description</p>\
</th>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Prefix for Maybe condition</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines an in condition dependency, which is required only on days when a job is released as an out condition.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Prefix for Global Conditions added by MF</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines Global conditions that are propagated from Mainframe Control-M to Distributed Control-M.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Prefix to Global Conditions added by DS</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines Global conditions that are propagated from Distributed Control-M to Mainframe Control-M.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Prefix for Global Conditions added by MF and DS</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines Global conditions that are propagated in both directions between Mainframe and Distributed Control-M.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Control-R installed</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to select if Control-R is installed on the mainframe</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Automatic restart</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Enables you to automatically restart the mainframe</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">MAXCC:</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the Maximum condition code for OK status. Valid range: 0-4095 (integers).</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Sysout From Class</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines a blank space or single character to specify the Sysout class.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Sysout To Class</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines a blank space or single character to specify the Sysout class. The Sysout is moved to the end of the job. The default value is &#8216;*&#8217;.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Sysout option</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the Sysout action when a job finishes. Valid values: </p>\
<ul class=\"tablelistbullet\"><li class=\"tablelistbullet\"><strong class=\"strong\">Release</strong></li><li class=\"tablelistbullet\"><strong class=\"strong\">Delete</strong></li><li class=\"tablelistbullet\"><strong class=\"strong\">None</strong></li></ul></td>\
</tr>\
\
</table>\
<p class=\"bodytext\">For Jobtrac additional rule parameters and JCL parameters, see <a id=\"h6918\" class=\"jumptemplate\" title=\"Jobtrac mainframe parameters\" href=\"Set_rules_jobtrac_mainframe.htm\" target=\"_self\">Jobtrac mainframe parameters</a> and <a id=\"h33403_2\" class=\"jumptemplate\" title=\"JCL parameters\" href=\"33401.htm\" target=\"_self\">JCL parameters</a>.</p>\
</div></li></ul></li><li class=\"listnumber\">Click <strong class=\"strong\">Next</strong> to start the conversion.<p class=\"listcontinue\">A message appears confirming that conversion is in progress. The results appear in the Conversion Results window, as described in <a id=\"h5900\" class=\"jumptemplate\" title=\"Conversion results\" href=\"Conversion_step.htm\" target=\"_self\">Conversion results</a>.</p>\
<p class=\"listnote\">The conversion rules are automatically saved after you run the conversion. The set of conversion rules appears in the Conversion rules list in the <strong class=\"strong\">Run</strong> <strong class=\"strong\">Conversion </strong>window. You can use these rules in future conversions.</p>\
<p class=\"listnote\"><strong class=\"strong\">NOTE: </strong>When there are DS and MF jobs:</p>\
<ul class=\"listnotebullet\"><li class=\"listnotebullet\">If Convert DS jobs is not selected, only MF jobs are converted.</li><li class=\"listnotebullet\">If Convert DS jobs is selected, both MF and DS jobs are converted.</li></ul></li></ol><table class=\"relatedtopics belowtopictext\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\
<tr valign=\"top\">\
<td>\
<h3 class=\"relatedheading\">Parent Topic</h3><p class=\"relateditem\"><a href=\"99707.htm\" target=\"_self\">CA Jobtrac</a></p></td>\
</tr>\
</table>\
\
\
<script>\
  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\
  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\
\
  ga(\'create\', \'UA-87414765-1\', \'auto\');\
  ga(\'send\', \'pageview\');\
</script>\
<input id=\"topicId\" type=\"hidden\" value=\"87621\" />\
<input id=\"topicDescription\" type=\"hidden\" value=\"Setting additional CA Jobtrac rules\" />\
<input id=\"footer-modified\" type=\"hidden\" value=\"Page last modified on: 12/26/2016 4:16:39 PM\" />\
</body>\
</html>\
'
});