JSONP.response({
  responseText: '﻿<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\
<title> Defining a new Tidal Software Enterprise Scheduler conversion project </title>\
<script type=\"text/javascript\">\
        function isTOCLoaded() {\
            /* this function for loading the topic within the application if loaded by itself */\
            /* i.e. open the topic .htm file or as search engines link */\
            var url = window.location.href;\
            var baseUrl = url.substring(0, url.lastIndexOf(\"/\") + 1);\
            var topicFile = url.substring(url.lastIndexOf(\"/\") + 1);\
            var newUrl = baseUrl + \"index.htm#\" + topicFile;\
            location.href = newUrl;\
            return false;\
        }\
</script>\
<script language=\"javascript\" type=\"text/javascript\" src=\"dhtml_popup.js\"></script>\
</head>\
<body  onload=\"if (isTOCLoaded()) {expand(\'99701\');highlight(\'87105\')}\">\
<h2 id=\"t87105\" class=\"heading2\">Defining a new Tidal Software Enterprise Scheduler conversion project</h2>\
<p class=\"bodytext\">This topic describes how to define a new Tidal Software Enterprise Scheduler (Tidal) conversion project. You can analyze the complexity of the conversion project by viewing the assessment report. You can either import the data by extracting the files manually or automatically extract the files from the Tidal database into the Conversion Tool, without having to configure your environment.</p>\
<p class=\"beforeyoubegin\">Before you begin</p>\
<p class=\"bodytext\">Do the following:</p>\
<ul class=\"listbullet\"><li class=\"listbullet\">Ask your DBA to supply all the relevant information in this screen.</li><li class=\"listbullet\">Perform the connection test before importing the data.</li><li class=\"listbullet\">Create a new conversion project, as described in <a id=\"h5911\" class=\"jumptemplate\" title=\"Creating a new Conversion Tool project\" href=\"Run_new_conv_project.htm\" target=\"_self\">Creating a new Conversion Tool project</a>.</li><li class=\"listbullet\">For manual data import, export the JOBDTL table from your Tidal environment, as described in <a id=\"h64945\" class=\"jumptemplate\" title=\"Tidal data extraction\" href=\"64843.htm\" target=\"_self\">Tidal data extraction</a>.</li></ul><p class=\"procedureheading\">To define a new Tidal conversion project:</p>\
<ol class=\"listnumber\"><li class=\"listnumber\">From the <strong class=\"strong\">Tidal Software Enterprise Scheduler - Load Data</strong> window, select one of the following:<ul class=\"listbullet2\"><li class=\"listbullet2\"><strong class=\"strong\">Automatic: </strong>Enables the Conversion Tool to automatically import the data from the Tidal database by doing the following:<ul class=\"listbullet3\"><li class=\"listbullet3\">Complete the <a id=\"h94415\" class=\"expandingblocktemplate\" title=\"Tidal data scheduling parameters\" href=\"javascript:toggleBlock(\'94415\')\" target=\"_self\">Tidal scheduling parameters</a>.<div id=\"d94415\" class=\"expandingblock\" style=\"display:none\"><p class=\"bodytext\">The following table describes the automatic import scheduling data parameters for a new Tidal conversion project. </p>\
<table class=\"tableintopic\" width=\"606\" cellpadding=\"2\" cellspacing=\"0\" border=\"1\" style=\"border-collapse:collapse; border:1px solid #010101\">\
<tr align=\"left\" valign=\"top\">\
<th bgcolor=\"#F76E00\" style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tableheading\">Parameter</p>\
</th>\
<th bgcolor=\"#F76E00\" style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tableheading\">Description</p>\
</th>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Type</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the database type. From the dropdown list select either Oracle or MSSQL.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Authentication type</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">(MSSQL only) Enables you to one of the following authentication types:</p>\
<ul class=\"tablelistbullet\"><li class=\"tablelistbullet\">SQL authentication: Enables you to enter the user name and password details.</li><li class=\"tablelistbullet\">Windows credentials: Use the Windows credentials, which are used to run the Conversion Tool to connect to the MSSQL Server.</li></ul></td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Host name</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the host name for the database.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">User name</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the user name for the database.</p>\
<p class=\"tablebodytext\"><strong class=\"strong\">NOTE:</strong> Not relevant if you select Windows credentials in the Authentication Type.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Password</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the password for the database.</p>\
<p class=\"tablebodytext\"><strong class=\"strong\">NOTE:</strong> Not relevant if you select Windows credentials in the Authentication Type.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Port</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the port number. For MSSQL, a default value appears.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Database server </p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the database server or service name.</p>\
</td>\
</tr>\
<tr align=\"left\" valign=\"top\">\
<td style=\"border:1px solid #010101;\" width=\"204\"><p class=\"tablebodytext\">Schema name</p>\
</td>\
<td style=\"border:1px solid #010101;\" width=\"402\"><p class=\"tablebodytext\">Defines the database Schema Name (optional). A schema name is needed if no Database owner credentials are entered.</p>\
</td>\
</tr>\
\
</table>\
<p class=\"bodytext\"></p>\
<p class=\"bodytext\"></p>\
</div></li><li class=\"listbullet3\">(Optional) To test that the connection to the database is successful, click <strong class=\"strong\">Test.</strong></li></ul></li><li class=\"listbullet2\"><strong class=\"strong\">Manual</strong>: Enables you to manually import the data by selecting one of the following:<ul class=\"listbullet3\"><li class=\"listbullet3\">In the <strong class=\"strong\">Automatically Detect Files</strong> area, click to locate the files directory and then click <strong class=\"strong\">Find files</strong>.</li><li class=\"listbullet3\">In the <strong class=\"strong\">Import Scheduling Data</strong> area, click  next to each field to locate the .csv files.</li></ul></li></ul><p class=\"listcontinue\"><strong class=\"strong\">NOTE:</strong> When you select <strong class=\"strong\">Automatically Detect Files</strong>, if any files are missing, you can add them manually in the <strong class=\"strong\">Import Data Scheduling Area</strong>.</p>\
</li><li class=\"listnumber\">Click <strong class=\"strong\">Import</strong>.<p class=\"listcontinue\">The data is loaded into the Conversion Tool and in the <strong class=\"strong\">Assessment Report </strong>window, a summary of the imported data appears. For more information, see <a id=\"h46362\" class=\"jumptemplate\" title=\"Data evaluation\" href=\"46358.htm\" target=\"_self\">Data evaluation</a>.</p>\
</li><li class=\"listnumber\">Click <strong class=\"strong\">Next</strong>.<p class=\"listcontinue\">The <strong class=\"strong\">Run Conversion</strong> window appears.</p>\
</li><li class=\"listnumber\">Select <strong class=\"strong\">Run conversion</strong> or<strong class=\"strong\"> Load existing conversion results</strong>. </li><li class=\"listnumber\">For more information about running conversion, see <a id=\"h21540\" class=\"jumptemplate\" title=\"Data conversion\" href=\"Conv_project_results.htm\" target=\"_self\">Data conversion</a>.</li><li class=\"listnumber\">Click <strong class=\"strong\">Next</strong>.<p class=\"listcontinue\">The <strong class=\"strong\">Conversion Settings</strong> window appears.</p>\
</li><li class=\"listnumber\">Continue converting your project to Control-M by reviewing and changing any conversion settings, as described in <a id=\"h5898\" class=\"jumptemplate\" title=\"Conversion settings\" href=\"Conv_rules_step.htm\" target=\"_self\">Conversion settings</a>. </li></ol><table class=\"relatedtopics belowtopictext\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\
<tr valign=\"top\">\
<td>\
<h3 class=\"relatedheading\">Parent Topic</h3><p class=\"relateditem\"><a href=\"99701.htm\" target=\"_self\">Tidal</a></p></td>\
</tr>\
</table>\
\
\
<script>\
  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\
  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\
\
  ga(\'create\', \'UA-87414765-1\', \'auto\');\
  ga(\'send\', \'pageview\');\
</script>\
<input id=\"topicId\" type=\"hidden\" value=\"87105\" />\
<input id=\"topicDescription\" type=\"hidden\" value=\"Defining a new Tidal Software Enterprise Scheduler conversion project\" />\
<input id=\"footer-modified\" type=\"hidden\" value=\"Page last modified on: 12/13/2017 9:14:32 AM\" />\
</body>\
</html>\
'
});