JSONP.response({
  responseText: '﻿<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\
<title> Converting TWS to Control-M </title>\
<script type=\"text/javascript\">\
        function isTOCLoaded() {\
            /* this function for loading the topic within the application if loaded by itself */\
            /* i.e. open the topic .htm file or as search engines link */\
            var url = window.location.href;\
            var baseUrl = url.substring(0, url.lastIndexOf(\"/\") + 1);\
            var topicFile = url.substring(url.lastIndexOf(\"/\") + 1);\
            var newUrl = baseUrl + \"index.htm#\" + topicFile;\
            location.href = newUrl;\
            return false;\
        }\
</script>\
</head>\
<body  onload=\"if (isTOCLoaded()) {expand(\'46153\');expand(\'99699\');highlight(\'46154\')}\">\
<h3 id=\"t46154\" class=\"heading3\">Converting TWS to Control-M</h3>\
<p class=\"bodytext\">This procedure describes the recommended practices for converting TWS jobs to Control-M.</p>\
<p class=\"procedureheading\">To convert TWS jobs to Control-M:</p>\
<ol class=\"listnumber\"><li class=\"listnumber\">Before converting jobs, it is recommended that you do the following:<ul class=\"listbullet2\"><li class=\"listbullet2\">A full scan of all scripts run by TWS to look for occurrences of TWS command lines, executables and variables within the scripts.</li><li class=\"listbullet2\">Identify any external interfaces to things such as monitoring and alerting tools, reporting tools, help desk incident management tools and CMDB&#8217;s.</li><li class=\"listbullet2\">A Precursory Scan of the TWS environment. If you have amended the .jobmanrc file to perform pre-execution actions, check if anything has been modified in the .jobmanrc file.  </li></ul><p class=\"listexample\"><strong class=\"examplebold\">EXAMPLE</strong>: A popular example of modification to the .jobmanrc is to provide the ability of job-step level restarts for UNIX and Windows jobs.  The .jobmanrc file should be checked for this added feature.  Users will typically be requested to use the &#8216;conman rr jobname step=restart-step-name&#8217; command.</p>\
<ul class=\"listbullet2\"><li class=\"listbullet2\">Create TWS variables.  These are equivalent to Control-M variables and can be embedded in the job definition or script.  These can be found in the Parms.txt file</li></ul><p class=\"listexample\"><strong class=\"examplebold\">EXAMPLE:</strong> </p>\
<p class=\"listexamplecontinue\">$PARM</p>\
<p class=\"listexamplecontinue\">PROD_E_SCR	&quot;c:\\schedules\\e-commerce\\filecopy.txt&quot;</p>\
<p class=\"listexample\">EXAMPLE: Conversion to Control-M Server for Windows:</p>\
<p class=\"listexample\">ctmvar -ACTION SET -VAR &quot;%%%%\\PROD_E_SCR&quot;     &#8211;VAREXPR &#8220;C:\\schedules\\e-commerce\\filecopy.txt&#8221;</p>\
</li><li class=\"listnumber\">In the Conversion Tool, it is recommended that you do the following:<ul class=\"listbullet2\"><li class=\"listbullet2\">From the Conversion Settings window, in the <strong class=\"strong\">General</strong> tab in the <strong class=\"strong\">Job Type Conversion</strong> area, select <strong class=\"strong\">Convert all jobs to Control-M command line jobs. </strong>For more information, see <a id=\"h6917\" class=\"jumptemplate\" title=\"Setting General rules\" href=\"Set_general_rules.htm\" target=\"_self\">Setting General rules</a>.</li><li class=\"listbullet2\">From the <strong class=\"strong\">Additional TWS Rules</strong> tab, select the following:<ul class=\"listbullet3\"><li class=\"listbullet3\">In the <strong class=\"strong\">General</strong> field, select <strong class=\"strong\">Convert OPENs statements to Control-M File Watcher.</strong></li><li class=\"listbullet3\">In the<strong class=\"strong\"> Scheduling Conversion </strong>field, select<strong class=\"strong\"> \'Exclude\' RBC\'s (Control-M V8 FP1 or later). </strong></li></ul></li></ul><p class=\"listnote\"><strong class=\"strong\">NOTE:</strong> This converts calendars to Rule Based Calendars and places logical names as far as possible. For example ON &#8220;MO,TU,WE,TH,FR&#8221; converts this to &#8220;Weekdays&#8221; </p>\
<ul class=\"listbullet2\"><li class=\"listbullet2\">If SAP jobs are identified, from the <strong class=\"strong\">SAP Editor - TWS</strong> tab, type the SAP parameters as required.</li><li class=\"listbullet2\">If PeopleSoft jobs are identified, from the <strong class=\"strong\">PeopleSoft editor</strong> tab, type the Peoplesoft parameters are required.</li></ul><p class=\"listcontinue\">For more information, see <a id=\"h5970\" class=\"jumptemplate\" title=\"Setting additional Tivoli Workload Scheduler (TWS) rules\" href=\"Set_addl_tivoli_rules.htm\" target=\"_self\">Setting additional Tivoli Workload Scheduler (TWS) rules</a></p>\
<p class=\"listnote\"><strong class=\"strong\">NOTE:</strong> You may wish to see the schedules in a slightly different way in the Planning Domain in Control-M.  Using the <strong class=\"strong\">Field Editor</strong> on the Application and Sub_Application fields enables slightly different views after conversion.  It is worth experimenting with these if you do not like the default view. For more information, see <a id=\"h5957\" class=\"jumptemplate\" title=\"Setting Control-M field values\" href=\"Set_field_editor_rules.htm\" target=\"_self\">Setting Control-M field values</a>.</p>\
</li><li class=\"listnumber\">After the conversion, from the <strong class=\"strong\">Conversion Results</strong> window, in the <strong class=\"strong\">Actions</strong> tab, click <strong class=\"strong\">Generate Scripts</strong> to add automatically Quantitative resources, Global variables or Node Groups. For more information, see <a id=\"h46270\" class=\"jumptemplate\" title=\"Generating scripts for Control-M/Server\" href=\"46268.htm\" target=\"_self\">Generating scripts for Control-M/Server</a>.<p class=\"listexample\"><strong class=\"examplebold\">EXAMPLE: Batch file to load Quantitative Resources:</strong></p>\
<p class=\"listexamplecontinue\"><span class=\"code\">$RESOURCE</span></p>\
<p class=\"listexamplecontinue\"><span class=\"code\">PROD-NPDS01B#TSMPBKP	   4	&quot;For NDA backups&quot;</span></p>\
<p class=\"listexamplecontinue\"><span class=\"code\">PROD-ONNM001A#TSMPBKP	   4	&quot;TSM prod backups so not too many run at the same time&quot;</span></p>\
<p class=\"listexamplecontinue\"><span class=\"code\">PROD-DTCAH05A#FTFRES1	   1	&quot;Prevents FTF_WKLY clashing with FTF&quot;</span></p>\
</li></ol><table class=\"relatedtopics belowtopictext\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\
<tr valign=\"top\">\
<td>\
<h3 class=\"relatedheading\">Parent Topic</h3><p class=\"relateditem\"><a href=\"46153.htm\" target=\"_self\">TWS recommended practices</a></p></td>\
</tr>\
</table>\
\
\
<script>\
  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\
  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\
\
  ga(\'create\', \'UA-87414765-1\', \'auto\');\
  ga(\'send\', \'pageview\');\
</script>\
<input id=\"topicId\" type=\"hidden\" value=\"46154\" />\
<input id=\"topicDescription\" type=\"hidden\" value=\"Converting TWS to Control-M\" />\
<input id=\"footer-modified\" type=\"hidden\" value=\"Page last modified on: 5/8/2017 4:19:34 PM\" />\
</body>\
</html>\
'
});