const { app, BrowserWindow} = require('electron');
app.commandLine.appendSwitch('js-flags', '--max-old-space-size=8192')
require('url');
const isDevMode = process.env.NODE_ENV === 'development';
process.env.ELECTRON_DISABLE_SECURITY_WARNINGS = true;
// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let win;

function createWindow() {
  function isSaas() {
    return process.env['JSON_DRAFT_FORMAT'] === 'Y';
  }

  function getFavicon() {
    return __dirname + (isSaas() ? '/saas_favicon.ico' : '/onprem_favicon.ico');
  }

  function getTitle() {
    return isSaas() ? 'Control-M SaaS Self Conversion' : 'Control-M Self Conversion';
  }

  function getServerUrl() {
    let DEFAULT_PORT = '4200';
    let port = process.env.SELF_CONVERSION_PORT || DEFAULT_PORT;
    let baseUrl = 'http://localhost:' + port + '/';
    return baseUrl;
  }

  // Create the browser window.
  win = new BrowserWindow({
    show: false,
    minWidth: 1296,
    minHeight: 679,
    icon: getFavicon(),
    title: getTitle(),
  });
  win.webContents.session.clearCache(() => {
    function loadHomePage() {
      win.loadURL(getServerUrl(), {'extraHeaders': 'pragma: no-cache\n'});
    }

    function createShortcuts() {
      win.webContents.on('before-input-event', (event, input) => {
        if (input.alt && input.shift) {
          if (input.key.toLowerCase() === 'r') {
            console.log('Refresh electron');
            loadHomePage();
            event.preventDefault();
          }
          if (input.key.toLowerCase() === 'd') {
            console.log('Opening dev-tools. Trigerred by a user shortcut.');
            win.webContents.openDevTools();
            event.preventDefault();
          }
        }
      });
    }

    win.maximize();
    loadHomePage();
    createShortcuts();

    // Open the DevTools.
    if (isDevMode) {
      win.webContents.openDevTools();
    }
    //set the default menubar to be not visible
    win.setMenuBarVisibility(false);

    // Emitted when the window is closed.
    win.on('closed', () => {
      // Dereference the window object, usually you would store windows
      // in an array if your app supports multi windows, this is the time
      // when you should delete the corresponding element.
      win = null
    })
    win.show();
  });
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', createWindow);

// Quit when all windows are closed.
app.on('window-all-closed', () => {
  // On macOS it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== 'darwin') {
    app.quit()
  }
});

app.on('activate', () => {
  // On macOS it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (win === null) {
    createWindow()
  }
});

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.
