@echo off

SET CURRENT_DIR=%CD%
SET CONV_HOME=%~dp0

SETLOCAL

CD %CONV_HOME%

set conversion_jar_file="%CD%\..\..\lib\Infrastructure\SelfConversionCLI-1.0.jar"
IF NOT EXIST %conversion_jar_file% (
    echo.
    echo The file %conversion_jar_file% was not found
    echo.
 )
IF "%RUN_MY_JAVA%"=="" GOTO CONVERSION_JAVA
IF %RUN_MY_JAVA% NEQ RUN_MY_JAVA goto CONVERSION_JAVA

java -version >NUL 2>&1
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA

java -version 2>&1 | findstr /r "1[5-9]\.[0-9]*" >NUL
IF %ERRORLEVEL% NEQ 0 goto NO_JAVA
::echo RUN_MY_JAVA = %RUN_MY_JAVA%
java -jar -Djco.trace_path=logs %conversion_jar_file% %*
goto EXIT

:CONVERSION_JAVA
::echo 64-bit...
"%CONV_HOME%\..\..\JRE\jre_64\bin\java.exe" -jar  %conversion_jar_file% %*
GOTO EXIT

:EXIT
ENDLOCAL
SET RC=%errorLevel%
CD %CURRENT_DIR%
echo.
exit /B %RC%

:NO_JAVA
  echo.
  echo This utility requires Java Runtime Environment version 1.8 or higher.
  echo Make sure Java is installed and configured before reruning the utility.
  echo.
  pause
  goto EXIT


