/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.logging.Level;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleRow;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedUpdatableResultSet;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleLargeObject;

class UpdatableResultSet
extends GeneratedUpdatableResultSet {
    private static final String CLASS_NAME = UpdatableResultSet.class.getName();
    static final int BEGIN_COLUMN_INDEX = 0;
    private GeneratedUpdatableResultSet.NullStatus wasNull;
    private OracleStatement scrollStmt = null;
    private ResultSetMetaData rsetMetaData = null;
    private int columnCount = 0;
    private OraclePreparedStatement deleteStmt = null;
    private OraclePreparedStatement insertStmt;
    private List<String> lastUpdateColumns = null;
    private OraclePreparedStatement updateStmt;
    private int[] indexColsChanged = null;
    private boolean isUpdating = false;
    private boolean isInserting = false;
    private GeneratedUpdatableResultSet.Updater<?>[] updateBuffer = null;
    ArrayList<Clob> tempClobsToFree = null;
    ArrayList<Blob> tempBlobsToFree = null;

    UpdatableResultSet(OracleStatement stmt, OracleResultSet rset) throws SQLException {
        super(stmt, rset);
        this.scrollStmt = stmt;
        this.wasNull = GeneratedUpdatableResultSet.NullStatus.VALUE_UNKNOWN;
        this.getInternalMetadata();
    }

    @Override
    void ensureOpen() throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
        }
        if (this.resultSet == null || this.scrollStmt == null || this.scrollStmt.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        if (this.closed) {
            return;
        }
        super.doClose();
        if (this.resultSet != null) {
            this.resultSet.doClose();
        }
        if (this.insertStmt != null) {
            this.insertStmt.closeOrCache(null);
        }
        if (this.updateStmt != null) {
            this.updateStmt.closeOrCache(null);
        }
        if (this.deleteStmt != null) {
            this.deleteStmt.closeOrCache(null);
        }
        if (this.scrollStmt != null) {
            this.scrollStmt.notifyCloseRset();
        }
        this.connection = LogicalConnection.closedConnection;
        this.resultSet = null;
        this.scrollStmt = null;
        this.rsetMetaData = null;
        this.scrollStmt = null;
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.updateBuffer = null;
    }

    @Override
    public boolean wasNull() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            switch (this.wasNull) {
                case VALUE_UNKNOWN: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
                }
                case VALUE_IN_RSET: {
                    boolean bl = this.resultSet.wasNull();
                    return bl;
                }
                case VALUE_NULL: {
                    boolean bl = true;
                    return bl;
                }
                case VALUE_NOT_NULL: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24).fillInStackTrace();
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            OracleStatement oracleStatement = this.scrollStmt;
            return oracleStatement;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            SQLWarning innerWarnings = this.resultSet.getWarnings();
            if (this.sqlWarning == null) {
                SQLWarning sQLWarning = innerWarnings;
                return sQLWarning;
            }
            SQLWarning thisWarning = this.sqlWarning;
            while (thisWarning.getNextWarning() != null) {
                thisWarning = thisWarning.getNextWarning();
            }
            thisWarning.setNextWarning(innerWarnings);
            SQLWarning sQLWarning = this.sqlWarning;
            return sQLWarning;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.sqlWarning = null;
            this.resultSet.clearWarnings();
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            OracleResultSet.AuthorizationIndicator authorizationIndicator = this.resultSet.getAuthorizationIndicator(columnIndex);
            return authorizationIndicator;
        }
    }

    @Override
    public boolean next() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                this.isRowDeleted = false;
                boolean bl = this.resultSet.isValidRow();
                return bl;
            }
            boolean bl = this.resultSet.next();
            return bl;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                boolean bl = this.resultSet.isFirst();
                return bl;
            }
            boolean bl = this.resultSet.isBeforeFirst();
            return bl;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            boolean bl = this.resultSet.isAfterLast();
            return bl;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            boolean bl = this.resultSet.isFirst();
            return bl;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            boolean bl = this.resultSet.isLast();
            return bl;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.beforeFirst();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            this.resultSet.afterLast();
        }
    }

    @Override
    public boolean first() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.first();
            return bl;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.last();
            return bl;
        }
    }

    @Override
    public int getRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            int n = this.resultSet.getRow();
            return n;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.absolute(row);
            return bl;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            if (this.isRowDeleted) {
                --rows;
                this.isRowDeleted = false;
            }
            boolean bl = this.resultSet.relative(rows);
            return bl;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.cancelRowChanges();
            this.isRowDeleted = false;
            boolean bl = this.resultSet.previous();
            return bl;
        }
    }

    void addToTempLobsToFree(Clob tclob) {
        if (this.tempClobsToFree == null) {
            this.tempClobsToFree = new ArrayList();
        }
        this.tempClobsToFree.add(tclob);
    }

    void addToTempLobsToFree(Blob tblob) {
        if (this.tempBlobsToFree == null) {
            this.tempBlobsToFree = new ArrayList();
        }
        this.tempBlobsToFree.add(tblob);
    }

    void cleanTempLobs() {
        this.cleanTempClobs(this.tempClobsToFree);
        this.cleanTempBlobs(this.tempBlobsToFree);
        this.tempClobsToFree = null;
        this.tempBlobsToFree = null;
    }

    void cleanTempBlobs(ArrayList<Blob> x) {
        if (x != null) {
            Iterator<Blob> iter = x.iterator();
            while (iter.hasNext()) {
                try {
                    ((OracleLargeObject)((Object)iter.next())).freeLOB();
                }
                catch (SQLException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanTempBlobs", " exception " + e.getMessage(), null, null);
                }
            }
        }
    }

    void cleanTempClobs(ArrayList<Clob> x) {
        if (x != null) {
            Iterator<Clob> iter = x.iterator();
            while (iter.hasNext()) {
                try {
                    ((OracleLargeObject)((Object)iter.next())).freeLOB();
                }
                catch (SQLException e) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanTempClobs", " exception " + e.getMessage(), null, null);
                }
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return this.resultSet.getMetaData();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.resultSet.findColumn(columnName);
            return n;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.resultSet.setFetchDirection(direction);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.resultSet.getFetchDirection();
            return n;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.resultSet.setFetchSize(rows);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            int n = this.resultSet.getFetchSize();
            return n;
        }
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen();
        return this.doGetType();
    }

    @Override
    protected int doGetType() {
        return this.scrollStmt.realRsetType.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen();
        return 1008;
    }

    @Override
    public String getCursorName() throws SQLException {
        Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
        try {
            this.ensureOpen();
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
        catch (Throwable throwable) {
            if (lock != null) {
                try {
                    lock.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.ensureOpen();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureOpen();
        return this.isRowDeleted;
    }

    @Override
    public void insertRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (!this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 83).fillInStackTrace();
            }
            this.prepareInsertRowStatement();
            this.prepareInsertRowBinds();
            RowId insertedRowId = this.executeInsertRow();
            this.resultSet.insertRow(insertedRowId);
            this.cancelRowChanges();
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            if (this.isBeforeFirst()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.isAfterLast()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            int numColumnsChanged = this.getNumColumnsChanged();
            if (numColumnsChanged > 0) {
                this.prepareUpdateRowStatement(numColumnsChanged);
                this.prepareUpdateRowBinds(numColumnsChanged);
                this.executeUpdateRow();
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            if (this.isBeforeFirst()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.isAfterLast()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            this.prepareDeleteRowStatement();
            this.prepareDeleteRowBinds();
            this.executeDeleteRow();
            this.isRowDeleted = true;
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (this.isOnInsertRow()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 84).fillInStackTrace();
            }
            if (this.isBeforeFirst()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14).fillInStackTrace();
            }
            if (this.isAfterLast()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289).fillInStackTrace();
            }
            this.resultSet.refreshRow();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isUpdating) {
                this.isUpdating = false;
                this.clearUpdateBuffer();
            }
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isOnInsertRow()) {
                return;
            }
            this.isRowDeleted = false;
            this.isInserting = true;
            if (this.updateBuffer == null) {
                this.updateBuffer = new GeneratedUpdatableResultSet.Updater[this.getColumnCount()];
            }
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.cancelRowChanges();
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            String cName = this.getInternalMetadata().getColumnClassName(columnIndex);
            try {
                Object obj = this.getObject(columnIndex, Class.forName(cName));
                return obj;
            }
            catch (ClassNotFoundException ex) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, ex).fillInStackTrace();
            }
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            assert (type != null) : "type: null";
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            T value = null;
            this.setIsNull(GeneratedUpdatableResultSet.NullStatus.VALUE_UNKNOWN);
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                GeneratedUpdatableResultSet.Updater<?> up = this.getUpdater(columnIndex);
                if (up == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(up.getValue(), type, this.connection, up.getExtra(), null);
                this.setIsNull(up.getValue() == null);
            } else {
                this.setIsNull(GeneratedUpdatableResultSet.NullStatus.VALUE_IN_RSET);
                value = this.resultSet.getObject(columnIndex, type);
            }
            T t = value;
            return t;
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNull").fillInStackTrace();
            }
            final int colType = this.getInternalMetadata().getColumnType(columnIndex);
            if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003 || colType == 2009) {
                final String typeName = this.getInternalMetadata().getColumnTypeName(columnIndex);
                this.setUpdater(columnIndex, new GeneratedUpdatableResultSet.Updater<Void>(null){

                    @Override
                    public void set(OraclePreparedStatement statement, int index) throws SQLException {
                        statement.setNull(index, colType, typeName);
                    }
                });
            } else {
                this.setUpdater(columnIndex, new GeneratedUpdatableResultSet.Updater<Void>(null){

                    @Override
                    public void set(OraclePreparedStatement statement, int index) throws SQLException {
                        statement.setNull(index, colType);
                    }
                });
            }
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value, final int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            final int type = this.getInternalMetadata().getColumnType(columnIndex);
            this.setUpdater(columnIndex, new GeneratedUpdatableResultSet.Updater<Object>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setObject(index, this.value, type, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value, final SQLType targetSqlType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new GeneratedUpdatableResultSet.Updater<Object>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setObject(index, this.value, targetSqlType);
                }
            });
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value, final SQLType targetSqlType, final int scaleOrLength) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new GeneratedUpdatableResultSet.Updater<Object>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setObject(index, this.value, targetSqlType, scaleOrLength);
                }

                @Override
                public Object getExtra() {
                    return scaleOrLength;
                }
            });
        }
    }

    @Override
    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.resultSet.getColumnCount();
        }
        return this.columnCount;
    }

    OracleResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.rsetMetaData == null) {
            this.rsetMetaData = this.resultSet.getMetaData();
        }
        return (OracleResultSetMetaData)this.rsetMetaData;
    }

    private void cancelRowChanges() throws SQLException {
        if (this.isInserting) {
            this.cancelRowInserts();
        }
        if (this.isUpdating) {
            this.cancelRowUpdates();
        }
    }

    @Override
    boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void cancelRowInserts() {
        if (this.isInserting) {
            this.isInserting = false;
            this.clearUpdateBuffer();
        }
    }

    @Override
    boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void clearUpdateBuffer() {
        if (this.updateBuffer != null) {
            for (int i = 0; i < this.updateBuffer.length; ++i) {
                this.updateBuffer[i] = null;
            }
        }
        this.cleanTempLobs();
    }

    @Override
    protected void setUpdater(int idx, GeneratedUpdatableResultSet.Updater<?> setter) throws SQLException {
        assert (idx > 0 && idx <= this.getColumnCount()) : "columnIndex: " + idx + " columnCount: " + this.getColumnCount();
        assert (setter != null) : "setter is null";
        if (!this.isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82).fillInStackTrace();
            }
            this.isUpdating = true;
        }
        if (this.updateBuffer == null) {
            this.updateBuffer = new GeneratedUpdatableResultSet.Updater[this.getColumnCount()];
        }
        this.updateBuffer[idx - 1] = setter;
    }

    @Override
    protected GeneratedUpdatableResultSet.Updater<?> getUpdater(int idx) throws SQLException {
        if (idx < 1 || idx > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getUpdater").fillInStackTrace();
        }
        if (this.updateBuffer != null) {
            return this.updateBuffer[idx - 1];
        }
        return null;
    }

    @Override
    protected boolean isRowBufferUpdatedAt(int idx) throws SQLException {
        if (idx < 1 || idx > this.getColumnCount()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "isRowBufferUpdatedAt").fillInStackTrace();
        }
        if (this.updateBuffer == null) {
            return false;
        }
        return this.updateBuffer[idx - 1] != null;
    }

    private void prepareInsertRowStatement() throws SQLException {
        OracleResultSetMetaData rsmd = this.getInternalMetadata();
        ArrayList<String> updateColumns = new ArrayList<String>(this.updateBuffer.length);
        boolean anythingToInsert = false;
        for (int i = 1; i <= this.updateBuffer.length; ++i) {
            if (!this.isRowBufferUpdatedAt(i)) continue;
            updateColumns.add(rsmd.getColumnName(i));
            anythingToInsert = true;
        }
        if (!anythingToInsert) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 86).fillInStackTrace();
        }
        if (this.insertStmt == null || !updateColumns.equals(this.lastUpdateColumns)) {
            if (this.insertStmt != null) {
                this.insertStmt.close();
            }
            this.lastUpdateColumns = updateColumns;
            String sql = this.scrollStmt.sqlObject.getInsertSqlForUpdatableResultSet(updateColumns);
            PreparedStatement ps = this.connection.prepareStatement(sql, 1);
            this.insertStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
            this.insertStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.insertStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareInsertRowBinds() throws SQLException {
        int bindIndex = 1;
        bindIndex = this.prepareSubqueryBinds(this.insertStmt, bindIndex);
        OracleResultSetMetaData rsmd = this.getInternalMetadata();
        int param = bindIndex;
        for (int col = 1; col <= this.getColumnCount(); ++col) {
            GeneratedUpdatableResultSet.Updater<?> up = this.getUpdater(col);
            if (up == null) continue;
            if (rsmd.isNCHAR(col)) {
                this.insertStmt.setFormOfUse(param, (short)2);
            }
            up.set(this.insertStmt, param++);
        }
    }

    private RowId executeInsertRow() throws SQLException {
        if (this.insertStmt.executeUpdate() != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
        try (ResultSet rs = this.insertStmt.getGeneratedKeys();){
            rs.next();
            RowId rowId = rs.getRowId(1);
            return rowId;
        }
    }

    private int getNumColumnsChanged() throws SQLException {
        int numColumnsChanged = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.updateBuffer != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.updateBuffer[i] == null) continue;
                this.indexColsChanged[numColumnsChanged++] = i;
            }
        }
        return numColumnsChanged;
    }

    private void prepareUpdateRowStatement(int numColumnsChanged) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        String sql = this.scrollStmt.sqlObject.getUpdateSqlForUpdatableResultSet(this, numColumnsChanged, (Object[])this.updateBuffer, this.indexColsChanged);
        PreparedStatement ps = this.connection.prepareStatement(sql);
        this.updateStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
        this.updateStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
        if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
            this.updateStmt.setEscapeProcessing(true);
        }
    }

    private void prepareUpdateRowBinds(int numColumnsChanged) throws SQLException {
        int bindIndex = 1;
        bindIndex = this.prepareSubqueryBinds(this.updateStmt, bindIndex);
        OracleResultSetMetaData rsmd = this.getInternalMetadata();
        for (int i = 0; i < numColumnsChanged; ++i) {
            int idx = this.indexColsChanged[i];
            GeneratedUpdatableResultSet.Updater<?> up = this.getUpdater(idx + 1);
            Object value = up.getValue();
            if (value != null) {
                if (rsmd.isNCHAR(idx + 1)) {
                    this.updateStmt.setFormOfUse(bindIndex, (short)2);
                }
                up.set(this.updateStmt, bindIndex++);
                continue;
            }
            int colType = this.getInternalMetadata().getColumnType(idx + 1);
            if (colType == 2006 || colType == 2002 || colType == 2008 || colType == 2007 || colType == 2003 || colType == 2009) {
                this.updateStmt.setNull(bindIndex++, colType, this.getInternalMetadata().getColumnTypeName(idx + 1));
                continue;
            }
            if (rsmd.isNCHAR(idx + 1)) {
                this.updateStmt.setFormOfUse(bindIndex, (short)2);
            }
            this.updateStmt.setNull(bindIndex++, colType);
        }
        this.prepareCompareSelfBinds(this.updateStmt, bindIndex);
    }

    private void executeUpdateRow() throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
            }
            this.refreshRows(this.getRow() - 1, 1);
            this.cancelRowUpdates();
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    @Override
    int refreshRows(long firstRow, int numberOfRows) throws SQLException {
        return this.resultSet.refreshRows(firstRow, numberOfRows);
    }

    private void prepareDeleteRowStatement() throws SQLException {
        if (this.deleteStmt == null) {
            String sql = this.scrollStmt.sqlObject.getDeleteSqlForUpdatableResultSet(this);
            PreparedStatement ps = this.connection.prepareStatement(sql);
            this.deleteStmt = (OraclePreparedStatement)((OraclePreparedStatementWrapper)ps).preparedStatement;
            this.deleteStmt.setQueryTimeout(this.scrollStmt.getQueryTimeout());
            if (this.scrollStmt.sqlObject.generatedSqlNeedEscapeProcessing()) {
                this.deleteStmt.setEscapeProcessing(true);
            }
        }
    }

    private void prepareDeleteRowBinds() throws SQLException {
        int bindIndex = 1;
        bindIndex = this.prepareSubqueryBinds(this.deleteStmt, bindIndex);
        this.prepareCompareSelfBinds(this.deleteStmt, bindIndex);
    }

    private void executeDeleteRow() throws SQLException {
        if (this.deleteStmt.executeUpdate() == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 85).fillInStackTrace();
        }
        this.removeCurrentRowFromCache();
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
        this.resultSet.removeCurrentRowFromCache();
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return this.resultSet instanceof InsensitiveScrollableResultSet ? ((InsensitiveScrollableResultSet)this.resultSet).isFromResultSetCache() : false;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return this.scrollStmt.getCompileKey();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return this.scrollStmt.getRuntimeKey();
    }

    private int prepareCompareSelfBinds(OraclePreparedStatement pstmt, int bindIndex) throws SQLException {
        pstmt.setRowId(bindIndex, ((InsensitiveScrollableResultSet)this.resultSet).getPrependedRowId());
        return bindIndex + 1;
    }

    private int prepareSubqueryBinds(OraclePreparedStatement pstmt, int bindIndex) throws SQLException {
        return bindIndex + this.scrollStmt.copyBinds(pstmt, bindIndex - 1);
    }

    @Override
    protected void setIsNull(GeneratedUpdatableResultSet.NullStatus status) {
        this.wasNull = status;
    }

    @Override
    protected void setIsNull(boolean isNull) {
        this.setIsNull(isNull ? GeneratedUpdatableResultSet.NullStatus.VALUE_NULL : GeneratedUpdatableResultSet.NullStatus.VALUE_NOT_NULL);
    }

    @Override
    protected void doneFetchingRows(boolean fromPrepareForNewResult) throws SQLException {
        this.resultSet.doneFetchingRows(fromPrepareForNewResult);
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        return this.resultSet == null ? null : this.resultSet.getOracleStatement();
    }

    @Override
    public int getCursorId() throws SQLException {
        return this.scrollStmt.getCursorId();
    }

    @Override
    public final <T> Flow.Publisher<T> publisherOracle(Function<? super OracleRow, T> rowMappingFunction) throws SQLException {
        throw new UnsupportedOperationException("Row publishing is not supported for updatable ResultSets");
    }
}

