/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\u0019\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020 H\u0096\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0016R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "statement", "Ljava/sql/PreparedStatement;", "wasGeneratedKeysRequested", "", "(Ljava/sql/PreparedStatement;Z)V", "value", "", "fetchSize", "getFetchSize", "()Ljava/lang/Integer;", "setFetchSize", "(Ljava/lang/Integer;)V", "resultSet", "Ljava/sql/ResultSet;", "getResultSet", "()Ljava/sql/ResultSet;", "getStatement", "()Ljava/sql/PreparedStatement;", "getWasGeneratedKeysRequested", "()Z", "addBatch", "", "cancel", "closeIfPossible", "executeBatch", "", "executeQuery", "executeUpdate", "set", "index", "", "setInputStream", "inputStream", "Ljava/io/InputStream;", "setNull", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "exposed-jdbc"})
public final class JdbcPreparedStatementImpl
implements PreparedStatementApi {
    @NotNull
    private final PreparedStatement statement;
    private final boolean wasGeneratedKeysRequested;

    public JdbcPreparedStatementImpl(@NotNull PreparedStatement statement, boolean wasGeneratedKeysRequested) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.statement = statement;
        this.wasGeneratedKeysRequested = wasGeneratedKeysRequested;
    }

    @NotNull
    public final PreparedStatement getStatement() {
        return this.statement;
    }

    public final boolean getWasGeneratedKeysRequested() {
        return this.wasGeneratedKeysRequested;
    }

    @Nullable
    public ResultSet getResultSet() {
        return this.wasGeneratedKeysRequested ? this.statement.getGeneratedKeys() : this.statement.getResultSet();
    }

    @Nullable
    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    public void setFetchSize(@Nullable Integer value) {
        Integer n = value;
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.getStatement().setFetchSize(value);
        }
    }

    public void addBatch() {
        this.statement.addBatch();
    }

    @NotNull
    public ResultSet executeQuery() {
        ResultSet resultSet = this.statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"statement.executeQuery()");
        return resultSet;
    }

    public int executeUpdate() {
        return this.statement.executeUpdate();
    }

    public void set(int index, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.statement.setObject(index, value);
    }

    public void setNull(int index, @NotNull IColumnType columnType) {
        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
        if (columnType instanceof BinaryColumnType || columnType instanceof BlobColumnType) {
            this.statement.setNull(index, -4);
        } else {
            this.statement.setObject(index, null);
        }
    }

    public void setInputStream(int index, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.statement.setBinaryStream(index, inputStream, inputStream.available());
    }

    public void closeIfPossible() {
        if (!this.statement.isClosed()) {
            this.statement.close();
        }
    }

    @NotNull
    public List<Integer> executeBatch() {
        int[] nArray = this.statement.executeBatch();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"statement.executeBatch()");
        return ArraysKt.toList((int[])nArray);
    }

    public void cancel() {
        if (!this.statement.isClosed()) {
            this.statement.cancel();
        }
    }

    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args) {
        return PreparedStatementApi.DefaultImpls.fillParameters((PreparedStatementApi)this, args);
    }
}

