/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace.schedentity;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message.Action;
import com.bmc.ctmconvert.common.message.NewMessage;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import com.bmc.ctmconvert.workspace.IOnStatement;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import com.bmc.ctmconvert.workspace.WorkspacePath;
import com.bmc.ctmconvert.workspace.entities.Attributable;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.IDo;
import com.bmc.ctmconvert.workspace.entities.Job;
import com.bmc.ctmconvert.workspace.entities.Variable;
import com.bmc.ctmconvert.workspace.schedentity.ActionMessageSupplier;
import com.bmc.ctmconvert.workspace.schedentity.JobSchedEntity;
import com.bmc.ctmconvert.workspace.schedentity.SubFolderSchedEntity;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;

public abstract class OrderableSchedEntity
extends DefaultSchedEntity
implements ActionMessageSupplier {
    protected OrderableEntity entity;

    public OrderableSchedEntity(OrderableEntity orderableEntity) {
        super(orderableEntity.getName(), SchedEntity.TYPE.JOB);
        this.entity = orderableEntity;
    }

    @Override
    public List<Properties> getTags() {
        ArrayList<Properties> tags = new ArrayList<Properties>();
        this.entity.getRBCs().forEach(this.setEntityData(tags));
        return tags;
    }

    @Override
    public ArrayList<String> getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.entity.getMessages() != null) {
            List<NewMessage> entityMessages = this.entity.getMessages();
            for (NewMessage message : entityMessages) {
                List<String> messageParams = message.getMessageParams();
                String[] messageParamsArray = new String[messageParams.size()];
                messageParamsArray = messageParams.toArray(messageParamsArray);
                Object jobId = this.entity.getPath().getAbsolutPath() + "/" + this.entity.getName();
                if (((String)jobId).startsWith("/")) {
                    jobId = ((String)jobId).substring(1);
                }
                Reporter.addMessage(messages, message.getMessageId(), (String)jobId, messageParamsArray);
            }
        }
        return messages;
    }

    @Override
    public boolean hasMessages() {
        List<NewMessage> messages = this.entity.getMessages();
        return messages != null && !messages.isEmpty();
    }

    @Override
    public List<Action> getActions() {
        return this.entity.getActions();
    }

    @Override
    public boolean hasWarnings() {
        List<NewMessage> messages = this.entity.getMessages();
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        for (NewMessage message : messages) {
            if (!message.getMessageId().startsWith("WRN")) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedHashMap<String, String> getAutoedits() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        List<Variable> variablesList = this.entity.getVariables();
        for (Variable variable : variablesList) {
            ret.put(variable.getName(), variable.getValue());
        }
        return ret;
    }

    @Override
    public String getAttr(String attrName) {
        return this.entity.getAttributes().get(attrName);
    }

    @Override
    public String getParentName() {
        WorkspacePath path = this.entity.getPath();
        return path.getAbsolutPath();
    }

    @Override
    public List<Properties> getInConds() {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        this.entity.getInConditions().forEach(this.setEntityData(ret));
        return ret;
    }

    @Override
    public List<Properties> getOutConds() {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        this.entity.getOutConditions().forEach(this.setEntityData(ret));
        return ret;
    }

    @Override
    public List<Properties> getQuantResources() {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        this.entity.getQuantitativeResources().forEach(this.setEntityData(ret));
        return ret;
    }

    @Override
    public List<Properties> getCtrlResources() {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        this.entity.getControlResources().forEach(this.setEntityData(ret));
        return ret;
    }

    @Override
    public List<Properties> getShouts() {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        this.entity.getShouts().forEach(this.setEntityData(ret));
        return ret;
    }

    @Override
    public List<Properties> getOnStmt() {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        this.entity.getOnDo().forEach(this.setEntityData(ret));
        return ret;
    }

    @Override
    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        LinkedHashMap<Properties, List<Properties>> ret = new LinkedHashMap<Properties, List<Properties>>();
        this.entity.getOnDo().forEach(this.setLinkedHashMapEntityData(ret));
        return ret;
    }

    @Override
    public List<SchedEntity> getChildren() {
        List<IWorkspaceEntity> childrenList;
        ArrayList<SchedEntity> ret = new ArrayList<SchedEntity>();
        if (this.entity instanceof Folder && (childrenList = ((Folder)((Object)this.entity)).getChildren()) != null && !childrenList.isEmpty()) {
            for (IWorkspaceEntity child : childrenList) {
                if (child instanceof Job) {
                    ret.add(new JobSchedEntity((OrderableEntity)((Object)child)));
                    continue;
                }
                ret.add(new SubFolderSchedEntity((OrderableEntity)((Object)child)));
            }
        }
        return ret;
    }

    private Consumer<? super IOnStatement> setLinkedHashMapEntityData(LinkedHashMap<Properties, List<Properties>> onList) {
        return onStatemente -> {
            List<IDo> dos = onStatemente.getDos();
            List<Properties> listOfDo = this.getDoProperties(dos);
            Properties onProperties = this.convertAttributesToProperties((Attributable)onStatemente);
            onList.put(onProperties, listOfDo);
        };
    }

    private List<Properties> getDoProperties(List<IDo> dos) {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        for (IDo iDo : dos) {
            Properties doProperties = this.convertAttributesToProperties(iDo);
            ret.add(doProperties);
        }
        return ret;
    }

    private Consumer<? super Attributable> setEntityData(List<Properties> ret) {
        return workspacesEntity -> {
            Properties properties = this.convertAttributesToProperties((Attributable)workspacesEntity);
            ret.add(properties);
        };
    }

    private Properties convertAttributesToProperties(Attributable e) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : e.getAttributes().entrySet()) {
            String value = entry.getValue();
            if (entry.getValue() == null) {
                value = "";
            }
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    @Override
    public boolean isCyclic() {
        return "1".equals(this.entity.getAttributes().getOrDefault("CYCLIC", "0"));
    }
}

