/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace;

import com.bmc.ctmconvert.workspace.IWalkerEntityHandler;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.XmlEntity;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlDomAggregator
implements IWalkerEntityHandler {
    private Element root;
    private Document doc;
    private Map<IWorkspaceEntity, Element> domElements;

    public XmlDomAggregator(IWorkspaceData workspaceData) {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.doc = builder.newDocument();
        this.root = this.doc.createElement(workspaceData.getHeaderName());
        Map<String, String> headerAttributes = workspaceData.getHeaderAttributes();
        for (String attributeName : headerAttributes.keySet()) {
            String attributeValue = headerAttributes.get(attributeName);
            this.root.setAttribute(attributeName, attributeValue);
        }
        this.domElements = new HashMap<IWorkspaceEntity, Element>();
    }

    @Override
    public void handleEntity(IWorkspaceEntity child, Optional<Folder> parent) {
        if (!this.isSupported(child, parent)) {
            throw new UnSupportedObjectsException();
        }
        if (parent.isPresent()) {
            this.addChildToParent((XmlEntity)child, (XmlEntity)((Object)parent.get()));
        } else {
            this.addEntityToRoot((XmlEntity)child);
        }
    }

    private void addEntityToRoot(XmlEntity child) {
        this.addChildDomToParent(child, this.root);
    }

    private void addChildToParent(XmlEntity child, XmlEntity parent) {
        Element parentElement = this.domElements.get(parent);
        this.addChildDomToParent(child, parentElement);
    }

    private void addChildDomToParent(XmlEntity child, Element parentDom) {
        Element childDom = child.getXmlDom();
        Node importedSubElement = this.doc.importNode(childDom, true);
        this.domElements.put(child, (Element)importedSubElement);
        parentDom.appendChild(importedSubElement);
    }

    private boolean isSupported(IWorkspaceEntity child, Optional<Folder> parent) {
        if (!(child instanceof XmlEntity)) {
            return false;
        }
        return !parent.isPresent() || parent.get() instanceof XmlEntity;
    }

    public Element getDraft() {
        return this.root;
    }

    public void writeXml(Writer writer) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(this.root), new StreamResult(writer));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public class UnSupportedObjectsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

