/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.workspace;

import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.message.NullMessageHandler;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.WorkspaceData;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.IRBC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Workspace
implements IWorkspace {
    protected List<Folder> folders = new ArrayList<Folder>();
    protected List<IWorkspaceEntity> jobs = new ArrayList<IWorkspaceEntity>();
    private final Map<WorkspaceId, IWorkspaceEntity> idMap = new HashMap<WorkspaceId, IWorkspaceEntity>();
    private final List<IRBC> rbcs = new ArrayList<IRBC>();
    private final MessageHandler messageHandler;
    private IWorkspaceData workspaceData = new WorkspaceData("", new HashMap<String, String>());

    public Workspace() {
        this.messageHandler = new NullMessageHandler();
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public void addFolder(Folder folder) {
        this.addIdToMap(folder);
        this.folders.add(folder);
        List<IWorkspaceEntity> children = folder.getChildren();
        if (children != null) {
            for (IWorkspaceEntity child : children) {
                if (child == null || this.containsEntity(child.getId())) continue;
                this.addIdToMap(child);
            }
        }
    }

    private void addIdToMap(IWorkspaceEntity entity) {
        if (!this.idMap.containsKey(entity.getId())) {
            this.idMap.put(entity.getId(), entity);
        }
    }

    private void removeIdFromMap(IWorkspaceEntity entity) {
        if (this.idMap.containsKey(entity.getId())) {
            this.idMap.remove(entity.getId(), entity);
        }
    }

    @Override
    public void addJob(IWorkspaceEntity job) {
        this.addIdToMap(job);
        this.jobs.add(job);
        if (job.getParent().isPresent()) {
            this.addIdToMap(job.getParent().get());
        }
    }

    @Override
    public void removeJob(IWorkspaceEntity job) {
        this.removeIdFromMap(job);
        if (job.getParent().isPresent()) {
            job.getParent().get().removeChild(job);
        }
    }

    @Override
    public IWorkspaceEntity getEntityByID(WorkspaceId id) {
        return this.idMap.get(id);
    }

    public boolean containsEntity(WorkspaceId id) {
        return this.idMap.containsKey(id);
    }

    @Override
    public void insertChildToFolder(IWorkspaceEntity childEntity, Folder folder) {
        if (this.containsEntity(childEntity.getId()) && this.containsEntity(folder.getId())) {
            childEntity.setParent(folder);
        }
    }

    @Override
    public List<Folder> getTopLevelFolders() {
        return this.folders.stream().filter(this.isTopLevel()).collect(Collectors.toList());
    }

    private Predicate<? super Folder> isTopLevel() {
        return f -> f.getParent().isEmpty();
    }

    @Override
    public Optional<Folder> getParentOf(WorkspaceId id) {
        Optional<Folder> result = Optional.empty();
        if (this.idMap.containsKey(id)) {
            result = this.idMap.get(id).getParent();
        }
        return result;
    }

    @Override
    public List<IWorkspaceEntity> getChildrenOf(WorkspaceId id) {
        IWorkspaceEntity workspaceEntity = this.idMap.get(id);
        if (workspaceEntity instanceof Folder) {
            return ((Folder)workspaceEntity).getChildren();
        }
        return new ArrayList<IWorkspaceEntity>();
    }

    public void addGlobalRbc(IRBC globalRbc) {
        this.rbcs.add(globalRbc);
    }

    public void addMessage(String messageId, String ... params) {
        this.messageHandler.handleMessage(messageId, params);
    }

    @Override
    public void addWorkspaceData(IWorkspaceData workspaceData) {
        this.workspaceData = workspaceData;
    }

    @Override
    public IWorkspaceData getWorkspaceData() {
        return this.workspaceData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Workspace [folders={");
        for (Folder folder : this.folders) {
            builder.append(folder).append("\n");
        }
        builder.append("}\n");
        for (IWorkspaceEntity job : this.jobs) {
            builder.append(job).append("\n");
        }
        builder.append(this.workspaceData).append("\n");
        return builder.toString();
    }

    public List<IWorkspaceEntity> getJobsList() {
        return new ArrayList<IWorkspaceEntity>(this.jobs);
    }

    public List<IWorkspaceEntity> getFoldersList() {
        return new ArrayList<IWorkspaceEntity>(this.folders);
    }
}

