/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.vc.validationitem;

import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.util.Optional;
import java.util.Properties;

public class FieldValidationItem {
    public static final String JSON_FIELD_IDENTIFIER = "_JSON_";
    private final Properties rules;
    private final String fieldName;
    private final boolean isMPM;

    public FieldValidationItem(boolean isMPM, Properties rules, String fieldName) {
        this.isMPM = isMPM;
        this.rules = rules;
        this.fieldName = fieldName;
    }

    public boolean hasValidationRule() {
        return this.rules.containsKey(this.fieldName);
    }

    public String getPattern() {
        String key = this.getFieldType("Pattern");
        return this.getValue(key);
    }

    public String getMinSize() {
        String key = this.getFieldType("MIN");
        return this.getValue(key);
    }

    public String getMaxSize() {
        String key = this.getFieldType("MAX");
        return this.getValue(key);
    }

    public boolean isSupportNonLatin1() {
        String key = this.getFieldType("SupportNonLatin1");
        return "Y".equals(this.getValue(key));
    }

    private String getValue(String field) {
        return Optional.ofNullable(this.rules.getProperty(field)).map(String::trim).orElse(null);
    }

    private String getFieldType(String fieldAttribute) {
        String fieldIdentifier = SettingsBooleanKeys.JSON_DRAFT_FORMAT.isEnabled() && this.hasJsonAttribute(fieldAttribute) ? JSON_FIELD_IDENTIFIER : (this.isMPM ? "_" : "_ZOS_");
        return this.createKey(fieldIdentifier, fieldAttribute);
    }

    private String createKey(String fieldIdentifier, String fieldAttribute) {
        return this.fieldName + fieldIdentifier + fieldAttribute;
    }

    private boolean hasJsonAttribute(String fieldAttribute) {
        String key = this.createKey(JSON_FIELD_IDENTIFIER, fieldAttribute);
        return this.rules.containsKey(key);
    }
}

