/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.utils;

import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UniqueValueGenerator {
    private final Map<String, Set<String>> uniqueValues;
    private final String uniqueSeparator;

    public UniqueValueGenerator() {
        this(SettingsTable.instance().getProperty(SettingsStringKeys.UNIQUE_VALUE_SEPARATOR));
    }

    public UniqueValueGenerator(String separator) {
        this.uniqueSeparator = separator;
        this.uniqueValues = new HashMap<String, Set<String>>();
    }

    public String getUniqueValue(String key, String value) {
        return this.getUniqueValue(key, value, 0);
    }

    public String getUniqueValue(String key, String value, int lenth) {
        return this.getUniqueValue(key, value, lenth, this.uniqueSeparator, true);
    }

    public String getUniqueValue(String key, String value, int maxAllowedLength, String seprator, boolean update) {
        Set<String> values = this.getValuesSetForKey(key);
        String toRet = value;
        if (maxAllowedLength > 0 && maxAllowedLength < toRet.length()) {
            toRet = toRet.substring(0, maxAllowedLength);
        }
        int count = 1;
        while (values.contains(toRet)) {
            int valueLength = value.length();
            if (maxAllowedLength > 0) {
                valueLength = maxAllowedLength - String.format("%s%d", seprator, count).length();
            }
            String finalValue = value.length() < valueLength ? value : value.substring(0, valueLength);
            toRet = String.format("%s%s%d", finalValue, seprator, count);
            ++count;
        }
        if (update) {
            values.add(toRet);
        }
        return toRet;
    }

    public Set<String> getValuesSetForKey(String key) {
        return this.uniqueValues.computeIfAbsent(key, k -> new HashSet());
    }
}

