/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.services.settings;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.settings.Feature;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;

public class SettingsTable {
    private static SettingsTable instance;
    private Properties settings = this.loadSettings();

    public static SettingsTable instance() {
        if (instance == null) {
            instance = new SettingsTable();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private SettingsTable() {
    }

    private Properties loadSettings() {
        Properties settingsProperties = new Properties();
        try (FileReader reader = new FileReader(Globs.SETTINGS_FILE);){
            settingsProperties.load(reader);
        }
        catch (FileNotFoundException e) {
            ConversionLogger.getLogger().info("Setting file not exist. " + Globs.SETTINGS_FILE);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info("Setting file found, but conversion was unable to open " + Globs.SETTINGS_FILE + "\n" + e.getMessage());
        }
        return settingsProperties;
    }

    public String getProperty(SettingsStringKeys key) {
        return this.getProperty(key, key.getDefaultValue());
    }

    public String getProperty(SettingsStringKeys key, String defaultValue) {
        return this.getProperty(key.toString(), defaultValue);
    }

    public boolean getProperty(Feature feature) {
        return this.getProperty(feature.toString(), feature.getDefaultValue() ? "Y" : "N").equals("Y");
    }

    private String getProperty(String key, String defaultValue) {
        String toRet = this.settings.getProperty(key);
        if (toRet == null) {
            toRet = defaultValue;
        }
        return toRet;
    }

    public boolean setProperty(Feature feature, boolean value) {
        return this.setProperty(feature.toString(), value ? "Y" : "N");
    }

    public boolean setProperty(SettingsStringKeys key, String value) {
        return this.setProperty(key.toString(), value);
    }

    private boolean setProperty(String key, String value) {
        boolean seccess = true;
        if (key != null && value != null) {
            this.settings.setProperty(key, value);
        } else {
            ConversionLogger.getLogger().info(() -> "Unable to update setting file:\nKey: " + key + "\nValue: " + value);
            seccess = false;
        }
        return seccess;
    }

    public void saveSettings() {
        if (!this.settings.isEmpty()) {
            try (FileOutputStream settingsFile = new FileOutputStream(Globs.SETTINGS_FILE);){
                this.settings.store(settingsFile, "");
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info("Unable to write setting file\n" + e.getMessage());
            }
        }
    }

    public static void setTestingInstance(SettingsTable settingsTableMock) {
        instance = settingsTableMock;
    }

    public void consumeSettings(BiConsumer<Object, Object> consumer) {
        this.settings.forEach((BiConsumer<? super Object, ? super Object>)consumer);
    }
}

