/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.scriptelement;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.getter.CtmEntityGetter;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.scriptelement.CtmFolderBaseApi;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.CtmJobBaseApi;
import com.bmc.ctmconvert.scriptelement.CtmXmlElement;
import com.bmc.ctmconvert.workspace.AbstractOrderableEntity;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.entities.RbcAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CtmWorkspace {
    private final Workspace workspace;
    private final CtmEntityGetter ctmEntityMapper;
    private Map<String, List<CtmFolder>> folderNameToCtmFolderMap;
    private Map<String, List<CtmJob>> jobNameToCtmJobMap;
    private int jobNameToCtmJobMapLastSize;
    private int folderNameToCtmFolderMapLastSize;
    private final Map<String, List<CtmJob>> jobsByApplTypeMap = new HashMap<String, List<CtmJob>>();

    public CtmWorkspace(Workspace workspace, CtmEntityGetter ctmEntityMapper) {
        this.workspace = workspace;
        this.ctmEntityMapper = ctmEntityMapper;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public List<CtmJob> getJobsByName(String jobName) {
        this.mapJobs();
        ArrayList result = this.jobNameToCtmJobMap.get(jobName);
        return result != null ? result : new ArrayList();
    }

    public List<CtmFolder> getFoldersByName(String folderName) {
        this.mapFolders();
        ArrayList result = this.folderNameToCtmFolderMap.get(folderName);
        return result != null ? result : new ArrayList();
    }

    public CtmJob createJob(XmlElement xmlElement) {
        CtmXmlElement ctmXmlElement = xmlElement == null ? null : new CtmXmlElement(xmlElement);
        CtmJob jobScriptElement = new CtmJob(ctmXmlElement);
        this.workspace.addJob(jobScriptElement);
        if (xmlElement != null) {
            this.ctmEntityMapper.put(xmlElement, jobScriptElement);
        }
        return jobScriptElement;
    }

    public CtmJob createJob(CtmXmlElement ctmXmlElement) {
        return this.createJob(ctmXmlElement.getXmlElement());
    }

    public CtmFolder createFolder(XmlElement xmlElement) {
        CtmXmlElement ctmXmlElement = xmlElement == null ? null : new CtmXmlElement(xmlElement);
        CtmFolder folderScriptElement = new CtmFolder(ctmXmlElement);
        this.workspace.addFolder(folderScriptElement);
        if (xmlElement != null) {
            this.ctmEntityMapper.put(xmlElement, folderScriptElement);
        }
        folderScriptElement.addRBC(this.generateEverydayRbc());
        return folderScriptElement;
    }

    private RbcAPI generateEverydayRbc() {
        RbcAPI rbc = new RbcAPI();
        rbc.addAttribute("NAME", "EVERYDAY");
        rbc.addAttribute("DAYS", "ALL");
        rbc.addAttribute("MAXWAIT", "00");
        rbc.addAttribute("DAYS_AND_OR", "O");
        rbc.addAttribute("JAN", "1");
        rbc.addAttribute("FEB", "1");
        rbc.addAttribute("MAR", "1");
        rbc.addAttribute("APR", "1");
        rbc.addAttribute("MAY", "1");
        rbc.addAttribute("JUN", "1");
        rbc.addAttribute("JUL", "1");
        rbc.addAttribute("AUG", "1");
        rbc.addAttribute("SEP", "1");
        rbc.addAttribute("OCT", "1");
        rbc.addAttribute("NOV", "1");
        rbc.addAttribute("DEC", "1");
        rbc.addAttribute("SHIFT", "Ignore Job");
        rbc.addAttribute("RETRO", "0");
        rbc.addAttribute("LEVEL", "N");
        return rbc;
    }

    public CtmFolder createFolder(CtmXmlElement ctmXmlElement) {
        return this.createFolder(ctmXmlElement.getXmlElement());
    }

    public CtmFolder createFolder() {
        XmlElement xmlElement = null;
        return this.createFolder(xmlElement);
    }

    public void insertJobToFolder(CtmJob jobEntity, CtmFolder folder) {
        this.workspace.insertChildToFolder(jobEntity, folder);
    }

    public void insertFolderToFolder(CtmFolderBaseApi folderEntity, CtmFolder folder) {
        this.workspace.insertChildToFolder(folderEntity, folder);
    }

    public List<CtmJob> getAllJobs() {
        return this.workspace.getJobsList().stream().map(job -> (CtmJob)this.mapToWrappetEntityIfPresent((IWorkspaceEntity)job)).collect(Collectors.toList());
    }

    public List<CtmJob> getJobsFromType(JobType jobType) {
        return this.getJobsByApplType(jobType.getValue());
    }

    public List<CtmJob> getJobsByApplType(String applTypeToSerach) {
        List<Object> returnValue;
        if (this.jobsByApplTypeMap.containsKey(applTypeToSerach)) {
            returnValue = this.jobsByApplTypeMap.get(applTypeToSerach);
        } else {
            List jobsByApplTypeList = this.workspace.getJobsList().stream().map(job -> (CtmJob)this.mapToWrappetEntityIfPresent((IWorkspaceEntity)job)).filter(job -> job.getAttribute("APPL_TYPE") != null).filter(job -> job.getAttribute("APPL_TYPE").equals(applTypeToSerach)).collect(Collectors.toList());
            this.jobsByApplTypeMap.put(applTypeToSerach, jobsByApplTypeList);
            returnValue = this.jobsByApplTypeMap.get(applTypeToSerach);
        }
        return returnValue != null ? returnValue : new ArrayList();
    }

    public List<CtmJob> getDatabasesJobs() {
        return this.getJobsByApplType("DATABASE");
    }

    public List<CtmJob> getOsJobs() {
        return this.getJobsByApplType("OS");
    }

    public List<CtmJob> getFileTransferJobs() {
        return this.getJobsByApplType("FILE_TRANS");
    }

    public List<CtmJob> getFileWatcherJobs() {
        return this.getJobsByApplType("FileWatch");
    }

    public List<CtmJob> getInformaticaJobs() {
        return this.getJobsByApplType("ETL_INFA");
    }

    public List<CtmJob> getOs2200Jobs() {
        return this.getJobsByApplType(JobType.JobTypeOS2200.getValue());
    }

    public List<CtmJob> getSapR3Jobs() {
        return this.workspace.getJobsList().stream().map(job -> (CtmJob)this.mapToWrappetEntityIfPresent((IWorkspaceEntity)job)).filter(job -> job.getAttribute("APPL_TYPE") != null).filter(job -> job.getAttribute("APPL_TYPE").equals("SAP")).filter(job -> job.getAttribute("APPL_FORM") != null).filter(job -> job.getAttribute("APPL_FORM").equals("SAP R3")).collect(Collectors.toList());
    }

    public List<CtmJob> getSapBWJobs() {
        return this.workspace.getJobsList().stream().map(job -> (CtmJob)this.mapToWrappetEntityIfPresent((IWorkspaceEntity)job)).filter(job -> job.getAttribute("APPL_TYPE") != null).filter(job -> job.getAttribute("APPL_TYPE").equals("SAP")).filter(job -> job.getAttribute("APPL_FORM") != null).filter(job -> job.getAttribute("APPL_FORM").equals("SAP Business Warehouse")).collect(Collectors.toList());
    }

    public List<CtmFolder> getAllFolders() {
        return this.workspace.getFoldersList().stream().map(folder -> (CtmFolder)this.mapToWrappetEntityIfPresent((IWorkspaceEntity)folder)).collect(Collectors.toList());
    }

    public CtmJobBaseApi getJob(CtmXmlElement ctmXmlElement) {
        return (CtmJobBaseApi)this.ctmEntityMapper.get(ctmXmlElement);
    }

    public CtmFolderBaseApi getFolder(CtmXmlElement ctmXmlElement) {
        return (CtmFolderBaseApi)this.ctmEntityMapper.get(ctmXmlElement);
    }

    private CtmBaseEntity mapToWrappetEntityIfPresent(IWorkspaceEntity entity) {
        return (CtmBaseEntity)entity;
    }

    public CtmFolder getFolderByName(String folderName) {
        return this.getFoldersByName(folderName).stream().findFirst().orElse(null);
    }

    public CtmJob getJobByName(String jobName) {
        return this.getJobsByName(jobName).stream().findFirst().orElse(null);
    }

    public void mapFolders() {
        int foldersListSize = this.workspace.getFoldersList().size();
        if (this.folderNameToCtmFolderMap == null) {
            this.folderNameToCtmFolderMap = this.workspace.getFoldersList().stream().map(CtmFolder.class::cast).collect(Collectors.groupingBy(AbstractOrderableEntity::getName));
        } else if (foldersListSize != this.folderNameToCtmFolderMapLastSize) {
            this.handleFoldersDiff(foldersListSize);
        }
        this.folderNameToCtmFolderMapLastSize = foldersListSize;
    }

    private void handleFoldersDiff(int foldersListSize) {
        int diff = foldersListSize - this.folderNameToCtmFolderMapLastSize;
        int fromRange = foldersListSize - diff;
        List<IWorkspaceEntity> foldersSubList = this.workspace.getFoldersList().subList(fromRange, foldersListSize);
        for (IWorkspaceEntity entity : foldersSubList) {
            String key = entity.getName();
            if (this.folderNameToCtmFolderMap.containsKey(key)) {
                this.folderNameToCtmFolderMap.get(key).add((CtmFolder)entity);
                continue;
            }
            ArrayList<CtmFolder> newFolderListForKey = new ArrayList<CtmFolder>();
            newFolderListForKey.add((CtmFolder)entity);
            this.folderNameToCtmFolderMap.put(key, newFolderListForKey);
        }
    }

    public void mapJobs() {
        int jobsListSize = this.workspace.getJobsList().size();
        if (this.jobNameToCtmJobMap == null) {
            this.jobNameToCtmJobMap = this.workspace.getJobsList().stream().map(CtmJob.class::cast).collect(Collectors.groupingBy(AbstractOrderableEntity::getName));
        } else if (jobsListSize != this.jobNameToCtmJobMapLastSize) {
            this.handleJobsDiff(jobsListSize);
        }
        this.jobNameToCtmJobMapLastSize = jobsListSize;
    }

    private void handleJobsDiff(int jobsListSize) {
        int diff = jobsListSize - this.jobNameToCtmJobMapLastSize;
        int fromRange = jobsListSize - diff;
        List<IWorkspaceEntity> jobsSubList = this.workspace.getJobsList().subList(fromRange, jobsListSize);
        for (IWorkspaceEntity entity : jobsSubList) {
            String key = entity.getName();
            if (this.jobNameToCtmJobMap.containsKey(key)) {
                this.jobNameToCtmJobMap.get(key).add((CtmJob)entity);
                continue;
            }
            ArrayList<CtmJob> newJobsListForKey = new ArrayList<CtmJob>();
            newJobsListForKey.add((CtmJob)entity);
            this.jobNameToCtmJobMap.put(key, newJobsListForKey);
        }
    }

    public List<CtmJob> getAirflowJobs() {
        return this.getJobsFromType(JobType.JobTypeAirflow);
    }

    public static enum JobType {
        JobTypeOs("OS"),
        JobTypeSAPR3("SAP"),
        JobTypeFileTransfer("FILE_TRANS"),
        JobTypeInformatica("ETL_INFA"),
        JobTypeAirflow("AFL"),
        JobTypeOS2200("OS2200");

        private final String value;

        private JobType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

