/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.scriptelement;

import com.bmc.ctmconvert.api.ActionsAPI;
import com.bmc.ctmconvert.api.GeneralAPI;
import com.bmc.ctmconvert.api.PrerequisitesAPI;
import com.bmc.ctmconvert.api.SchedulingAPI;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.exception.InvalidParameterException;
import com.bmc.ctmconvert.exception.StringDoesNotMatchPatternException;
import com.bmc.ctmconvert.scriptelement.CtmFolder;
import com.bmc.ctmconvert.scriptelement.OrderableEntityWrapper;
import com.bmc.ctmconvert.workspace.entities.Folder;
import com.bmc.ctmconvert.workspace.entities.InCondition;
import com.bmc.ctmconvert.workspace.entities.OutCondition;
import com.bmc.ctmconvert.workspace.entities.Variable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface CtmBaseEntity
extends OrderableEntityWrapper {
    public static final String HOURS = "H";
    public static final String MINUTES = "M";
    public static final String DAYS = "D";

    @Override
    public CtmBaseEntity getBaseEntity();

    default public void setDescription(String description) {
        this.addAttribute("DESCRIPTION", description);
    }

    default public String getDescription() {
        return this.getBaseEntity().getAttributes().get("DESCRIPTION");
    }

    default public void setRunAs(String runAs) {
        this.addAttribute("OWNER", runAs);
    }

    default public void setApplication(String application) {
        this.addAttribute("APPLICATION", application);
    }

    default public void setSubApplication(String subApplication) {
        this.addAttribute("GROUP", subApplication);
    }

    default public void addOutCondition(String sourceJobName, String targetJobName) {
        this.addOutCondition(sourceJobName + "-TO-" + targetJobName);
    }

    default public void addOutCondition(String conditionName) {
        OutCondition outCondition = new OutCondition(conditionName, "ODAT", "+");
        this.addOutCondition(outCondition);
    }

    default public void addInCondition(String sourceJobName, String targetJobName) {
        this.addInCondition(sourceJobName + "-TO-" + targetJobName);
    }

    default public void addInCondition(String sourceJobName, String targetJobName, boolean addOutConditionForRemoval) {
        this.addInCondition(sourceJobName + "-TO-" + targetJobName, addOutConditionForRemoval);
    }

    default public void addInCondition(String conditionName) {
        this.addInCondition(conditionName, true);
    }

    default public void addInCondition(String conditionName, boolean addOutConditionForRemoval) {
        InCondition inCondition = new InCondition(conditionName, "ODAT", "A");
        this.addInCondition(inCondition);
        if (addOutConditionForRemoval) {
            OutCondition outCondition = new OutCondition(conditionName, "ODAT", "-");
            this.addOutCondition(outCondition);
        }
    }

    default public void setIsCyclic(boolean isCyclic) {
        this.addAttribute("CYCLIC", isCyclic ? "1" : "0");
    }

    default public void setTimeFrom(String hours, String minutes) {
        String timeFrom = String.format("%2s%2s", hours, minutes);
        this.addAttribute("TIMEFROM", timeFrom);
    }

    default public void setRerunByMinutes(String minutes) {
        this.setRerunEvery(minutes, MINUTES);
    }

    default public void setRerunByHours(String hours) {
        this.setRerunEvery(hours, HOURS);
    }

    default public void setRerunByDays(String days) {
        this.setRerunEvery(days, DAYS);
    }

    default public void setRerunEvery(String interval, String unit) {
        String intervalAttrValue = String.format("%05d" + unit, Integer.parseInt(interval));
        this.setIsCyclic(true);
        this.addAttribute("INTERVAL", intervalAttrValue);
        this.addAttribute("CYCLIC_TYPE", "C");
        this.addAttribute("IND_CYCLIC", "S");
    }

    default public void addIntervalSequenceByDays(String interval) {
        this.addIntervalSequenceBy(interval, DAYS);
    }

    default public void addIntervalSequenceByHours(String interval) {
        this.addIntervalSequenceBy(interval, HOURS);
    }

    default public void addIntervalSequenceByMinutes(String interval) {
        this.addIntervalSequenceBy(interval, MINUTES);
    }

    default public void addIntervalSequenceBy(String interval, String unit) {
        String intervalAttrValue = String.format("+%d" + unit, Integer.parseInt(interval));
        this.setIsCyclic(true);
        String intervalSequenceString = this.getAttributes().get("CYCLIC_INTERVAL_SEQUENCE");
        if (intervalSequenceString == null) {
            this.addAttribute("CYCLIC_INTERVAL_SEQUENCE", intervalAttrValue);
        } else {
            intervalSequenceString = intervalSequenceString.concat("," + intervalAttrValue);
            this.addAttribute("CYCLIC_INTERVAL_SEQUENCE", intervalSequenceString);
        }
        this.addAttribute("CYCLIC_TYPE", "V");
        this.addAttribute("IND_CYCLIC", "S");
    }

    default public void setWeekDays(String weedDaysStr) throws StringDoesNotMatchPatternException {
        String pattern = "^\\d(,\\d){0,6}$|ALL";
        if (!this.isStringContainPattern(weedDaysStr, pattern)) {
            throw new StringDoesNotMatchPatternException(weedDaysStr, pattern);
        }
        this.addAttribute("WEEKDAYS", weedDaysStr);
    }

    default public void setMonths(String monthsStr) throws StringDoesNotMatchPatternException {
        String pattern = "^(\\d|10|11)(,\\d|,10|,11){0,11}$";
        if (!this.isStringContainPattern(monthsStr, pattern)) {
            throw new StringDoesNotMatchPatternException(monthsStr, pattern);
        }
        String[] monthsArray = GlobalFunctions.getMonthsArray();
        for (String month : monthsStr.split(",")) {
            Integer monthIntegerValue = Integer.parseInt(month);
            this.addAttribute(monthsArray[monthIntegerValue], "1");
        }
    }

    default public boolean isStringContainPattern(String str, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    default public void setIntervalsAreFromJobState(String indCyclic) {
        List<String> possibleValues = Arrays.asList("S", "E", "T");
        if (!possibleValues.contains(indCyclic)) {
            throw new InvalidParameterException("setIntervalsAreFromJobState method", "S,E,T");
        }
        this.addAttribute("IND_CYCLIC", indCyclic);
    }

    default public void setVariable(String name, String value) {
        Variable variable = new Variable(name, value);
        if (this.getVariableByName(name) != null) {
            this.removeVariable(name);
        }
        this.addVariable(variable);
    }

    default public String getFullPathName() {
        return this.getFullPathName(".");
    }

    default public String getFullPathName(String delimeter) {
        if (this.getBaseEntity().getParent().isPresent()) {
            return this.getPathToJob(this.getBaseEntity().getParent().get()) + delimeter + this.getName();
        }
        return this.getName();
    }

    default public String getPathToJob(Folder parentFolder) {
        if (!parentFolder.getParent().isPresent()) {
            return parentFolder.getName();
        }
        return this.getPathToJob(parentFolder.getParent().get()) + "." + parentFolder.getName();
    }

    default public CtmFolder getParentFolder() {
        return this.getParent().isPresent() ? (CtmFolder)this.getParent().get() : null;
    }

    default public PrerequisitesAPI prerequisites() {
        return new PrerequisitesAPI(this);
    }

    default public SchedulingAPI scheduling() {
        return new SchedulingAPI(this);
    }

    default public GeneralAPI general() {
        return new GeneralAPI(this);
    }

    default public ActionsAPI actions() {
        return new ActionsAPI(this);
    }

    default public String getVariableByName(String name) {
        return this.getVariables().stream().filter(variable -> variable.getName().equalsIgnoreCase(name)).map(v -> v.getValue()).findFirst().orElse("");
    }
}

