/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ondo;

import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.IdentityProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public abstract class OnStatement {
    private final String statement;
    private final String code;
    ArrayList<Do> doList;

    protected OnStatement(String statement, String code) {
        this.statement = statement;
        this.code = code;
        this.doList = new ArrayList();
    }

    public static OnOkStatement createOnOkStatement() {
        return new OnOkStatement();
    }

    public static void addOnToOnMap(Map<Properties, List<Properties>> onDoStmt, OnStatement on) {
        on.accept(onDoStmt::put);
    }

    private Properties getProperties() {
        Properties ret = new Properties();
        ret.put("CODE", this.code);
        ret.put("STMT", this.statement);
        return ret;
    }

    public void accept(BiConsumer<Properties, List<Properties>> consumer) {
        if (!this.doList.isEmpty()) {
            IdentityProperties properties = new IdentityProperties(this.getProperties());
            consumer.accept(properties, this.createDoStatements());
        }
    }

    public boolean hasDoStatements() {
        return !this.doList.isEmpty();
    }

    public static OnNumberOfFailures createOnNumberOfFailures(String numberOfFailures) {
        return new OnNumberOfFailures(numberOfFailures);
    }

    public static OnNotOkStatement createOnNotOkStatement() {
        return new OnNotOkStatement();
    }

    public static OnNumberOfReruns createOnNumberOfReruns(int numberOfReruns) {
        return new OnNumberOfReruns(numberOfReruns);
    }

    public static OnNumberOfRetries createOnNumberOfRetries(String numberOfRetries) {
        return new OnNumberOfRetries(numberOfRetries);
    }

    public static OnCompletionStatus createOnCompletionStatus(int completionStatus) {
        return new OnCompletionStatus(completionStatus);
    }

    public static OnCompletionStatus createOnCompletionStatusNotEquals(int completionStatus) {
        return new OnCompletionStatus(completionStatus, COMPLETION_STATUS_OP.NE);
    }

    public static OnCompletionStatus createOnCompletionStatusLessThenEquals(int completionStatus) {
        return new OnCompletionStatus(completionStatus, COMPLETION_STATUS_OP.LE);
    }

    public static OnCompletionStatus createOnCompletionStatusGreaterThenEquals(int completionStatus) {
        return new OnCompletionStatus(completionStatus, COMPLETION_STATUS_OP.GE);
    }

    public static OnCompletionStatus createOnCompletionStatusLessThen(int completionStatus) {
        return new OnCompletionStatus(completionStatus, COMPLETION_STATUS_OP.LT);
    }

    public static OnCompletionStatus createOnCompletionStatus(int completionStatus, String comp) {
        return switch (comp.toUpperCase()) {
            case "NE" -> OnStatement.createOnCompletionStatusNotEquals(completionStatus);
            case "LE" -> OnStatement.createOnCompletionStatusLessThenEquals(completionStatus);
            case "GE" -> OnStatement.createOnCompletionStatusGreaterThenEquals(completionStatus);
            case "LT" -> OnStatement.createOnCompletionStatusLessThen(completionStatus);
            default -> OnStatement.createOnCompletionStatus(completionStatus);
        };
    }

    public OnStatement addDo(Do doObj) {
        this.doList.add(doObj);
        return this;
    }

    public void addAllDo(List<Do> doList) {
        this.doList.addAll(doList);
    }

    private List<Properties> createDoStatements() {
        return this.doList.stream().map(Do::getProperties).collect(Collectors.toList());
    }

    public String toString() {
        return "OnStatement [stateMent=" + this.statement + ", code=" + this.code + "\nDolist:\n" + String.valueOf(this.doList) + "]";
    }

    public static class OnOkStatement
    extends OnStatement {
        public OnOkStatement() {
            super("*", "OK");
        }
    }

    public static class OnNumberOfFailures
    extends OnStatement {
        static String numberOfFailuresFormat = "FAILCOUNT=%s";

        public OnNumberOfFailures(String numberOfRetries) {
            super("*", String.format(numberOfFailuresFormat, numberOfRetries));
        }
    }

    public static class OnNotOkStatement
    extends OnStatement {
        public OnNotOkStatement() {
            super("*", "NOTOK");
        }
    }

    public static class OnNumberOfReruns
    extends OnStatement {
        static String runCountFormat = "RUNCOUNT EQ %s";

        public OnNumberOfReruns(int numberOfReruns) {
            super("*", String.format(runCountFormat, numberOfReruns));
        }
    }

    public static class OnNumberOfRetries
    extends OnStatement {
        static String retryCountFormat = "RERUNNO EQ %s";

        public OnNumberOfRetries(String numberOfRetries) {
            super("*", String.format(retryCountFormat, numberOfRetries));
        }
    }

    public static class OnCompletionStatus
    extends OnStatement {
        static String completionStatusFormat = "COMPSTAT %s %s";

        public OnCompletionStatus(int completionStatus) {
            this(completionStatus, COMPLETION_STATUS_OP.EQ);
        }

        public OnCompletionStatus(int completionStatus, COMPLETION_STATUS_OP op) {
            super("*", String.format(completionStatusFormat, op.toString(), completionStatus));
        }
    }

    private static enum COMPLETION_STATUS_OP {
        EQ,
        NE,
        LE,
        LT,
        GE;

    }

    public static class OnJobEndedStatement
    extends OnStatement {
        public OnJobEndedStatement() {
            super("*", "COMPSTAT EQ ANY");
        }
    }

    public static class OnSpecificStatement
    extends OnStatement {
        public OnSpecificStatement(String statement, String code) {
            super(statement, code);
        }
    }
}

