/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ondo;

import com.bmc.ctmconvert.ondo.Do;
import java.util.Optional;
import java.util.Properties;

public class DoOutput
extends Do {
    private Optional<String> destination;
    private Operation operation;
    private Optional<String> fromClass = Optional.empty();

    public DoOutput(Operation operation) {
        super("DOSYSOUT");
        this.operation = operation;
    }

    @Override
    protected Properties getDoProperties() {
        Properties ret = new Properties();
        this.destination.ifPresent(des -> ret.put("PAR", des));
        ret.setProperty("OPTION", this.operation.toString());
        this.fromClass.ifPresent(fromClass -> ret.setProperty("FROM", (String)fromClass));
        return ret;
    }

    public DoOutput setDestination(String destination) {
        this.destination = Optional.ofNullable(destination);
        return this;
    }

    public DoOutput setFromClass(String fromClass) {
        this.fromClass = Optional.ofNullable(fromClass);
        return this;
    }

    public static enum Operation {
        Copy("Copy"),
        File("File"),
        Delete("Delete"),
        Move("Move"),
        NewDest("NewDest"),
        Print("Release"),
        Release("Release"),
        ChangeClass("ChangeClass");

        private final String operation;

        private Operation(String operation) {
            this.operation = operation;
        }

        public String toString() {
            return this.operation;
        }
    }
}

