/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.interfaces;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.interfaces.ConversionReader;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import com.bmc.ctmconvert.io.csv.DataObjectToCsvWriter;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.IOException;
import java.nio.file.Path;

public abstract class DefaultVendorData
implements VendorData {
    private volatile DataObject dataObject;
    private String dataObjectProjectName = "";

    protected abstract ConversionReader getReader();

    @Override
    public DataObject getDataObject() {
        String currentProject = ConversionEntitiesService.getCurrentProjectName();
        if (this.dataObject == null || !currentProject.equals(this.dataObjectProjectName)) {
            ConversionReader reader = this.getReader();
            this.dataObject = reader != null ? reader.read() : null;
            this.dataObjectProjectName = currentProject;
        }
        return this.dataObject;
    }

    public void writeDataObjectToCsv(Path target) {
        DataObjectToCsvWriter dataObjectWriter = new DataObjectToCsvWriter();
        if (target != null) {
            try {
                if (dataObjectWriter.getCsvWriter() == null) {
                    dataObjectWriter.setCsvWriter(new CsvWriter(target.toString() + Globs.DIRSEP + "DataObject.csv"));
                }
                dataObjectWriter.write(this.getDataObject());
            }
            catch (IOException e) {
                ConversionLogger.getLogger().warning("Failed to write data object:" + e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
    }
}

