/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport.dbtableomporter;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportDetails;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;

public class AutomaticDBTableImporter
extends Importer {
    protected ImportDetails connectionDetails;
    protected ImportEntry entry;
    private Connection connection;
    private String tableName;
    private int rowCount;
    private String schemaName;
    private SimpleDateFormat sdf;
    private boolean connectionOnly;

    public AutomaticDBTableImporter(ImportEntry entry, boolean connectionOnly) {
        this.entry = entry;
        this.connectionOnly = connectionOnly;
        this.initialize();
    }

    private void initialize() {
        this.connectionDetails = this.entry.getImportDetails();
        this.tableName = this.entry.getTableName().trim();
        this.schemaName = this.connectionDetails.getProperty("SchemaName");
        if (this.schemaName == null) {
            this.schemaName = "";
        }
        if (!this.schemaName.isEmpty()) {
            this.schemaName = this.schemaName.trim() + ".";
        }
        this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    }

    @Override
    public String getTitle() {
        return "Extracting table records";
    }

    @Override
    public boolean isImportable() {
        boolean importable;
        this.initConnection();
        boolean bl = importable = this.connection != null;
        if (this.connectionOnly) {
            String messageFormat = importable ? "Connection to '%s' succeed" : "Unable to connect '%s'";
            ProcessAlertsManager.instance().addMessage(String.format(messageFormat, this.entry.getImportDetails().getProperty("ServerName")));
        }
        this.setStatus(Progressable.ProgressStatus.RUNNING);
        return importable;
    }

    @Override
    public String getID() {
        return this.entry.getID();
    }

    @Override
    public Progressable.ProgressStatus performImport() {
        this.initConnection();
        int ret = this.count();
        if (ret > 0) {
            this.setProgressMax(this.count());
            ret = this.export();
        }
        if (this.isStopped()) {
            this.setStatus(Progressable.ProgressStatus.ENDED_STOPED);
        } else if (ret >= 0) {
            this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
        } else {
            this.setStatus(this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
        }
        return this.getStatus();
    }

    private void initConnection() {
        if (this.connection == null) {
            String databaseType = this.connectionDetails.getProperty("DBType");
            String hostName = this.connectionDetails.getProperty("HostName");
            String port = this.connectionDetails.getProperty("DBPort");
            String instance = this.connectionDetails.getProperty("ServerName");
            String userName = this.connectionDetails.getProperty("UserName");
            String password = this.connectionDetails.getProperty("Password");
            Object dbURL = "";
            try {
                boolean isSQLServerAuth = this.connectionDetails.getProperty("AuthenticationType").equalsIgnoreCase("SQL Server Authentication");
                if (databaseType.equalsIgnoreCase("ORACLE")) {
                    isSQLServerAuth = true;
                    dbURL = "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + hostName + ")(PORT = " + port + "))(LOAD_BALANCE=yes))(CONNECT_DATA=(SERVICE_NAME=" + instance + ")))";
                } else if (databaseType.equalsIgnoreCase("MSSQL")) {
                    Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                    dbURL = "jdbc:sqlserver://" + hostName + ":" + port + ";databaseName=" + instance + (isSQLServerAuth ? ";integratedSecurity=false" : ";integratedSecurity=true");
                }
                ConversionLogger.getLogger().log(Level.INFO, String.format("'%s' connection string for '%s'.\n'%s'", databaseType, this.entry.getTitle(), dbURL));
                this.connection = isSQLServerAuth ? DriverManager.getConnection((String)dbURL, userName, password) : DriverManager.getConnection((String)dbURL);
            }
            catch (ClassNotFoundException | SQLException e) {
                this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
                ConversionLogger.getLogger().log(Level.WARNING, String.format("Unable to connect '%s'", instance), e);
                ExceptionHandler.writeToExceptionFile(e);
                ProcessAlertsManager.instance().addMessage(String.format("Connection failure: %s", e.getMessage()));
            }
        }
    }

    /*
     * Loose catch block
     */
    public int count() {
        block14: {
            Statement ps;
            block13: {
                ps = null;
                this.rowCount = -1;
                ps = this.connection.prepareStatement(String.format("select count(*) from %s%s", this.schemaName, this.tableName));
                ResultSet results = ps.executeQuery();
                if (results == null || !results.next()) break block13;
                this.rowCount = results.getInt(1);
                ps.close();
            }
            try {
                if (ps != null) {
                    ps.close();
                }
                break block14;
            }
            catch (SQLException e) {
                ConversionLogger.getLogger().log(Level.INFO, String.format("Failed to close statement when counting rows in '%s'", this.entry.getTableName()), e);
            }
            break block14;
            catch (SQLException e) {
                try {
                    ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to count rows in '%s'", this.entry.getTableName()), e);
                }
                catch (Throwable throwable) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e2) {
                        ConversionLogger.getLogger().log(Level.INFO, String.format("Failed to close statement when counting rows in '%s'", this.entry.getTableName()), e2);
                    }
                    throw throwable;
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e3) {
                    ConversionLogger.getLogger().log(Level.INFO, String.format("Failed to close statement when counting rows in '%s'", this.entry.getTableName()), e3);
                }
            }
        }
        return this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int export() {
        int ret;
        block29: {
            ResultSet results;
            Statement ps;
            CsvWriter tableWriter;
            block28: {
                ret = -1;
                String destinationfile = ConversionEntitiesService.getCurrentProjectDataDirectory() + this.entry.getDestinationFileName();
                tableWriter = new CsvWriter(destinationfile);
                ResultSetMetaData metaData = null;
                ps = null;
                results = null;
                ps = this.connection.prepareStatement(String.format("select * from %s%s", this.schemaName, this.tableName));
                results = ps.executeQuery();
                if (results == null) {
                    ret = -1;
                }
                if ((ret = this.count()) <= 0) break block28;
                metaData = results.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    tableWriter.write(metaData.getColumnLabel(i).toUpperCase());
                }
                tableWriter.endRecord();
                tableWriter.flush();
                int recordCounter = 0;
                while (results.next() && !this.isStopped()) {
                    for (int i = 1; i <= columnCount; ++i) {
                        if (metaData.getColumnType(i) == 91 || metaData.getColumnType(i) == 93) {
                            if (metaData.getColumnType(i) == 91) {
                                Date d = results.getDate(i);
                                if (d != null) {
                                    tableWriter.write(this.sdf.format(d));
                                } else {
                                    tableWriter.write(results.getString(i));
                                }
                            }
                            if (metaData.getColumnType(i) != 93) continue;
                            Timestamp ts = results.getTimestamp(i);
                            if (ts != null) {
                                tableWriter.write(this.sdf.format(ts));
                                continue;
                            }
                            tableWriter.write(results.getString(i));
                            continue;
                        }
                        tableWriter.write(results.getString(i));
                    }
                    tableWriter.endRecord();
                    tableWriter.flush();
                    this.setCurrentProgress(++recordCounter);
                }
            }
            try {
                tableWriter.close();
                if (results != null) {
                    results.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
                break block29;
            }
            catch (SQLException e) {
                ConversionLogger.getLogger().log(Level.INFO, String.format("Failed to close statement or connection after ectracting '%s'", this.entry.getTableName()), e);
            }
            break block29;
            catch (IOException | SQLException e) {
                try {
                    ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to extract '%s'", this.entry.getTableName()), e);
                }
                catch (Throwable throwable) {
                    try {
                        tableWriter.close();
                        if (results != null) {
                            results.close();
                        }
                        if (ps != null) {
                            ps.close();
                        }
                        if (this.connection != null) {
                            this.connection.close();
                        }
                    }
                    catch (SQLException e2) {
                        ConversionLogger.getLogger().log(Level.INFO, String.format("Failed to close statement or connection after ectracting '%s'", this.entry.getTableName()), e2);
                    }
                    throw throwable;
                }
                try {
                    tableWriter.close();
                    if (results != null) {
                        results.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (SQLException e3) {
                    ConversionLogger.getLogger().log(Level.INFO, String.format("Failed to close statement or connection after ectracting '%s'", this.entry.getTableName()), e3);
                }
            }
        }
        return ret;
    }
}

