/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.AbstractImportEntity;
import com.bmc.ctmconvert.dataimport.FileDirectoryEntry;
import com.bmc.ctmconvert.dataimport.ImportDetails;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.dataimport.ListEntry;
import com.bmc.ctmconvert.dataimport.SubSectionTitleEntry;
import com.bmc.ctmconvert.dataimport.TextInputEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImportEntryReader {
    public static final String rootNodeName = "ImportEntries";
    private ImportDetails importDetails;
    private ImporterType type;
    private String defaultsLocation;
    private Document entriesDocument;

    public ImportEntryReader(String defaultsLocation) {
        this.defaultsLocation = defaultsLocation;
    }

    public ImportEntryList read(InputStream in) {
        ImportEntryList list = null;
        try {
            Document userInputDocument = this.getDocumentEntries(in);
            this.handleAttributes();
            Map<String, Element> userInputEntries = this.handleUserInputEntries(userInputDocument);
            list = this.getImportEntriesList(userInputEntries);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ConversionLogger.getLogger().severe("Unable to read import entries details: " + e.getMessage());
        }
        return list;
    }

    private Document getDocumentEntries(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.entriesDocument = builder.parse(new InputSource(in));
        File defaultsFile = new File(this.defaultsLocation);
        Document userInputDocument = null;
        if (defaultsFile.isFile()) {
            try (FileInputStream defaults = new FileInputStream(defaultsFile);){
                if (defaults != null) {
                    userInputDocument = builder.parse(new InputSource(defaults));
                }
            }
            catch (IOException | IllegalArgumentException | SAXException e) {
                ConversionLogger.getLogger().info("Unable to read import entries user data: " + e.getMessage());
            }
        }
        return userInputDocument;
    }

    private ImportEntryList getImportEntriesList(Map<String, Element> userInputEntries) {
        ImportEntryList importIntrylist = new ImportEntryList(this.type, this.entriesDocument, this.defaultsLocation, this.importDetails);
        Element documentElement = this.entriesDocument.getDocumentElement();
        NodeList entries = documentElement.getChildNodes();
        for (int index = 0; index < entries.getLength(); ++index) {
            Node xmlEntry = entries.item(index);
            if (xmlEntry.getAttributes() == null || xmlEntry.getNodeType() != 1) continue;
            Element xmlEntryElement = (Element)xmlEntry;
            String entryType = xmlEntry.getAttributes().getNamedItem("Type").getNodeValue();
            ImporterType type = ImporterType.getEnumFromName(entryType);
            ImportEntry newEntry = this.entryFactory(type, xmlEntryElement, userInputEntries);
            if (newEntry.getType() == ImporterType.SubSectionTitle) {
                this.handleElementWithChildrens(userInputEntries, xmlEntryElement, newEntry);
            }
            importIntrylist.add(newEntry);
        }
        return importIntrylist;
    }

    private void handleElementWithChildrens(Map<String, Element> userInputEntries, Element xmlEntryElement, ImportEntry newEntry) {
        NodeList children = xmlEntryElement.getElementsByTagName("ImportEntry");
        for (int i = 0; i < children.getLength(); ++i) {
            Element entry;
            if (children.item(i).getAttributes() == null || children.item(i).getNodeType() != 1 || (entry = (Element)children.item(i)) == null) continue;
            if (entry.hasAttribute("ID")) {
                userInputEntries.put(entry.getAttribute("ID"), entry);
            }
            String childEntryTypeName = entry.getAttributes().getNamedItem("Type").getNodeValue();
            ImporterType childType = ImporterType.getEnumFromName(childEntryTypeName);
            ImportEntry childEntry = this.entryFactory(childType, entry, userInputEntries);
            ((SubSectionTitleEntry)newEntry).addChild(childEntry);
        }
    }

    private Map<String, Element> handleUserInputEntries(Document userInputDocument) {
        NamedNodeMap userInputAttributes;
        if (userInputDocument != null && (userInputAttributes = userInputDocument.getElementsByTagName(rootNodeName).item(0).getAttributes()) != null) {
            this.setImportDetailes(userInputAttributes);
        }
        HashMap<String, Element> userInputEntries = new HashMap<String, Element>();
        if (userInputDocument != null) {
            Element documentElement = userInputDocument.getDocumentElement();
            NodeList importEntries = documentElement.getChildNodes();
            for (int i = 0; i < importEntries.getLength(); ++i) {
                Element entry;
                if (importEntries.item(i).getAttributes() == null || importEntries.item(i).getNodeType() != 1 || !(entry = (Element)importEntries.item(i)).hasAttribute("ID")) continue;
                userInputEntries.put(entry.getAttribute("ID"), entry);
            }
        }
        return userInputEntries;
    }

    private void handleAttributes() {
        NamedNodeMap attributes = this.entriesDocument.getElementsByTagName(rootNodeName).item(0).getAttributes();
        if (attributes != null) {
            this.setImportDetailes(attributes);
            Node typeNode = attributes.getNamedItem("Type");
            String typeStr = "";
            if (typeNode != null) {
                typeStr = typeNode.getTextContent();
            }
            this.type = ImporterType.getEnumFromName(typeStr == null ? "" : typeStr);
        }
    }

    private ImportEntry entryFactory(ImporterType importerType, Element xmlEntry, Map<String, Element> userInputEntries) {
        AbstractImportEntity retVal = null;
        switch (importerType) {
            case File: {
                retVal = new FileDirectoryEntry(xmlEntry, userInputEntries.get(xmlEntry.getAttributes().getNamedItem("ID").getNodeValue()), this.importDetails);
                break;
            }
            case List: {
                retVal = new ListEntry(xmlEntry, userInputEntries.get(xmlEntry.getAttributes().getNamedItem("ID").getNodeValue()), this.importDetails);
                break;
            }
            case TextInput: {
                retVal = new TextInputEntry(xmlEntry, userInputEntries.get(xmlEntry.getAttribute("ID")), this.importDetails);
                break;
            }
            case SubSectionTitle: {
                retVal = new SubSectionTitleEntry(xmlEntry, userInputEntries.get(xmlEntry.getAttribute("ID")), this.importDetails);
                break;
            }
            default: {
                retVal = new FileDirectoryEntry(xmlEntry, userInputEntries.get(xmlEntry.getAttribute("ID")), this.importDetails);
            }
        }
        return retVal;
    }

    private void setImportDetailes(NamedNodeMap attributes) {
        if (this.importDetails == null) {
            this.importDetails = new ImportDetails();
        }
        for (String key : ImportDetails.importDetailsKeys) {
            Node keyNode = attributes.getNamedItem(key);
            String value = "";
            if (keyNode != null) {
                value = keyNode.getTextContent();
            }
            this.importDetails.setProperty(key, value);
        }
    }

    public ImporterType getType() {
        return this.type;
    }

    public ImportDetails getImportDetails() {
        return this.importDetails;
    }
}

