/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.dataImport.EntriesContentPanel;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.dataimport.EntriesImporter;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.progress.ProgressEvent;
import com.bmc.ctmconvert.progress.ProgressListener;
import com.bmc.ctmconvert.progress.Progressable;
import java.awt.Component;
import java.awt.Dimension;

public class DynamicDataImportPanel
extends DataImportVendor {
    protected EntriesImporter importer;
    protected String help_id;
    private EntriesContentPanel panel;

    public DynamicDataImportPanel(EntriesImporter importer, String help_id) {
        this.help_id = help_id;
        this.importer = importer;
        this.initPanel();
    }

    public void initPanel() {
        ImportEntryList importEntries = this.importer.getEntries();
        this.panel = new EntriesContentPanel(importEntries);
    }

    @Override
    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        ProgressableBar progressBarListner = new ProgressableBar(this, progressBar);
        this.importer.addProgressListener(progressBarListner);
        this.importer.run();
        Progressable.ProgressStatus importerStatus = this.importer.getStatus();
        return DynamicDataImportPanel.getCompletionMode(importerStatus);
    }

    public static FlowGlobals.COMPLETION_MODE getCompletionMode(Progressable.ProgressStatus importerStatus) {
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
        if (importerStatus == Progressable.ProgressStatus.ENDED_FAILURE) {
            toRet = FlowGlobals.COMPLETION_MODE.FAILURE;
        } else if (importerStatus == Progressable.ProgressStatus.ENDED_STOPED) {
            toRet = FlowGlobals.COMPLETION_MODE.ABORTED;
        }
        return toRet;
    }

    @Override
    public String getHelpTitle() {
        return this.help_id;
    }

    @Override
    public String getFieldsData() {
        return null;
    }

    @Override
    public BaseContentPanel getNextPanel() {
        return this.panel;
    }

    @Override
    public Component getDefaultFocusedComponent() {
        return this.panel.getFirstComponent();
    }

    @Override
    public Dimension getSize() {
        Dimension entriesPanelSize = this.panel.getComponent().getPreferredSize();
        entriesPanelSize.height += 100;
        entriesPanelSize.width += 120;
        return entriesPanelSize;
    }

    public class ProgressableBar
    implements ProgressListener {
        private BaseProgressBar progressBar;

        public ProgressableBar(DynamicDataImportPanel this$0, BaseProgressBar progressBar) {
            this.progressBar = progressBar;
        }

        @Override
        public void updateProgress(ProgressEvent evt) {
            String value;
            if (evt.getType().equals((Object)ProgressEvent.ProgressType.PROGRESS_MAX)) {
                value = evt.getValue();
                int max = Integer.parseInt(value);
                this.progressBar.setProgressMax(max);
            }
            if (evt.getType().equals((Object)ProgressEvent.ProgressType.PROGRESS)) {
                value = evt.getValue();
                int percent = Integer.parseInt(value);
                this.progressBar.setProgressValue(percent);
            }
        }
    }
}

