/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.dataimport;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.dataimport.fileimporter.FileMonitor;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;

public class DirectoryImporter
extends Importer {
    protected ImportEntry entry;
    private FileSystem fileSystem;
    private Path targetDirPath;

    public DirectoryImporter(ImportEntry entry, Path destinationPath) {
        this(entry, FileSystems.getDefault(), destinationPath);
    }

    public DirectoryImporter(ImportEntry entry, FileSystem fileSystem, Path targetDirPath) {
        this.entry = entry;
        this.fileSystem = fileSystem;
        this.targetDirPath = targetDirPath;
    }

    public void setEntry(ImportEntry entry) {
        this.entry = entry;
    }

    public void setTargetDirPath(Path targetDirPath) {
        this.targetDirPath = targetDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Progressable.ProgressStatus performImport() {
        if (this.entry != null) {
            String sourceFullName = this.entry.getSourceFullName();
            Path sourcePath = this.fileSystem.getPath(sourceFullName, new String[0]);
            Path targetFilePath = this.targetDirPath.resolve(this.entry.getDestinationFileName());
            Progressable fileMonitor = null;
            try {
                if (Files.isDirectory(sourcePath, new LinkOption[0]) && !sourceFullName.isEmpty()) {
                    long fileSize = Files.size(sourcePath);
                    this.setProgressMax(fileSize);
                    fileMonitor = new FileMonitor(targetFilePath, this.entry.getID());
                    fileMonitor.addProgressListener(evt -> this.fireProgressEvent(evt));
                    new Thread(fileMonitor).start();
                    ConversionLogger.getLogger().info(String.format("Copy file '%s' started", this.entry.getID()));
                    GlobalFunctions.copyFolder(sourcePath, targetFilePath);
                    ConversionLogger.getLogger().info(String.format("Copy file '%s' ended", this.entry.getID()));
                    this.entry.setDestinationPath(targetFilePath.toAbsolutePath().toString());
                    this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
                } else {
                    this.setStatus(this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
                }
            }
            catch (IOException e) {
                this.setStatus(this.entry.isMandatory() ? Progressable.ProgressStatus.ENDED_FAILURE : Progressable.ProgressStatus.ENDED_WITH_MESSAGE);
                ConversionLogger.getLogger().log(Level.INFO, String.format("Unable to copy '%s'", sourcePath.getFileName()), e);
            }
            finally {
                if (fileMonitor != null) {
                    fileMonitor.stop();
                }
            }
        }
        return this.getStatus();
    }

    @Override
    public String getTitle() {
        return "Copy files...";
    }

    @Override
    public String getID() {
        return this.entry.getID();
    }
}

